FUNCTION you_sure
*
* Syntax.: you_sure( [<expC1>,<expC2>,<expN1>,<expN2>] )
* Where..:
*          expC1 = optional message, defaults to 'Save these changes (y/n)'
*          expC2 = optional default response, defaults to 'Y'
*          expN1 = optional display row, defaults to 9
*          expN2 = optional display column, defaults to centered
*
* Return.: .T. if Y was pressed, .F. otherwise
* --------------------------------------------------------------------------
PARAMETER opt_text,opt_def,opt_row,opt_col
PRIVATE retval,w1,lng,ans
retval = .F.

IF TYPE("opt_text") <> "C"
   opt_text = "Save these changes (y/n)"
ENDIF

IF TYPE("opt_def") <> "C"
   opt_def = "Y"
ENDIF

IF TYPE("opt_row") <> "N"
  opt_row = 9
ENDIF

IF TYPE("opt_col") <> "N"
  opt_col = 0
ENDIF

opt_text  = TRIM(opt_text)
lng       = INT( LEN(opt_text) / 2 )
ans       = opt_def
IF opt_col = 0
   opt_col = 38-lng
ENDIF
w1        = w_make(opt_row,opt_col,opt_row+4,opt_col+6+(2*lng),2,.T.)
@ opt_row+2,opt_col+2 SAY opt_text GET ans PICT "!" VALID ans$"YN"
READ
IF lastkey() <> 27 .AND. ans = "Y"
   retval = .T.
ENDIF
w_release(w1)

RETURN retval


