FUNCTION automem
*
* Syntax.:  automem( <expC1>,<expC2>,<expL> )
* Where..:
*          <expC1>   the prefix characters, defaults to M_
*
*          <expC2>   the work area, defaults to current
*
*          <expL>   .t. - create blank records, .F. - fill with database fields
*
* Returns: <expL>   .T. if valid workarea, .F. otherwise
*
* Purpose: Automatically create memory variables to holds fields
*          from a database
*
******************************************************************************
PARAMETER prefix,what_area,is_blank
PRIVATE retval,fd_name,fd_type,field_ct,k,the_var

IF TYPE("prefix") <> "C"                      && Default prefix is not given
   prefix = "M_"
ENDIF

IF TYPE("what_area") <> "C"                   && Default to current work area
   what_area = ALIAS()
ENDIF

IF TYPE("is_blank") <> "L"                    && Create blank variables (y/N)
   is_blank = .F.
ENDIF

retval   = .T.


IF SELECT(what_area) = 0
   retval = .F.
ELSE
   SELECT &what_area
   field_ct = fcount()
   DECLARE the_name[field_ct],the_type[field_ct],the_size[field_ct]
   AFIELDS( the_name,the_type,the_size )

   FOR k = 1 TO field_ct
      fd_name   = the_name[k]
      fd_type   = the_type[k]
      the_var   = TRIM(prefix)+fd_name
      PUBLIC &the_var
      DO CASE
         CASE fd_type = "C"
            &the_var = iif(is_blank,SPAC(the_size[k]),&fd_name)
         CASE fd_type = "D"
            &the_var = iif(is_blank,CTOD("  /  /  "),&fd_name)
         CASE fd_type = "L"
            &the_var = iif(is_blank,.F.,&fd_name)
         CASE fd_type = "N"
            &the_var = iif(is_blank,0,&fd_name)
      ENDCASE
   NEXT
ENDIF
RETURN retval

FUNCTION autorep && ---------------------------------------------------------
*
* Syntax.:  autorep( <expC>,<expC>,<expL> )
*
*          <expC1>   the prefix characters, defaults to M_
*
*          <expC2>   the work area, defaults to current
*
*          <expL>   .T. - lock record, .f. - lock not needed
*
* Returns: <expL>   .T. if valid workarea, .F. otherwise
*
* Purpose:  Automatically REPLACE memory variables to fields in a database
*
*
******************************************************************************

PARAMETER prefix,what_area,lock_it
PRIVATE retval,the_type,the_field,the_rep

IF TYPE("prefix") <> "C"                      && Default prefix is not given
   prefix = "M_"
ENDIF

IF TYPE("what_area") <> "C"                   && Default to current work area
   what_area = ALIAS()
ENDIF

IF TYPE("lock_it") <> "L"                     && Lock the file before REPLacing
   lock_it = .T.
ENDIF

retval = .T.
IF SELECT(what_area) = 0
   retval = .F.
ELSE
   SELECT &what_area
   IF lock_it
      IF .NOT. rec_lock(15)
         retval = .F.
      ENDIF
   ENDIF
   IF retval
      FOR k = 1 TO fcount()
         mm_field = field(k)
         mm_type  = type("&mm_field")
         mm_rep   = TRIM(prefix)+mm_field
         IF TYPE("&mm_rep") = mm_type .AND. mm_type <> "M"
            REPLACE &mm_field WITH &mm_rep
         ENDIF
      NEXT
   ENDIF

   UNLOCK

ENDIF
RETURN retval && ------------------------------------------------------------


FUNCTION sqzn
*
* Syntax.: SQZN( <expN1> , <expN2> )
* Where..:
*          <expN1>   the numeric memory variable
*
*          <expN2>   the size of the number
*
*
* Returns:  <expC>   the squished string representation of the number passed
*
******************************************************************************
PARAMETERS sqnumber,sqsize
PRIVATE retval,snumb,k
retval=""
snumb = str(sqnumber,sqsize)
FOR k=1 TO sqsize STEP 2
   retval = retval + CHR( VAL( SUBS(snumb,k,2) ) +100 )
NEXT
RETURN retval
* ---------------------------------------------------------------------------

FUNCTION unsqzn
*
* Syntax.: UNSQZN( <expC1> )
* Where..:
*          <expC1>   the squished number
*
*
* Returns:   <expN>  the numeric equivalent of the squished string
*
******************************************************************************
PARAMETER sqalpha
PRIVATE retval,k
IF TYPE("sqalpha") <> "C"
   sqalpha = ""
ENDIF
retval=""
IF LEN(TRIM(sqalpha)) > 0
   FOR k=1 TO LEN(sqalpha)
      retval = retval + STRZERO( ASC( SUBS(sqalpha,k,1) ) -100 ,2 )
   NEXT
ELSE
   retval="000"
ENDIF
RETURN VAL(retval)
* ---------------------------------------------------------------------------

FUNCTION sqzd
*
* Syntax.: SQZD( <expD> )
* Where..:
*          <expD>    the date variable
*
* Returns:  <expC>   the squished string representation of the date
*
*
PARAMETERS sq_date
PRIVATE retval
retval=CHR( year(sq_date)-1900 ) + CHR( 100+month( sq_date ) ) + ;
       CHR( 100+day( sq_date ) )
RETURN retval
* ---------------------------------------------------------------------------

FUNCTION unsqzd
*
* Syntax.: UNSQZD( <expC> )
* Where..:
*          <expC>   the squished date
*
*
* Returns: <expD>  the date extracted from the character string
*
*
PARAMETER sqalpha
PRIVATE retval
IF LEN(TRIM(sqalpha)) = 3
   retval = STR( ASC(SUBS(sqalpha,2,1))-100,2)+"/"+;
            STR( ASC(SUBS(sqalpha,3,1))-100,2)+"/"+;
            STR( ASC(LEFT(sqalpha,1)),2)
ELSE
   retval = "01/01/88"
ENDIF
RETURN CTOD(retval)
* ---------------------------------------------------------------------------