* Program: ARRAYS -----------------------------------------------------------
* Author.: Joseph D. Booth
* Purpose: A library of additional ARRAY() manipulation functions
*
*          aavg( <array>,<include zero's> ) - average of array
*          adec( @<array>,<start-at>,<decrement> ) - fill array with decreasing
*                                                   numbers
*          ainc( @<array>,<start-at>,<increment> ) - fill array with increasing
*                                                   numbers
*          amax( <array> ) - return highest numeric value
*          amin( <array> ) - return lowest numeric value
*          atot( <array> ) - total of array
*
* ---------------------------------------------------------------------------
FUNCTION aavg
* Purpose: What is the average value in the array
* Returns: The numeric average
* Syntax.: aavg( <expC> [,<expL>] ) - Where expC is the array name and
*                                   - expL means include zero's in calculation
PARAMETER whatarray,zeros_too
PRIVATE totnum,k,ctr
IF TYPE("zeros_too") <> "L"           && Make sure paramter is passed & valid
   zeros_too = .F.
ENDIF
STORE 0 TO totnum,ctr
FOR k=1 TO LEN(whatarray)
   totnum = totnum + whatarray[k]
   IF whatarray[k] > 0 .OR. zeros_too
      ctr    = ctr +1
   ENDIF
NEXT
RETURN iif( ctr>0, totnum/ctr, 0 )
* ---------------------------------------------------------------------------
FUNCTION adec
* Purpose: Fill an array with decreasing numbers
* Returns: Filled array
* Syntax.: adec( @<expC>[,<expN1>,<expN2>] ) - where expC is array name
*                                                    expN1 is starting value
*                                                    expN2 is decrement
PARAMETER whatarray,start_at,decrement
PRIVATE k,j
IF TYPE("start_at") <> "N"
   start_at = LEN(whatarray)
ENDIF
IF TYPE("decrement") <> "N"
   decrement = 1
ENDIF
FOR k=LEN(whatarray) TO 1 STEP -1
   j           = LEN(whatarray) -k +1
   whatarray[j]=start_at
   start_at    = start_at - decrement
NEXT
RETURN ""
* ---------------------------------------------------------------------------
FUNCTION ainc
* Purpose: Fill an array with increasing numbers
* Returns: Filled array
* Syntax.: adec( @<expC>[,<expN1>,<expN2>] ) - where expC is array name
*                                                    expN1 is starting value
*                                                    expN2 is increment
PARAMETER whatarray,start_at,increment
PRIVATE k
IF TYPE("start_at") <> "N"
   start_at = 1
ENDIF
IF TYPE("increment") <> "N"
   increment = 1
ENDIF
FOR k=1TO LEN(whatarray)
   whatarray[k] = start_at
   start_at     = start_at + increment
NEXT
RETURN ""
* ---------------------------------------------------------------------------
FUNCTION amax
* Purpose: What is the highest number in an array
* Returns: The value of the maximum element
* Syntax.: amax( <expC> ) - Where expC is the array name
PARAMETER whatarray
PRIVATE maxnum,k
maxnum = 0
FOR k=1 TO LEN(whatarray)
   maxnum = iif( maxnum < whatarray[k],whatarray[k], maxnum )
NEXT
RETURN maxnum
* ---------------------------------------------------------------------------
FUNCTION amin
* Purpose: What is the lowest number in an array
* Returns: The value of the minimum element
* Syntax.: amax( <expC> ) - Where expC is the array name
PARAMETER whatarray
PRIVATE minnum,k
minnum = 999999999999
FOR k=1 TO LEN(whatarray)
   minnum = iif( minnum > whatarray[k],whatarray[k], minnum )
NEXT
RETURN minnum
* ---------------------------------------------------------------------------
FUNCTION atot
* Purpose: What is the total value of the array
* Returns: The total value of the array
* Syntax.: aavg( <expC> ) - Where expC is the array name
PARAMETER whatarray
PRIVATE totnum,k
totnum = 0
FOR k=1 TO LEN(whatarray)
   totnum = totnum + whatarray[k]
NEXT
RETURN totnum
* ---------------------------------------------------------------------------
