*Ŀ
*                                                                         
*      Program: SAMELEN.PRG       (Requires Clipper, Summer 87)           
*                                                                         
*       System: SameLen.exe  Set a standard field length                  
*       Author: T L Johnson                                               
*               4409 Beaumont Dr.                                         
*               Orlando, Florida 32808                                    
*               407-291-3960                                              
*                                                                         
*    Copyright (c) 1988, TJs Lab                                          
*                                                                         
*    Functions: DOSCROLL                                                  
*             : FVALTYPE                                                  
*             : FPRINTER2                                                 
*             : BEEP                                                      
*             : CENTER                                                    
*                                                                         
*         Uses: &TEMP.DBF                                                 
*             : SAMELEN1.DBF                                              
*             : SAMELEN.DBF                                               
*                                                                         
*
PUBLIC i,arrtemp,arrfields,arrwidth,arrtype,arrdecimals
IF FILE("samelen.dbf")
	ERASE samelen.dbf
	ERASE samelen.dbt
ENDIF
SET ESCAPE ON
SET EXACT ON
SET KEY -1 TO DOBROWSE
SET KEY 28 TO SOMEHELP
IF ISCOLOR()
	main="W+/B,N/W,B"
	sub="GR+/B"
	misc="BG+/B"
	helpcolor="W+/R"
ELSE
	main="W/n,n/w,n/w"
	sub="N/W"
	misc="N/W"
	helpcolor="N/W"
ENDIF
SET COLOR TO &main
CLEAR
@ 1,0 TO 23,79
SET COLOR TO &sub
@ 1,23 SAY "[ TJs Lab  -  SameLen.exe ]"
@ 0,0 SAY DATE()
SET COLOR TO &main
@ 4,3 SAY "This Clipper routine will search all .DBF files in the current directory,"
@ 5,3 SAY "looking for a field name (that you specify). If found, a list is created"
@ 6,3 SAY "containing the database name, field type, field length and number of"
@ 7,3 SAY "decimals. You can also modify all database structures to match the length"
@ 8,3 SAY "you request."
SET COLOR TO &main
SAVE SCREEN TO scrn1                && Main Screen/Credits
DECLARE arrtemp[ADIR("*.DBF")]
ADIR("*.DBF",arrtemp)               && Fill arrtemp with the names of all .DBFs
IF LEN(arrtemp)=0                   && Check to see if there are any .DBFs
	TONE(343,1)
	TONE(2323,2)
	@ 2,1 CLEAR TO 22,78
	@ 13,13 SAY "Sorry, but there are no .DBFs in this directory, try another..."
	@ 15,27 SAY "Press any key to EXIT/QUIT"
	CLEAR
	QUIT                        && If no .DBFs, then quit
ENDIF
DOSCROLL()   && scroll array arrtemp[], which contains the names of all .DBFs
@ 24,16 SAY    "Press  F2  to browse, any other key to continue..."
INKEY(60)
X=0
lf=CHR(13)+CHR(10)   && LF is the 'carriage return' for the summary
DO WHILE X<>27
	RESTORE SCREEN FROM scrn1
	SET COLOR TO &MAIN
	@ 24,23 SAY  "Press  Esc  to QUIT/EXIT,  F2  to browse..."
	xnm=SPACE(12)
	@ 10,5 SAY "Enter Field Name: " GET xnm PICTURE "@! XXXXXXXXXXXX"
	READ
	IF LASTKEY()=27 .OR. EMPTY(xnm)
		X=27
		LOOP
	ENDIF
	@ 12,5 SAY "Search only (Y/N)"    && You can search only, or actually
	X=0                               && make the modification...
	DO WHILE X=0
		@ 12,20 SAY ""
		X=INKEY()
		IF X>0
			IF UPPER(CHR(X))="Y"
				findonly=.T.
				@ 12,25 SAY "Search and List Only!"
				SET EXCLUSIVE OFF  && for networks, no need to lock the file
			ELSE
				findonly=.F.   &&  If .f. then modify
				@ 12,25 SAY "Search and Possibly Modifying"
				SET EXCLUSIVE ON   && Since we may be modifying a structure, lets
				** lock the file (applicable on networks only)...
			ENDIF
		ENDIF
		IF X=27
			LOOP
		ENDIF
	ENDDO
	IF !findonly          && Modify!
		dummy=.T.
		thetype="C"
		@ 14,5 SAY  "                                { C-Character  N-Numeric }"
		@ 15,5 SAY  "Enter the character TYPE of "+xnm+" (C/N): " GET thetype PICTURE "!" VALID fvaltype(dummy)
		READ
		IF LASTKEY()=27
			LOOP
		ENDIF
		thelength=1
		@ 17,5 SAY "Enter the LENGTH you want "+xnm+ " to be: " GET thelength PICTURE "999" RANGE 1,999
		READ
		IF LASTKEY()=27
			LOOP
		ENDIF
		DECIMALS=0
		IF thetype="N"      && If numeric, then ask for the decimals
			@ 19,5 SAY "Enter the number of Decimals: " GET DECIMALS PICTURE "9" RANGE 0,9
			READ
			IF LASTKEY()=27
				LOOP
			ENDIF
		ENDIF
		**   Start making the text/summary using the variable: samelen
		samelen="TJs LAB  -  SameLen.exe"+lf+lf+"Field to Change: "+xnm+lf
		samelen=samelen+"Type: "+thetype+lf+"Length: "+LTRIM(STR(thelength))+lf
		IF thetype="N"
			samelen=samelen+"Decimals: "+LTRIM(STR(DECIMALS))+lf
		ENDIF
	ELSE
		samelen="TJs LAB  -  SameLen.exe"+lf+lf+"Field to Search for: "+xnm+lf
	ENDIF  && .not. findonly
	@ 24,0
	SET COLOR TO &MISC
	@ 24,20 SAY "Working!   Searching all .DBFs for "+xnm
	samelen=samelen+lf+"DATABASE       TYPE     WIDTH     DECIMALS"+lf
	samelen=samelen+   ""+lf
	@ 11,3 CLEAR TO 23,61   && Scroll box of Databases containing the field
	@ 11,3 TO 23,61
	@ 11,3 SAY "Ŀ"
	@ 12,4 SAY  " DATABASE      TYPE     WIDTH     DECIMALS   RECORDS"
	@ 13,3 SAY "Ĵ"
	FOR i=1 TO LEN(arrtemp)
		temp=arrtemp[i]
		USE &temp
		RELEASE arrfields,arrtype,arrwidth,arrdecimals
		DECLARE arrfields[fcount()],arrtype[fcount()],arrwidth[fcount()],arrdecimals[fcount()]
		afields(arrfields,arrtype,arrwidth,arrdecimals)
		number=0
		SET COLOR TO &SUB
		@ 11,65 CLEAR TO 19,77
		@ 11,65 TO 19,77
		FOR jj=1 TO fcount()
			SCROLL(12,66,18,76,-1)
			@ 12,66 SAY arrfields[JJ]
			IF xnm=arrfields[JJ]
				number=jj
				TONE(4343,.1)
			ENDIF
		NEXT
		SET COLOR TO &MISC
		IF number>0
			length=fcount()
			samelen=samelen+SUBSTR(arrtemp[I]+SPACE(15),1,13)+CHR(179)+"  "
			SCROLL(14,5,22,60,-1)  && Scroll the fields
			@ 14,5 SAY arrtemp[I]  && (just for the visual effect)
			@ 14,17 SAY CHR(179)
			@ 14,27 SAY CHR(179)
			@ 14,38 SAY CHR(179)
			@ 14,50 SAY CHR(179)
			GOTO BOTTOM
			@ 14,53 SAY RECNO()
			WIDTH=-1
			DEC=-1
			IF !findonly
				IF thetype<>arrtype[NUMBER] && Oops, wrong TYPE!
					TONE(2323,2)
					TONE(3434,1)
					@ 5,2 CLEAR TO 7,78
					@ 5,2 TO 7,78
					@ 6,4 SAY "Hey! this field is of a different TYPE. Therefore you cannot change it!"
					TONE(4343,.3)
				ENDIF   &&  thetype <> arrtype[NUMBER]
				IF arrwidth[number]<>thelength  && Flag a change
					WIDTH = arrwidth[number]
				ELSE
					WIDTH = -1
				ENDIF
				IF arrdecimals[number]<>DECIMALS
					DEC = arrdecimals[number]
				ELSE
					DEC = -1
				ENDIF
				IF THETYPE=ARRTYPE[NUMBER]   && Was change made?
				    arrwidth[NUMBER]=thelength
				    arrdecimals[NUMBER]=DECIMALS
				ENDIF
				** if a Modification is to be made, then the next
				** IF/ENDIF will do it. It creates a new structure,
				** copies all data into it, the renames it to the original
				** name of the database it changed...
				if (width>0 .or. dec>0) .and. thetype=arrtype[number]
				   CREATE samelen1
				   FOR j=1 TO length
					   APPEND BLANK
					   REPLACE field_name WITH arrfields[j]
					   REPLACE field_type WITH arrtype[j]
					   REPLACE field_len WITH arrwidth[j]
					   REPLACE field_dec WITH arrdecimals[j]
				   NEXT
				   DELETE FOR EMPTY(field_name)
				   PACK
				   USE
				   CREATE samelen FROM samelen1
				   USE samelen
				   ERASE samelen1.dbf           && I had to OPEN and CLOSE
				   ERASE samelen1.dbt           && frequently because
				   temp=arrtemp[i]              && otherwise, I was getting
				   USE                          && corrupted databases.(???)
				   USE &temp
				   USE
				   USE samelen
				   APPEND FROM &temp
				   USE
				   ERASE &temp
				   RENAME samelen.dbf TO &temp
				   USE &temp
				   CLOSE DATABASES
				endif
			ENDIF
			samelen=samelen+SUBSTR(arrtype[NUMBER]+SPACE(7),1,7)+CHR(179)+"  "
			samelen=samelen+SUBSTR(LTRIM(STR(arrwidth[NUMBER]))+SPACE(8),1,8)+CHR(179)+"  "
			samelen=samelen+SUBSTR(LTRIM(STR(arrdecimals[NUMBER]))+SPACE(7),1,8)
			IF WIDTH>0
				samelen=samelen+"Length was "+LTRIM(STR(WIDTH))
			ENDIF
			IF DEC>0
				IF WIDTH>0
					tx=","
				ELSE
					tx=""
				ENDIF
				samelen=samelen+tx+" Decimals were "+LTRIM(STR(DEC))
			ENDIF
			samelen=samelen+lf   && End of a summary line
			@ 14,20 SAY arrtype[NUMBER]
			@ 14,30 SAY LTRIM(STR(arrwidth[NUMBER]))
			@ 14,41 SAY LTRIM(STR(arrdecimals[NUMBER]))
		ENDIF
	NEXT
	samelen=samelen+CHR(12)+CHR(13) && End of the Summary...
	FPRINTER2()   && Routine to redirect printer output to ....
ENDDO
CLOSE DATABASES
SET COLOR TO W/n,n/w,n
CLEAR
RETURN


FUNCTION DOBROWSE    && Dbedit the databases (.DBFs)
SAVE SCREEN TO SCRN4
TEMPCOLOR=SETCOLOR()  && SAVE THE CURRENT COLOR, RESTORE UPON EXITING
SET COLOR TO &misc
@ 9,39 CLEAR TO 22,53
@ 9,39 TO 22,53
@ 11,39 SAY "Ĵ"
@ 10,43 SAY "SELECT"
x=ACHOICE(12,40,21,52,ARRTEMP)
IF LASTKEY()=13
   temp=arrtemp[x]
   USE &temp
   DECLARE FIELDARRAY[FCOUNT()]
   AFIELDS(FIELDARRAY)
   @ 3,1 TO 11,78
   DBEDIT(4,2,10,77,"xbrowse")   && xbrowse is a UDF in the EXTEND.LIB
ENDIF
RESTORE SCREEN FROM SCRN4
SET COLOR TO &TEMPCOLOR
RETURN ""

FUNCTION DOSCROLL    && Scroll the databases (.DBFs) onto the screen
@ 10,5 SAY "You have "+LTRIM(STR(LEN(arrtemp)))+" .DBFs in this directory."
SET COLOR TO &misc
@ 11,39 CLEAR TO 22,53
@ 11,39 TO 22,53
@ 12,40 SAY  "Database Name"
@ 13,39 SAY "Ĵ"
SET COLOR TO &sub
FOR jj=1 TO LEN(arrtemp)
	SCROLL(14,40,21,52,-1)
	@ 14,40 SAY arrtemp[JJ]
	INKEY(.1)
NEXT
SET COLOR TO &main
RETURN ""

FUNCTION fvaltype       && Validate the TYPE (Must be N or C )
PARAMETER dummy
IF thetype="N" .OR. thetype="C"
	RETURN .T.
ELSE
	RETURN .F.
ENDIF

FUNCTION FPRINTER2   && Redirects printer output to:  LPT1 (parallel printer 1)
SET COLOR TO &misc   &&                               LPT2 (parallel printer 2)
RELEASE arroutput    &&                               LPT3 (parallel printer 3)
DECLARE arroutput[6] &&                               COM1 (serial port 1)
arroutput[1]="LPT1"  &&                               COM2 (serial port 2)
arroutput[2]="LPT2"  &&                               FILE (disc file - you name)
arroutput[3]="LPT3"
arroutput[4]="COM1"
arroutput[5]="COM2"
arroutput[6]="FILE"
CENTER("", 2)
CENTER("     WHERE DO YOU WANT THE SUMMARY OUTPUT TO GO?    ", 3)
CENTER("      ", 4)
SET CURSOR ON
@ 24,0
@ 4,37 CLEAR TO 11,42
@ 4,37 TO 11,42
choice=achoice(5, 38, 10, 41, arroutput)  && USE ACHOICE TO DIRECT OUTPUT
IF LASTKEY()=27 .OR. choice=0
	RETURN ""
ENDIF
IF LASTKEY()=27 .OR. choice=0
   RETURN ""
ENDIF
nmoutput=ARROUTPUT[CHOICE]
IF choice=6
   response="N"
   SAVE SCREEN TO scrn4
   DO WHILE response="N"
      @ 12,10 CLEAR TO 15,70
      @ 12,10 TO 15,70
      @ 13,12 SAY "Enter the Name of the file"
      nmoutput=SPACE(40)
      @ 14,12 SAY "      to contain the Output: " GET nmoutput PICTURE "@S20"
      READ
      nmoutput=UPPER(ALLTRIM(nmoutput))
      IF AT(".",nmoutput)=0
	      nmoutput=nmoutput+".TXT"
      ENDIF
      IF LASTKEY()=27 .OR. EMPTY(nmoutput)
	      RETURN ""
      ENDIF
      IF FILE("&NMOUTPUT") && File exists, do you want to overwrite?
	      BEEP()
	      SAVE SCREEN TO scrn3
	      BEEP()
	      FOR ii=1 TO 5     && Visuals...
		      RESTORE SCREEN FROM scrn3
		      @ ii+5,19 CLEAR TO ii+7,48+LEN(nmoutput)
		      @ ii+5,19 TO ii+7,48+LEN(nmoutput)
		      @ ii+6,20 SAY "THIS FILE: "+nmoutput+" ALREADY EXISTS !"
	      NEXT
	      RESTORE SCREEN FROM scrn3
	      @ ii+6,19 CLEAR TO ii+9,57+LEN(nmoutput)
	      @ ii+6,19 TO ii+9,57+LEN(nmoutput)
	      @ ii+7,20 SAY "THIS FILE: "+nmoutput+" ALREADY EXISTS !"
	      BEEP()
	      response="N"
	      @ ii+8,20 SAY "Do you want to overwrite it? (Y/N) " GET response PICTURE "!Y"
	      READ
	      IF LASTKEY()=27
		      RETURN ""
	      ENDIF
      ELSE
	      response="Y"
      ENDIF
      RESTORE SCREEN FROM scrn4
   ENDDO
ENDIF
num=1
IF EMPTY(ALLTRIM(nmoutput))
	SET PRINTER TO
ELSE
	SET PRINTER TO &nmoutput && REDIRECT PRINTER OUTPUT TO WHATEVER (PRINTER, DISC...)
ENDIF
SET DEVICE TO PRINTER
@ PROW()+1,0 SAY samelen
SET DEVICE TO SCREEN
RETURN ""

FUNCTION BEEP       && Different beep...
TONE(3434,.1)
TONE(2323,.1)
TONE(343,.1)
TONE(100,.2)
RETURN ""

FUNCTION CENTER     && Center a text string on the screen
PARAMETERS STRING,LN
@ LN,INT((80-LEN(string))/2) SAY string
RETURN ""

FUNCTION SOMEHELP     &&  Simple Help Routine
PARAMETERS CALLPRG,LN,VARIABLE
SAVE SCREEN TO SCRNHELP
TEMPCOLOR=SETCOLOR()  && Save current color, restore upon exiting
IF ROW()<13           && Put the HELP message where the cursor isn't
   R=13
ELSE
   R=2
ENDIF
IF COL()<40
   C=40
ELSE
   C=2
ENDIF
SET COLOR TO &HELPCOLOR
@ R,C CLEAR TO R+10,C+38
@ R,C TO R+10,C+38
@ R+2,C+2 SAY "Sorry, but no HELP is available!"
@ R+3,C+2 SAY "If You do have a pressing question,"
@ R+4,C+2 SAY "write to me (Tom) at:"
SET COLOR TO &MISC
@ R+5,C+6 SAY " TJs LAB "
@ R+6,C+6 SAY " 4409 Beaumont Drive "
@ R+7,C+6 SAY " Orlando, Florida 32808 "
SET COLOR TO &HELPCOLOR
@ R+8,C+2 SAY "I will respond!"
@ 24,0
CENTER("Press any key to exit this HELP message...",24)
INKEY(99)
SET COLOR TO &TEMPCOLOR
RESTORE SCREEN FROM SCRNHELP
RETURN ""

* EOF _ SAMELEN.PRG
