*------------
FUNCTION safe (xKeyword, xValue, xType)
*------------
*   (RE)STORE 'global' data to/from Static array
*------------
/*

all parameters OPTIONAL

 xKeyword = data identifier (character-string) or array reference
   if empty, clear and return entire array
   if array, replace entire array with content of "xKeyword"
    else, retrieve value associated with identifier

 xValue = value of identified variable
   if missing (NIL), retrieve (only) current value
   if == "/*" , delete array "row" corresponding to "xKeyword"
    else, add/replace value related to specified keyword

 xType = data type of identified variable
   when "xKeyword" is not found in the array, SAFE() attempts to
    return an appropriate "empty" value.  If xValue is specified, it
    uses the data type of the xValue variable.  If xValue is not
    specified, it uses the data type specified by xType.  If neither
    is specified, it returns the default, a NULL STRING.

 returns:
   if "xKeyword" not specified or 0, entire array (content upon entry)
    else, value associated with "xKeyword" identifier.  If not found,
    return value is determined by xValue, xType, or default (in that
    order!)

 Examples:

xRet = SAFE("HELP", "utssys.hlp")
       Stores character string "utssys.hlp" in array element labeled "HELP"
       Returns prior value associated with "HELP", if any.

xRet = SAFE("HELP")
       Returns value associated with "HELP", e.g., "utssys.hlp"
       If not found, returns NULL STRING.

xRet = SAFE("DATE") -or- SAFE("DATE", "", "N")
       Returns value associated with "DATE"; If not found, returns ("")

xRet = SAFE("DATE", CTOD("12/31/90"))
       Returns value associated with "DATE"; If not found, returns CTOD("").

xRet = SAFE("DATE",,"N")
       Returns value associated with "DATE"; If not found, returns ZERO!.

xRet = SAFE("HELP", "/*")
       Deletes variable and related value
       Returns stored value associated with "HELP", if any.

xRet = SAFE() or SAFE ("") or SAFE (0)
       Clears and returns entire array

xRet = SAFE(array)
       Restores entire array and returns "upon entry" content

    Static Array - can be referenced ONLY by this function!
*/

STATIC aSafe[0]

LOCAL nIndex, cKpType, xRetVal
nIndex := 0
cKpType := VALTYPE(xKeyword)
xRetVal := IF(cKpType = "C", "", ACLONE(aSafe))

DO CASE
   CASE EMPTY(xKeyword)
      aSafe := {}

   CASE cKpType = "A"
      * restore entire array
      aSafe := ACLONE(xKeyword)

   CASE cKpType = "C"
      * note that keyword is NOT case sensitive
      xKeyword = UPPER(xKeyword)

      nIndex := ASCAN( aSafe, { |aDes| aDes[1] == xKeyword } )
      IF nIndex = 0
         * item not in array
         IF xValue # NIL
            AADD(aSafe, { xKeyword, xValue } )
            xType := VALTYPE(xValue)
         ENDIF
         DO CASE
            CASE xType = "N"
               xRetVal := 0
            CASE xType = "D"
               xRetVal := CTOD("")
            CASE xType = "A"
               xRetVal := {}
            CASE xType = "L"
               xRetVal := .F.
         ENDCASE
       ELSE
         xRetVal := aSafe[nIndex, 2]
         IF xValue # NIL
            IF VALTYPE(xValue) = "C" .AND. xValue == "/*"
               * delete existing array "row"
               ADEL(aSafe, nIndex)
               ASIZE(aSafe, LEN(aSafe) - 1)
             ELSE
               aSafe[nIndex, 2] = xValue
            ENDIF
         ENDIF
      ENDIF
ENDCASE

RETURN (xRetVal)

