* Program Name: wdemo.prg
* Author: Robert DiFalco
* Copyright (c) 1990 by Robert DiFalco
*-----------------------------------------------------------------------------
* Created: 4/24/1990 at 19:26
*.............................................................................
* Revision: 1.0 Last Revised: 4/24/1990 at 19:26
* Description: Original Creation.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------


set procedure to wind

set cursor off

wInit(100)								&& Initialize public arrays and window limit

Clear
setcolor("w+/n")
@ 0,0 say replicate("",2000)

**------------------------------- General usage windows
one   =  wMake("Window 1",3,3,21,76,"G+/B",.t.,.t.,1)
two   =  wMake(" Window 2 ",9,4,13,70,"N+/GR",.t.,.t.,2)
three =  wMake(" Window 3 ",3,4,22,75,"W+/W",.t.,.t.,3)
four  =  wMake(" Window 4 ",14,40,19,70,"w+/rb",.t.,.t.,4)
five  =  wMake(" Window 5 ",10,20,13,60,"BG+/B",.t.,.t.,1)

**------------------------------- Closing Windows
Commands =  wMake(" Command List ",5,2,22,76,"W+/W",.t.,.t.,3)
wEnding =  wMake(" Closing Thoughts ",3,3,21,76,"G+/B",.t.,.t.,1)

**------------------------------- Windows for different box examples
Box0 = wMake("* No Border Type *",8,20,13,60,"B/G",.t.,.t.)
Box1 = wMake(" Border Type 1 ", 3, 5, 7,35,"N/W",.t.,.t.,1)
Box2 = wMake(" Border Type 2 ", 3,42, 7,75,"G+/B",.t.,.t.,2)
Box3 = wMake(" Border Type 3 ", 11, 5,16,35,"W+/RB",.t.,.t.,3)
Box4 = wMake(" Border Type 4 ", 11,42,16,75,"B/GR",.t.,.t.,4)
Box5 = wMake(" Border Type 5 ", 18,5,23,75,"W+/R",.t.,.t.,5)

**-------------------------------- Windows for "Ten Fast Windows"
w1 = wMake(" One ",1,1,6,24,"gr+/r",.f.,.t.,1)
w2 = wMake(" Two ",3,4,8,28,"gr+/r",.f.,.t.,1)
w3 = wMake(" Three ",5,8,10,32,"gr+/r",.f.,.t.,1)
w4 = wMake(" Four ",7,12,12,36,"gr+/r",.f.,.t.,1)
w5 = wMake(" Five ",9,16,14,40,"gr+/r",.f.,.t.,1)
w6 = wMake(" Six ",11,20,16,44,"gr+/r",.f.,.t.,1)
w7 = wMake(" Seven ",13,24,18,48,"gr+/r",.f.,.t.,1)
w8 = wMake(" Eight ",15,28,20,52,"gr+/r",.f.,.t.,1)
w9 = wMake(" Nine ",17,32,22,56,"gr+/r",.f.,.t.,1)
w10 =wMake(" Ten ",19,36,24,64,"gr+/r",.f.,.t.,1)


wOpen(One)

wSay(One,2,1,"     These are almost functioning Windowing _Objects_ for "+;
"Clipper. I am offering them as -- well actually forget it.  I am not "+;
"offering these into the public domain, I am just being a nice guy and "+;
"loading them up for people to see how true windowing could be done in "+;
"<pure> Clipper code <g>.  I am going to rewrite these Functions in Turbo C "+;
"to improve speed and add some important details as such Window promoting - "+;
"which enables moving inactive or overwritten windows and a whole host of "+;
"other things, keeping the text from being overwritten during Interactive "+;
"Window Re-Sizing. Moving windows without loosing text "+;
"is _no_problem, however.  Let's Try re-sizing this window and be ready to "+;
"loose all of this wonderful text..Ready? Ok....    "+;
"                                                              "+;
"                           "+;
"Use arrows to Resize Window, Hit Return to Accept New Size, "+;
"escape to return to original Size.")

wSize(One)

wSay(One,1,1," Okay...Let's Move it around with arrow keys...")

wMove(one)

wOpen(two)

wSay(Two,1,1,"Making a window is as easy as....                      "+;
"       Window2 = wMake(' Window 2 ',9,4,16,70,'N/GR',.t.,.t.,2) "+;
"    wOpen(Window2) activates it. ")


inkey(0)
wOpen(three)

wSay(Three,1,1,;
"Use: wMake()                                                       "+;
"                                                                   "+;
"Syntax:                                                            "+;
"<c1>   =  Title Character String                                   "+;
"<n1>   =  Top Row                                                  "+;
"<n2>   =  Left Column                                              "+;
"<n3>   =  Bottom Row                                               "+;
"<n4>   =  Right Column                                             "+;
"<c2>   =  Color String                                             "+;
"<l1>   =  Logical - To Explode or not to Explode                   "+;
"<l2>   =  Logical - Shadow Hmm...Yes, no, forget maybe             "+;
"<n5>   =  Numerical Border Type 1 - 5                               "+;
"                                                                    "+;
"Returns: Numeric                                                    "+;
"                                                                    "+;
"To activate just call wOpen()                                       "+;
"wOpen <n1>   =  Window Name as in wOpen(MyWindow)                 ")

wOpen(Five)
wSay(Five,1,1,"Let's take a closer look at the wMake() syntax....")

inkey(0)

wClose(Five)

wDispMsg(Three," Hit any key to Continue ")

inkey(0)

wOpen(four)
wSay(four,2,1,"Let's Look at the different Border Types...")
wDispMsg(four," Press Any Key ")

inkey(0)
**------------------------------- Close for a clean background
wClose(four)
wClose(three)
wCLose(two)
wClose(one)

**------------------------------- Open Border Types
wOpen(Box1)
wOpen(Box2)
wOpen(Box3)
wOPen(Box4)
wOpen(Box5)

inkey(0)

wOpen(Box0)
wSay(Box0,1,1,"And of course... There's no Border at all!!")

inkey(0)

**------------------------------- Ten Boxes Demo
wSay(Box5,3,1,"Let's open Ten Box Very Quickly...")

inkey(0)
For i =  1 to 2
	wOpen(w1)
	wOpen(w2)
	wOpen(w3)
	wOpen(w4)
	wOpen(w5)
	wOpen(w6)
	wOpen(w7)
	wOpen(w8)
	wOpen(w9)
	wOpen(w10)
	if i = 1
		wSay(w10,1,1,"Let's move this one around so you can see why I want to finish this project in TC.")
		wMove(w10)
		wClear(w10)
		wSay(w10,1,1,"I just used wClear() to clear text area so I could enter new Text.")
		Inkey(0)
		wClear(w10)
		wSay(w10,1,1,"Let's clear one line while we try not to think about slow Clipper Array Processing.")
		inkey(0)
		wClearEOL(w10,2)
		inkey(0)
		wClearEOL(w10,4)
		inkey(0)
		wClear(w10)
		wSay(w10,1,1,"Let's resize the Fucker! BTW, the screen writes are fast enough the flick is from the processing.")
		wSize(w10)
	endif
	wClose(w10)
	inkey(.01)
	wClose(w9)
	inkey(.01)
	wClose(w8)
	inkey(.01)
	wClose(w7)
	inkey(.01)
	wClose(w6)
	inkey(.01)
	wClose(w5)
	inkey(.01)
	wClose(w4)
	inkey(.01)
	wClose(w3)
	inkey(.01)
	wClose(w2)
	inkey(.01)
	wClose(w1)
	inkey(.01)

	wOpen(four)
	wSay(four,1,1,"Lets do it Again !!!")
	inkey(0)

Next

wClear(four)

wSay(four,1,1,"Nah...I don't think so...")

wSay(four,2,1,"How about This...Hit a Key")
inkey(0)

wDispMsg(four," Hey it's a Footer! ")

inkey(0)

wClear(four)

wSay(four,1,1,"Let's clear up the screen...")

inkey(0)

wClose(four)

inkey(0)
wClose(Box0)

inkey(0)
wClose(Box5)

inkey(0)
wClose(Box4)

inkey(0)
wClose(Box3)

inkey(0)
wClose(box2)

inkey(0)
wClose(Box1)

wOpen(Commands)
wSay(Commands,1,1,;
" wInit(<n1>)                                                            "+;
" wMake(<c1>,<n1>,<n2>,<n3>,<n4>,<c2>[,<L1>[,<L2>[,<n5>]]])              "+;
" wOpen(<n1>)                                                            "+;
" wSay(<n1>,<n2>,<n3>,<c1>)                                              "+;
" wClose(<n1>)                                                           "+;
" wClear(<n1>)                                                           "+;
" wClearEOL(<n1>,<n2>)                                                   "+;
" wMove(<n1>[,<n2>[,<n3>]])                                              "+;
" wSize(<n1>[,<n2>[,<n3>]])                                              "+;
" wDispTit(<n1>[,<c1>])                                                  "+;
" wDispMsg(<n1>,<c1>)                                                    "+;
"                                                                        "+;
"Related Commands:                                                       "+;
" Shadow(<n1>,<n2>,<n3>,<n4>)                                            "+;
" Explode(<n1>,<n2>,<n3>,<n4>,<c1>)")

inkey(0)


wOpen(wEnding)
wSay(wEnding,1,1,;
"  Ok...Lets talk about what's missing. ALOT! But for starters a wGet() just like "+;
"the wSay() is ofcourse a piece of cake, saving and  reformatting text during "+;
"an Interactive Re-Sizing session would not be as easy.  There's a "+;
"way to strip the attribute out of a savescreen() string and get rid of blank "+;
"spaces...I suppose.  This is the approach I would take if I wasn't goin to "+;
"re-write in Turbo-C.  I still think that it's pretty fucking amazing that "+;
"you can actually do this sort of thing in Clipper but thats probably just "+;
"do to my inexperience --irregardless, I'm very impressed with Clipper.  If "+;
"Someone has some good ideas (and a little more expertise than I) and "+;
"would like to work with me on making this sort of thing a commercial LIB "+;
"-maybe Fresh.Lib- I have many other functions to put into this, most in "+;
"Turbo-C.  The Shadow function, by the way, is the only code in these functions written "+;
"in C. It basically reverses the attribute with out saving, manipulating and "+;
"restoring the screen.  I can be reached at (415) 398-4131 "+;
"or on CIS - 71610,1705.")
inkey(0)
wClose(wEnding)
Inkey(0)
wClose(Commands)
inkey(0)
clear
set cursor on
release all
quit

