* Program Name: wind.prg
* Author: Robert DiFalco
* Copyright (c) 1990 by Robert DiFalco
*-----------------------------------------------------------------------------
* Created: 4/24/1990 at 20:31
*.............................................................................
* Revision: 1.0 Last Revised: 4/24/1990 at 20:31
* Description: Original Creation.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------

**------------------------------- Function to Initialize window params.
Function wInit

	parameters wMax

	if pcount() != 1
		wMax = 100
	elseif type("wMax") != "N"
		return (.f.)
	endif

	Public wTR[wMax], wLC[wMax], wBR[wMax], wRC[wMax],;
	wX[wMax], wY[wMax], wXX[wMax], wYY[wMax],;
	wScreen[wMax], wTitle[wMax], wBorder[wMax], wShadow[wMax],;
	wExplode[wMax], wFrame[wMax], wActive[wMax],;
	wCurX[wMax], wCurY[wMax], wColor[wMax], wOldColr[wMax], wLevel

	wLevel = 0

Return (.t.)


Function wMake

	parameters wTit, wT, wL, wB, wR, wCol, wExp, wShad, wBrdr, wMsg

	if type("wScreen") = "U" .or. type("wScreen") != "A"
		wInit()
	endif

	**-------------------- Error and Parameter Checks
	If pcount() < 5
		return (0)
	endif

	if pcount() < 10
		wMsg = .f.
	endif

	**-------------------- Define Window Level
	wLevel 		   = wLevel + 1

	wActive[wLevel] = .f.			&& Window is not yet active.


	**------------------------------- Initialize Title
	wTitle[wLevel] = ""
	if type("wTit") != "U" .and. type("wTit") = "C"
		if !empty(wTit)
			wTitle[wLevel] = wTit
		endif
	endif

	**------------------------------- Make Border, Frame, Title area
	wFrame[wLevel]  = space(9)
	wBorder[wLevel] = ""
	x = wT

	if type("wBrdr") = "U"
		wBrdr = 0
	endif

	if !empty(wTitle[wLevel]) .and. (wB - wT) >= 4
		x = x - 2
		if wBrdr = 1
			wFrame[wLevel]  = "Ŀ"
			wBorder[wLevel] = "Ŀó"

		elseif wBrdr = 2
			wFrame[wLevel]  = "ͻȺ"
			wBorder[wLevel] = "ͻ̺"

		elseif wBrdr = 3
			wFrame[wLevel]  = "͸Գ"
			wBorder[wLevel] = "͸Ƴ"

		elseif wBrdr = 4
			wFrame[wLevel]  = "ķԳ"
			wBorder[wLevel] = "ķó"

		elseif wBrdr = 5
			wFrame[wLevel]  = ""
			wBorder[wLevel] = ""
			x = x + 2

		endif
	else
		if wBrdr = 1
			wFrame[wLevel]  = "Ŀ"
			wBorder[wLevel] = ""

		elseif wBrdr = 2
			wFrame[wLevel]  = "ͻȺ"
			wBorder[wLevel] = ""

		elseif wBrdr = 3
			wFrame[wLevel]  = "͸Գ"
			wBorder[wLevel] = ""

		elseif wBrdr = 4
			wFrame[wLevel]  = "ķԳ"
			wBorder[wLevel] = ""

		elseif wBrdr = 5
			wFrame[wLevel]  = ""
			wBorder[wLevel] = ""

		endif
	endif

	**------------------------------- Define wExplode
	wExplode[wLevel] = .f.
	if type("wExp") != "U"
		if wExp
			wExplode[wLevel] = .t.
		endif
	endif

	**-------------------- Define Shadows
	wShadow[wLevel] = .f.
	if type("wShad") != "U" .and. type("wShad") = "L"
		if wShad
			wShadow[wLevel] = .t.
		endif
	endif

	**-------------------- Define Window Level Colors
	wColor[wLevel] = wCol

	*--------------------- Check for and save edges of the screen
	wTR[wLevel]	= X
	wLC[wLevel] = wL
	wBR[wLevel] = wB + if(wB+1 <= 24, 1, 0)
	wRC[wLevel]	= wR + if(wR+2 <= 79, 2, if( wR+1 <= 79, 1, 0))

	**-------------------- Save window text coordinates
	wX[wLevel] = wT
	wY[wLevel] = wL
	wXX[wLevel] = wB
	wYY[wLevel] = wR

	**-------------------- Position Cursor in top left corner of the window.
	wCurX[wLevel] = 0
	wCurY[wLevel] = 0
	Num = wLevel
Return (wLevel)						&& Return Level

** End of wMake.Prg **


**------------------------------- Open and Activate window
Function wOpen

	parameters Num

	if pcount() != 1
		return (.f.)
	elseif type("Num") != "N"
		return (.f.)
	endif

	**-------------------- Check to see if window is active.
	*--------------------- Save screen and color configuration
	if !wActive[Num]
		wActive[Num]  = .t.
		wScreen[Num]  = savescreen(wTR[Num]-1, wLC[Num]-1,;
		wBR[Num]+1, wRC[Num]+1)
	endif

	wOldColr[Num] = Setcolor()
	setcolor(wColor[Num])

	**------------------------------- Explode Box if True
	if wExplode[Num]
		Explode( wTR[Num], wLC[Num], wXX[Num], wYY[Num], wFrame[Num])
	else
		scroll( wX[Num]+1, wY[Num]+1, wXX[Num]-1, wYY[Num]-1, 0)	 && fastest clear area.
		@ wTR[Num], wLC[Num], wXX[Num], wYY[Num] box wFrame[Num]
	endif

	**------------------------------- Draw Title Box if Required
	if wTR[Num] < wX[Num]
		@ wTR[Num], wLC[Num] clear to wTR[Num]+2, wYY[Num]
		@ wTR[Num], wLC[Num], wTR[Num] + 2, wYY[Num] box wBorder[Num]
	endif

	**------------------------------- Draw Shadow if True
	if  wShadow[Num]
		Shadow( wTR[Num], wLC[Num], wXX[Num], wYY[Num])
	endif


	**------------------------------- Clear Text Area
	scroll( wX[Num]+1, wY[Num]+1, wXX[Num]-1, wYY[Num]-1, 0)	 && fastest clear area.

	**------------------------------- Display Title
	if !empty(wTitle[Num])
		wDispTit(Num)
	endif

Return (.t.)

*** Eof wOpen.Prg ***

**------------------------------- Draw a window Footer
function wDispMsg

	parameters Num, Msg
	private Y, Size

	Old = setcolor()
	setcolor(wColor[Num])

	y = wY[Num] + 1
	Size = len(Msg)
	Size = (wYY[Num] - Y - Size)/2

	if Size < 0
		return ""
	endif

	Y = Y + Size;

	@ wXX[Num], Y say Msg

	setcolor(Old)

Return ""

** End of wDispMsg.Prg **

**------------------------------- Draw window Title - if title fits
function wDispTit

	parameters Num, Msg
	private Y, Size

	If pcount() = 2
		wTitle[Num] = Msg
	endif

	y = wY[Num] + 1
	Size = len(wTitle[Num])
	Size = (wYY[Num] - Y - Size)/2

	if Size < 0
		return ""
	endif

	Y = Y + Size;

	if wX[num] > wTR[Num]
		@ wX[Num] -1, Y say wTitle[Num]
	else
		@ wX[Num], Y say wTitle[Num]
	endif

Return ""

** End of wDispTit.Prg **


**------------------------------- Explode a Window
procedure Explode

	parameters	eT, eL, eB, eR, wFrame
	private		xT, xL, xB, xR, TReached, LReached

	*------------------------- Determine top & bottom starting lines.
	xT = eT
	xB = eB

	do while .t.
		xT = xT + 1
		xB = xB - 1

		if  xT >= xB
			xT = xT - 1
			xB = xB + 1
			exit
		endif
	enddo

	*------------------------- Determin left and right starting lines.
	xL = eL
	xR = eR

	do while .t.
		xL = xL + 1 * 2
		xR = xR - 1 * 2

		if xL >= xR
			xL = xL - 1 * 2
			xR = xR + 1 * 2
			exit
		endif
	enddo

	*------------------------- Explode the Frame
	store .f. to   TReached, LReached

	do while ! ( TReached .and.  LReached)
		@ xT, xL clear to xB, xR
		@ xT, xL, xB, xR box wFrame
		*------------------------- Decrement top/Increment bottom
		if xT > eT
			xT = xT - 1
			xB = xB + 1
		else
			TReached = .t.
		endif
		*------------------------- Decrement left/Increment right
		if xL > eL
			xL = xL - 1 * 2
			xR = xR + 1 * 2
		else
			LReached = .t.
		endif

	enddo

Return

*** Eof Explode.Prg ***


**------------------------------- Deactivate a window - CLose
Function wClose

	parameters Num

	if pcount() != 1
		return (.f.)
	elseif type("Num") != "N"
		return (.f.)
	endif

	**------------------------------- Reset Cursor at top of window
	wCurX[Num] = 0
	wCurY[Num] = 0

	wActive[Num] = .f.

	**------------------------------- Restore screen under cursor
	restscreen(wTR[Num]-1, wLC[Num]-1, wBR[Num]+1, wRC[Num]+1, wScreen[Num])
	setcolor(wOldColr[Num])

Return (.t.)

** End of wClose.Prg **



**------------------------------- Interactively Re-Size a Window.
Procedure wSize

	parameters Num, kExit, kSave

	OldExp = wExplode[Num]
	wExplode[Num] = .f.

	if pcount() < 2
		kExit = 27
		kSave = 13

	elseif pcount() = 2
		kSave = 13

	endif

	wTRDiff = wX[Num] - wTR[Num]
	OldX = wTR[num]
	NewX = wTR[Num]

	OldY = wLC[num]
	NewY = wLC[Num]
	key = 0

	do while  key != kSave
		key = inkey(0)
		do case
			case Key = 19				&& Left Arrow
				NewY = NewY - 1

			case Key = 4				&& Right Arrow
				NewY = NewY + 1

			case key = 5				&& Up Arrow
				NewX = NewX - 1

			case Key = 24				&& Down Arrow
				NewX = NewX + 1

			case Key = kExit
				NewX = OldX
				NewY = OldY
				key = kSave
		endcase

		**------------------------------- See if Out-of-Range
		if NewX < 0
			NewX = NewX + 1
		endif

		if NewX >= wXX[Num]-5
			NewX = NewX - 1
		endif

		if NewY < 0
			NewY = NewY + 1
		endif

		if NewY >= wYY[Num]-4
			NewY = NewY - 1
		endif

		wClose(Num)

		wTR[Num] = NewX
		wLC[Num] = NewY
		wX[Num]  = NewX + wTRDiff
		wY[Num]  = NewY

		wCurX[Num] = wX[Num]
		wCurY[Num] = wY[Num]

		wOpen(Num)

	Enddo
	wExplode[Num] = OldExp

Return


**------------------------------- Function to move windows.
Procedure wMove

	parameters Num

	parameters Num, kExit, kSave

	OldExp = wExplode[Num]
	wExplode[Num] = .f.

	if pcount() < 2
		kExit = 27
		kSave = 13

	elseif pcount() = 2
		kSave = 13

	endif

	TopDiff = wX[Num] - wTR[Num]

	store wTR[num] to OldX, NewX
	store wBR[Num] to OldXX, NewXX
	store wLC[Num] to OldY, NewY
	store wRC[Num] to OldYY, NewYY
	store wX[Num]  to X
	store wXX[Num]	to XX
	store wY[Num]  to Y
	store wYY[Num] to YY
	yDiff = YY - Y
	xDiff = XX - X

	key = 0

	do while  key != kSave
		key = inkey(0)
		do case
			case Key = 19				&& Left Arrow
				NewY  = NewY  - 1
				NewYY = NewYY - 1

			case Key = 4				&& Right Arrow
				NewY  = NewY  + 1
				NewYY = NewYY + 1

			case key = 5				&& Up Arrow
				NewX  = NewX  - 1
				NewXX = NewXX - 1

			case Key = 24				&& Down Arrow
				NewX  = NewX  + 1
				NewXX = NewXX + 1

			case Key = kExit
				NewX  = OldX
				NewY  = OldY
				NewXX = OldXX
				NewYY = OldYY
				key = kSave

		endcase

		**------------------------------- See if Out-of-Range
		if NewX < 0
			NewX  = NewX  + 1
			NewXX	= NewXX + 1
		endif

		if NewXX >= 24
			NewX  = NewX  - 1
			NewXX = NewXX - 1
		endif

		if NewY < 0
			NewY  = NewY  + 1
			NewYY = NewYY + 1
		endif

		if NewYY >= 79
			NewY  = NewY  - 1
			NewYY = NewYY - 1
		endif

		text = savescreen(wX[Num]+1,wY[Num]+1,wXX[Num]-1,wYY[Num]-1)
		wClose(Num)

		wTR[Num] = NewX
		wBR[Num] = NewXX
		wLC[Num] = NewY
		wRC[Num] = NewYY
		wX[Num]  = NewX + TopDiff
		wY[Num]  = NewY
		wXX[Num] = wX[Num] + xDiff
		wYY[Num] = wY[Num] + yDiff

		wOpen(Num)
		restscreen(wX[Num]+1,wY[Num]+1,wXX[Num]-1,wYY[Num]-1, text)

	Enddo

	wExplode[Num] = OldExp

Return

** End of wSize.Prg **


**------------------------------- Window Say Functions
Function wSay

	parameters Num, X, Y, SayText

	X = X + wX[Num]
	Y = Y + wY[Num]+1

	if Y >= wYY[Num]
		Y = wCurY[Num]
	endif

	if X >= wXX[Num]
		X = wCurX[Num]
	endif

	old = setcolor()
	setcolor(wColor[Num])

	if len(SayText) >= wYY[Num] - Y

		Do while len(SayText) > 1
			sText = substr(SayText, 1, wYY[Num] - y)
			sLen  = if(len(sText) = wYY[Num] - Y,rat(" ",sText),len(stext))
			@ X, Y say Substr(SayText, 1, sLen)
			SayText = Substr(SayText,sLen+1)
			X = X + 1
			if X >= wXX[Num]
				return (.f.)
			endif
		Enddo
		wCurX[Num] = X
		wCurY[Num] = Y

	else
		@ X,Y say SayText

	endif

	setcolor(old)

Return (.t.)
**------------------------------- Window Screen Handling

**------------------------------- Clear a window
Function wClear

	parameters Num
	private Old

	old = setcolor()
	setcolor(wColor[Num])
	scroll(wX[Num]+1, wY[Num]+1, wXX[Num]-1, wYY[Num]-1, 0)
	setcolor(old)

	**------------------------------- Reset the Cursor
	wCurX[Num] = 0
	wCurY[Num] = 0

Return (.t.)

** End of wClear.Prg **

**------------------------------- Clear to End-Of-Line
Function wClearEol

	parameters Num, X
	private Old

	old = setcolor()
	setcolor(wColor[Num])
	scroll(X+wX[Num], wY[Num]+1, X+wX[Num], wYY[Num]-1, 0)
	setcolor(old)

Return (.t.)

