*     UDF's  -  by Roy Ferguson - 436-0645 (H)

* -----------------------------  CONTENTS  ----------------------------
* DATENAME    Return string, i.e. "Wednesday July 23, 1988" from date
* DB_REST     Restore a work area saved with DBSAVE
* DB_SAVE     Save current parameters for a work area & select new area
* SAYMEMO     Clear a rectangular area & "say" a memo variable in it

* 

function DATENAME            && Return date as a name including day of
*                               the week - "Saturday August 20, 1988"

parameter date               && The input date field
private day[7],month[12]

day[1] = "Sunday"
day[2] = "Monday"
day[3] = "Tuesday"
day[4] = "Wednesday"
day[5] = "Thursday"
day[6] = "Friday"
day[7] = "Saturday"
month[ 1] = "January "
month[ 2] = "February "
month[ 3] = "March "
month[ 4] = "April "
month[ 5] = "May "
month[ 6] = "June "
month[ 7] = "July "
month[ 8] = "August "
month[ 9] = "September "
month[10] = "October "
month[11] = "November "
month[12] = "December "

return day[dow(date)] + " " + month[month(date)] + ;
  ltrim(str(day(date))) + ", " + str(year(date),4)

* 

function DB_REST             && Restore a work area saved with DB_SAVE
                             *  (Must be used in pairs)

if dbs_order != 0                      && If there was no index
  set order to dbs_order
endif
select (dbs_area)                      && Area
goto dbs_rec                           && Position record
release dbs_order,dbs_area,dbs_rec     && Free the variables
return .T.

* 

function DB_SAVE             && Save the current work area parameters
                             *  and select a new area

*  Note: this could be expanded to include other work area parameters
*        as listed under "SELECT"

parameter database                     && The new work area

public dbs_rec,;                       && Record number
       dbs_area,;                      && Area
       dbs_order                       && Index order

dbs_rec  = recno()                     && Save the stuff ...
dbs_area = select()
select &database                       && Select the new area
dbs_order = indexord()                 && Save its current index order
return .T.

* 

function SAYMEMO                       && Clear a memo area & "say" it

parameter t,l,b,r,;                    && Boundaries of area
          memo                         && The memo

private nline,mlen,;                   && Line counter & length
        i                              && Index

mlen = r - l                           && Length of memo
nline = 1
@ t,l clear to b,r                     && Clear area (memo may be null)
for i=t to b
  @ i,l say memoline(memo,mlen,nline)  && Say one line of memo
  nline = nline + 1
next
return .T.
