************************************************************************
**
** Ret = RRPrn(array) Given an array of 8 characters, return the 
**       cooresponding printer from the RR.CNF file. On an error, the
**       error is placed in the array ellement. 
**
** Note: This routine is of use to persons using the R&R Relational 
**       Report Writer (r) only. RR.CNF must be in the same directory as
**       the application program. 
** Note: On an error the program will return false or true of no error.
**
**       Copyright (c) 1989 by Dan Rhea
**       All Rights Reserved
**
**       Permission is granted to use this routine in any Clipper
**       application without cost. Just don't pull my Copyright.
**
**  Use: Public Printers[8]
**       If !RRPrn(Printers)
**          ? "Error of some sort with RR.CNF"
**       Endif
**
************************************************************************

Function RRPrn

Parameters Printer

Private Bad, RROk, Pcount, Handle, Header, Buffer, Ineed

Bad = .F.
RROk = .F.
Pcount = 0
Afill(Printer, "Unknown")
*
** Validate the parameter
*
If Len(Printer) <> 8 
   Printer[Pcount+1] = "Err: Printers 1 to 8 only"
   Bad = .T.
Else
   *
   ** Open up the R&R (r) configuration file
   *
   Handle = Fopen("RR.CNF")
   If Ferror() <> 0
      Printer[Pcount+1] = "Err: Can not open RR.CNF"
      Bad = .T.
      Else
      *
      ** Read untill we get an error or all the printers
      *
      Do While !RROk
         Header = Space(2)
         *
         ** Get the 2 byte header
         *
         Got = Fread(Handle, @Header, 2)
         If Ferror() <> 0 .or. Got = 0
            Fclose(Header)
            Printer[Pcount+1] = "Err: Header read"
            Bad = .T.
            RROk = .T.
         Endif
         If !Bad
            Length = Space(2)
            *
            ** Get the 2 byte buffer length
            *
            Got = Fread(Handle, @Length, 2)
            If Ferror() <> 0 .or. Got = 0
               Fclose(Handle)
               Printer[Pcount+1] = "Err: Length read"
               Bad = .T.
               RROk = .T.
            Endif
         Endif
         If !Bad
         Ineed = Bin2i(Length)
         Buffer = Space(Ineed)
            *
            ** Get the buffer
            *
            Got = Fread(Handle, @Buffer, Ineed)
            If Ferror() <> 0 .or. Got <> ineed
               Fclose(Handle)
               Printer[Pcount+1] = "Err: Buffer read"
               Bad = .T.
               RROk = .T.
            Endif
         Endif
         If !Bad
            *
            ** See if this is a printer record and then if it is the
            ** last one
            *
            If AllTrim(Str(Bin2i(Header))) = "260" && Printer header
               Pcount = Pcount + 1                 && Bump printer count
               If Pcount = 8                       && Is this the end? 
                  Bad = .F.                        && It's time to leave
                  RROk = .T.
                  Fclose(Handle)
               Endif
               Printer[Pcount] = Substr(Buffer, 2, Ineed-1)
            Endif
         Endif
      Enddo
   Endif
Endif
*
** Return the final status
*
Return(Bad)
