;------------------------------------------------------------------------------
; Filename: EricRtn.ASM
; Program.: Clipper Extended Library
; Authors.: Eric Eisenhower
; Notes...: User-defined dBASE functions in 8086 assembly for Clipper.
; R&R Support Routines
;	RRPrn(n)    ::= Returns name of printer n from rr.cnf file
   PUBLIC RRPrn

; Clipper return value calls
   EXTRN  __PARINFO:FAR ; fetch info on paramaters passed to me
   EXTRN  __PARC:FAR    ; fetch character string
   EXTRN  __PARDS:FAR   ; fetch date type from date string "YYYYMMDD"
   EXTRN  __PARL:FAR    ; fetch logical true or false
   EXTRN  __PARNI:FAR   ; fetch word as numeric
   EXTRN  __PARNL:FAR   ; fetch double word as numeric
   EXTRN  __PARND:FAR   ; fetch floating point as numeric

   EXTRN  __RETC:FAR    ; return character string
   EXTRN  __RETDS:FAR   ; return date type from date string "YYYYMMDD"
   EXTRN  __RETL:FAR    ; return logical true or false
   EXTRN  __RETNI:FAR   ; return word as numeric
   EXTRN  __RETNL:FAR   ; return double word as numeric
   EXTRN  __RETND:FAR   ; return floating point as numeric

; Macroes

CallDos MACRO	dosfunc		;Call dos
	MOV	AH,dosfunc
	INT	21h
	ENDM

RestR	MACRO		;Restore registers
	POP	ES
	POP	DS
	POP	BP
	ENDM

SaveR	MACRO		;Save registers
	PUSH	BP
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
	ENDM

Spooler MACRO SpoolFunc
	MOV	AH,01
	MOV	AL,SpoolFunc
	INT	47
	ENDM

RetInt  MACRO   Reg	;Return Integer
	PUSH	Reg
	CALL	__RETNI
	POP	Reg
	ENDM

RetLog  MACRO   Reg	;Return Logical
	PUSH	Reg
	CALL	__RETL
	POP	Reg
	ENDM

RetChar MACRO   Reg1,Reg2	;Return Character
	PUSH	Reg1
	PUSH	Reg2
	CALL	__RETC
	ADD	SP,4
	ENDM

GetChar MACRO	num		;Get character parameter
	MOV	AX,num		;Get parameter <num> by
	PUSH	AX		;putting <num> on the stack
	CALL	__PARC		;Get character parameter
	ADD	SP,2		;Fix up stack
	ENDM			;DX:AX points to ASCIIZ string

GetInt	MACRO	num		;Get character parameter
	MOV	AX,num		;Get parameter <num> by
	PUSH	AX		;putting <num> on the stack
	CALL	__PARNI		;Get character parameter
	ADD	SP,2		;Fix up stack
	ENDM			;AX:BX points to ASCIIZ string

DGROUP  GROUP   DATASG  ; Clipper's Data Segment

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group
DATASG  SEGMENT PUBLIC  'DATA'
RRCNF	DB	'RR.CNF',00,'$'	; rr.cnf configuration file
RRRTYPE	DW	?
RRRLEN	DW	?
RRPRINT DW	15 DUP (?)

DATASG  ENDS			; end of datasg (in DGROUP)

_PROG SEGMENT	'CODE'

	ASSUME CS:_PROG,DS:DATASG,ES:DATASG

;--
;  RRPrn()
;  Syntax: RRPrn(n)
;  Return: Name of printer n from rr.cnf file

RRPrn	PROC FAR
	SaveR
	GetInt	1
	PUSH	AX		; Save it temporarily

	MOV	AX,SEG RRCNF
	MOV	DS,AX
	MOV	RRPRINT,0000h	;Clear out return value
	MOV	DX,OFFSET RRCNF
	MOV	AL,00		;read only
	CallDos 3dH		;Open file
	JC	RRBAD
	MOV	BX,AX		;file handle

RREADh:
	MOV	CX,04			;read 4 bytes
	MOV	DX,OFFSET RRRTYPE	;buffer
	CallDos 3Fh			;read
	JC	RRCLOSE
	CMP	AX,04			;Did we get four bytes? (is it EOF)
	JC	RRCLOSE
	CMP	RRRTYPE,0104h		;Is record type Printer name?
RREADh2:

	JE	RRREADp			;Yes? goto readp (read printer name)
	MOV	CX,0			;
	MOV	DX,RRRLEN		;read rest of record
	MOV	AL,1
	CallDos 42h
	JC	RRCLOSE
	JMP	RREADh

RRREADp:
	POP	AX
	DEC	AX
	PUSH	AX
	CMP	AX,0
	JG	RREADh2
	MOV	CX,RRRLEN		;read ? bytes
	MOV	DX,OFFSET RRPRINT	;buffer
	MOV	SI,DX
	ADD	SI,RRRLEN
	MOV	BYTE PTR [SI],00h	; null terminate byte
	INC	SI
	MOV	BYTE PTR [SI],00h	; null terminate byte
	CallDos 3Fh			;read

RRCLOSE:
	CallDos 3eH		;Close file
	JMP	RROK

RRBAD:	MOV	BX,AX
	JMP	RRDONE

RROK:	MOV	BX,0

	
RRDONE:
	POP	BX	;get rid of param
	MOV	AX,DS
	MOV	BX,OFFSET RRPRINT
	INC	BX
	RestR
	RetChar	AX,BX

	RET

RRPrn	ENDP


_PROG ENDS

	END

; EOF EricRtn.asm -----------------------------------------------------------

