#include 'fileio.ch'

/******************************************************************************
  This program was an Original idea by: Copyright (c) 1989 by Dan Rhea
                                        All Rights Reserved

  Conception and Modification by:
     Alain Hogue
     AZA Informatique
     (514) 595-5885
     Montral, Qubec, Canada
     Compuserve: 75360,163
     18 fvrier 1991

     This program is FreeWare, and you can change it to your heart
     content.

     Please retain this heading, so the credit will at least survive me.
     If you change/add something, if you find a bug or just hate it,
     please let me know.

     This is my second FreeWare, and I hope you will enjoyed it.

     This is working with either version 3 or 4 of RR.CNF
     It will read the .CNF file to extract the name of the printer
     defined in it, and will return an array.

     This is A LOT faster than the original version !


USAGE: RRprn([<cRRFileName>],    // Name of R&R '.CNF' file. RR.CNF if NIL.
             [<lFrench>]         // .T. if you want French lines.
            ) -> aPrinter        // Return an Array containing the name
                                    of the printers defined in the '.CNF'
                                    file, PLUS the 'Display' & 'To file' option.

       The returned array is defined like this:

         aPrinter[1] := {"Printer 1","Printer2",...,"Display","To file"}
         aPrinter[2] := {        "1",       "2",...,      "D",      "A"}

       So by using ACHOICE with the printer string, you can use the returned
       value to get the printer number.


EXAMPLE: ...

         LOCAL aPrinter := RRprn("RR.CNF"),;
               nValue := 0,;
               cPrinterSelected := " "

         IF (nValue := ACHOICE(10,10,15,60,aPrinter[1])) > 0
              cPrinterSelected := aPrinter[2,nValue]
              RRUNIN->RI_PRINTER := cPrinterSelected
         END

         ...


******************************************************************************/

FUNCTION RRprn(cRRfile,lFrench)
LOCAL ObjHandle,;                         // This is used to keep the handle
      cBuffer := "",;                     // Keep the whole rr.cnf file
      cBuf1, cBuf2, cBuf3,;               // working buffer
      nIneed := 0,;
      nLength := 0,;
      nCount := 0,;
      aPrinter := ARRAY(2,1),;            // final array to return
      i,;
      nIndex := 1

cRRfile := IIF(cRRfile == NIL, "RR.CNF", cRRfile)
lFrench := IIF(lFrench == NIL, .F., lFrench)

IF ( GetFileObject(cRRfile,@ObjHandle) )  // open the file
     nLength := SeekFileObject(ObjHandle, .T.)   // get the size
     SeekFileObject(ObjHandle)                   // rewind the pointer
     cBuffer := SPACE( nLength )

     IF ( ReadFileObject(ObjHandle, @cBuffer, nLength ) == nLength );
          .AND. FERROR() == 0

          WHILE .T.
               cBuf1 := SUBSTR(cBuffer, nIndex, 2)
               nIndex += 2
               cBuf2 := SUBSTR(cBuffer, nIndex, 2)
               nIndex += 2
               nIneed := BIN2I(cBuf2)

               IF ALLTRIM( STR( BIN2I( cBuf1 ) ) ) == "260"   // Printer header
                    cBuf3 := SUBSTR(cBuffer, nIndex, nIneed)
                    nIndex += nIneed
                    nCount++
                    IF nCount > 1
                         AADD(aPrinter[1],"")
                         AADD(aPrinter[2],"")
                    ENDIF
                    aPrinter[1,nCount] := LEFT(SPACE(1);
                                        + SUBSTR(cBuf3, 2, nIneed - 1);
                                        + SPACE(30), 30)
                    aPrinter[2,nCount] := STR(nCount, 1)
               ELSE
                    nIndex += nIneed
               ENDIF

               IF (nIndex >= nLength) .OR. (nCount == 8) // maximum printer is 8
                    EXIT
               ENDIF

          ENDDO
     ENDIF
     KillFileObject( ObjHandle )  // close the file rr.cnf
ENDIF

nCount++
IF nCount > 1
     AADD(aPrinter[1],"")
     AADD(aPrinter[2],"")
ENDIF
aPrinter [1,nCount] := IIF(lFrench,;
                           LEFT(" Visualiser  l'cran" + SPACE(30), 30),;
                           LEFT(" Display to Screen" + SPACE(30), 30))
aPrinter [2,nCount] := "D"

nCount++
IF nCount > 1
     AADD(aPrinter[1],"")
     AADD(aPrinter[2],"")
ENDIF
aPrinter [1,nCount] := IIF(lFrench,;
                           LEFT(" Traitement de Texte" + SPACE(30), 30),;
                           LEFT(" Print to a File" + SPACE(30), 30))
aPrinter [2,nCount] := "A"

RETURN aPrinter




/*
  Theses functions are taken from the 50orbust.doc included
  in FUNCky1.5
*/
*********************************************************
FUNCTION GetFileObject(cFileName, FileObject)
IF (( FileObject := FOPEN(cFileName,FO_SHARED)) < 0)
     RETURN .F.
ENDIF
RETURN (.T.)




*********************************************************
FUNCTION KillFileObject( FileObject)
IF ( FileObject > 0 )
     FCLOSE( FileObject )
ENDIF
RETURN NIL



*********************************************************
FUNCTION ReadFileObject( FileObject, Buffer, Bytes)
RETURN(FREAD( FileObject, @Buffer, Bytes ))





*********************************************************
FUNCTION SeekFileObject( FileObject, lEnd)

lEnd := IIF(lEnd==NIL,.F.,lEnd)

IF lEnd
     RETURN(FSEEK(FileObject, 0, FS_END))
ELSE
     RETURN(FSEEK(FileObject, 0))
ENDIF
