@echo off
REM ==========================================================================
REM  File:     MAKEDEMO.BAT
REM
REM  Purpose:  Batch file to compile and link the RLIB demo program DEMO.PRG
REM
REM  Syntax:   makedemo
REM
REM  Notes:    This is a batch file to make the RLIB demonstration program
REM            DEMO.EXE from the source file DEMO.PRG supplied with the
REM            RLIB 3.2 demo and distribution package.
REM
REM            This will meke the RLIB 3.2 demo under Clipper Summer '87
REM
REM            This batch file assumes that the Clipper Summer '87 files
REM            reside in the C:\CLIPPER directory.  It also assumes that
REM            the Clipper supplied libraries reside in C:\CLIPPER.
REM            Change the directory references and environment variable
REM            settings as needed.
REM ==========================================================================


:COMPS87
REM --------------------------------------------------------------------------
REM  I have left the RLIB reference to the current directory and assume the
REM  Clipper Summer '87 files are in C:\CLIPPER.
REM --------------------------------------------------------------------------
c:\clipper\clipper demo -m


:LINKS87
REM --------------------------------------------------------------------------
REM  Use the linker of your choice here.  I use BLINKER and TLINK a lot, but
REM  everyone has PLINK86 because it comes with Clipper S'87.  To link DEMO
REM  using TLINK, my syntax is as follows:
REM
REM  cd j:\clipper
REM  j:\tc\tlink11 demo,demo.exe,nul,j:clipper+j:libs\rlib+j:extend
REM
REM  To link DEMO using Blinker, my syntax is:
REM
REM  cd j:\clipper
REM  j:\clipper\blinker\blinker @demo.lnk
REM
REM  If you did not place RLIB.LIB in the current directory, add the directory
REM  where it is located to the link command.  For instance, if you placed
REM  RLIB.LIB in the Clipper directory, change the link reference below from
REM  RLIB to C:\CLIPPER\RLIB.
REM
REM  *** A little known fact is that PLINK86 respects the setting of the LIB
REM      environment variable.  I set LIB=C:\CLIPPER to keep PLINK86 from
REM      complaining that it can't find CLIPPER.LIB.
REM --------------------------------------------------------------------------
set LIB=C:\CLIPPER
c:\clipper\plink86 file demo lib clipper,rlib,extend verbose

:END

