*******************************************************************************
* Program:     DEMO.PRG
*
* Purpose:     RLIB 3.2 Demonstration Program
*
* Author:      Richard Low
*
* Notice:      Copyright (C) 1991-1993 Richard C. Low
*
* Version:     Compile with either Clipper Summer '87, Clipper 5.01, or
*              CA-Clipper 5.2 compiler.
*
*              If compiling with 5.x DO NOT use the /N or /W compiler switch.
*
* Syntax:      demo [EDIT]
*
* Called by:   DOS
*
* Returns:     Nothing
*
* Parameters:  Optional character string "EDIT" which will force the demo
*              program into edit mode when function descriptions are presented
*              with MEMOEDIT().  This was used to build the descriptions in
*              the demo database.
*
*******************************************************************************
PARAMETER edit

edit = IF( PCOUNT() = 1, ( UPPER(edit) = "EDIT" ), .F. )

SET SCOREBOARD OFF
SET COLOR TO W/N
SETCURSOR(1)                      && it's a good idea to make the 1st call early
CLEAR

IF .NOT. FILES("demo.dbf", "demo.dbt")
   ? "This demo requires the database file DEMO.DBF and its associated memo"
   ? "file DEMO.DBT which are included in the RLIB package.  Please place"
   ? "these two files in the current default directory and try again."
   ? CHR(7)
   RETURN
ENDIF

SAVE SCREEN TO dosscreen
saverow = ROW()
savecol = COL()

SETCOLOR(IF(ISCOLOR(),"BG+/B,B/W","W/N,N/W"))
@ 1,0 CLEAR
TEXT
                                     RLIB
                                  Version 3.2

            Useful Functions for the Clipper Applications Programmer

                         Copyright 1991-1993 Richard Low
                               All Rights Reserved

   Welcome to the RLIB demonstration program.  The purpose of this demo is to
   show what RLIB functions can do.  It can also serve as a supplement to the
   documentation by providing examples of RLIB functions in use.

   The demo starts by presenting you with a menu of RLIB function categories.
   The starting menu is an example of the RLIB BOXMENU() function.  To change
   the style of menu used in the demo, choose the BARMENU(), the MULTIMENU(),
   or the PDOWNMENU() option from the Menu Functions sub-menu.

   Take a look at the PICKREC()  function in the Database Functions sub-menu.
   The PICKREC() demo lets you to scroll through a list of the RLIB functions
   where you can view RLIB function descriptions and syntax.

ENDTEXT
@ 1,0,24,79 BOX "Ŀ"
CENTER(23, "Initializing...")


*-- first need to initialize all public variables and arrays
IF .NOT. Initialize()
   CENTER(23,"Could not create DEMO index, program aborted")
   RETURN
ENDIF


CENTER(23,"Press any key to begin...")

x = GetKey(30)
DO WHILE x = 0
   x = ASC(BOXASK(helpColor,"The demo will start as soon as you press a key",4))
   x = IF( x = 0, GetKey(10), x )
ENDDO

SETCOLOR("W/N")
CLEAR

ClearScr()

*-- use the SETCURSOR() function so subsequent RLIB functions know of it
SETCURSOR(SC_NONE)
SETCOLOR(democolor)


*-- Each active menu routine may control the whole demo.  If the user selectes
*-- a different menu control, the current routine will set <menustyle> and exit
*-- back to this main loop.  The BEGIN SEQUENCE facility is used to allow
*-- conditional branching back to this main routine from within the other procs
PUBLIC menustyle, showtime, dummy, single, double

menustyle = "BOXMENU()"            && start off with BOXMENU
showtime  = 5                      && seconds to pause while showing syntax
dummy     = ""                     && global DUMMY parameter
single    = "Ŀ"             && used for single line boxes w/ clear fill
double    = "ͻȺ"             && used for double line boxes
solid     = ""


*-- open the demo database and index created during initialization
IF .NOT. OPENED("demo INDEX demo SHAREABLE")
   SET CURSOR ON
   SET COLOR TO
   @ 23,0 SAY ""
   RETURN
ENDIF

*-- turn on the ticking clock after the intialization period
gkey_clock = .T.

*-- each routine will set menustyle to NULL ("") to quit
DO WHILE .NOT. EMPTY(menustyle)
   BEGIN SEQUENCE
      DO CASE
         CASE menustyle = "BARMENU()"
            BarDemo()

         CASE menustyle = "BOXMENU()"
            BoxDemo()

         CASE menustyle = "MULTIMENU()"
            MultiDemo()

         CASE menustyle = "PDOWNMENU()"
            PullDemo()
      ENDCASE
   END
ENDDO

RESTORE SCREEN FROM dosscreen
@ saverow,savecol SAY ""
CLOSE DATABASES
SET CURSOR ON
SET COLOR TO
RETURN

*-- End of main program.

*----------------------------------------------------------------------------
* Function:  Initialize()
* Notes:     Function to initialize demo procedure names into a PUBLIC
*            array to be later referenced via the DIM2() UDF.
*            These demo procedures are called via macro substitution at
*            run time by first retrieving the name of the demo procedure
*            to run from the combination of menu options chosen.  These
*            options pair correspond to the DIM2 location of the procedure
*            name in the <demos> array, which, thanks to the DIM@() UDF,
*            looks and acts like a two dimensional array.
*----------------------------------------------------------------------------
FUNCTION Initialize

PUBLIC SC_NONE
PUBLIC SC_NORMAL

*-- these can be changed to #defines in 5.01 and are compatible with setcurs.ch
SC_NONE   = 0
SC_NORMAL = 1


PUBLIC gkey_clock
gkey_clock = .F.


*-- set color variables and arrays for the demo
PUBLIC demoColor, sayColor, getColor, unselColor, helpColor, syntaxColor, backGround

IF ISCOLOR()
   PUBLIC boxcolors[6], barcolors[5], pullcolors[8], multicolors[5]

   sayColor    = "W/B"
   getColor    = "N/W"
   unselColor  = "N/BG"
   helpColor   = "B/W"
   syntaxColor = "N/BG"
   backGround  = "W/B"

   boxcolors[1] = "W/B"                 && White on Blue option display
   boxcolors[2] = "N/BG"                && Black on Cyan hilite menu bar
   boxcolors[3] = "BG+/B"               && Bright Cyan on Blue Active Border
   boxcolors[4] = "BG/B"                && Regular Cyan on Blue In-active Border
   boxcolors[5] = "GR+/B"               && Yellow on Blue for the selected option
   boxcolors[6] = "BG+/B"               && Bright Cyan on Blue messages

   barcolors[1] = "W/B"                 && White on Blue display
   barcolors[2] = "N/BG"                && Black on Cyan menu bar
   barcolors[3] = "BG+/B"               && Bright Cyan on Blue Active Border
   barcolors[4] = "BG/B"                && Regular Cyan on Blue In-active Border
   barcolors[5] = "GR+/B"               && Yellow on Blue for the selected option

   pullcolors[1] = "W/B"                && White on Blue options
   pullcolors[2] = "N/BG"               && Black on Cyan menu bar
   pullcolors[3] = "BG+/B"              && Bright Cyan on Blue Active Border
   pullcolors[4] = "BG/B"               && Regular Cyan on Blue In-active Border
   pullcolors[5] = "GR+/B"              && Yellow on Blue for the selected option
   pullcolors[6] = "BG+/B"              && Bright Cyan on Blue messages
   pullcolors[7] = "N+/B"               && Dim Black unselectable options
   pullcolors[8] = "N/BG"               && Top menu bar when selected

   multicolors[1] = "W/B"               && White on Blue display
   multicolors[2] = "N/BG"              && Black on Cyan menu bar
   multicolors[3] = "BG+/B"             && Bright Cyan on Blue Active Border
   multicolors[4] = "BG/B"              && Regular Cyan on Blue In-active Border
   multicolors[5] = "GR+/B"             && Yellow on Blue for the selected option
ELSE
   PUBLIC boxcolors, barcolors, pullcolors[8], multicolors[5]
   STORE "" TO boxcolors, barcolors     && use RLIB default monochrome colors

   sayColor    = "W/N"
   getColor    = "N/W"
   unselColor  = "W/N"
   helpcolor   = "N/W"
   syntaxcolor = "N/W"
   background  = "W/N"

   pullcolors[1] = "W/N"                && White on Black options
   pullcolors[2] = "N/W"                && Black on White menu bar
   pullcolors[3] = "W+/N"               && Bright White Black Active Border
   pullcolors[4] = "W/N"                && Regular White on Black In-active Border
   pullcolors[5] = "W+/N"               && Bright White on Black for the selected option
   pullcolors[6] = "W/N"                && White on Black messages
   pullcolors[7] = "W/N"                && no choice in mono for unselectable options
   pullcolors[8] = "N/W"                && Top menu bar when selected

   multicolors[1] = "W/N"               && White on Black display
   multicolors[2] = "N/W"               && Black on White menu bar
   multicolors[3] = "W/N"               && White on Black Active Border
   multicolors[4] = "W/N"               && same for In-active Border
   multicolors[5] = "W+/N"              && Bright White for selected option
ENDIF

demoColor = sayColor + "," + getColor + ",,," + unselColor

PUBLIC m_aboxask
PUBLIC m_acronym
PUBLIC m_adim2
PUBLIC m_alist
PUBLIC m_alphadate
PUBLIC m_anycharsin
PUBLIC m_arraylen
PUBLIC m_atinsay
PUBLIC m_barmenu
PUBLIC m_beep
PUBLIC m_bin2dec
PUBLIC m_blip
PUBLIC m_borderbox
PUBLIC m_boxask
PUBLIC m_boxmenu
PUBLIC m_bright
PUBLIC m_buzz
PUBLIC m_calendar
PUBLIC m_catf
PUBLIC m_center
PUBLIC m_cfta
PUBLIC m_changed
PUBLIC m_checkfile
PUBLIC m_closearea
PUBLIC m_dbfcreate
PUBLIC m_dec2hex
PUBLIC m_decrypted
PUBLIC m_divide
PUBLIC m_encrypted
PUBLIC m_feof
PUBLIC m_filedate
PUBLIC m_files
PUBLIC m_filesize
PUBLIC m_filetime
PUBLIC m_forget
PUBLIC m_fprompt
PUBLIC m_freadline
PUBLIC m_frestscreen
PUBLIC m_fsavescreen
PUBLIC m_getfile
PUBLIC m_getkey
PUBLIC m_getparm
PUBLIC m_hex2dec
PUBLIC m_isdbf
PUBLIC m_isfield
PUBLIC m_keyinput
PUBLIC m_makealias
PUBLIC m_markrec
PUBLIC m_memorize
PUBLIC m_middle
PUBLIC m_mreplace
PUBLIC m_multimenu
PUBLIC m_namesplit
PUBLIC m_no_append
PUBLIC m_no_flock
PUBLIC m_no_rlock
PUBLIC m_notempty
PUBLIC m_ntxkeyval
PUBLIC m_olderfile
PUBLIC m_opened
PUBLIC m_parent
PUBLIC m_pathto
PUBLIC m_pdowninit
PUBLIC m_pdownmenu
PUBLIC m_pickcolor
PUBLIC m_pickfile
PUBLIC m_pickrec
PUBLIC m_popbox
PUBLIC m_popuppick
PUBLIC m_printcode
PUBLIC m_query
PUBLIC m_reportinit
PUBLIC m_revdate
PUBLIC m_rh_header
PUBLIC m_rh_lines
PUBLIC m_rh_text
PUBLIC m_rh_width
PUBLIC m_rjustify
PUBLIC m_rliberror
PUBLIC m_rlibinit
PUBLIC m_rlibver
PUBLIC m_sayinbox
PUBLIC m_setcursor
PUBLIC m_startreport
PUBLIC m_str2date
PUBLIC m_stretch
PUBLIC m_target
PUBLIC m_tempfile
PUBLIC m_typec
PUBLIC m_valtypec
PUBLIC m_vrange

m_aboxask     = "Pop up a centered message box using array of messages"
m_acronym     = "Convert a text string to its abbreviated acronym"
m_adim2       = "Formulate a two dimension reference to a linear array"
m_alist       = "List the elements of an array in a screen window"
m_alphadate   = "Convert date variables to alphabetic format"
m_anycharsin  = "Test if any characters in a string are in another"
m_arraylen    = "Count the number of contiguous elements in an array"
m_atinsay     = "Display expression at in a specified color"
m_barmenu     = "Create horizontal light bar menus"
m_beep        = "Ring the system bell one or more times"
m_bin2dec     = "Convert binary number to its equivalent decimal value"
m_blip        = "Generate a blipping sound for warnings or errors"
m_borderbox   = "Draw a box with a one line title area at the top"
m_boxask      = "Pop up a centered message box using multiple messages"
m_boxmenu     = "Create boxed framed highlight bar (pop up) menus"
m_bright      = "Convert Clipper color string to its bright equivalent"
m_buzz        = "Generate a buzzing sound for warnings or errors"
m_calendar    = "Pop up a configurable calendar on the screen"
m_catf        = "Copy array values to database fields"
m_center      = "Center a string and/or get the center position"
m_cfta        = "Copy database field values to an array"
m_changed     = "Test if memory copies of fields have been changed"
m_checkfile   = "Verify valid filenames, optionally pop up a pick list"
m_closearea   = "Close multiple database work areas with one command"
m_dbfcreate   = "Dynamically create a database from a structure array"
m_dec2hex     = "Convert decimal numeric value to a hexadecimal string"
m_decrypted   = "Decrypt a character string encrypted with ENCRYPTED()"
m_divide      = "Divide numbers with divide by zero protection"
m_encrypted   = "Encrypt a character string"
m_feof        = "Test for the End Of File status on a binary file"
m_filedate    = "Retrieve last update date for a given file from DOS"
m_files       = "Test for the existence of multiple files"
m_filesize    = "Retrieve the size of a file from DOS directory"
m_filetime    = "Retrieve the last update time for a given file"
m_forget      = "Release field variables created with MEMORIZE()"
m_fprompt     = "Display formatted and highlighted prompt strings"
m_freadline   = "Read line from text file opened with FOPEN()/FCREATE()"
m_frestscreen = "Restore screen from a file saved with FSAVESCREEN()"
m_fsavescreen = "Save screen to file to restore with FRESTSCREEN()"
m_getfile     = "Full featured user dialogue box for GETing filenames"
m_getkey      = "Replace INKEY() to allow internal customization"
m_getparm     = "Retrieve comma delimited token from character string"
m_hex2dec     = "Convert hex string to equivalent decimal value"
m_isdbf       = "Test if a file is a valid .DBF format database file"
m_isfield     = "Test if a field name is valid in the selected area"
m_keyinput    = "Get keyboard input optionally echoing dots to screen"
m_makealias   = "Construct a database alias from a full filename"
m_markrec     = "Mark/select multiple records from a pick list"
m_memorize    = "Save fields from database record to memory variables"
m_middle      = "Center string by padding with leading/trailing spaces"
m_mreplace    = "Replace fields with memvars created with MEMORIZE()"
m_multimenu   = "Create multi-column menus with 4 way cursor movement"
m_namesplit   = "Swap from First Middle Last to Last, First Middle"
m_no_append   = "Network append blank function with error trapping"
m_no_flock    = "Network file lock function with error trapping"
m_no_rlock    = "Network record lock function with error trapping"
m_notempty    = "Validate that data was entered in a field"
m_ntxkeyval   = "Get controlling index key value of the current record"
m_olderfile   = "Determine the older of two disk files"
m_opened      = "Open multiple databases with network error checking"
m_parent      = "Retrieve parent directory for a specified directory"
m_pathto      = "Search DOS path for path leading to a given filename"
m_pdowninit   = "Initialize the PDOWNMENU() function for use"
m_pdownmenu   = "Activate pull-down menu initialized with PDOWNINIT()"
m_pickcolor   = "Pick a color setting from a boxed display"
m_pickfile    = "Pop up directory listing from which to select a file"
m_pickrec     = "Pop up a scrollable pick list of database records"
m_popbox      = "Restore a screen from a SAYINBOX() screen variable"
m_popuppick   = "Generic pop-up pick list handler"
m_printcode   = "Convert text printer codes into escape sequences"
m_query       = "Create a logical query/filter string via menu prompts"
m_reportinit  = "Initialize StartReport() databases"
m_revdate     = "Reverse date fields for reverse index ordering"
m_rh_header   = "Retrieve the header from a RHELP compiled help file"
m_rh_lines    = "Get the number of text lines within a help text block"
m_rh_text     = "Extract help text for a key from compiled .HLP file"
m_rh_width    = "Get the maximum line width within a help text block"
m_rjustify    = "Move trailing blanks to the front"
m_rliberror   = "Return and optionally set the last RLIB error number"
m_rlibinit    = "Initialize internal RLIB PUBLIC/STATIC variable(s)"
m_rlibver     = "Retrieve the version number of the RLIB.LIB linked"
m_sayinbox    = "Pop up centered message box using multiple messages"
m_setcursor   = "Retrieve and optionally set the current cursor state"
m_startreport = "General report format and print control function"
m_str2date    = "Convert date strings to a Clipper date type variable"
m_stretch     = "Pad string with blanks or truncate to a defined width"
m_target      = "Provide a pop-up target printer output selection menu"
m_tempfile    = "Generate a temporary filename"
m_typec       = "Test if a PUBLIC/PRIVATE is character and not blank"
m_valtypec    = "Test if a LOCAL/STATIC is character and not blank"
m_vrange      = "Numeric range validation with error handling"


*-- use OPENED() function to try to open file WITHOUT error notification
*-- the first time around.

IF OPENED(.F., "demo EXCLUSIVE")
   INDEX ON udf_name TO demo
ELSE
   *-- If we can't open the file exclusive, assume it's already open by
   *-- another station, in which case the index file will be there and
   *-- up to date.  Check that the reason OPENED() failed was strictly
   *-- a file sharing problem with RLIBERROR(), which should equal 1101.
   IF RLIBERROR() > 1101
      BUZZ()
      SAYINBOX(IF(ISCOLOR(),"W+/R","N/W"),"Error opening DEMO.DBF",;
               "Demo aborted!", "Press any key to return to DOS", 30)
      RETURN .F.
   ENDIF
ENDIF

CLOSE DATABASES
RETURN .T.



*----------------------------------------------------------------------------
* Function:  BOXDEMO()
* Notes:     Sub function to control demo with BOXMENU(), default.
*----------------------------------------------------------------------------
FUNCTION BoxDemo
PRIVATE option, message, choice, toprow, topcol, msgrow, header

*-- set up arrays to hold menu options and messages
DECLARE option[11], message[11]

*-- they don't have to be the same length, just a matter of preference
option[ 1] = "  Menu Functions          "
option[ 2] = "  Array Functions         "
option[ 3] = "  Character Functions     "
option[ 4] = "  Database Functions      "
option[ 5] = "  Date Functions          "
option[ 6] = "  File Functions          "
option[ 7] = "  Numeric Functions       "
option[ 8] = "  Printer Functions       "
option[ 9] = "  Screen Functions        "
option[10] = "  Other Functions         "
option[11] = "  Quit to DOS             "

message[ 1] = "Menus never were easier and more powerful!"
message[ 2] = "Test, list, and pseudo dimension array"
message[ 3] = "Handy character string functions, all in Clipper!"
message[ 4] = "Make editing database files easy"
message[ 5] = "Pop-up Calendar, reverse dates, convert strings to dates"
message[ 6] = "Find files, get file dates and times, and other stuff"
message[ 7] = "You don't have to program in C to do numeric conversions"
message[ 8] = "Use these to snaz up report routines in a flash"
message[ 9] = "Helpful goodies for prompting and error messages"
message[10] = "A few UDFs to use either now and then, or all the time"
message[11] = "Before you quit, try all the neat menus"

*-- 1234567 will automatically select the choice, add
choice    = 1
toprow    = 5
topcol    = CENTER(option[1])
msgrow    = 24
header    = "RLIB FUNCTION CATEGORIES"

DO WHILE .T.
   ClearScr()
   choice = BOXMENU( toprow, topcol, option, choice, dummy, dummy,;
                     message, msgrow, boxcolors, header, .T. )
   DO CASE
      CASE choice = 0
         choice = 11

      CASE choice = 11
         menustyle = ""                && forces calling fucntion to terminate
         BREAK

      OTHERWISE
         SubBoxMenu(choice, LTRIM(TRIM(option[choice])))

   ENDCASE
ENDDO
RETURN 0


*----------------------------------------------------------------------------
* Function:  SubBoxMenu()
* Syntax:    SubBoxMenu(group,header)
* Notes:     Sub procedure to control demo with BOXMENU(), default.
* Assumes:   The group numbers are:
*
*              1   Menuing Tools
*              2   Array Functions
*              3   Character Functions
*              4   Database Functions
*              5   Date Functions
*              6   File Functions
*              7   Numeric Functions
*              8   Printer Functions
*              9   Screen Functions
*             10   Other Functions
*             11   Quit to DOS
*----------------------------------------------------------------------------
FUNCTION SubBoxMenu
PARAMETER group, header
PRIVATE choice, row, col, subBoxScr

DO CASE
   CASE group = 1                                          && Menu
      DECLARE rlib[3], mess[3]
      rlib[ 1] = "  1.  BARMENU()      "
      rlib[ 2] = "  2.  MULTIMENU()    "
      rlib[ 3] = "  3.  PDOWNMENU()    "
      mess[ 1] = m_barmenu
      mess[ 2] = m_multimenu
      mess[ 3] = m_pdownmenu

   CASE group = 2                                           && Array
      DECLARE rlib[5], mess[5]
      rlib[ 1] = "  1.  ADIM2()        "
      rlib[ 2] = "  2.  ALIST()        "
      rlib[ 3] = "  3.  ARRAYLEN()     "
      rlib[ 4] = "  4.  CATF()         "
      rlib[ 5] = "  5.  CFTA()         "
      mess[ 1] = m_adim2
      mess[ 2] = m_alist
      mess[ 3] = m_arraylen
      mess[ 4] = m_catf
      mess[ 5] = m_cfta

   CASE group = 3                                           && Character
      DECLARE rlib[15], mess[15]
      rlib[ 1] = "  1.  ACRONYM()      "
      rlib[ 2] = "  2.  ANYCHARSIN()   "
      rlib[ 3] = "  3.  BRIGHT()       "
      rlib[ 4] = "  4.  DECRYPTED()    "
      rlib[ 5] = "  5.  ENCRYPTED()    "
      rlib[ 6] = "  6.  GETKEY()       "
      rlib[ 7] = "  7.  GETPARM()      "
      rlib[ 8] = "  8.  KEYINPUT()     "
      rlib[ 9] = "  9.  MIDDLE()       "
      rlib[10] = " 10.  NAMESPLIT()    "
      rlib[11] = " 11.  NOTEMPTY()     "
      rlib[12] = " 12.  RJUSTIFY()     "
      rlib[13] = " 13.  STRETCH()      "
      rlib[14] = " 14.  TYPEC()        "
      rlib[15] = " 15.  VALTYPEC()     "
      mess[ 1] = m_acronym
      mess[ 2] = m_anycharsin
      mess[ 3] = m_bright
      mess[ 4] = m_decrypted
      mess[ 5] = m_encrypted
      mess[ 6] = m_getkey
      mess[ 7] = m_getparm
      mess[ 8] = m_keyinput
      mess[ 9] = m_middle
      mess[10] = m_namesplit
      mess[11] = m_notempty
      mess[12] = m_rjustify
      mess[13] = m_stretch
      mess[14] = m_typec
      mess[15] = m_valtypec

   CASE group = 4                                           && Database
      DECLARE rlib[18], mess[18]
      rlib[ 1] = "  1.  CHANGED()       "
      rlib[ 2] = "  2.  CLOSEAREA()     "
      rlib[ 3] = "  3.  DBFCREATE()     "
      rlib[ 4] = "  4.  FORGET()        "
      rlib[ 5] = "  5.  ISDBF()         "
      rlib[ 6] = "  6.  ISFIELD()       "
      rlib[ 7] = "  7.  MAKEALIAS()     "
      rlib[ 8] = "  8.  MARKREC()       "
      rlib[ 9] = "  9.  MEMORIZE()      "
      rlib[10] = " 10.  MREPLACE()      "
      rlib[11] = " 11.  NO_APPEND()     "
      rlib[12] = " 12.  NO_FLOCK()      "
      rlib[13] = " 13.  NO_RLOCK()      "
      rlib[14] = " 14.  NTXKEYVAL()     "
      rlib[15] = " 15.  OPENED()        "
      rlib[16] = " 16.  PICKREC()       "
      rlib[17] = " 17.  POPUPPICK()     "
      rlib[18] = " 18.  QUERY()         "
      mess[ 1] = m_changed
      mess[ 2] = m_closearea
      mess[ 3] = m_dbfcreate
      mess[ 4] = m_forget
      mess[ 5] = m_isdbf
      mess[ 6] = m_isfield
      mess[ 7] = m_makealias
      mess[ 8] = m_markrec
      mess[ 9] = m_memorize
      mess[10] = m_mreplace
      mess[11] = m_no_append
      mess[12] = m_no_flock
      mess[13] = m_no_rlock
      mess[14] = m_ntxkeyval
      mess[15] = m_opened
      mess[16] = m_pickrec
      mess[17] = m_popuppick
      mess[18] = m_query

   CASE group = 5                                           && Date
      DECLARE rlib[4], mess[4]
      rlib[ 1] = "  1.  ALPHADATE()    "
      rlib[ 2] = "  2.  CALENDAR()     "
      rlib[ 3] = "  3.  REVDATE()      "
      rlib[ 4] = "  3.  STR2DATE()     "
      mess[ 1] = m_alphadate
      mess[ 2] = m_calendar
      mess[ 3] = m_revdate
      mess[ 4] = m_str2date

   CASE group = 6                                           && File
      DECLARE rlib[11], mess[11]
      rlib[ 1] = "  1.  CHECKFILE()    "
      rlib[ 2] = "  2.  FEOF()         "
      rlib[ 3] = "  3.  FILEDATE()     "
      rlib[ 4] = "  4.  FILES()        "
      rlib[ 5] = "  5.  FILESIZE()     "
      rlib[ 6] = "  6.  FILETIME()     "
      rlib[ 7] = "  7.  FREADLINE()    "
      rlib[ 8] = "  8.  GETFILE()      "
      rlib[ 9] = "  9.  OLDERFILE()    "
      rlib[10] = " 10.  PICKFILE()     "
      rlib[11] = " 11.  TEMPFILE()     "
      mess[ 1] = m_checkfile
      mess[ 2] = m_feof
      mess[ 3] = m_filedate
      mess[ 4] = m_files
      mess[ 5] = m_filesize
      mess[ 6] = m_filetime
      mess[ 7] = m_freadline
      mess[ 8] = m_getfile
      mess[ 9] = m_olderfile
      mess[10] = m_pickfile
      mess[11] = m_tempfile

   CASE group = 7                                           && Numeric
      DECLARE rlib[5], mess[5]
      rlib[ 1] = "  1.  BIN2DEC()      "
      rlib[ 2] = "  2.  DEC2HEX()      "
      rlib[ 3] = "  3.  DIVIDE()       "
      rlib[ 4] = "  4.  HEX2DEC()      "
      rlib[ 5] = "  5.  VRANGE()       "
      mess[ 1] = m_bin2dec
      mess[ 2] = m_dec2hex
      mess[ 3] = m_divide
      mess[ 4] = m_hex2dec
      mess[ 5] = m_vrange

   CASE group = 8                                           && Printer
      DECLARE rlib[4], mess[4]
      rlib[ 1] = "  1.  PRINTCODE()    "
      rlib[ 2] = "  2.  REPORTINIT()   "
      rlib[ 3] = "  3.  STARTREPORT()  "
      rlib[ 4] = "  4.  TARGET()       "
      mess[ 1] = m_printcode
      mess[ 2] = m_reportinit
      mess[ 3] = m_startreport
      mess[ 4] = m_target

   CASE group = 9                                           && Screen
      DECLARE rlib[14], mess[14]
      rlib[ 1] = "  1.  ABOXASK()      "
      rlib[ 2] = "  2.  ATINSAY()      "
      rlib[ 3] = "  3.  BORDERBOX()    "
      rlib[ 4] = "  4.  BOXASK()       "
      rlib[ 5] = "  5.  CENTER()       "
      rlib[ 6] = "  6.  FPROMPT()      "
      rlib[ 7] = "  7.  FRESTSCREEN()  "
      rlib[ 8] = "  8.  FSAVESCREEN()  "
      rlib[ 9] = "  9.  KEYINPUT()     "
      rlib[10] = " 10.  PICKCOLOR()    "
      rlib[11] = " 11.  POPBOX()       "
      rlib[12] = " 12.  RJUSTIFY()     "
      rlib[13] = " 13.  SAYINBOX()     "
      rlib[14] = " 14.  SETCURSOR()    "
      mess[ 1] = m_aboxask
      mess[ 2] = m_atinsay
      mess[ 3] = m_borderbox
      mess[ 4] = m_boxask
      mess[ 5] = m_center
      mess[ 6] = m_fprompt
      mess[ 7] = m_frestscreen
      mess[ 8] = m_fsavescreen
      mess[ 9] = m_keyinput
      mess[10] = m_pickcolor
      mess[11] = m_popbox
      mess[12] = m_rjustify
      mess[13] = m_sayinbox
      mess[14] = m_setcursor

   CASE group = 10                                           && Other
      DECLARE rlib[10], mess[10]
      rlib[ 1] = "  1.  BEEP()         "
      rlib[ 2] = "  2.  BLIP()         "
      rlib[ 3] = "  3.  BUZZ()         "
      rlib[ 4] = "  4.  RH_HEADER()    "
      rlib[ 5] = "  5.  RH_LINES()     "
      rlib[ 6] = "  6.  RH_TEXT()      "
      rlib[ 7] = "  7.  RH_WIDTH()     "
      rlib[ 8] = "  8.  RLIBERROR()    "
      rlib[ 9] = "  9.  RLIBINIT()     "
      rlib[10] = " 10.  RLIBVER()      "
      mess[ 1] = m_beep
      mess[ 2] = m_blip
      mess[ 3] = m_buzz
      mess[ 4] = m_rh_header
      mess[ 5] = m_rh_lines
      mess[ 6] = m_rh_text
      mess[ 7] = m_rh_width
      mess[ 8] = m_rliberror
      mess[ 9] = m_rlibinit
      mess[10] = m_rlibver

ENDCASE

choice = 1
row    = 10-INT(LEN(rlib)/2)
col    = CENTER(rlib[1])

DO WHILE choice > 0
   ClearScr()
   choice = BOXMENU( row, col, rlib, choice, dummy, dummy,;
                     mess, msgrow, boxcolors, header, .T. )

   IF choice = 0
      *-- if Escape pressed, exit to top menu
      EXIT
   ELSEIF group = 1
      *-- if in the Menu group, set menustyle
      menustyle = TRIM(SUBSTR(rlib[choice],7))
      BREAK
   ENDIF

   demoproc = DPROCNAME(rlib[choice])
   SETCOLOR(democolor)
   ShowSyntax()
   DO &demoproc
ENDDO
RETURN 0



*----------------------------------------------------------------------------
* Function:  BARDEMO()
* Syntax:    BarDemo()
* Notes:     Sub function to control demo with BARMENU(), default.
*----------------------------------------------------------------------------
FUNCTION BarDemo
PRIVATE choice, option, message

*-- set up arrays to hold menu options and messages
DECLARE option[7], message[7]

*-- they don't have to be the same length, just a matter of preference
option[1] = " Menu "
option[2] = " Screen "
option[3] = " File "
option[4] = " Character "
option[5] = " Database "
option[6] = " Other "
option[7] = " Quit "

message[1] = "Box Menus, Multi-Column Menus, and Pull Down menus"
message[2] = "Screen goodies for prompts and error messages"
message[3] = "Find files, get file dates and times, and other stuff"
message[4] = "Handy character string functions, all in Clipper!"
message[5] = "Make editing database files easy"
message[6] = "A few UDF's to use either now and then, or all the time"
message[7] = "Before you quit, try all the neat menus"

toprow    = 1
promptrow = 2
choice    = 1

DO WHILE .T.
   ClearScr()
   choice = BARMENU( toprow, option, dummy, choice, dummy,;
                     dummy, message, promptrow, barcolors )
   DO CASE
      CASE choice = 0
         choice = 7

      CASE choice = 7
         menustyle = ""                    && force calling proc to terminate
         BREAK

      OTHERWISE
         SubBarMenu(choice)

   ENDCASE
ENDDO
RETURN 0



*----------------------------------------------------------------------------
* Function:  SubBarMenu()
* Syntax:    SubBarMenu(group)
* Notes:     Sub function to control demo with BARMENU().
*----------------------------------------------------------------------------
FUNCTION SubBarMenu
PARAMETER group
PRIVATE choice

DO CASE
   CASE group = 1                                          && Menu
      DECLARE rlib[3], mess[3]
      rlib[1] = "BOXMENU() "
      rlib[2] = "MULTIMENU() "
      rlib[3] = "PDOWNMENU() "
      mess[1] = m_boxmenu
      mess[2] = m_multimenu
      mess[3] = m_pdownmenu

   CASE group = 2                                          && Screen
      DECLARE rlib[6], mess[6]
      rlib[1] = "ATINSAY() "
      rlib[2] = "BOXASK() "
      rlib[3] = "BRIGHT() "
      rlib[4] = "CENTER() "
      rlib[5] = "MULTIMENU() "
      rlib[6] = "SAYINBOX() "
      mess[1] = m_atinsay
      mess[2] = m_boxask
      mess[3] = m_bright
      mess[4] = m_center
      mess[5] = m_multimenu
      mess[6] = m_sayinbox

   CASE group = 3                                          && File
      DECLARE rlib[6], mess[6]
      rlib[1] = "FILEDATE() "
      rlib[2] = "FILES() "
      rlib[3] = "FILETIME() "
      rlib[4] = "PARENT() "
      rlib[5] = "PATHTO() "
      rlib[6] = "PICKFILE() "
      mess[1] = m_filedate
      mess[2] = m_files
      mess[3] = m_filetime
      mess[4] = m_parent
      mess[5] = m_pathto
      mess[6] = m_pickfile

   CASE group = 4                                          && Character
      DECLARE rlib[6], mess[6]
      rlib[1] = "DECRYPTED() "
      rlib[2] = "ENCRYPTED() "
      rlib[3] = "GETPARM() "
      rlib[4] = "KEYINPUT() "
      rlib[5] = "NAMESPLIT() "
      rlib[6] = "RJUSTIFY() "
      mess[1] = m_decrypted
      mess[2] = m_encrypted
      mess[3] = m_getparm
      mess[4] = m_keyinput
      mess[5] = m_namesplit
      mess[6] = m_rjustify

   CASE group = 5                                          && Database
      DECLARE rlib[6], mess[6]
      rlib[1] = "DBFCREATE()"
      rlib[2] = "ISDBF()"
      rlib[3] = "MARKREC()"
      rlib[4] = "OPENED()"
      rlib[5] = "PICKREC()"
      rlib[6] = "QUERY()"
      mess[1] = m_dbfcreate
      mess[2] = m_isdbf
      mess[3] = m_markrec
      mess[4] = m_opened
      mess[5] = m_pickrec
      mess[6] = m_query

   CASE group = 6                                          && Other
      DECLARE rlib[4], mess[4]
      rlib[1] = "ALPHADATE() "
      rlib[2] = "BEEP() "
      rlib[3] = "NTXKEYVAL() "
      rlib[4] = "STR2DATE() "
      mess[1] = m_alphadate
      mess[2] = m_beep
      mess[3] = m_ntxkeyval
      mess[4] = m_str2date
ENDCASE

choice = 1                                      && start at first option

DO WHILE choice > 0                             && BOXMENU returns 0 on Escape
   ClearScr()
   choice = BARMENU( toprow, rlib, dummy, choice, dummy, dummy,;
                     mess, promptrow, barcolors )

   IF choice = 0
      *-- if Escape pressed, exit to top menu
      EXIT
   ELSEIF group = 1
      *-- if in the Menu group, set menustyle
      menustyle = TRIM(rlib[choice])
      BREAK
   ENDIF

   demoproc = DPROCNAME(rlib[choice])
   SETCOLOR(democolor)
   ShowSyntax()
   DO &demoproc
ENDDO
RETURN 0


*----------------------------------------------------------------------------
* Function:  MULTIDEMO()
* Syntax:    MultiDemo()
* Notes:     Sub function to control demo with MULTIMENU()
*----------------------------------------------------------------------------
FUNCTION MultiDemo

PRIVATE rlib, mess, choice, colums, incolor, nameof_udf

*-- set up arrays to hold options and messages
DECLARE rlib[91], mess[91]

rlib[ 1] = " ABOXASK()     "
rlib[ 2] = " ACRONYM()     "
rlib[ 3] = " ADIM2()       "
rlib[ 4] = " ALIST()       "
rlib[ 5] = " ALPHADATE()   "
rlib[ 6] = " ANYCHARSIN()  "
rlib[ 7] = " ARRAYLEN()    "
rlib[ 8] = " ATINSAY()     "
rlib[ 9] = " BARMENU()     "
rlib[10] = " BEEP()        "
rlib[11] = " BIN2DEC()     "
rlib[12] = " BLIP()        "
rlib[13] = " BORDERBOX()   "
rlib[14] = " BOXASK()      "
rlib[15] = " BOXMENU()     "
rlib[16] = " BRIGHT()      "
rlib[17] = " BUZZ()        "
rlib[18] = " CALENDAR()    "
rlib[19] = " CATF()        "
rlib[20] = " CENTER()      "
rlib[21] = " CFTA()        "
rlib[22] = " CHANGED()     "
rlib[23] = " CHECKFILE()   "
rlib[24] = " CLOSEAREA()   "
rlib[25] = " DBFCREATE()   "
rlib[26] = " DEC2HEX()     "
rlib[27] = " DECRYPTED()   "
rlib[28] = " DIVIDE()      "
rlib[29] = " ENCRYPTED()   "
rlib[30] = " FEOF()        "
rlib[31] = " FILEDATE()    "
rlib[32] = " FILES()       "
rlib[33] = " FILESIZE()    "
rlib[34] = " FILETIME()    "
rlib[35] = " FORGET()      "
rlib[36] = " FPROMPT()     "
rlib[37] = " FREADLINE()   "
rlib[38] = " FRESTSCREEN() "
rlib[39] = " FSAVESCREEN() "
rlib[40] = " GETFILE()     "
rlib[41] = " GETKEY()      "
rlib[42] = " GETPARM()     "
rlib[43] = " HEX2DEC()     "
rlib[44] = " ISDBF()       "
rlib[45] = " ISFIELD()     "
rlib[46] = " KEYINPUT()    "
rlib[47] = " MAKEALIAS()   "
rlib[48] = " MARKREC()     "
rlib[49] = " MEMORIZE()    "
rlib[50] = " MIDDLE()      "
rlib[51] = " MREPLACE()    "
rlib[52] = " MULTIMENU()   "
rlib[53] = " NAMESPLIT()   "
rlib[54] = " NO_APPEND()   "
rlib[55] = " NO_FLOCK()    "
rlib[56] = " NO_RLOCK()    "
rlib[57] = " NOTEMPTY()    "
rlib[58] = " NTXKEYVAL()   "
rlib[59] = " OLDERFILE()   "
rlib[60] = " OPENED()      "
rlib[61] = " PARENT()      "
rlib[62] = " PATHTO()      "
rlib[63] = " PDOWNINIT()   "
rlib[64] = " PDOWNMENU()   "
rlib[65] = " PICKCOLOR()   "
rlib[66] = " PICKFILE()    "
rlib[67] = " PICKREC()     "
rlib[68] = " POPBOX()      "
rlib[69] = " POPUPPICK()   "
rlib[70] = " PRINTCODE()   "
rlib[71] = " QUERY()       "
rlib[72] = " REPORTINIT()  "
rlib[73] = " REVDATE()     "
rlib[74] = " RH_HEADER()   "
rlib[75] = " RH_LINES()    "
rlib[76] = " RH_TEXT()     "
rlib[77] = " RH_WIDTH()    "
rlib[78] = " RJUSTIFY()    "
rlib[79] = " RLIBERROR()   "
rlib[80] = " RLIBINIT()    "
rlib[81] = " RLIBVER()     "
rlib[82] = " SAYINBOX()    "
rlib[83] = " SETCURSOR()   "
rlib[84] = " STARTREPORT() "
rlib[85] = " STR2DATE()    "
rlib[86] = " STRETCH()     "
rlib[87] = " TARGET()      "
rlib[88] = " TEMPFILE()    "
rlib[89] = " TYPEC()       "
rlib[90] = " VALTYPEC()    "
rlib[91] = " VRANGE()      "

mess[ 1] = m_aboxask
mess[ 2] = m_acronym
mess[ 3] = m_adim2
mess[ 4] = m_alist
mess[ 5] = m_alphadate
mess[ 6] = m_anycharsin
mess[ 7] = m_arraylen
mess[ 8] = m_atinsay
mess[ 9] = m_barmenu
mess[10] = m_beep
mess[11] = m_bin2dec
mess[12] = m_blip
mess[13] = m_borderbox
mess[14] = m_boxask
mess[15] = m_boxmenu
mess[16] = m_bright
mess[17] = m_buzz
mess[18] = m_calendar
mess[19] = m_catf
mess[20] = m_center
mess[21] = m_cfta
mess[22] = m_changed
mess[23] = m_checkfile
mess[24] = m_closearea
mess[25] = m_dbfcreate
mess[26] = m_dec2hex
mess[27] = m_decrypted
mess[28] = m_divide
mess[29] = m_encrypted
mess[30] = m_feof
mess[31] = m_filedate
mess[32] = m_files
mess[33] = m_filesize
mess[34] = m_filetime
mess[35] = m_forget
mess[36] = m_fprompt
mess[37] = m_freadline
mess[38] = m_frestscreen
mess[39] = m_fsavescreen
mess[40] = m_getfile
mess[41] = m_getkey
mess[42] = m_getparm
mess[43] = m_hex2dec
mess[44] = m_isdbf
mess[45] = m_isfield
mess[46] = m_keyinput
mess[47] = m_makealias
mess[48] = m_markrec
mess[49] = m_memorize
mess[50] = m_middle
mess[51] = m_mreplace
mess[52] = m_multimenu
mess[53] = m_namesplit
mess[54] = m_no_append
mess[55] = m_no_flock
mess[56] = m_no_rlock
mess[57] = m_notempty
mess[58] = m_ntxkeyval
mess[59] = m_olderfile
mess[60] = m_opened
mess[61] = m_parent
mess[62] = m_pathto
mess[63] = m_pdowninit
mess[64] = m_pdownmenu
mess[65] = m_pickcolor
mess[66] = m_pickfile
mess[67] = m_pickrec
mess[68] = m_popbox
mess[69] = m_popuppick
mess[70] = m_printcode
mess[71] = m_query
mess[72] = m_reportinit
mess[73] = m_revdate
mess[74] = m_rh_header
mess[75] = m_rh_lines
mess[76] = m_rh_text
mess[77] = m_rh_width
mess[78] = m_rjustify
mess[79] = m_rliberror
mess[80] = m_rlibinit
mess[81] = m_rlibver
mess[82] = m_sayinbox
mess[83] = m_setcursor
mess[84] = m_startreport
mess[85] = m_str2date
mess[86] = m_stretch
mess[87] = m_target
mess[88] = m_tempfile
mess[89] = m_typec
mess[90] = m_valtypec
mess[91] = m_vrange

arrows   = CHR(24) + CHR(25) + CHR(27) + CHR(26)
columns  = 6
incolor  = SETCOLOR(multicolors[1])

DO WHILE .T.
   ClearScr()
   SCROLL(15,0,22,79,0)

   SETCOLOR(helpColor)
   @ 15,0,23,79 BOX single + " "
   @ 16,4 SAY "MULTIMENU() lets you select menu options by cursoring up, down, left, or"
   @ 17,4 SAY "right, without having to wade through levels of menus.    From this menu"
   @ 18,4 SAY "you can directly select any of the  RLIB demonstration routines,  or you"
   @ 19,4 SAY "change the style of menus by selecting either  BOXMENU(),  BARMENU() or,"
   @ 20,4 SAY "PDOWNMENU().  Just pick the option you desire by pressing the &arrows keys."
   @ 22,4 SAY "             Press PgDn/PgUp keys to page back and forth                "
   SETCOLOR(demoColor)

   @ 1,0,14,79 BOX double + " "
   choice = MULTIMENU( 2, 1, 13, 78, rlib, columns, mess, 24, multicolors )

   SETCOLOR(incolor)
   DO CASE
      CASE choice = 0
         *-- Escape, go back to default, BOXMENU style
         menustyle = "BOXMENU()"
         BREAK

      CASE choice = 9                  && BARMENU
         menustyle = "BARMENU()"
         BREAK

      CASE choice = 15                 && BOXMENU
         menustyle = "BOXMENU()"
         BREAK

      CASE choice = 64                 && PDOWNMENU
         menustyle = "PDOWNMENU()"
         BREAK

      OTHERWISE
         demoproc = DPROCNAME(rlib[choice])
         SETCOLOR(democolor)
         ShowSyntax()
         DO &demoproc

   ENDCASE
ENDDO
RETURN 0



*----------------------------------------------------------------------------
* Function:  PULLDEMO()
* Syntax:    PullDemo()
* Notes:     Sub function to control demo with PDOWNMENU()
*----------------------------------------------------------------------------
FUNCTION PullDemo

DECLARE menus[11], mnmsg[11], column[11], starts[11]
DECLARE item[91], mess[91]

menus[ 1] = "Menu"
menus[ 2] = "Array"
menus[ 3] = "Character"
menus[ 4] = "Database"
menus[ 5] = "Date"
menus[ 6] = "File"
menus[ 7] = "Numeric"
menus[ 8] = "Printer"
menus[ 9] = "Screen"
menus[10] = "Other"
menus[11] = "Quit"

mnmsg[ 1] = "Menus never were easier and more powerful!"
mnmsg[ 2] = "Test, list, and pseudo dimension array"
mnmsg[ 3] = "Handy character string functions, all in Clipper!"
mnmsg[ 4] = "Make editing database files easy"
mnmsg[ 5] = "Pop-up Calendar, reverse dates, convert strings to dates"
mnmsg[ 6] = "Find files, get file dates and times, and other stuff"
mnmsg[ 7] = "You don't have to program in C to do numeric conversions"
mnmsg[ 8] = "Use these to snaz up report routines in a flash"
mnmsg[ 9] = "Helpful goodies for prompting and error messages"
mnmsg[10] = "A few UDFs to use either now and then, or all the time"
mnmsg[11] = "Before you quit, try all the neat menus"

column[ 1] =  0
column[ 2] =  5
column[ 3] = 11
column[ 4] = 21
column[ 5] = 30
column[ 6] = 35
column[ 7] = 40
column[ 8] = 48
column[ 9] = 56
column[10] = 63
column[11] = 69


starts[1] = 1                                    && Menu
item[ 1] = " BARMENU()      "
item[ 2] = " BOXMENU()      "
item[ 3] = " MULTIMENU()    "

mess[ 1] = m_barmenu
mess[ 2] = m_boxmenu
mess[ 3] = m_multimenu


starts[2] = 4                                    && Array
item[ 4] = " ADIM2()        "
item[ 5] = " ALIST()        "
item[ 6] = " ARRAYLEN()     "
item[ 7] = " CATF()         "
item[ 8] = " CFTA()         "

mess[ 4] = m_adim2
mess[ 5] = m_alist
mess[ 6] = m_arraylen
mess[ 7] = m_catf
mess[ 8] = m_cfta


starts[3] = 9                                    && Character
item[ 9] = " ACRONYM()      "
item[10] = " ANYCHARSIN()   "
item[11] = " BRIGHT()       "
item[12] = " DECRYPTED()    "
item[13] = " ENCRYPTED()    "
item[14] = " GETKEY()       "
item[15] = " GETPARM()      "
item[16] = " KEYINPUT()     "
item[17] = " MIDDLE()       "
item[18] = " NAMESPLIT()    "
item[19] = " NOTEMPTY()     "
item[20] = " RJUSTIFY()     "
item[21] = " STRETCH()      "
item[22] = " TYPEC()        "
item[23] = " VALTYPEC()     "

mess[ 9] = m_acronym
mess[10] = m_anycharsin
mess[11] = m_bright
mess[12] = m_decrypted
mess[13] = m_encrypted
mess[14] = m_getkey
mess[15] = m_getparm
mess[16] = m_keyinput
mess[17] = m_middle
mess[18] = m_namesplit
mess[19] = m_notempty
mess[20] = m_rjustify
mess[21] = m_stretch
mess[22] = m_typec
mess[23] = m_valtypec


starts[4] = 24                                   && Database
item[24] = " CHANGED()       "
item[25] = " CLOSEAREA()     "
item[26] = " DBFCREATE()     "
item[27] = " FORGET()        "
item[28] = " ISDBF()         "
item[29] = " ISFIELD()       "
item[30] = " MAKEALIAS()     "
item[31] = " MARKREC()       "
item[32] = " MEMORIZE()      "
item[33] = " MREPLACE()      "
item[34] = " NO_APPEND()     "
item[35] = " NO_FLOCK()      "
item[36] = " NO_RLOCK()      "
item[37] = " NTXKEYVAL()     "
item[38] = " OPENED()        "
item[39] = ""
item[40] = " PICKREC()       "
item[41] = ""
item[42] = " POPUPPICK()     "
item[43] = " QUERY()         "

mess[24] = m_changed
mess[25] = m_closearea
mess[26] = m_dbfcreate
mess[27] = m_forget
mess[28] = m_isdbf
mess[29] = m_isfield
mess[30] = m_makealias
mess[31] = m_markrec
mess[32] = m_memorize
mess[33] = m_mreplace
mess[34] = m_no_append
mess[35] = m_no_flock
mess[36] = m_no_rlock
mess[37] = m_ntxkeyval
mess[38] = m_opened
mess[39] = ""
mess[40] = m_pickrec
mess[41] = ""
mess[42] = m_popuppick
mess[43] = m_query


starts[5] = 44                                   && Date
item[44] = " ALPHADATE()    "
item[45] = " CALENDAR()     "
item[46] = " REVDATE()      "
item[47] = " STR2DATE()     "

mess[44] = m_alphadate
mess[45] = m_calendar
mess[46] = m_revdate
mess[47] = m_str2date


starts[6] = 48                                   && File
item[48] = " CHECKFILE()    "
item[49] = " FEOF()         "
item[50] = " FILEDATE()     "
item[51] = " FILES()        "
item[52] = " FILESIZE()     "
item[53] = " FILETIME()     "
item[54] = " FREADLINE()    "
item[55] = " GETFILE()      "
item[56] = " OLDERFILE()    "
item[57] = " PICKFILE()     "
item[58] = " TEMPFILE()     "

mess[48] = m_checkfile
mess[49] = m_feof
mess[50] = m_filedate
mess[51] = m_files
mess[52] = m_filesize
mess[53] = m_filetime
mess[54] = m_freadline
mess[55] = m_getfile
mess[56] = m_olderfile
mess[57] = m_pickfile
mess[58] = m_tempfile


starts[7] = 59                                   && Numeric
item[59] = " BIN2DEC()      "
item[60] = " DEC2HEX()      "
item[61] = " DIVIDE()       "
item[62] = " HEX2DEC()      "
item[63] = " VRANGE()       "

mess[59] = m_bin2dec
mess[60] = m_dec2hex
mess[61] = m_divide
mess[62] = m_hex2dec
mess[63] = m_vrange


starts[8] = 64                                   && Printer
item[64] = " PRINTCODE()    "
item[65] = " REPORTINIT()   "
item[66] = " STARTREPORT()  "
item[67] = " TARGET()       "

mess[64] = m_printcode
mess[65] = m_reportinit
mess[66] = m_startreport
mess[67] = m_target


starts[9] = 68                                   && Screen
item[68] = " ABOXASK()     "
item[69] = " ATINSAY()     "
item[70] = " BORDERBOX()   "
item[71] = " BOXASK()      "
item[72] = " CENTER()      "
item[73] = " FPROMPT()     "
item[74] = " FRESTSCREEN() "
item[75] = " FSAVESCREEN() "
item[76] = " KEYINPUT()    "
item[77] = " PICKCOLOR()   "
item[78] = " POPBOX()      "
item[79] = " RJUSTIFY()    "
item[80] = " SAYINBOX()    "
item[81] = " SETCURSOR()   "

mess[68] = m_aboxask
mess[69] = m_atinsay
mess[70] = m_borderbox
mess[71] = m_boxask
mess[72] = m_center
mess[73] = m_fprompt
mess[74] = m_frestscreen
mess[75] = m_fsavescreen
mess[76] = m_keyinput
mess[77] = m_pickcolor
mess[78] = m_popbox
mess[79] = m_rjustify
mess[80] = m_sayinbox
mess[81] = m_setcursor


starts[10] = 82                                  && Other
item[82] = " BEEP()      "
item[83] = " BLIP()      "
item[84] = " BUZZ()      "
item[85] = " RH_HEADER() "
item[86] = " RH_LINES()  "
item[87] = " RH_TEXT()   "
item[88] = " RH_WIDTH()  "
item[89] = " RLIBERROR() "
item[90] = " RLIBINIT()  "
item[91] = " RLIBVER()   "

mess[82] = m_beep
mess[83] = m_blip
mess[84] = m_buzz
mess[85] = m_rh_header
mess[86] = m_rh_lines
mess[87] = m_rh_text
mess[88] = m_rh_width
mess[89] = m_rliberror
mess[90] = m_rlibinit
mess[91] = m_rlibver


starts[11] = 0                                   && Quit

*-- start with menu number one, no drop down
menu   = 1
choice = 0
mrow   = 1
prow   = 24
inum   = 0
pini   = .T.


DO WHILE .T.
   *-- clear the screen, or just make sure it is the way you want it
   *-- to appear underneath the pull-down menu boxes
   ClearScr()

   *-- initially the "ini" flag is set to initialize the menu, or if colors chng
   IF pini
      PDOWNINIT(mrow,column,menus,item,starts,mnmsg,prow,pullcolors,"", .T.,.F.)
      pini = .F.
   ENDIF

   inum = PDOWNMENU( @menu, @choice, menus, item, column, starts, mess, .T. )

   DO CASE
      CASE menu = 0
         menustyle = "BOXMENU()"
         BREAK

      CASE menu = 1
         menustyle = TRIM(SUBSTR(item[inum],2))
         BREAK

      CASE menu == 11
         menustyle = ""
         BREAK

      OTHERWISE
         demoproc = DPROCNAME(item[inum])
         *-- here's another way to get the element text
         *-- demoproc = DPROCNAME(item[starts[menu]+choice-1])
         SETCOLOR(democolor)
         ShowSyntax()
         DO &demoproc
         *-- if we changed any colors, set the flag to re-initialize the menu
         IF inum == 77
            pini = .T.
         ENDIF

   ENDCASE
ENDDO
RETURN 0


******************************************************************************
* GENERAL FUNCTIONS CALLED FOR EACH DEMO PROCEDURE                           *
******************************************************************************

*------------------------------------------------------------------------------
* Function: DPROCNAME()
* Syntax:   DprocName(function)
* Purpose:  Generate a demo procedure name from a function name by stripping
*           off trailing parentheses and adding a D_ prefix to the function
*           name.
*           The mechanics of how this works is based on the assumption that
*           the paramater is a function name, including trailing parentheses,
*           and with at least one space preceeding the function name.  The
*           name is trimmed, then the preceeding space is located with the
*           RAT() function, then the function name, less the parenthese is
*           extracted and a D_ is prepended.
*------------------------------------------------------------------------------
FUNCTION DprocName
PARAMETER rfunc
rfunc = LTRIM(TRIM(rfunc))
rfunc = IF(" " $ rfunc, SUBSTR(rfunc,RAT(" ",rfunc)+1), rfunc)
RETURN ("d_" + SUBSTR(rfunc,1,AT("()",rfunc)-1))


*-----------------------------------------------------------------------------
* Function:  ShowSyntax()
* Syntax:    ShowSyntax()
* Notes:     Function to look up function in database and display the memo
*            contents in a 12 line window at the bottom of the screen.
*-----------------------------------------------------------------------------
FUNCTION ShowSyntax
PRIVATE incolor
incolor = SETCOLOR(syntaxcolor)
SCROLL(13,0,23,79,0)
@ 13,0,24,79 BOX single + " "
@ 13,1 SAY UPPER(SUBSTR(demoproc,3)) + "()"
SEEK UPPER(SUBSTR(demoproc,3))
MEMOEDIT(descrip, 14, 1, 23, 78, .F., .F.)
SETCOLOR(incolor)
GetKey(showtime)
RETURN .T.


*-----------------------------------------------------------------------------
* Function:  ClearScr()
* Syntax:    ClearScr()
* Notes:     Central function to clear the screen
*-----------------------------------------------------------------------------
FUNCTION ClearScr
SET COLOR TO W/N
@ 0,0
SETCOLOR(background)
@ 24,0
@ 1,0,23,79 BOX ""
SETCOLOR(democolor)
RETURN 0


*-----------------------------------------------------------------------------
* Function:  ClearTop()
* Syntax:    ClearTop()
* Notes:     Central procedure for clearing the top window in preparation
*            for the particular function demonstration.
*-----------------------------------------------------------------------------
FUNCTION ClearTop
SETCOLOR(background)
@ 1,0,12,79 BOX ""
SETCOLOR(democolor)
RETURN 0


*-----------------------------------------------------------------------------
* Function:  ClearBox()
* Syntax:    ClearBox(t,l,b,r)
* Notes:     Function to clear an area of the screen.
*-----------------------------------------------------------------------------
FUNCTION ClearBox
PARAMETERS t,l,b,r
SETCOLOR(background)
@ t,l,b,r BOX ""
SETCOLOR(democolor)
RETURN 0


*-----------------------------------------------------------------------------
* Function:  NoDemo()
* Syntax:    NoDemo()
* Notes:     Display notice of no real demonstration for the function.
*-----------------------------------------------------------------------------
FUNCTION NoDemo
ClearTop()
SETCOLOR(helpColor)
@ 2,6,10,72 BOX single + " "
@ 4,8 SAY "This function is difficult to demonstrate, as any demonstration"
@ 5,8 SAY "would just be a reiteration of the function syntax shown below."
@ 6,8 SAY "See the RLIB documentation for more information and examples."
CENTER(8,"Press any key to continue...")
SETCOLOR(demoColor)
GetKey(60)
RETURN 0


*-----------------------------------------------------------------------------
* Function:  GetKey()
* Syntax:    GetKey(seconds)
* Notes:     Substitute RLIB GETKEY() function that allows a ticking clock.
*            This is a replacement for the GETKEY() function that is in RLIB.
*            This shows how you can intercept all keystokes before an RLIB
*            function acts on them.  This is because all keyboard input,
*            except for @..GET..READs, in all RLIB functions is obtained by
*            a call to GETKEY().
*
*            See the D_GETKEY procedure for the function that turns on or
*            off the ticking clock.
*-----------------------------------------------------------------------------
FUNCTION GetKey
PARAMETER timeout
PRIVATE ikey, irow, icol, iclr, stop
ikey = 0
irow = ROW()                                 && save cursor position
icol = COL()
iclr = SETCOLOR(backGround)
icsr = (SETCURSOR() == 1)
DO CASE
CASE timeout = 0
   DO WHILE ikey == 0
      IF gkey_clock
         SET CURSOR OFF
         @ 0,72 SAY TIME()                   && say time
         @ irow,icol SAY ""                  && move cursor back
         IF icsr
            SET CURSOR ON
         ENDIF
      ENDIF
      ikey = INKEY(.2)                       && loop more than once each second
   ENDDO

CASE timeout < 1
   IF gkey_clock
      @ 0,72 SAY TIME()
      @ irow,icol SAY ""
   ENDIF
   ikey = INKEY(timeout)

OTHERWISE
   stop = SECONDS() + timeout                && calculate stop time
   IF stop > 86399                           && if wrapped past midnight
      stop = timeout - (86399 - SECONDS())   && adjust stop time
   ENDIF
   DO WHILE ikey == 0 .AND. SECONDS() < stop
      IF gkey_clock
         SET CURSOR OFF
         @ 0,72 SAY TIME()                   && say time
         @ irow,icol SAY ""                  && move cursor back
         IF icsr
            SET CURSOR ON
         ENDIF
      ENDIF
      ikey = INKEY(.2)                       && loop more than once each second
   ENDDO
ENDCASE
SETCOLOR(iclr)
RETURN ikey


******************************************************************************
***    THESE ARE THE PROCEDURES THAT ACTUALLY DEMONSTRATE THE FUNCTIONS    ***
******************************************************************************


*==============================================================================
PROCEDURE d_aboxask
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_acronym
PRIVATE acr
ClearTop()
acr = "Advanced Computer Resource Organization - New York Membership"
@ 4,0,8,79 BOX double + " "
CENTER(5,"Enter a title to be reduced to an acronym:")
@ 6,CENTER(acr) GET acr PICTURE "@K"
SETCURSOR(SC_NORMAL)
READ
CENTER(7,'The ACRONYM() function returns: "' + ACRONYM(acr) + '"')
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_adim2
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_alist
DECLARE a[20]
ClearTop()
a[ 1] = "This is a sample array with 15 elements. "
a[ 2] = "ALIST() lets you easily see the contents "
a[ 3] = "of arrays in the Clipper Summer '87 debug"
a[ 4] = "screen.  ALIST() displays the value of   "
a[ 5] = "each element regardless of the data type."
a[ 6] = "These first few lines represent array    "
a[ 7] = "elements that are character type.  The   "
a[ 8] = "remaining elements are different types to"
a[ 9] = "illustrate how ALIST() presents the data "
a[10] = ""
a[11] = 3.2
a[12] = DATE()
a[13] = .T.
a[14] = .F.
a[15] = 100000
ALIST(a)
RETURN


*==============================================================================
PROCEDURE d_alphadate
PRIVATE mdate
ClearTop()
mdate = DATE()
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "Enter date to be displayed as text:" GET mdate
SETCURSOR(SC_NORMAL)
READ
CENTER(6,ALPHADATE(mdate))
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_anycharsin
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_arraylen
DECLARE a[9]
ClearTop()
a[ 1] = " This is a sample array that was declared  "
a[ 2] = " with 9 elements.  However, the 8th array  "
a[ 3] = " element has not been assigned.  Clipper's "
a[ 4] = " LEN() function will return 9, but if you  "
a[ 5] = " try to parse it in a for loop you'll get  "
a[ 6] = " a runtime arror.  ARRAYLEN() returns the  "
a[ 7] = " actual number of contiguous elements, 7.  "
a[ 9] = " Press any key to show ALEN() & ARRAYLEN() "
SETCOLOR(helpColor)
@ 1,0,11,44 BOX double + " "
FOR x = 1 TO 7
   @ 1+x,1 SAY a[x]
NEXT
@ 10,1 SAY a[9]
GetKey(0)
SAYINBOX( "Clipper's LEN() returns " + STR(LEN(a),1,0),;
          "RLIB's ARRAYLEN() returns " + STR(ARRAYLEN(a),1,0),;
          "Press any key to continue", 30 )
RETURN


*==============================================================================
PROCEDURE d_atinsay
PRIVATE mrow, mcol, mcolor, mtext
mrow = 21
mcol = 20
mcolor = "W+*/N   "
mtext  = "           Testing: 1, 2, 3           "
ClearTop()
@ 3,0,11,79 BOX double + " "
@ 5, 1 SAY "Enter row,colum coordinates   ,"
@ 5,29 GET mrow PICTURE "##" RANGE 0,24
@ 5,32 GET mcol PICTURE "##" RANGE 0,79
@ 6, 1 SAY "Enter Clipper color string " GET mcolor PICTURE "@!"
@ 7, 1 SAY "Enter the text to display  " GET mtext  PICTURE "@K"
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
ATINSAY( mrow, mcol, mcolor, mtext )
CENTER( 10, "Press any key to continue..." )
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_beep
PRIVATE mnumber
ClearTop()
mnumber = 2
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "How many times do you want to ring the bell?" GET mnumber PICTURE "#"
SETCURSOR(SC_NORMAL)
READ
CENTER( 6, "This is an example of BEEP(" + STR(mnumber,1,0) + ")")
SETCURSOR(SC_NONE)
BEEP(mnumber)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_bin2dec
PRIVATE str
ClearTop()
str = STRETCH("11001100",42)
@ 4,0,8,79 BOX double + " "
CENTER(5,"Enter a binary number as a character string:")
@ 6,CENTER(str) GET str PICTURE "@K"
SETCURSOR(SC_NORMAL)
READ
CENTER(7, "Decimal value = " + LTRIM(STR(BIN2DEC(str))) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_blip
PRIVATE mnumber
ClearTop()
mnumber = 2
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "How many times do you want BLIP?" GET mnumber PICTURE "#"
SETCURSOR(SC_NORMAL)
READ
CENTER( 6, "This is an example of BLIP(" + STR(mnumber,1,0) + ")")
SETCURSOR(SC_NONE)
BLIP(mnumber)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_borderbox
PRIVATE top, left, bottom, right, title, box, color
top    =  1
left   =  0
bottom = 12
right  = 40
title  = "Sample BorderBox"
box    = single
color  = STRETCH(demoColor,14)
ClearTop()
@ 3, 0,11,79 BOX double + " "
@ 4, 2 SAY "Enter screen coordinates (top,left,bottom,right)  ##,##,##,##"
@ 5, 2 SAY "Enter title text to appear in the BORDERBOX()"
@ 6, 2 SAY "Select style of box (Single, Double, or Solid"
@ 7, 2 SAY "Choose a color string to use for BORDERBOX()"

@ 4,52 GET top     PICTURE "##"
@ 4,55 GET left    PICTURE "##"
@ 4,58 GET bottom  PICTURE "##"
@ 4,61 GET right   PICTURE "##"
@ 5,52 GET title   PICTURE "@K"   VALID BoxPopUp(1)
SETCOLOR(unselColor)
@ 6,52 SAY box
SETCOLOR(demoColor)
@ 7,52 GET color   PICTURE "@K!"  VALID BoxPopUp(2)
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
IF LASTKEY() != 27
   BORDERBOX( top, left, bottom, right, title, .T., box, color )
   GetKey(10)
ENDIF
RETURN


*================================================
* Function: BoxPopUp
* Purpose:  Pop-up a list of the three box styles
*================================================
FUNCTION BoxPopUp
PARAMETER num
PRIVATE x
DECLARE boxes[3]
boxes[1] = STRETCH(single,14)
boxes[2] = STRETCH(double,14)
boxes[3] = STRETCH(solid,14)
IF num = 1                          && if at previous get
   IF LASTKEY() == 5                && and they hit the up arrow
      RETURN .T.                    && don't enter pop-up
   ENDIF
ELSE                                && if at get below
   IF .NOT. LASTKEY() == 5          && and did not hit up arrow
      RETURN .T.                    && don't go into pop-up
   ENDIF
ENDIF
x = BOXMENU(4, 63, boxes, 1, "", "", "", "", boxColors, "BOX STYLES", .T.)
IF x = 0
   RETURN .F.
ENDIF
box = TRIM(boxes[x])
SETCOLOR(unselColor)
@ 6,52 SAY box
SETCOLOR(demoColor)
RETURN .T.


*==============================================================================
PROCEDURE d_buzz
PRIVATE mnumber
ClearTop()
mnumber = 2
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "How many times do you want BUZZ?" GET mnumber PICTURE "#"
SETCURSOR(SC_NORMAL)
READ
CENTER( 6, "This is an example of BUZZ(" + STR(mnumber,1,0) + ")")
SETCURSOR(SC_NONE)
BUZZ(mnumber)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_boxask
PRIVATE mline1, mline2, answer
ClearTop()
SETCURSOR(SC_NORMAL)
@ 3,0,11,79 BOX double + " "
@ 5,1 SAY "Enter two lines of text to appear in BOXASK (up to 65 characters each)"
@ 7,1 SAY "Line #1: "
mline1 = KEYINPUT( 65, .F., .T. )
@ 8,1 SAY "Line #2: "
mline2 = KEYINPUT( 65, .F., .T. )
answer = BOXASK( mline1, mline2, "Now press any key..." )
BOXASK( "You pressed the " + answer + " key in response to BOXASK",;
        "Press any key to continue...", 30 )
SETCURSOR(SC_NONE)
RETURN


*==============================================================================
PROCEDURE d_bright
PRIVATE mcolor
ClearTop()
SETCURSOR(SC_NORMAL)
mcolor = STRETCH(SETCOLOR(),20)
@ 4,5,7,68 BOX double + " "
@ 5,12 SAY "Enter a Clipper color string:" GET mcolor
READ
@ 6,12 SAY "The BRIGHT() of this color is: " + BRIGHT(mcolor)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_calendar
PRIVATE date
ClearTop()
SETCOLOR(helpColor)
@ 2,2,10,42 BOX single + " "
@ 4,4 SAY "Move the current day cursor with the"
@ 5,4 SAY "directional arrow keys.  You can move"
@ 6,4 SAY "the calendar around the screen with"
@ 7,4 SAY "the Ctrl-arrow keys.  Press Enter to"
@ 8,4 SAY "select a date or Escape to terminate."
SETCOLOR(demoColor)
SETCURSOR(SC_NONE)
date = CALENDAR(DATE(),boxcolors)
SAYINBOX( IF(EMPTY(date), "No date selected",;
                          "The date you selected is: " + DTOC(date)), 10)
RETURN


*==============================================================================
PROCEDURE d_catf
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_cfta
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_changed
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_checkfile
PRIVATE mfile
ClearTop()
mfile = STRETCH("BAD+FILE.NAM",80)
BORDERBOX(5, 10, 9, 70, "Try to enter an invalid filename or a filespec")
@ 8,11 GET mfile PICTURE "@!KS59" VALID CHECKFILE(@mfile)
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
RETURN


*==============================================================================
PROCEDURE d_center
PRIVATE mstring
ClearTop()
SETCURSOR(SC_NORMAL)
mstring = STRETCH("Greetings to all Clipper programmers!",78)
@ 4,0,7,79 BOX double + " "
CENTER(5,"Enter a string to be centered")
@ 6,1 GET mstring PICTURE "@K"
READ
@ 6,1 SAY SPACE(78)
CENTER(6,ALLTRIM(mstring))
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_closearea
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_dbfcreate
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_dec2hex
PRIVATE dnum
ClearTop()
SETCURSOR(SC_NORMAL)
dnum = 1234567890
@ 4,0,7,79 BOX double + " "
@ 5,20 SAY "Enter a decimal number: " GET dnum PICTURE "@K ##################"
READ
CENTER(6, "Hexadecimal value = " + DEC2HEX(dnum) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_decrypted
PRIVATE mstring, estring, dstring
ClearTop()
SETCURSOR(SC_NORMAL)
mstring = SPACE(35)
@ 4,0,8,79 BOX double + " "
@ 5,6 SAY "Enter a string to be encrypted:" GET mstring
READ
estring = ENCRYPTED(ALLTRIM(mstring))
CENTER(6,"Encrypted version is: " + estring)
dstring = DECRYPTED(estring)
CENTER(7,"Decrypted version is: " + dstring)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_divide
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_encrypted
PRIVATE mstring, estring
ClearTop()
SETCURSOR(SC_NORMAL)
mstring = SPACE(35)
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "Enter a string to be encrypted:" GET mstring
READ
estring = ENCRYPTED(ALLTRIM(mstring))
CENTER(6,"Encrypted version is: " + estring)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_feof
DO d_freadline
RETURN


*==============================================================================
PROCEDURE d_filedate
PRIVATE mfile
ClearTop()
mfile = GETE("COMSPEC")
mfile = GETFILE( mfile, "Enter an existing filename", .T., .F., 2, .F. )
SAYINBOX( helpColor, "The last update date for", mfile,;
                     "is " + DTOC(FILEDATE(mfile)), 10 )
RETURN


*==============================================================================
PROCEDURE d_files
PRIVATE mfile1, mfile2, mfile3, mdisplay
ClearTop()
SETCURSOR(SC_NORMAL)
mfile1 = STRETCH("RLIB.LIB",60)
mfile2 = STRETCH("DEMO.EXE",60)
mfile3 = STRETCH("DEMO.PRG",60)
@ 4,0,7,79 BOX double + " "
CENTER(5,"Enter files to test for existance:")
@ 6, 2 SAY "#1:" GET mfile1 PICTURE "@!KS20"
@ 6,28 SAY "#2:" GET mfile2 PICTURE "@!KS20"
@ 6,54 SAY "#3:" GET mfile3 PICTURE "@!KS20"
READ
@ 6,1 SAY SPACE(78)
mfile1 = ALLTRIM(mfile1)
mfile2 = ALLTRIM(mfile2)
mfile3 = ALLTRIM(mfile3)
mdisplay = 'FILES("&mfile1", "&mfile2", "&mfile3") = ' +;
            IF( FILES(mfile1, mfile2, mfile3), '.T.', '.F.' )
CENTER(6,mdisplay)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_filesize
PRIVATE mfile
ClearTop()
mfile = GETE("COMSPEC")
mfile = GETFILE( mfile, "Enter an existing filename", .T., .F., 2, .F. )
SAYINBOX( helpColor, "The size of ", mfile,;
                     "is " + LTRIM(STR(FILESIZE(mfile))), 10 )
RETURN


*==============================================================================
PROCEDURE d_filetime
PRIVATE mfile
ClearTop()
mfile = GETE("COMSPEC")
mfile = GETFILE( mfile, "Enter an existing filename", .T., .F., 2, .F. )
SAYINBOX( helpColor, "The last update time of ", mfile,;
                     "is " + FILETIME(mfile), 10 )
RETURN


*==============================================================================
PROCEDURE d_forget
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_fprompt
PRIVATE fpsample
fpSample = "F1=Help,F2=Save,F3/Esc=Quit,F4=File,F10=Menu                      "
ClearTop()
SETCURSOR(SC_NORMAL)
@ 4,0,9,79 BOX double + " "
CENTER(5,"Enter a sample FPROMPT() formatted string (blanks will be TRIMmed)")
@ 6,CENTER(fpSample) GET fpSample PICTURE "@K"
READ
CENTER(8,"The result of FPROMPT(string) appears below")
fpSample = TRIM(fpSample)
SETCOLOR(demoColor)
FPROMPT(fpSample)
GetKey(15)
RETURN


*==============================================================================
PROCEDURE d_freadline
PRIVATE mfile, fhandle, curline, fast, key
ClearTop()
mfile = GETFILE("C:\CONFIG.SYS","Enter the name of a text file",.T.,.F.,2,.T.)
IF EMPTY(mfile)
   RETURN
ENDIF
IF .NOT. FILE(mfile)
   BLIP()
   BOXASK(helpColor,"Sorry " + mfile + " doesn't exist!", 10)
   RETURN
ENDIF
ClearBox(1,0,24,79)
@ 2,1,22,78 BOX single + " "
fhandle = FOPEN(mfile)
curline = 2
fast = .T.
key = 32
DO WHILE .NOT. FEOF(fhandle)
   IF key == 27
      IF BOXASK(helpColor, "Do you want to stop? (y/N) ") == "Y"
         EXIT
      ENDIF
   ELSEIF key == 32
      fast = .NOT. fast
      CENTER(24," Press SPACE to " + IF(fast,"slow down","speed up") +;
                ", ESCAPE to stop ")
   ENDIF
   line = FREADLINE(fhandle)
   IF curline = 21
      SCROLL(3,2,21,77,1)
   ELSE
      curline = curline + 1
   ENDIF
   @ curline,2 SAY SUBSTR(line,1,76)
   key = IF( fast, INKEY(), GetKey(.2) )
ENDDO
FCLOSE(fhandle)
ClearBox(23,0,24,79)
CENTER(24," Press any key to continue ")
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_frestscreen
PRIVATE mfile
ClearTop()
mfile = GETFILE("TEMP.SCR",;
                "Enter previous FSAVESCREEN() filename", .T., .F., 2, .F.)
IF .NOT. EMPTY(mfile)
   FRESTSCREEN(mfile)
   GetKey(3)
   SAYINBOX(helpColor,"The underlying screen was saved previously to",;
                      "and was just restored from " + mfile, 15)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_fsavescreen
PRIVATE mfile, row, col, start
ClearTop()
mfile = GETFILE("TEMP.SCR",;
                "Enter file to which to save the screen", .F., .T., 2, .F.)
IF .NOT. EMPTY(mfile)
   SAYINBOX(helpColor,"Press any key at which point a pattern will be",;
                      "painted onto the screen, and then the screen will",;
                      "be saved to " + mfile,;
                      "Select the FRESTSCREEN() function to demonstrate",;
                      "the screen being restored.",30)
   FOR row = 1 TO 24
      start = IF(row % 2 = 0, 0, 1)
      FOR col = start TO 79 STEP 2
         @ row,col SAY CHR(start+1)
      NEXT col
   NEXT row
   FSAVESCREEN(mfile)
   SAYINBOX(helpColor, "The underlying screen was saved to", mfile,;
                       "Select the FRESTSCREEN() function to restore", 15)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_getfile
PRIVATE getfile
ClearTop()
getfile = GETFILE("", "Enter the name of a file, wildcards ok",.F.,.F.,2,.F.)
IF .NOT. EMPTY(getfile)
   SAYINBOX("You entered " + getfile,10)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_getkey
PRIVATE ans
ans = BOXASK(helpColor,;
             "All wait states in the demo are performed by a call",;
             "to GETKEY().   To test it out for yourself, you can",;
             "alter the demo GETKEY() function to display a clock",;
             "ticking on the top right corner of your screen.  To",;
             "show the clock, answer YES to the following prompt.","",;
             "Make GETKEY() show a ticking clock? (Y/N) ", 60)
IF ans = "Y"
   gkey_clock = .T.
ELSE
   gkey_clock = .F.
ENDIF
RETURN


*==============================================================================
PROCEDURE d_getparm
PRIVATE mstring, mnumber, mparm
ClearTop()
SETCURSOR(SC_NORMAL)
mstring = "Red, Orange, Yellow, Green, Blue, Indigo, Violet"
@ 4,0,9,79 BOX double + " "
CENTER(5,"Enter a string with sections separated by commas")
@ 6,CENTER(mstring) GET mstring PICTURE '@K'
READ
mnumber = 4
@ 7,25 SAY "Enter parameter to retrieve:" GET mnumber PICTURE "#"
READ
mparm = GETPARM(mnumber,mstring)
CENTER(8, "Token #" + STR(mnumber,1,0) + " is: " + mparm)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_hex2dec
PRIVATE str
ClearTop()
SETCURSOR(SC_NORMAL)
str = STRETCH("1234ABCDEF",16)
@ 4,0,8,79 BOX double + " "
CENTER(5,"Enter a hexadecimal number as a character string:")
@ 6,CENTER(str) GET str PICTURE "@K"
READ
CENTER(7, "Decimal value = " + LTRIM(STR(HEX2DEC(str))) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_isdbf
PRIVATE mfile
ClearTop()
mfile = GETFILE("", "Enter an existing .DBF filename", .T., .F., 2, .F.)
IF .NOT. EMPTY(mfile)
   IF mfile = "DEMO.DBF"
      BOXASK(helpColor,;
             "DEMO.DBF cannot be tested because it is currently open.",;
             "The database file you test must not be open.",;
             "Please try another file",15)
      RETURN
   ENDIF
   SAYINBOX(helpColor, mfile,;
            IF(ISDBF(mfile)," is", " is not") + " a valid .DBF file", 10)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_isfield
PRIVATE mfield
mfield = "UDF_NAME  "
ClearTop()
@ 4,0,9,79 BOX double + " "
CENTER(5,"Enter a valid or invalid field from the DEMO database")
@ 6,CENTER(mfield) GET mfield PICTURE "@!K"
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
SAYINBOX( helpColor, mfield, IF( ISFIELD(mfield)," is", " is not") +;
          " a valid field in DEMO.DBF", 15 )
RETURN


*==============================================================================
PROCEDURE d_keyinput
PRIVATE length, upcase, echoon, mstring
length = 60
upcase = .F.
echoon = .T.
ClearTop()
@ 3,0,11,79 BOX double + " "
@ 4,2 SAY 'Enter maximum allowed key input length: ' GET length PICTURE '###'
@ 5,2 SAY 'Force characters into upper case? (Y/N):' GET upcase PICTURE 'Y'
@ 6,2 SAY 'Echo characters onto the screen? (Y/N): ' GET echoon PICTURE 'Y'
SETCURSOR(SC_NORMAL)
READ
@ 8,1 SAY 'Start typing:'
mstring = KEYINPUT(length,upcase,echoon)
@ 10,1 SAY 'You entered: ' + mstring
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_makealias
PRIVATE mdbf
ClearTop()
mdbf = STRETCH("C:\CLIPPER\DEMO\DEMO.DBF",40)
@ 4,0,8,79 BOX double + " "
CENTER(5, "Press ENTER or type in another database filename")
@ 6,CENTER(mdbf) GET mdbf PICTURE "@!K"
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
CENTER(7,"MAKEALIAS() returns " + MAKEALIAS(mdbf) )
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_markrec
PRIVATE marked, mrow
GO TOP
ClearTop()
SETCOLOR(helpColor)
@ 4,4,8,46 BOX single + " "
@ 5,6 SAY 'Press the  keys to choose a function.'
@ 6,6 SAY 'Mark by pressing the F9 key, and finish'
@ 7,6 SAY 'by pressing the ENTER key.             '
SETCOLOR(demoColor)

@ 1,60,12,79 BOX double + " "
marked = MARKREC( 2, 61, 11, 78, "' '+udf_name", -8, "udf_name" )
@ 1,60,12,79 BOX single

IF .NOT. EMPTY(marked)
   ClearBox(4,4,8,46,0)
   ClearBox(13,0,24,79)
   mrow = 3
   @ 3,0 SAY "You marked: "
   DO WHILE .NOT. EMPTY(marked)
      IF mrow = 24
         SCROLL(3,12,23,27,1)
         mrow = 23
      ENDIF
      @ mrow,12 SAY SUBSTR( marked, 1, AT(",",marked)-1 )
      marked = SUBSTR( marked, AT(",",marked)+1 )
      mrow = mrow + 1
      GetKey(.2)
   ENDDO
   @ 24,0
   ?? 'Press any key to continue...'
   GetKey(60)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_memorize
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_middle
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_mreplace
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_multimenu
PRIVATE num, x, filenum
SETCOLOR(multicolors[1])
SCROLL(2,10,6,70,0)
@ 2,10,6,70 BOX single + " "
CENTER(4,'Loading directory for MULTIMENU demostration')

*-- get a directory of all files
num = ADIR("*.*")
DECLARE files[num], sizes[num], dates[num], times[num], fileinfo[num]
ADIR( "*.*", files, sizes, dates, times )

FOR x = 1 TO num
   *-- now make each file name 12 spaces wide
   files[x] = STRETCH(files[x],12)
   *-- and build file description for each
   fileinfo[x] = 'Date: ' + DTOC(dates[x]) + '    ' +;
                 'Time: ' + times[x] + '    ' +;
                 'Size: ' + TRANSFORM( sizes[x], '###,###' )
NEXT x

*-- now present these files in a single line box with four
*-- columns across and descriptions on the line below the box
ClearTop()

@ 1,0,10,79 BOX single + " "
*-- the zero makes UDF calc column number dynamically
filenum = MULTIMENU( 2, 1, 9, 78, files, 4, fileinfo, 11, multicolors )
RETURN


*==============================================================================
PROCEDURE d_namesplit
PRIVATE mname, sname
ClearTop()
SETCURSOR(SC_NORMAL)
mname = STRETCH('Elmer Q. Fudd',35)
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "Enter a name to be parsed (split):" GET mname
READ
sname = NAMESPLIT(mname)
CENTER(6,'NAMESPLIT() version is: &sname')
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_no_append
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_no_flock
ClearTop()
IF NO_FLOCK()
   BOXASK(helpColor,"That was the result of NO_FLOCK()",;
                    "The DEMO.DBF file could not be locked",;
                    "Press any key to continue", 15)
ELSE
   BOXASK(helpColor,;
          "The DEMO.DBF file has been sucessfully locked by this station.","",;
          "To demonstrate NO_FLOCK(), please go to another network based",;
          "workstation and start the RLIB 3.2 demo program from the same",;
          "directory and select the  NO_FLOCK() or  NO_RLOCK() function.",;
          "NO_FLOCK()  or  NO_RLOCK() will not be able to place the lock",;
          "and will display an appropriate error message.   When you are",;
          "finished with the test, press any key here to unlock the file")
ENDIF
UNLOCK
RETURN


*==============================================================================
PROCEDURE d_no_rlock
ClearTop()
IF NO_RLOCK()
   BOXASK(helpColor,"That was the result of NO_RLOCK()",;
                    "The record in the DEMO.DBF file could not be locked",;
                    "Press any key to continue", 15)
ELSE
   BOXASK(helpColor,;
          "The current record has been sucessfully locked by this station.","",;
          "To demonstrate NO_RLOCK(), please go to another network based",;
          "workstation and start the RLIB 3.2 demo program from the same",;
          "directory and select the  NO_FLOCK() or  NO_RLOCK() function.",;
          "NO_FLOCK()  or  NO_RLOCK() will not be able to place the lock",;
          "and will display an appropriate error message.   When you are",;
          "finished with the test, press any key to unlock the record   ")
ENDIF
UNLOCK
RETURN


*==============================================================================
PROCEDURE d_notempty
PRIVATE mget
ClearTop()
SETCURSOR(SC_NORMAL)
mget = SPACE(20)
@ 4,0,8,79 BOX double + " "
CENTER(5,"Try to press ENTER without entering any text to see NOTEMPTY() in force")
@ 6,CENTER(mget) GET mget PICTURE "@K" VALID NotEmpty(mget)
READ
SETCURSOR(SC_NONE)
RETURN


*==============================================================================
PROCEDURE d_ntxkeyval
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_olderfile
PRIVATE older, mresult
SETCURSOR(SC_NORMAL)
DECLARE mfile[2]
mfile[1] = STRETCH("DEMO.PRG",60)
mfile[2] = STRETCH("DEMO.EXE",60)
@ 4,0,8,79 BOX double + " "
CENTER(5,"Enter two files to test which is older")
@ 6,13 SAY "#1:" GET mfile[1] PICTURE "@!KS20"
@ 6,46 SAY "#2:" GET mfile[2] PICTURE "@!KS20"
READ
mfile[1] = ALLTRIM(mfile[1])
mfile[2] = ALLTRIM(mfile[2])
older    = OLDERFILE(mfile[1], mfile[2])
mresult  = "OLDERFILE() reports " +;
           IF(older > 0, mfile[older] + " is the older file.",;
           IF(older < 0, mfile[ABS(older)] + " does not exist.",;
           IF(older = 0, " both files have the same date and time.",;
                         "a syntax error.")))
SETCURSOR(SC_NONE)
CENTER(7,mresult)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_opened
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_parent
PRIVATE mdir
ClearTop()
SETCURSOR(SC_NORMAL)
mdir = STRETCH("C:\CLIPPER\LIBS\RLIB\SOURCE",40)
@ 4,0,8,79 BOX double + " "
CENTER(5, "Press ENTER or type in another directory name:")
@ 6,CENTER(mdir) GET mdir PICTURE "@!K"
READ
@ 6,1 SAY SPACE(78)
CENTER(6,ALLTRIM(mdir))
CENTER(7,"The parent directory is " + PARENT(mdir) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_pathto
PRIVATE mfile, mpath
ClearTop()
SETCURSOR(SC_NORMAL)
mfile = "CLIPPER.EXE "
@ 4,0,8,79 BOX double + " "
CENTER(5, 'Enter the name of a file which can be found through the DOS path')
CENTER(6, '(Current DOS path is ' + GETE('PATH') + ')')
@ 7,CENTER(mfile) GET mfile PICTURE "@!"
READ
mfile = ALLTRIM(mfile)
mpath = PATHTO(mfile)
IF EMPTY(mpath)
   CENTER(7,'&mfile is not located in any directory in the DOS path!')
ELSE
   CENTER(7,'&mfile can be found in the &mpath directory')
ENDIF
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_pdowninit
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_pickcolor
PRIVATE cmenu, dcolor, pcolor, header
DECLARE cmenu[6]

header   = " SELECT COLORS TO CHANGE "
cmenu[1] = " Screen Text             "              &&   sayColor    = "W/B"
cmenu[2] = " Selected Gets           "              &&   getColor    = "N/W"
cmenu[3] = " Unselected Gets         "              &&   unselColor  = "N/BG"
cmenu[4] = " Instructions/Help       "              &&   helpColor   = "W+/B"
cmenu[5] = " Function Syntax         "              &&   syntaxColor = "N/B"
cmenu[6] = " Background              "              &&   backGround  = "W/B"

dcolor = 1

DO WHILE .T.
   ClearTop()
   dcolor = BOXMENU(2, 10, cmenu, dcolor, "","","","", boxColors, header, .F.)

   IF dcolor = 0
      EXIT
   ENDIF

   pcolor = IF(dcolor = 1, sayColor,;
            IF(dcolor = 2, getColor,;
            IF(dcolor = 3, unselColor,;
            IF(dcolor = 4, helpColor,;
            IF(dcolor = 5, syntaxColor, backGround)))))

   pcolor = PICKCOLOR(pcolor, background, .f., 2, 79, .F.)

   IF LASTKEY() != 27
      DO CASE
         CASE dcolor = 1
            sayColor    = pcolor
         CASE dcolor = 2
            getColor    = pcolor
         CASE dcolor = 3
            unselColor  = pcolor
         CASE dcolor = 4
            helpColor   = pcolor
         CASE dcolor = 5
            syntaxColor = pcolor
            SETCOLOR(syntaxcolor)
            SCROLL(13,0,23,79,0)
            @ 13,0,24,79 BOX single + " "
            MEMOEDIT(demo->descrip, 14, 1, 23, 78, .F., .F.)
         CASE dcolor = 6
            backGround  = pcolor
      ENDCASE
      demoColor = sayColor + "," + getColor + ",,," + unselColor
   ENDIF
ENDDO
RETURN


*==============================================================================
PROCEDURE d_pickfile
PRIVATE filespec
ClearTop()
@ 5,15,7,65 BOX double + " "
filespec = "*.*" + SPACE(60)
@ 6,19 SAY "Enter filespec:" GET filespec PICTURE "@!KS26"
SETCURSOR(SC_NORMAL)
READ
SETCURSOR(SC_NONE)
@ 5,15,7,65 BOX single
IF LASTKEY() <> 27
   filename = PICKFILE( TRIM(filespec), 1, 0, 24, democolor, .T. )
   IF .NOT. EMPTY(filename)
      SAYINBOX("You selected " + filename,5)
   ENDIF
ENDIF
RETURN


*==============================================================================
* Notes: The <condition> parameter lets this function be used for the Query
*        demo by giving a condition, otherwise it's set to the default "".
*==============================================================================
PROCEDURE d_pickrec
PARAMETER condition
PRIVATE mrow, fieldlist, incolor

IF TYPE("condition") != "C"
   condition = ""
   GetKey(3)          && give them 3 more seconds to see write up on PICKREC()
ENDIF

mrow      = 0
incolor   = SETCOLOR()
fieldlist = "' ' + UDF_NAME"
SETCURSOR(SC_NONE)

GO TOP
ClearTop()

DO WHILE .T.
   SETCOLOR(helpColor)
   @  2,2,11,40 BOX single + " "
   @  3,4 SAY "Scroll with ,,PgUp,PgDn,Home,End"
   @  5,4 SAY "Jump to a function by pressing the"
   @  6,4 SAY "beginning letters of the name."
   @  8,4 SAY "Select/view the function syntax by"
   @  9,4 SAY "pressing Enter, or press Escape to"
   @ 10,4 SAY "return to the controlling menu."

   SETCOLOR(syntaxColor)
   @ 13,0,24,79 BOX single

   SETCOLOR(demoColor)
   @ 1,60,12,79 BOX double

   mrow = PICKREC(2, 61, 11, 78, fieldlist, "DISPSYNTAX", condition, mrow)

   @ 1,60,12,79 BOX single
   ClearBox(2,2,11,40)

   DO CASE
      CASE mrow = 0
         EXIT

      CASE LASTKEY() = 13                            && Enter key
         SETCOLOR(syntaxColor)
         @ 13,0,24,79 BOX double

         SETCOLOR(helpColor)
         @ 3,2,10,36 BOX single + " "
         IF edit
            IF NO_RLOCK()             && NO_RLOCK() does error messages for us!
               LOOP
            ENDIF
            @ 5,4 SAY "Edit syntax or scroll with the"
            @ 6,4 SAY "directional arrow keys.  Press"
            @ 7,4 SAY "Ctrl-W to save edits, or press"
            @ 8,4 SAY "Escape to abort without saving"
            SETCOLOR(getColor)
            SETCURSOR(SC_NORMAL)
            REPLACE demo->Descrip WITH MEMOEDIT(demo->Descrip,14,1,23,78,.T.)
            SETCURSOR(SC_NONE)
         ELSE
            @ 5,4 SAY "Scroll through the syntax with"
            @ 6,4 SAY "the directional arrow keys."
            @ 8,4 SAY "Press Escape when done."
            SETCOLOR(syntaxColor)
            MEMOEDIT(demo->Descrip,14,1,23,78,.F.)
         ENDIF

   ENDCASE
ENDDO
SETCOLOR(incolor)
RETURN


*===============================================
PROCEDURE dispsyntax
PRIVATE incolor
incolor = SETCOLOR(syntaxcolor)
MEMOEDIT(demo->descrip, 14, 1, 23, 78, .F., .F.)
SETCOLOR(incolor)
RETURN


*==============================================================================
PROCEDURE d_popbox
PRIVATE pbox1, pbox2, pbox3
pbox1 = SAYINBOX(helpColor,;
         "The screen area underneath this SAYINBOX() display has been",;
         "saved to a single memory variable that contains the screen ",;
         "contents and the coordinates where it is to be restored.   ",;
         "The screen will be restored by a call to POPBOX()", "",;
         "Press any key to display and restore more SAYINBOX() boxes" )
GetKey(30)
pbox2 = SAYINBOX(demoColor,"This is another SAYINBOX() screen",;
                           "that covers part of the first",;
                           "and will be covered by a third box")
GetKey(4)
pbox3 = SAYINBOX(helpColor,"This is the third box")
GetKey(2)
POPBOX(pbox3)
GetKey(1)
POPBOX(pbox2)
GetKey(1)
POPBOX(pbox1)
GetKey(1)
SAYINBOX(helpColor,"There!  All done",5)
RETURN


*==============================================================================
PROCEDURE d_popuppick
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_printcode
PRIVATE pcode
ClearTop()
SETCURSOR(SC_NORMAL)
pcode = '27,"(s16.67H"                         '
@ 4,0,8,79 BOX double + " "
CENTER(5,"Enter a printer control code in comma delimited decimal values:")
@ 6,CENTER(pcode) GET pcode PICTURE "@K"
READ
CENTER(7,"PRINTCODE() returns: " + PRINTCODE(pcode) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_query
PRIVATE names, query, pbox
DECLARE names[4]

names[1] = " Function Name   "           &&  UDF_NAME       C      16     0
names[2] = " Category        "           &&  CATEGORY       C      12     0
names[3] = " Purpose         "           &&  PURPOSE        C      60     0
names[4] = " Description     "           &&  DESCRIP        M      10     0

ClearTop()

SETCOLOR(helpColor)
@ 2,0,11,79 BOX single + " "
@ 4, 4 SAY "Press any key to bring up the query screen.  Select fields and criteria"
@ 5, 4 SAY "using the query builder.  When you are finished, select DONE and the"
@ 6, 4 SAY "query condition you built will be used as an index key and used as a"
@ 7, 4 SAY "condition to PICKREC() to show only those functions selected."
@ 9,15 SAY "Press any key to enter the query building screen..."
SETCOLOR(demoColor)
GetKey(0)
@ 1,0 CLEAR
CENTER(1,"SAMPLE DEMO QUERY BUILDER")
query = QUERY(names)
IF LASTKEY() = 27
   RETURN
ENDIF
pbox = SAYINBOX("Indexing query, one moment")
INDEX ON IF(&query,"A","Z") + demo->udf_name TO query.ntx
POPBOX(pbox)
DO d_pickrec WITH query
SET INDEX TO demo
GO TOP
RETURN


*==============================================================================
PROCEDURE d_reportinit
ClearTop()
BOXASK(helpColor,"Press any key to create PRINTERS.DBF and REPORTS.DBF",;
                 "with a single call to the REPORTINIT() function...")
IF REPORTINIT(.T.)
   BOXASK(helpColor,"PRINTERS.DBF and REPORTS.DBF have been created by REPORTINIT()",;
                    "Now try out the STARTREPORT() function", 15)
ELSE
   BOXASK(helpColor,"An error occurred creating the databases",15)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_revdate
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_rh_header
ClearTop()
SETCOLOR(helpColor)
@ 2,20,11,60 BOX single + " "
@ 4,22 SAY "This is one of the RHELP Application "
@ 5,22 SAY "Programming Interface (API) functions"
@ 6,22 SAY "and is difficult to demonstrate.  See"
@ 7,22 SAY "Appendix B of the RLIB documentation."
@ 8,22 SAY "The sample HELP procedure shows how  "
@ 8,22 SAY "to easily implement RHELP using these"
@ 9,22 SAY "API functions."
SETCOLOR(demoColor)
GetKey(15)
RETURN


*==============================================================================
PROCEDURE d_rh_lines
DO d_rh_header
RETURN


*==============================================================================
PROCEDURE d_rh_text
DO d_rh_header
RETURN


*==============================================================================
PROCEDURE d_rh_width
DO d_rh_header
RETURN


*==============================================================================
PROCEDURE d_rlibver
SAYINBOX( "This is RLIB version " + RLIBVER(), 10)
RETURN


*==============================================================================
PROCEDURE d_rjustify
PRIVATE mstring
ClearTop()
SETCURSOR(SC_NORMAL)
mstring = STRETCH("RLIB 3.2 Function Library",40)
@ 4,0,7,79 BOX double + " "
@ 5,3 SAY "Enter text to be right justified:" GET mstring
READ
@ 6,39 SAY RJUSTIFY(mstring)
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_rliberror
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_rlibinit
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_sayinbox
PRIVATE mline1, mline2, mline3
ClearTop()
SETCURSOR(SC_NORMAL)
@ 3,0,11,79 BOX double + " "
@ 5,1 SAY 'Enter three lines of text to appear in SAYINBOX (up to 65 characters each)'
@ 7,1 SAY 'Line #1: '
mline1 = KEYINPUT( 65, .F., .T. )
@ 8,1 SAY 'Line #2: '
mline2 = KEYINPUT( 65, .F., .T. )
@ 9,1 SAY 'Line #3: '
mline3 = KEYINPUT( 65, .F., .T. )
SAYINBOX( mline1, mline2, mline3, 10 )
SETCURSOR(SC_NONE)
RETURN


*==============================================================================
PROCEDURE d_setcursor
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_startreport
PRIVATE reportName, pbox
reportName = STRETCH("Sample Report #1",40)
ClearTop()

IF .NOT. FILES("reports.dbf","printers.dbf","printers.ntx")
   pbox = SAYINBOX(helpColor,"Creating report files...")
   IF .NOT. ReportInit(.T.)
      BOXASK(helpColor,"An error occurred creating the databases",15)
      RETURN
   ENDIF
   POPBOX(pbox)
ENDIF

SETCOLOR(helpColor)
@ 2,2,8,42 BOX single + " "
@ 3,4 SAY "Enter the name of a sample report, "
@ 4,4 SAY "the StartReport() configuration you"
@ 5,4 SAY "build will be saved in the REPORTS "
@ 6,4 SAY "database and can be recalled later "
@ 7,4 SAY "by specifying the same report name."
SETCOLOR(demoColor)

@ 10,20,12,61 BOX double
@ 11,21 GET reportName PICTURE "@K"
SETCURSOR(SC_NORMAL)
READ
@ 10,20,12,61 BOX single
reportName = TRIM(reportName)

IF STARTREPORT(reportName)
   ? "This is two sample lines of text being sent to the target device"
   ? "selected in the StartReport() RLIB function."
   STOPREPORT()
   GetKey(1)
ENDIF

SETCURSOR(SC_NONE)
RETURN


*==============================================================================
PROCEDURE d_str2date
PRIVATE datestring
ClearTop()
SETCURSOR(SC_NORMAL)
datestring = STRETCH(ALPHADATE(DATE()),30)
@ 4,0,7,79 BOX double + " "
@ 5,6 SAY "Enter date string to be converted:" GET datestring
READ
CENTER( 6, "The date is: " + DTOC(STR2DATE(datestring)) )
SETCURSOR(SC_NONE)
GetKey(10)
RETURN


*==============================================================================
PROCEDURE d_stretch
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_target
target = TARGET( 2, 21, boxColors, .T., "Select A Sample Target", "" )
IF .NOT. EMPTY(target)
   SAYINBOX(helpColor,"You selected " + target, 15)
ENDIF
RETURN


*==============================================================================
PROCEDURE d_tempfile
PRIVATE tempf
tempf = TEMPFILE()
SAYINBOX( helpColor, "The temporary filename generated by TEMPFILE() is",;
          tempf, 15)
ERASE (tempf)
RETURN


*==============================================================================
PROCEDURE d_typec
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_valtypec
NoDemo()
RETURN


*==============================================================================
PROCEDURE d_vrange
PRIVATE number
ClearTop()
number = 0
SETCURSOR(SC_NORMAL)
@ 4,0,8,79 BOX double + " "
CENTER(5,"Try to enter a number that is not between 1 and 100")
@ 6,37 GET number PICTURE "999999" VALID Vrange(number,1,100)
READ
SETCURSOR(SC_NONE)
RETURN

