@echo off
REM ==========================================================================
REM  File:     MAKEDEMO.BAT
REM
REM  Purpose:  Batch file to compile and link the RLIB demo program DEMO.PRG
REM
REM  Syntax:   makedemo
REM
REM  Notes:    This is a batch file to make the RLIB demonstration program
REM            DEMO.EXE from the source file DEMO.PRG supplied with the
REM            RLIB 3.2 demo and distribution package.  It will make the
REM            DEMO.EXE file using CA-Clipper 5.2.
REM
REM            This batch file assumes that the CA-Clipper 5.2 executable
REM            files reside in the C:\CLIPPER5\BIN directory, and that the
REM            CA-Clipper supplied libraries reside in C:\CLIPPER5\LIB.
REM            Change the directory references and environment variable
REM            settings as needed.
REM ==========================================================================


:COMP5x
REM --------------------------------------------------------------------------
REM  Compile and link.  Change the directories to point to the location
REM  where your Clipper executables and libraries (including RLIB) reside.
REM  I have left the RLIB reference to the current directory and assume the
REM  Clipper 5.x files are in C:\CLIPPER5\BIN and the Clipper supplied library
REM  files are in C:\CLIPPER5\LIB.  Most of you will undoubtedly have to change
REM  these directories to conform to your own structure.
REM --------------------------------------------------------------------------
set CLIPPERCMD=
set LIB=C:\CLIPPER5\LIB
set INCLUDE=C:\CLIPPER5\INCLUDE
c:\clipper5\bin\clipper demo /M


:LINK5x
REM --------------------------------------------------------------------------
REM  Use the linker of your choice here.  I use BLINKER 1.5 a lot, but
REM  everyone has RTLINK because it comes with Clipper 5.x.
REM
REM  If you did not place RLIB.LIB in the current directory, add the directory
REM  where it is located to the link command.  For instance, if you placed
REM  RLIB.LIB in a directory other than the C:\CLIPPER\LIB directory that was
REM  specified in the LIB environment variable, add the directory to the RLIB
REM  reference in the link command below.
REM --------------------------------------------------------------------------
c:\clipper5\bin\rtlink file demo lib clipper,rlib,extend verbose

