* Function: BRIGHT
* Author..: Richard Low
* Syntax..: BRIGHT( [<expC>] )
* Returns.: Color setting passed as parameter in bright. (With "+" added)
*           If parameter is omitted, current color is switched to bright.

FUNCTION BRIGHT
PARAMETER p_color
PRIVATE ret_val

IF TYPE('p_color') = 'C'
   p_color = UPPER(p_color)
ELSE
   p_color = UPPER(SETCOLOR())
ENDIF

IF "/" $ p_color
   ret_val = SUBSTR(p_color, 1, AT('/',p_color)-1 ) + "+" +;
             SUBSTR(p_color, AT('/',p_color) )
ELSE
   IF "," $ p_color
      ret_val = SUBSTR(p_color, 1, AT(',',p_color)-1 ) + "+" +;
                SUBSTR(p_color, AT(',',p_color) )
   ELSE
      ret_val = p_color + "+"
   ENDIF
ENDIF

IF ISCOLOR() .AND. SUBSTR(ret_val, 1, 2) = "W+"
   *-- if White on a color monitor, make bright Yellow
   ret_val = "GR+" + SUBSTR( ret_val, 3 )
ENDIF

RETURN (ret_val)
