*- Generates a report based on information in the REPORTS database
*- Pass the routine the name of the report you desire which corresponds
*- to a report in the REPORTS database, and the name of a semaphore (text
*- file name) that the report will be output to.

*- NOTE: Requires CT1.LIB from Clipper Tools one, and Clipper S'87
*-
*- Upon entry, you have USED and SELECTED the database which you want to
*- generate the report from, and SET any FILTERS which you may want.

*- The REPORTS database contains the following fields:
*-
*- REPORT - character name of this report
*- WIDTH  - numeric width of the page which you want to print on
*-          used to center and underline
*- SPACING - numeric - number of spaces between columns of the report
*- VARNAMES - a memo field which defines the report.
*-
*- VARNAMES is specified as follows:
*-
*-   FIRSTEJECT - if specified, a page eject will be generated before the
*-                first title header - defaults to .F.
*-   LASTEJECT  - if specied, a page eject will be generated at the end of
*-                the report - defaults to .F.
*-   PAGELENGTH - if specified, the page length for the report will be
*-                adjusted to that specfied eg. PAGELENGTH66 will set the
*-                page length to 66 lines - default is 58
*-   TITLE% -      you may specify as many titles as you wish and they
*-                will appear in the order given.  If you precede the
*-                title with the word CENTERED, the title will be centered
*-                in REPORTS->width.  If you specify NOHYPHEN, then that
*-                line will not be followed by a separating line.
*-
*-                TITLE%CENTEREDAccount listing as at &m_date
*-                TITLE%NOHYPHENAccount #     Name             Address
*-                TITLE%          30 day Balance   60 day balance     Last payment
*-
*-                This would generate a title that would look like this if
*-                REPORTS->width were 79
*-
*12:00:00                     01/12/1989                             Page 1
*------------------------------------------------------------------------------
*                      Account listing as at 01/12/1989
*------------------------------------------------------------------------------
*Account #     Name          Address
*     30 day Balance     60 day balance  Last payment
*------------------------------------------------------------------------------
*-
*-               Note that you may embed macros in the titles - just make sure
*-               that the macro evaluates to a valid character expression at
*-               run-time.  You may have up to 10 titles, if you wish more,
*-               you must increase the size of the array TITLES[]

*-   OUTPUT<n>%  allows you to specify as many fields as you like to put on
*-               each line of the report - thereby allowing multiple line
*-               reports.
*-               The only requirement here is that you make the expression one
*-               that evaluates to a character string as the expression is
*-               macro converted and then output.  ie. you would not make
*-               DATE a field - rather DTOC(date) or TRANSFORM(amount,"9999.99")
*-
*-               example:
*-
*-               OUTPUT1%STR(account_no,6)
*-               OUTPUT1%name
*-               OUTPUT1%address
*-               OUTPUT2%SPACE(5)
*-               OUTPUT2%TRANSFORM(thirtyday,"9999.99")
*-               OUTPUT2%TRANSFORM(sixtyday,"9999.99")
*-               OUTPUT2%DTOC(last_payment)
*-               OUTPUT3%SPACE(1)
*-
*-               These specifications would generate lines of report that looked
*-               like this:
* 123456  Joe Smith          1234 Main street
*     419.75   125.75  01/12/1990
*
* 123457  John Doe           3186 Pine
*    1238.78   605.38  01/19/1989
*-
*- and so on...
*-               again, there is no way for this routine to check for values
*-               that will not evaluate at run-time, so ensure that all databases
*-               you are using are open, any variables that you may use are
*-               defined, etc. before running the report.  You are allowed up
*-               to 10 per item.  If you wish more, you must increase the size
*-               of the array DISP_STRING[]
*-
*-   GRANDTOTAL - This prefix will allow you to total on the condition that
*-               you specify.  eg.
*-
*-                  GRANDTOTAL%thirtyday%Total thirty day balances:
*-                  GRANDTOTAL%sixtyday%Total sixty day balances:
*-
*-                This would keep a running tab of thirty day balances
*-                throughout the report and print out
*-
*- Total thirty day balances:  1234.56
*- Total sixty day balances :  9999.99
*-
*-   ... at the end of the report.  Note that this is primarily intended for
*-                  financial reports so that final total is always printed
*-                  in the picture "9999.99".  If this is unsatisfactory,
*-                  you can easily alter the routine to include your own
*-                  picture clause for each total.
*-
*-
*-   The routine will RETURN .T. if the report has successfuly been written
*-  to the file specified, or will return a .F. and a meaningful error message
*-  if it could not accomplish this.

*-   Have a look at the REPORTS database to see how the memo field works
*-   and play around with it a bit.  I think you'll agree this is a most
*-   flexible way to write reports


*-   You'll have to use dBase's editor to edit the memo field or simply
*-   a quick MEMOEDIT function to edit the VARNAMES field.  I haven't
*-   included one as I just use dBase to accomplish this end.

*-   Experiment with this and make whatever embellishments you feel are needed.
*-   I find this to be a god-send for writing multi line reports and just
*-   reports in general, as I find REPORT FORM to be woefully inadequate.
*-   In the near future I'll be adding GROUPING as a field, but I suspect
*-   some others will beat me to it.
*-
*-
*-   Any questions/suggestions, please leave them by Easyplex -
*-
*-                                                Mark Sicherman
*-                                                76506,2156
*-


CLEAR
SELECT 0
USE REPORTS
SELECT 0
USE SAMPLE
@0,0 SAY "Generating report... read the PRG file for details"
m_date = DTOC(date())  && m_date is used in the title of the sample report

IF REPORTER("daily_report","dreport.txt")
     @1,0 SAY "The report was successfully generated to file 'DREPORT.TXT'"
ELSE
     @1,0 SAY "Could not generate report - read the PRG file for details"
ENDIF
QUIT





FUNCTION REPORTER
PARAMETERS report_name, semaphore

PRIVATE memo_text, num_elements
PRIVATE num_titles, num_totals, num_outputs
PRIVATE page, line
PRIVATE cond[10],tot_header[10],Gtotal[10],title[10],disp_string[10]
PRIVATE curr_select
PRIVATE first_eject, last_eject, pagelength
PRIVATE screen_buf

curr_select = SELECT()
STORE 0 to num_titles, num_totals, num_outputs
STORE 1 to page, line
STORE .F. TO firsteject,lasteject
pagelength = 58

afill(cond,"")
afill(tot_header,"")
afill(Gtotal,0)
afill(title,"")
afill(disp_string,"")


SELECT REPORTS
LOCATE FOR UPPER(report) = UPPER(report_name)
IF !FOUND()
*- put your own error handling routine here.
     err_msg("Report " + report_name + " not found")
     SELECT (curr_select)
     RETURN .F.
ENDIF

PRIVATE this_area, this_rec, this_color, this_help, this_esc,this_screen, this_funcs

*- break out the tokens and determine what they are
memo_text = MEMOTRAN(varnames,"|","|")
num_elements = NUMTOKEN(memo_text,"|")
FOR i = 1 TO num_elements
     this_line = TOKEN(memo_text,"|",i)
     DO CASE
     CASE this_line = "TITLE"
          num_titles = num_titles + 1
          title[num_titles] = TOKEN(this_line,"%",2)
     CASE this_line = "PAGELENGTH"
          pagelength = VAL(SUBSTR(this_line,11))
     CASE this_line = "FIRSTEJECT"
          firsteject = .T.
     CASE this_line = "LASTEJECT"
          lasteject = .T.
     CASE this_line = "GRANDTOTAL"
          num_totals = num_totals + 1
          cond[num_totals] = TOKEN(this_line,"%",2)
          tot_header[num_totals] = TOKEN(this_line,"%",3)
     CASE this_line = "OUTPUT"
          output_no = VAL(SUBSTR(this_line,7,1))
          num_outputs = MAX(output_no,num_outputs)
          disp_string[output_no] = disp_string[output_no] + SUBSTR(this_line,9) + '+"' + replicate(" ",spacing) + '"+'
     ENDCASE
NEXT

*- Trim trailing spaces and + symbols from output lines
FOR i = 1 to num_outputs
     disp_string[i] = posdel(disp_string[i],spacing+4)
NEXT

SELECT (curr_select)
retval = .T.
m_error = ""
BEGIN SEQUENCE
     *- create the output file
*- Include this information if you are working in a network environment
*- and wish to lock the semaphore before generating the report
*     IF ! N_SLOCK(semaphore)
*          m_error = "Network error"
*          retval = .F.
*          BREAK
*     ENDIF

     fhandle = FCREATE(semaphore,0)
     IF fhandle = -1
          m_error = "File create error " + N2str(FERROR())
          retval = .F.
          BREAK
     ENDIF

     DO WHILE .NOT. EOF()
          DO CASE
          CASE line = 1
               maketitle()
          CASE line > pagelength-num_outputs
               line = 1
               LOOP
          ENDCASE

          FOR i = 1 TO num_outputs
               m_string = disp_string[i]
               m_string = &m_string
               mywrite(fhandle,m_string)
               line = line + 1
          NEXT

          FOR i = 1 to num_totals
               M_COND = COND[I]
               gtotal[i] = Gtotal[i] + &M_COND
          NEXT

          line = IF(line < pagelength,line+1,1)
          SKIP
     ENDDO
     mywrite(fhandle,REPLICATE("-",REPORTS->width))
     mywrite(fhandle, CJUSTIFY("*** End of report ***",REPORTS->width))
     mywrite(fhandle,REPLICATE("-",REPORTS->width))
     FOR i = 1 TO num_totals
          mywrite(fhandle,tot_header[i] + " " + TRANSFORM(Gtotal[i],"@) 9999.99"))
     NEXT
END
*- Netlib semaphore unlock function - only necessary in network environment
*N_SUNLOCK(semaphore)
IF lasteject
     mywrite(fhandle,CHR(12))
ENDIF
FCLOSE(fhandle)
IF retval = .F.
     err_msg(m_error)
     RETURN .F.
ENDIF
RETURN .T.



PROCEDURE maketitle
*- prints a page title based upon elements in the MEMO field of the REPORTS
*- database that start with the word TITLE.  If the field starts with the
*- word title, then this routine will break them out, expand any included
*- macros, and, if CENTERED is the first eight characters of the title, it
*- will center it.  It starts with a line with the time on the right, the
*- date in the middle, the page number on the left.  It increments the page
*- number.  The next line is a repeated hyphen which is REPORTS->width long.
*- It then alternates title line, hyphenated line till all titles are
*- processed.
PRIVATE i, nohyphen, retval

*- eject first page if necessary and all other pages
IF page = 1 .AND. firsteject
     mywrite(fhandle,CHR(12))
ELSE
     mywrite(fhandle,CHR(12))
ENDIF


mywrite(fhandle, time() + REPLICATE(" ",INT(REPORTS->width/2)-13) + DTOC(date()) + REPLICATE(" ", REPORTS->width-INT(REPORTS->width/2) - 5 - LEN("Page " + N2str(page)) ) + "Page " + N2str(page))
mywrite(fhandle,REPLICATE("-",REPORTS->width))
line = line + 1
line = line + 1


FOR i = 1 TO num_titles
     no_hyphen = .F.
     IF !EMPTY(title[i])
          IF LEFT(title[i],8) = "NOHYPHEN"
               no_hyphen = .T.
               m_title = SUBSTR(title[i],9)
          ELSE
               m_title = title[i]
          ENDIF
          mywrite(fhandle,IF(LEFT(m_title,8) = "CENTERED", CJUSTIFY(CONVERT(SUBSTR(m_title,9)), REPORTS->width), m_title))
          line = line + 1
          IF !no_hyphen
               mywrite(fhandle,REPLICATE("-",REPORTS->width))
               line = line + 1
          ENDIF
     ENDIF
NEXT
page = page + 1
RETURN

FUNCTION convert
*- Breaks out any macros in a string, expands them, and returns the
*- expanded string.  Macros must be started with a &, and terminated
*- with either a space or a carriage return
PARAMETERS m_string
PRIVATE pos, m_right, m_token
DO WHILE "&" $ m_string
     pos = AT("&",m_string)
     m_right = RIGHT(m_string,LEN(m_string)-pos)
     m_token = TOKEN(m_right," "+CHR(13),1)
     m_string = LEFT(m_string,pos-1) + &m_token + RIGHT(m_right,LEN(m_right) - LEN(m_token))
ENDDO
RETURN m_string


PROCEDURE mywrite
PARAMETERS m_handle, m_text
FWRITE(m_handle,m_text+CHR(13)+CHR(10))
IF FERROR() # 0
     m_error = "File write error"
     retval = .F.
     BREAK
ENDIF
RETURN

*- Substitute in your own error message routine for this
FUNCTION err_msg
PARAMETERS m_msg
? m_msg

*- justifies a string in len spaces
FUNCTION CJustify
parameters lString, lLen
lString=space(int((lLen-len(lString))/2))+lString
return lString+space(lLen-len(lString))

*- returns a trimmed string from a numeric
FUNCTION n2str
PARAMETERS m_str, m_len, m_dec
DO CASE
     CASE type("m_len") = 'U'
          RETURN ALLTRIM(STR(m_str))
     CASE type("m_dec") = 'U'
          RETURN(ALLTRIM(STR(m_str,m_len)))
     OTHERWISE
          RETURN(ALLTRIM(STR(m_str,m_len,m_dec)))
ENDCASE

