#include "box.ch"

/*

     REPo Example implementation

     The following programming example illustrates how
     REPo can be implemented into applications so users
     can print print and customize predefined reports and
     build their own.

*/

FUNCTION Main(cPath)

   local nSaveCurs := setCursor(0)
   local nChoice,o,oScan
   local cCommand  := chr(24)+chr(25)+" - Select Option  <ENTER> - Execute  <ESC> - Quit"
   local cDrive
   local aDrives := {"C:","A:","B:","D:"}

     if cPath == Nil
        cPath := curdir()
     endif

     set scoreboard off

     //                  *** Get drive letter

     clear screen


     tone(500)
     @10,10 say "Select drive letter EXAMPLE program is being executed from:"

     @12,15 prompt "C:"
     @12,20 prompt "A:"
     @12,25 prompt "B:"
     @12,30 prompt "D:"

     menu to nchoice

     cDrive := iif(nChoice > 0, aDrives[nChoice], aDrives[1] )+"\"

     //   ** Open work areas and set relations

     use customer.dbf index customer new
     use salesman.dbf index salesman new
     use items.dbf index items new
     use invoices.dbf index invoices new

      set relation to customer into customer
      set relation to salesman into salesman additive
      set relation to number into items additive


     //  **  Display menu

     while .t.

        go top

        setColor("w/n")

        clear screen

        setColor("n/w")                    // Status Bar
        @maxrow(),0 say space(maxcol()+1)
        @maxrow(), (maxcol()/2) - (len(cCommand)/2) say cCommand

        setColor("w/n,n/w")

        @5,2,20,75 BOX B_SINGLE

        setColor("w+/n")
        @5,5 say " REPo Example Report Center "

        @7,5 say " Invoices... "
        setColor("w/n,n/w")

        @9,6 prompt  " A) Invoices            "
        @10,6 prompt " B) Edit Invoice Report "

        setColor("w+/n")
        @12,5 say " Customer Information..."
        setColor("w/n,n/w")

        @14,6 prompt " A) Customer Listing        "
        @15,6 prompt " B) Customer Sales Activity "
        @16,6 prompt " C) Edit Customer Listing   "
        @17,6 prompt " D) Edit Customer Activity  "


        setColor("w+/n")
        @7,35 say " Sales... "
        setColor("w/n,n/w")

        @9,35 prompt  " A) Sales Personnel (Territory)  "
        @10,35 prompt " B) Sales Person Activity Report "
        @11,35 prompt " C) Edit Personnel               "
        @12,35 prompt " D) Edit Sales Person Activity   "

        setColor("w+/n")
        @14,35 say " Mailings... "
        setColor("w/n,n/w")

        @16,35 prompt " A) Customer Mailing Labels  "
        @17,35 prompt " B) Customer Form Letter     "
        @18,35 prompt " C) Edit Labels              "
        @19,35 prompt " D) Edit Form Letter         "

        menu to nChoice


        //  ** Execute menu selection

        do case

//
//         *** Invoices
//

           case nChoice == 1


            select invoices

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| invoices->number == items->number }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\invoice\"
               o:template := "invoices.rfw"
               o:print("invoices.rpt")   // Print report

           case nChoice == 2


              select invoices
                go top


               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\invoice\"
               o:template := "invoices.rfw"
               o:title := 0
               o:heading := 0
               o:detail := 40
               o:summary := 0

               if (nError := o:edit()) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" editing report, press any key..."
                  inkey(0)
               endif

//
//        *** Customers
//

           case nChoice == 3             //  Customer Listing
   
               select customer

               go top

               o := repoNew()            // Report object

               o:reports := cDrive+alltrim(cPath)+"\customer\"
               o:template := "customer.rfw"

                if (nError := o:print("customer.rpt")) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
                  inkey(0)
                endif
  

           case nChoice == 4           //  Customer Activity


              select invoices
                go top

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\activity\"
               o:template := "invoices.rfw"

               o:print("activity.rpt")


            case nChoice == 5       // Edit Customer Information

               select customer
               go top

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\customer\"
               o:template := "customer.rfw"

               if (nError := o:edit()) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" editing report, press any key..."
                  inkey(0)
               endif


            case nChoice == 6        // Edit Activity Report


              select invoices
                go top

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\activity\"
               o:template := "invoices.rfw"

               if (nError := o:edit()) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" editing report, press any key..."
                  inkey(0)
               endif

//
//        ***  Sales Personnel Reports....
//

            case nChoice == 7   // Sales Territory

               select salesman
                go top

                o := RepoNew()

                o:reports := cDrive+alltrim(cPath)+"\terr\"

                 if (nError := o:print("salester.rpt")) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
                  inkey(0)
                endif

            case nChoice == 8     // Sales Activity

              select invoices
                go top

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)

               o:reports := cDrive+alltrim(cPath)+"\salesact\"
               o:template := "invoices.rfw"
                         o:noBlanks := .t.

                 if (nError := o:print("salesact.rpt")) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
                  inkey(0)
                endif

        case nChoice == 9  // Edit Sales Personnel

             select salesman

              go top

              o := repoNew()

              o:template := "salesman.rfw"
              o:reports := cDrive+alltrim(cPath)+"\terr\"

               if (nError := o:edit()) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" editing report, press any key..."
                  inkey(0)
               endif


        case nChoice == 10 // Edit Sales Person Activity

              select invoices
                go top

               o := repoNew()            // Report object

               oScan := scanNew()        // Scan object
               oScan:block := {|| iif(invoices->number == items->number,.t.,.f.)  }
               oScan:WorkArea := select("items")

               o:AddScan(oScan)
               o:reports := cDrive+alltrim(cPath)+"\salesact\"
               o:template := "invoices.rfw"
               o:noBlanks := .t.

               if (nError := o:edit()) > 0    // Print report
                  tone(500)
                  ?"Error "+alltrim(str(nError))+" editing report, press any key..."
                  inkey(0)
               endif

        case nChoice == 11  // Mailing Labels

           select customer
           go top

           o := RepoNew()

           o:reports := cDrive+alltrim(cPath)+"\labels\"
           o:eject := .f.

            if (nError := o:print("labels.rpt")) > 0    // Print report
              tone(500)
              ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
               inkey(0)
            endif

        case nChoice == 12 // Form letter

           select customer

           go top

           o := RepoNew()

           o:reports := cDrive+alltrim(cPath)+"\letter\"

            if (nError := o:print("letter.rpt")) > 0    // Print report
              tone(500)
              ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
               inkey(0)
            endif

      case nChoice == 13  // Mailing Labels Edit

           select Customer
           go top

           o := RepoNew()

           o:reports := cDrive+alltrim(cPath)+"\labels\"
           o:eject := .f.
           o:template := "customer.rfw"
           o:title := 0
           o:heading := 0
           o:detail := 10
           o:summary := 0


            if (nError := o:edit()) > 0    // Print report
              tone(500)
              ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
               inkey(0)
            endif

      case nChoice == 14  // Form Letter Edit

           select Customer
           go top

           o := RepoNew()

           o:reports := cDrive+alltrim(cPath)+"\letter\"
           o:template := "customer.rfw"
           o:title := 0
           o:heading := 0
           o:detail := 80
           o:summary := 0

            if (nError := o:edit()) > 0    // Print report
              tone(500)
              ?"Error "+alltrim(str(nError))+" Printing report, press any key..."
               inkey(0)
            endif


        otherwise
           exit
        endcase

    end

   clear screen
   setCursor(nSaveCurs)

Quit

