/* 
 * by Doug Van Horn
 * 12 August 1987
 * read_dbf [-d] [file: from environment] [?] searchstring fieldname
 */

#include   <stdio.h>
#include   <stdlib.h>
#include   <math.h>
#include   <string.h>
#include   <ctype.h>

#define      TWO_8        256.0
#define      TWO_5        32.0
#define      MAXFIELDS    128
#define      MAXRECORDS   100
#define      MAXCHAR      11
#define      MAXLINE      31
#define      MAXFORMAT    16

char   *progname;
char   *database;
char   *srchstrg;
char   *field;
char   *path = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

int      debflag = 0;
int      helpflag = 0;
int      length = 0;

char   *def_fields[MAXFORMAT];

struct {
   int numrec;
   int hdlen;
   int reclen;
   int fldnum;
   char fieldname[MAXFIELDS][MAXCHAR];
   char fieldtype[MAXFIELDS][MAXCHAR];
   int  fieldlength[MAXFIELDS];
} skeleton;

struct {
   char scree_form[MAXLINE];
   char print_form[MAXLINE];
   char characters[MAXLINE];
   char field_info[MAXRECORDS][MAXLINE];
} record[MAXFORMAT];

char buffer[1024];

char *ptr = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
char *def = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";

main(argc, argv)
int argc;
char **argv;
{
   int i;

   int how_many = 0;

   FILE   *fp, *fdefp, *fopen();
   char   *trim();

   progname = *argv++;

   if (argc == 1) {
      majorhelp();
      exit(0);
   }

   if (strcmp(*argv, "-d") == 0) {  /* debug mode */
      debflag = 1;
      *argv++;
      argc--;
   }

   for (i=0; i < strlen(*argv); i++) argv[0][i] = toupper(argv[0][i]);

   if (getenv("HOME") != NULL) {
      def = strcat(getenv("HOME"), "\\");
      (void)strcat(def, *argv);
      (void)strcat(def, ".DEF");
   } else { 
      fprintf(stderr, "Definition file not pointed to by HOME\n");
      exit(1);
   }

   if (getenv(*argv) != NULL) path = getenv(*argv++);

   if (strcmp(*argv, "?") == 0) {
      *argv++;
      argc--;
      helpflag = 1;
   } else {
      if (argc != 4) {
         fprintf(stderr, "Check argument number\n");
         exit(1);
      }
      srchstrg = *argv++;
      for (i=0; i < strlen(*argv); i++)
         argv[0][i] = toupper(argv[0][i]);
      field = *argv++;
   }

   if ((fp = fopen(path, "rb")) == NULL) {
      fprintf(stderr, "Database file = %s, does not exist\n", path);
      exit(1);
   }

   load_integers(fp);

   skeleton.fldnum = load_fields(fp);

   if (helpflag) {
     for(i=0; i<skeleton.fldnum; i++) {
        fprintf(stderr, "%s\n",skeleton.fieldname[i]);
     }
     exit(0);
   }

   if ((fdefp = fopen(def, "rb")) == NULL) {
      fprintf(stderr, "Definition file = %s, does not exist\n", def);
      exit(1);
   }

   read_defs(fdefp);

   how_many = find_matches(fp);

   format_screen(how_many);

   (void)fclose(fp);
}

pattern(s, t) /* Pattern matching function */
char s[], t[];
{
   register int i,j,k;

   for (i=0; s[i] != '\0'; i++) {
      for (j=i, k=0; t[k] != '\0' && s[j] == t[k]; j++, k++)
         ;
      if (t[k] == '\0') return(i);
   }
   return(-1);
}

majorhelp()
{
   fprintf(stderr, "Usage:  read_dbf [c] [d] [e] [?] searchstring fieldname\n");
   fprintf(stderr, "                                                       \n");
   fprintf(stderr, "        read_dbf c ? = gives the field names in the    \n");
   fprintf(stderr, "                       clinical database.              \n");
   fprintf(stderr, "        read_dbf d ? = gives the field names in the    \n");
   fprintf(stderr, "                       dairy database.                 \n");
   fprintf(stderr, "        read_dbf e ? = gives the field names in the    \n");
   fprintf(stderr, "                       environmental database.         \n");
   fprintf(stderr, "                                                       \n");
   fprintf(stderr, "        read_dbf c 0001 labnum = gives the laboratory  \n");
   fprintf(stderr, "                       with a lab number of 0001 in the\n");
   fprintf(stderr, "                       clinical database.              \n");
}

format_screen(how_many)
int how_many;
{
   int i,j;
   int count;
   int choice;

   if (how_many == 0) {
      fprintf(stderr, "\n\nNone found!  Sorry.\n\n");
      return;
   }

   if (how_many >= 1) {
      i = 0;
      do {
         count = 0;
         fprintf(stderr, "[2J");
         fprintf(stderr, "\t\t\tREAD_DBF.EXE v. 1.00 by Doug Van Horn");
         j=0;
         do {
            fprintf(stderr, "%s", record[j].scree_form);
            fprintf(stderr, "%s", record[j].characters);
            fprintf(stderr, "%s", trim(record[j].field_info[i]));
            j++;
         } while (record[j-1].field_info[i][0] != NULL);
         fprintf(stderr, "[22;8f%d/%d", (i)+1, how_many);
         fprintf(stderr, "[22;20fF -- To page forward, B -- To page backward,");
         fprintf(stderr, "[23;20fP -- To print this address, and Q -- To quit  ");
         while (choice = getchar()) {
            if (choice == '\n') continue;
            if (isdigit(choice) > 0) {
               if ((choice > 47) && (choice < 58)) {
                  count = 10 * count + choice - 48;
               }
               continue;
            }
            break;
         }
         if ((choice == 'f') || (choice == 'F')) {
            if (i+count >= (how_many-1)) {
               i = (how_many-1);
            } else {
               if (count == 0) count = 1;
               i = i+count;
            }
         }
         if ((choice == 'b') || (choice == 'B')) {
            if (i-count <= 0) {
               i = 0;
            } else {
               if (count == 0) count = 1;
               i = i-count;
            }
         }
         if ((choice == 'p') || (choice == 'P')) {
            format_printer(i);
            return;
         }
      } while ((choice != 'q') && (choice != 'Q'));
   }
}

char *
trim(string)
char *string;
{
   int c;
   int i;

   i=0;
   while (c != '\0') {
      c = string[i++];
   }
   while (i>=0) {
      if (isgraph(string[i-1]) == 0) {
         string[--i] = NULL;
         continue;
      }
      break;
   }
   return(string);
}

format_printer(selection)
int selection;
{
   int i=0;

   do {
      fprintf(stdprn, "%s", record[i].print_form);
      fprintf(stdprn, "%s", record[i].characters);
      fprintf(stdprn, "%s", trim(record[i].field_info[selection]));
      i++;
   } while (record[i-1].field_info[selection][0] != NULL);
}

load_integers(fp)
FILE *fp;
{
   int c, i;

   double num = 0;
   double hd = 0;
   double rec = 0;

   for (i=0; i<TWO_5; i++) {
      c = getc(fp);
      if (i>3 && i<8) {
         skeleton.numrec=skeleton.numrec+(pow(TWO_8,num)*c);
         num++;
      }
      if (i>7 && i<10) {
         skeleton.hdlen=skeleton.hdlen+(pow(TWO_8,hd)*c);
         hd++;
      }
      if (i>9 && i<12) {
         skeleton.reclen=skeleton.reclen+(pow(TWO_8,rec)*c);
         rec++;
      }
   }
}

load_fields(fp)
FILE *fp;
{
   int c;
   int i = 32;
   int j = 0;
   int k = 0;
   int l = 0;

   while (i<skeleton.hdlen) {
      c = getc(fp);
      if (j >= 32) {
         j = 0;
         k = 0;
         l++;
      }
      if (j<11) skeleton.fieldname[l][k++] = c;
      if (j==11) skeleton.fieldtype[l][0] = c;
      if (j==16) skeleton.fieldlength[l] = c;
      i++;
      j++;
   }
   return(l);
}

load_record(fp)
FILE *fp;
{
   register int c;
   register int i = 0;

   while (i < skeleton.reclen) {
      c = getc(fp);
      buffer[i++] = c;
   }
   buffer[i] = NULL;
}

find_matches(fp)
FILE *fp;
{
   int i, j;
   int offset;
   int match;
   int k = 0;

   offset = find_offset(field);

   for (i=0; i<skeleton.numrec; i++) {
      load_record(fp);
      for (j=0; j<length; j++) {
         ptr[j] = buffer[offset+j];
      }
      ptr[j] = NULL;
      match = pattern(ptr, srchstrg);
      if (match != -1) {
         fields_to_text(k);
         k++;
         if (k > MAXRECORDS) {
            fprintf(stderr, "\n\nToo many!  ");
            fprintf(stderr, "Narrow your search and try again.\n\n");
            exit(1);
         }    
         length = 30;
      }
   }
   return(k);
}

find_offset(matchstr)
char *matchstr;
{
   int i;
   int j = -1;
   int offset = 1;

   for (i=0; i<skeleton.fldnum; i++) {
      j = pattern(skeleton.fieldname[i], matchstr);
      if (j != -1) {
         length = skeleton.fieldlength[i];
         break;
      }
      offset = offset + skeleton.fieldlength[i];
   }
   return(offset);
}

fields_to_text(howmany)
int howmany;
{
   int offset;
   int i, j;

   for (i=0; def_fields[i] != NULL; i++) {
      offset = find_offset(def_fields[i]);
      for (j=0; j<length; j++) {
         record[i].field_info[howmany][j] = buffer[offset+j];
      }
      (void)strcat(record[i].field_info[howmany], '\0');
   }
}

read_defs(fdefp)
FILE *fdefp;
{
   int c, i;
   int j = 0;
   int k = 0;
   int part = 0;
   int match;
   char temp[4][MAXLINE];

   while ((c = getc(fdefp)) != EOF) { 
      if (c == 13) continue;
      if (c == 126) {
         temp[part][k] = NULL;
         part++;
         k = 0;
         continue;
      }
      if (c != 10) {
         temp[part][k++] = c;
      } else {
         temp[part][k] = NULL;
         (void)strcat(record[j].scree_form, temp[0]);
         (void)strcat(record[j].print_form, temp[1]);
         (void)strcat(record[j].characters, temp[2]);
         for (i=0; i<skeleton.fldnum; i++) {
            match = strcmp(temp[3], skeleton.fieldname[i]);
            if (match == 0) def_fields[j++] = skeleton.fieldname[i];
         }
         for (part = 0; part < 4; part++) temp[part][0] = NULL;
         k = 0;
         part = 0;
      }
   }
}
