/*
readndx.c:  spits out some info about dBase III Plus NDX files
Andrew Schulman 1/4/88, revised 1/14/88
12 Humboldt St., Cambridge MA 02140

compiled with MSC 5.0:
		cl -Zpe -Ox -Gs readndx.c \msc5\lib\ssetargv.obj
ssetargv.obj takes care of wildcard expansion

based on information supplied by Pete Olympia.  Thanks, Pete!
and by information from Curtis H. Hoffman (".DBF and .NDX Header Definitions")
*/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>

#define MAXKEYLEN	100

typedef unsigned char BYTE;
typedef unsigned long DWORD;

typedef struct
{
	DWORD rootnode;
	DWORD nextnode;
	DWORD pad1;
	BYTE keylen, pad2;
	BYTE keypernode, pad3;
	BYTE numeric, pad4;
	BYTE sizekeyentry;
	char pad5[5];
	char expression[MAXKEYLEN];
	char pad6[512-124];
	BYTE numentries;
	char pad7[3];
} NDX_HEAD;

NDX_HEAD ndx;

main(argc, argv)
	int argc;
	char *argv[];
{
	register int i;

	if (argc<2)	{
		printf("READNDX reads dBase III Plus NDX files. Big deal!\n");
		printf("examples:\n\tREADNDX inv1987.*\n\tREADNDX *.*\n\tREADNDX *.NDX\n");
		exit(1);
		}
	
	for (i=1; i<argc; i++)	{
		readndx(argv[i]);
		printf("\n");
		}
	
	exit(0);
}

readndx(s)
	char *s;
{
	char file[80];
	unsigned int f, count;
	
	strcpy(file,strupr(s));
	if (! strchr(file, '.')) strcat(file, ".NDX");
	
	if (_dos_open(file, O_RDONLY | O_BINARY, &f) != 0)	{
		printf("READNDX cannot open file (%s)\n", file);
		return;
		}

	if (_dos_read(f, (void far *)&ndx, sizeof(NDX_HEAD), &count) != 0)	{
		printf("Can't read from file (%s)\n", file);
		return;
		}

/***
	THIS IS THE BIG TEST TO DETERMINE IF IT'S A DBASE NDX FILE (THE NDX
    EXTENSION DOESN'T MEAN IT IS; AND THE LACK OF ONE DOESN'T MEAN IT ISN'T)
***/		 
	if (! ndx.sizekeyentry || ndx.keypernode != (508 / ndx.sizekeyentry))	{
		printf("Not a dBase III Plus index file (%s)\n", file);
		return;
		}
		
	printf("dBase III Plus index file %s\n", file);
	printf("key expression: \"%s\"\n", ndx.expression);
	printf("rootnode: %lu\n", ndx.rootnode);
	printf("nextnode: %lu\n", ndx.nextnode);
	printf("keylen: %d\n", ndx.keylen);
	printf("keypernode: %d\n", ndx.keypernode);
	printf("numeric flag: %d\n", ndx.numeric);
	printf("sizekeyentry: %d\n", ndx.sizekeyentry);
	printf("root node num entries: %d\n", ndx.numentries);
	
	_dos_close(f);
}	
