FUNCTION READLINE
**************************************************************************
*  READS A LINE OF AN ASCII TEXT FILE AT A TIME
*  RETURNS "" WHEN REACHS END OF TEXT FILE
*  USAGE  CHARSTR=READLINE(FHANDLE,100)
*  WHERE FHANDLE IS THE FILE HANDLE AFTER OPENING WITH FOPEN OR FCREATE
*  AND 100 IS THE MAXIMUM LINE WIDTH
***************************************************************************
PARA FHANDLE, LEN_TO_READ
PRIVATE M_BUFFER, NUMBYTE, M_LOC, M_TEMP
DO WHILE .T.
        IF LEN_TO_READ=0
                LEN_TO_READ=90
        ENDIF
        M_BUFFER=SPACE(LEN_TO_READ)
        NUMBYTE=FREAD(FHANDLE,@M_BUFFER,LEN_TO_READ)
        IF NUMBYTE=0
                M_TEMP=""
        ELSE
                M_LOC=AT(CHR(10),M_BUFFER)
                IF M_LOC # 0
                        M_TEMP=SUBSTR(M_BUFFER,1,M_LOC)
                        M_SEEK=NUMBYTE-M_LOC
                        FSEEK(FHANDLE,-M_SEEK,1)
                ELSE
                        IF LEN_TO_READ < 256     && recover from incorrect width setting
                                LEN_TO_READ=256
                                LOOP
                        ENDIF
                        @0,0 SAY "No end of line as far out as 256 characters. Probably not a text file.        "
                        TONE(2500,2)
                        M_TEMP=""
                ENDIF
        ENDIF
        RETURN M_TEMP
ENDDO

