* PROGRAM --:RDRIVER1.PRG
* 
* This program is called by RDRIVER.PRG to select and execute a report
* script.  It is without a doubt the largest single PRG file I have ever
* created.  Be sure you fully understand it's operation before making any
* changes.


* main program loop
DO WHILE .T.
  * switch to load the report editor later
  ZZ_EditSpec = "N"

  * get operators choice
  CLEAR
  @ 01,00 SAY "ͻ"
  @ 02,00 SAY " SBS DATABASE REPORT DRIVER                                  GENERATE REPORTS "
  @ 03,00 SAY "ͼ"
  @ 12,23 SAY "Enter Report Script" GET ZZ_Spec PICTURE '@!@K'
  @ 23,00 SAY "Please enter the report to run or press Esc to exit."
  @ 24,00 SAY "Enter a space to list report scripts on disk."
  READ
  IF LASTKEY() = 27 
    RETURN
  ENDIF
  IF ZZ_Spec = SPACE(8) 
    * list any report scripts if operator clears the report filename
    ZZ_Junk = RPTLIST()
    LOOP
  ENDIF
  * add the RPT extension and check for file existence
  ZZ_Name = LTRIM(TRIM(ZZ_Spec)) + ".RPT"
  IF .NOT. FILE("&ZZ_Name")
    ZZ_wait = "Y"
    @ 23,00 CLEAR
    @ 24,00 SAY "Report Specification does not exist. Create it? (Y/N)" GET ZZ_wait PICTURE '@!'
    READ
    IF LASTKEY() = 27 
      LOOP
    ENDIF
    * create a new report script from an existing one
    IF ZZ_wait = "Y"
      ZZ_EditSpec = "Y"
      ZZ_Source = SPACE(8)
      @ 14,23 SAY "Report To Copy From" GET ZZ_Source PICTURE '@!'
      @ 23,00 CLEAR
      @ 24,00 SAY "Enter the name of the report to copy from or leave blank."
      READ
      IF LASTKEY() = 27 
        LOOP
      ENDIF
      * get the report description
      ZZ_ReptDesc = SPACE(60)
      @ 16,03 SAY "Description" GET ZZ_ReptDesc PICTURE '@!'
      @ 23,00 CLEAR
      @ 24,00 SAY "Enter the new report description or leave blank."
      READ
      IF LASTKEY() = 27 
        LOOP
      ENDIF
      ZZ_SoName = LTRIM(TRIM(ZZ_Source)) + ".RPT"
      * create the new report script
      IF .NOT. FILE("&ZZ_SoName")
        SET CONSOLE OFF
        SET ALTERNATE TO &ZZ_Name
        SET ALTERNATE ON
        ?
        CLOSE ALTERNATE
      ELSE
        @ 23,00 CLEAR
        @ 24,00 SAY "Copying Report Specification..."
        @ 23,00 SAY ""
        SET CONSOLE OFF
        RUN COPY &ZZ_SoName &ZZ_Name > Nul:
      ENDIF
      ZZ_Desc = LTRIM(TRIM(ZZ_Spec)) + ".RPN"
      SET ALTERNATE TO &ZZ_Desc
      SET ALTERNATE ON
      ?? ZZ_ReptDesc
      CLOSE ALTERNATE
      SET CONSOLE ON
    ELSE
      LOOP
    ENDIF
  ENDIF
  * see if operator wishes to edit the script
  IF ZZ_EditSpec <> "Y"
    @ 23,00 CLEAR
    @ 24,00 SAY "Do you wish to edit this specification before reporting? (Y/N)" GET ZZ_EditSpec PICTURE '@!'
    READ
    IF LASTKEY() = 27 
      LOOP
    ENDIF
  ENDIF
  IF ZZ_EditSpec = "Y"
    @ 23,00 CLEAR
    @ 24,00 SAY "Loading Report Editor..."
    @ 23,00 SAY ""
    SET CONSOLE OFF
    RUN Reditor &ZZ_Name
    SET CONSOLE ON
    LOOP
  ENDIF

  * execute the report script
  * it gets complex from here!
  @ 23,00 CLEAR
  @ 24,00 SAY "Reading Report Specification..."
  CLOSE DATABASES
  SELECT A
  * create a temp database if it does not exist for field information
  IF .NOT. FILE("Data.$$$")
    CREATE Tdata.$$$
    APPEND BLANK
    REPLACE Field_Name WITH "ZZ_DATA"
    REPLACE Field_Type WITH "C"
    REPLACE Field_Len WITH 254
    REPLACE Field_Dec WITH 0
    UNLOCK
    USE
    CREATE Data.$$$ FROM Tdata.$$$
    DELETE FILE Tdata.$$$
  ENDIF
  SET DELETED ON
  * open it in area A and clear it
  USE Data.$$$
  ZAP
  * read in the report script
  APPEND FROM &ZZ_Name SDF
  * get rid of any non-command lines
  DELETE FOR ZZ_Data <> "."
  * initialize all needed memory variables
  * environment settings
  ZZ_Parse = .T.
  ZZ_MakeProg = ""
  ZZ_Type = ""
  ZZ_OPageLen = 55
  ZZ_Pagelen = 55
  ZZ_Eject = .T.
  ZZ_SupCRLF = .F.
  ZZ_SNewPage = .F.
  ZZ_Dest = "SCREEN"
  * data file names
  ZZ_File1 = ""
  ZZ_File2 = ""
  ZZ_File3 = ""
  ZZ_File4 = ""
  * index file names
  ZZ_Indx1 = ""
  ZZ_Indx2 = ""
  ZZ_Indx3 = ""
  ZZ_Indx4 = ""
  * index expressions, fields, and relations
  ZZ_IndxF1A = ""
  ZZ_IndxF1B = ""
  ZZ_IndxF1C = ""
  ZZ_IndxF2A = ""
  ZZ_IndxF2B = ""
  ZZ_IndxF2C = ""
  ZZ_IndxF3A = ""
  ZZ_IndxF3B = ""
  ZZ_IndxF3C = ""
  ZZ_IndxF4A = ""
  ZZ_IndxF4B = ""
  ZZ_IndxF4C = ""
  ZZ_RelaF2A = ""
  ZZ_RelaF2B = ""
  ZZ_RelaF2C = ""
  ZZ_RelaF3A = ""
  ZZ_RelaF3B = ""
  ZZ_RelaF3C = ""
  ZZ_RelaF4A = ""
  ZZ_RelaF4B = ""
  ZZ_RelaF4C = ""
  * build index switches
  ZZ_Bindx1 = .F.
  ZZ_Bindx2 = .F.
  ZZ_Bindx3 = .F.
  ZZ_Bindx4 = .F.
  * search parameters for the A file
  ZZ_DoSearch = .T.
  ZZ_STit1 = ""
  ZZ_STit2 = ""
  ZZ_STit3 = ""
  ZZ_Cond = ""
  * subtotalling parameters
  ZZ_Stot1B = ""
  ZZ_Stot1F = ""
  ZZ_SubTot1 = 0.0
  ZZ_Stot2F = ""  
  ZZ_SubTot2 = 0.0
  ZZ_Stot3F = ""
  ZZ_SubTot3 = 0.0
  ZZ_Stot4F = ""
  ZZ_SubTot4 = 0.0
  ZZ_Stot5F = ""
  ZZ_SubTot5 = 0.0
  * report totalling parameters
  ZZ_Rtot1F = ""
  ZZ_RepTot1 = 0.0
  ZZ_Rtot2F = ""  
  ZZ_RepTot2 = 0.0
  ZZ_Rtot3F = ""
  ZZ_RepTot3 = 0.0
  ZZ_Rtot4F = ""
  ZZ_RepTot4 = 0.0
  ZZ_Rtot5F = ""
  ZZ_RepTot5 = 0.0
  * header counters
  ZZ_Hcntr = 0
  ZZ_Hmax = 0
  * body counters
  ZZ_Bcntr = 0
  ZZ_Bmax = 0
  * subtotalling counters
  ZZ_Scntr = 0
  ZZ_Smax = 0
  * report totalling counters
  ZZ_Rcntr = 0
  ZZ_Rmax = 0
  * page footer counters
  ZZ_Fcntr = 0
  ZZ_Fmax = 0

  * go through the file and accumulate the report specs
  * this is the biggest darn case structure I have ever used, but proved to be
  * the quickest way to process the report spec
  GO TOP
  DO WHILE .NOT. EOF()
    ZZ_TestData = UPPER(ZZ_Data)
    DO CASE
    CASE ZZ_TestData = ".PARSE OFF"
      ZZ_Parse = .F.
    CASE ZZ_TestData = ".TYPE"
      ZZ_Type = UPPER(LTRIM(TRIM(SUBSTR(ZZ_Data,6,255))))
    CASE ZZ_TestData = ".PAGE"
      ZZ_OPageLen = VAL(LTRIM(TRIM(SUBSTR(ZZ_Data,6,255))))
    CASE ZZ_TestData = ".EJECT OFF"
      ZZ_Eject = .F.
    CASE ZZ_TestData = ".LINEFEEDS OFF"
      ZZ_SupCRLF = .T.
    CASE ZZ_TestData = ".DESTINATION"
      ZZ_Dest = UPPER(LTRIM(TRIM(SUBSTR(ZZ_Data,13,255))))
    CASE ZZ_TestData = ".CREATE PROGRAM"
      ZZ_MakeProg = UPPER(LTRIM(TRIM(SUBSTR(ZZ_Data,16,255))))
      IF AT(".",ZZ_MakeProg) = 0
        ZZ_MakeProg = ZZ_MakeProg + ".PRG"
      ENDIF
    CASE ZZ_TestData = ".A DATA FILE"
      ZZ_File1 = LTRIM(TRIM(SUBSTR(ZZ_Data,13,255)))
      IF AT(".",ZZ_File1) = 0
        ZZ_File1 = ZZ_File1 + ".DBF"
      ENDIF
    CASE ZZ_TestData = ".B DATA FILE"
      ZZ_File2 = LTRIM(TRIM(SUBSTR(ZZ_Data,13,255)))
      IF AT(".",ZZ_File2) = 0
        ZZ_File2 = ZZ_File2 + ".DBF"
      ENDIF
    CASE ZZ_TestData = ".C DATA FILE"
      ZZ_File3 = LTRIM(TRIM(SUBSTR(ZZ_Data,13,255)))
      IF AT(".",ZZ_File3) = 0
        ZZ_File3 = ZZ_File3 + ".DBF"
      ENDIF
    CASE ZZ_TestData = ".D DATA FILE"
      ZZ_File4 = LTRIM(TRIM(SUBSTR(ZZ_Data,13,255)))
      IF AT(".",ZZ_File4) = 0
        ZZ_File4 = ZZ_File4 + ".DBF"
      ENDIF
    CASE ZZ_TestData = ".A INDEX FILE"
      ZZ_Indx1 = LTRIM(TRIM(SUBSTR(ZZ_Data,14,255)))
      IF AT(".",ZZ_Indx1) = 0
        ZZ_Indx1 = ZZ_Indx1 + ".NTX"
      ENDIF
    CASE ZZ_TestData = ".B INDEX FILE"
      ZZ_Indx2 = LTRIM(TRIM(SUBSTR(ZZ_Data,14,255)))
      IF AT(".",ZZ_Indx2) = 0
        ZZ_Indx2 = ZZ_Indx2 + ".NTX"
      ENDIF
    CASE ZZ_TestData = ".C INDEX FILE"
      ZZ_Indx3 = LTRIM(TRIM(SUBSTR(ZZ_Data,14,255)))
      IF AT(".",ZZ_Indx3) = 0
        ZZ_Indx3 = ZZ_Indx3 + ".NTX"
      ENDIF
    CASE ZZ_TestData = ".D INDEX FILE"
      ZZ_Indx4 = LTRIM(TRIM(SUBSTR(ZZ_Data,14,255)))
      IF AT(".",ZZ_Indx4) = 0
        ZZ_Indx4 = ZZ_Indx4 + ".NTX"
      ENDIF
    CASE ZZ_TestData = ".A INDEX FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,15,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF1A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF1A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF1B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF1B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF1C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF1C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".B INDEX FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,15,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF2A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF2A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF2B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF2B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF2C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF2C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".B RELATED FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF2A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF2A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF2B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF2B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF2C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF2C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".C INDEX FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,15,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF3A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF3A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF3B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF3B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF3C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF3C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".C RELATED FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF3A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF3A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF3B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF3B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF3C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF3C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".D INDEX FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,15,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF4A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF4A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF4B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF4B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_IndxF4C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_IndxF4C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".D RELATED FIELD"
      ZZ_Tdata = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
      DO WHILE .T.
        * extract the field names
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF4A = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF4A = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF4B = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF4B = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        IF AT(",",ZZ_Tdata) = 0
          ZZ_RelaF4C = ZZ_Tdata
          EXIT
        ELSE
          ZZ_RelaF4C = SUBSTR(ZZ_Tdata,1,AT(",",ZZ_Tdata) -1)
          ZZ_Tdata = SUBSTR(ZZ_Tdata,AT(",",ZZ_Tdata)+1,LEN(ZZ_Tdata) - AT(",",ZZ_Tdata))
        ENDIF
        EXIT
      ENDDO
    CASE ZZ_TestData = ".A BUILD INDEX"
      ZZ_Bindx1 = .T.
    CASE ZZ_TestData = ".B BUILD INDEX"
      ZZ_Bindx2 = .T.
    CASE ZZ_TestData = ".C BUILD INDEX"
      ZZ_Bindx3 = .T.
    CASE ZZ_TestData = ".D BUILD INDEX"
      ZZ_Bindx4 = .T.
    CASE ZZ_TestData = ".A SEARCH TITLE1"
      ZZ_STit1 = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
    CASE ZZ_TestData = ".A SEARCH TITLE2"
      ZZ_STit2 = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
    CASE ZZ_TestData = ".A SEARCH TITLE3"
      ZZ_STit3 = LTRIM(TRIM(SUBSTR(ZZ_Data,17,255)))
    CASE ZZ_TestData = ".CONDITION"
      ZZ_Cond = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SEARCH OFF"
      ZZ_DoSearch = .F.
    CASE ZZ_TestData = ".SUBTOTAL BREAK"
      ZZ_Stot1B = LTRIM(TRIM(SUBSTR(ZZ_Data,16,255)))
    CASE ZZ_TestData = ".SUBTOTAL1"
      ZZ_Stot1F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SUBTOTAL2"
      ZZ_Stot2F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SUBTOTAL3"
      ZZ_Stot3F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SUBTOTAL4"
      ZZ_Stot4F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SUBTOTAL5"
      ZZ_Stot5F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".SUBTOTAL NEWPAGE"
      ZZ_SNewPage = .T.
    CASE ZZ_TestData = ".REPTOTAL1"
      ZZ_Rtot1F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".REPTOTAL2"
      ZZ_Rtot2F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".REPTOTAL3"
      ZZ_Rtot3F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".REPTOTAL4"
      ZZ_Rtot4F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".REPTOTAL5"
      ZZ_Rtot5F = LTRIM(TRIM(SUBSTR(ZZ_Data,11,255)))
    CASE ZZ_TestData = ".HEAD"
      ZZ_Vname = "ZZ_Head" + LTRIM(STR(ZZ_Hcntr,3,0))
      &ZZ_Vname = TRIM(SUBSTR(ZZ_Data,7,255))
      ZZ_Hcntr = ZZ_Hcntr + 1
    CASE ZZ_TestData = ".BODY"
      ZZ_Vname = "ZZ_Body" + LTRIM(STR(ZZ_Bcntr,3,0))
      &ZZ_Vname = TRIM(SUBSTR(ZZ_Data,7,255))
      ZZ_Bcntr = ZZ_Bcntr + 1
    CASE ZZ_TestData = ".STOT"
      ZZ_Vname = "ZZ_Subt" + LTRIM(STR(ZZ_Scntr,3,0))
      &ZZ_Vname = TRIM(SUBSTR(ZZ_Data,7,255))
      ZZ_Scntr = ZZ_Scntr + 1
    CASE ZZ_TestData = ".RTOT"
      ZZ_Vname = "ZZ_Rept" + LTRIM(STR(ZZ_Rcntr,3,0))
      &ZZ_Vname = TRIM(SUBSTR(ZZ_Data,7,255))
      ZZ_Rcntr = ZZ_Rcntr + 1
    CASE ZZ_TestData = ".FOOT"
      ZZ_Vname = "ZZ_Foot" + LTRIM(STR(ZZ_Fcntr,3,0))
      &ZZ_Vname = TRIM(SUBSTR(ZZ_Data,7,255))
      ZZ_Fcntr = ZZ_Fcntr + 1
    ENDCASE
    SKIP
  ENDDO
  * store various other variables
  ZZ_PageLen = ZZ_OPagelen
  ZZ_Hmax = ZZ_Hcntr
  ZZ_Bmax = ZZ_Bcntr
  ZZ_Smax = ZZ_Scntr
  ZZ_Rmax = ZZ_Rcntr
  ZZ_Fmax = ZZ_Fcntr

  CLOSE DATABASES
  ZZ_Filesok = .T.
  * check to see if a database file was specified
  DO WHILE .T.
    IF LEN(ZZ_File1) = 0 .OR. LEN(ZZ_File1) + LEN(ZZ_File2) + LEN(ZZ_File3) + LEN(ZZ_File4) = 0
      @ 23,00 CLEAR
      @ 24,00 SAY "No database files were specified, press any key to continue..."
      ZZ_Filesok = .F.
      EXIT
    ENDIF
    * check all filenames
    IF LEN(ZZ_File1) <> 0
      IF .NOT. CHKFNAME(ZZ_File1)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for data file A, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF .NOT. FILE("&ZZ_File1")
        @ 23,00 CLEAR
        @ 24,00 SAY "Data file " + ZZ_File1 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_Indx1) <> 0
      IF .NOT. CHKFNAME(ZZ_Indx1)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for index file A, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF (.NOT. ZZ_Bindx1) .AND. (.NOT. FILE("&ZZ_Indx1"))
        @ 23,00 CLEAR
        @ 24,00 SAY "Index file " + ZZ_Indx1 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_File2) <> 0
      IF .NOT. CHKFNAME(ZZ_File2)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for data file B, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF .NOT. FILE("&ZZ_File2")
        @ 23,00 CLEAR
        @ 24,00 SAY "Data file " + ZZ_File2 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_Indx2) <> 0
      IF .NOT. CHKFNAME(ZZ_Indx2)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for index file B, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF (.NOT. ZZ_Bindx2) .AND. (.NOT. FILE("&ZZ_Indx2"))
        @ 23,00 CLEAR
        @ 24,00 SAY "Index file " + ZZ_Indx2 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_File3) <> 0
      IF .NOT. CHKFNAME(ZZ_File3)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for data file C, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF .NOT. FILE("&ZZ_File3")
        @ 23,00 CLEAR
        @ 24,00 SAY "Data file " + ZZ_File3 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_Indx3) <> 0
      IF .NOT. CHKFNAME(ZZ_Indx3)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for index file C, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF (.NOT. ZZ_Bindx3) .AND. (.NOT. FILE("&ZZ_Indx3"))
        @ 23,00 CLEAR
        @ 24,00 SAY "Index file " + ZZ_Indx3 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_File4) <> 0
      IF .NOT. CHKFNAME(ZZ_File4)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for data file D, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF .NOT. FILE("&ZZ_File4")
        @ 23,00 CLEAR
        @ 24,00 SAY "Data file " + ZZ_File4 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    IF LEN(ZZ_Indx4) <> 0
      IF .NOT. CHKFNAME(ZZ_Indx4)
        @ 23,00 CLEAR
        @ 24,00 SAY "Name entered incorrectly for index file D, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
      IF (.NOT. ZZ_Bindx4) .AND. (.NOT. FILE("&ZZ_Indx4"))
        @ 23,00 CLEAR
        @ 24,00 SAY "Index file " + ZZ_Indx4 + " was not found, press any key to continue..."
        ZZ_Filesok = .F.
        EXIT
      ENDIF
    ENDIF
    EXIT
  ENDDO
  IF .NOT. ZZ_Filesok
    SET CONSOLE OFF
    WAIT
    SET CONSOLE ON
    LOOP
  ENDIF
  * check field names in the first file and build indexing fields, search vars
  ZZ_IndxStr = ""
  ZZ_Skey1 = ""
  ZZ_Skey2 = ""
  ZZ_Skey3 = ""
  ZZ_Flength = 0
  SELECT A
  IF LEN(ZZ_File1) <> 0
    USE &ZZ_File1
    * build structure extended file to get field info
    COPY TO Tadata.$$$ STRUCTURE EXTENDED
    SELECT B
    USE TaData.$$$
    INDEX ON Field_Name TO Tadatan.$$$
    SET INDEX TO Tadatan.$$$
    ZZ_GoodFlds = .T.
    IF LEN(ZZ_Indx1) <> 0
      * create an index expression and assign search keys for the file
      ZZ_Cntr = 1
      DO WHILE ZZ_Cntr <= 3
        DO CASE
        CASE ZZ_Cntr = 1
          ZZ_ErrWrd = "First"
        CASE ZZ_Cntr = 2
          ZZ_ErrWrd = "Second"
        CASE ZZ_Cntr = 3
          ZZ_ErrWrd = "Third"
        ENDCASE
        ZZ_Vname = "ZZ_IndxF1" + CHR(ZZ_Cntr+64)
        ZZ_Kname = "ZZ_Skey" + STR(ZZ_Cntr,1,0)
        IF LEN(&ZZ_Vname) = 0
          EXIT
        ENDIF
        * determine type of index field 1
        SEEK UPPER(&ZZ_Vname)
        IF EOF()
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file a not found, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDIF
        * store the field name
        &ZZ_Kname = TRIM(Field_Name)
        DO CASE
        CASE Field_Type = "C"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "UPPER(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+UPPER(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "D"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "DTOC(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+DTOC(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "N"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "STR(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+STR(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "M"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file A is a memo field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        CASE Field_Type = "L"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file A is a logical field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDCASE
        ZZ_Cntr = ZZ_Cntr + 1
      ENDDO
      IF .NOT. ZZ_GoodFlds
        LOOP
      ENDIF
      USE
      SELECT A
      IF ZZ_Bindx1
        ZZ_Mspaces = 4 - ((ZZ_Flength/4 - INT(ZZ_Flength/4)) * 4)
        IF ZZ_Mspaces <> 0 .AND. ZZ_Mspaces <> 4
          ZZ_IndxStr = ZZ_IndxStr + " + SPACE(" + STR(ZZ_Mspaces,1,0) + ")"
        ENDIF
        @ 23,00 CLEAR
        @ 24,00 SAY "Building index for database file " + ZZ_File1
        INDEX ON &ZZ_IndxStr TO &ZZ_Indx1
      ENDIF
    ENDIF	
    IF LEN(ZZ_Indx1) <> 0
      SET INDEX TO &ZZ_Indx1
    ENDIF
  ENDIF

  * cancel searches if no field titles were given
  DO CASE
  CASE LEN(ZZ_Stit1) = 0
    ZZ_Skey1 = ""
    ZZ_Skey2 = ""
    ZZ_Skey3 = ""
    ZZ_DoSearch = .F.
  CASE LEN(ZZ_Stit2) = 0
    ZZ_Skey2 = ""
    ZZ_Skey3 = ""
  CASE LEN(ZZ_Stit3) = 0
    ZZ_Skey3 = ""
  ENDCASE

  * pull index expressions and build index for file B
  ZZ_IndxStr = ""
  ZZ_Bkey = ""
  ZZ_Flength = 0
  SELECT B
  IF LEN(ZZ_File2) <> 0
    USE &ZZ_File2
    * build structure extended file to get field info
    COPY TO Tbdata.$$$ STRUCTURE EXTENDED
    SELECT C
    USE TbData.$$$
    INDEX ON Field_Name TO Tbdatan.$$$
    SET INDEX TO Tbdatan.$$$
    ZZ_GoodFlds = .T.
    IF LEN(ZZ_Indx2) <> 0
      * create index expressions
      ZZ_Cntr = 1
      DO WHILE ZZ_Cntr <= 3
        DO CASE
        CASE ZZ_Cntr = 1
          ZZ_ErrWrd = "First"
        CASE ZZ_Cntr = 2
          ZZ_ErrWrd = "Second"
        CASE ZZ_Cntr = 3
          ZZ_ErrWrd = "Third"
        ENDCASE
        ZZ_Vname = "ZZ_IndxF2" + CHR(ZZ_Cntr+64)
        IF LEN(&ZZ_Vname) = 0
          EXIT
        ENDIF
        * determine type of index field 1
        SEEK UPPER(&ZZ_Vname)
        IF EOF()
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field is not in data file B, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDIF
        * build index string
        DO CASE
        CASE Field_Type = "C"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "UPPER(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+UPPER(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "D"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "DTOC(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+DTOC(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "N"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "STR(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+STR(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "M"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file B is a memo field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        CASE Field_Type = "L"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file B is a logical field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDCASE
        ZZ_Cntr = ZZ_Cntr + 1
      ENDDO
      IF .NOT. ZZ_GoodFlds
        LOOP
      ENDIF
      USE
      SELECT B
      IF ZZ_Bindx2
        ZZ_Mspaces = 4 - ((ZZ_Flength/4 - INT(ZZ_Flength/4)) * 4)
        IF ZZ_Mspaces <> 0 .AND. ZZ_Mspaces <> 4
          ZZ_IndxStr = ZZ_IndxStr + " + SPACE(" + STR(ZZ_Mspaces,1,0) + ")"
        ENDIF
        @ 23,00 CLEAR
        @ 24,00 SAY "Building index for database file " + ZZ_File2
        INDEX ON &ZZ_IndxStr TO &ZZ_Indx2
      ENDIF
    ENDIF	
    IF LEN(ZZ_Indx2) <> 0
      SET INDEX TO &ZZ_Indx2
    ENDIF
    * create search expressions
    SELECT C
    USE TaData.$$$
    SET INDEX TO Tadatan.$$$
    ZZ_Cntr = 1
    ZZ_GoodFlds = .T.
    DO WHILE ZZ_Cntr <= 3
      DO CASE
      CASE ZZ_Cntr = 1
        ZZ_ErrWrd = "First related field in file B"
      CASE ZZ_Cntr = 2
        ZZ_ErrWrd = "Second related field in file B"
      CASE ZZ_Cntr = 3
        ZZ_ErrWrd = "Third related field in file B"
      ENDCASE
      ZZ_Vname = "ZZ_RelaF2" + CHR(ZZ_Cntr+64)
      IF LEN(&ZZ_Vname) = 0
        EXIT
      ENDIF
      * determine type of Related field 1
      SEEK UPPER(&ZZ_Vname)
      IF EOF()
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " was not found in file A, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDIF
      * build related string
      DO CASE
      CASE Field_Type = "C"
        IF ZZ_Cntr = 1
          ZZ_Bkey = ZZ_Bkey + "UPPER(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Bkey = ZZ_Bkey + "UPPER(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "D"
        IF ZZ_Cntr = 1
          ZZ_Bkey = ZZ_Bkey + "DTOC(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Bkey = ZZ_Bkey + "+DTOC(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "N"
        IF ZZ_Cntr = 1
          ZZ_Bkey = ZZ_Bkey + "STR(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Bkey = ZZ_Bkey + "+STR(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "M"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a memo field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      CASE Field_Type = "L"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a logical field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDCASE
      ZZ_Cntr = ZZ_Cntr + 1
    ENDDO
    IF .NOT. ZZ_GoodFlds
      LOOP
    ENDIF
    USE
  ENDIF
  * pull index expressions and build index for file C
  ZZ_IndxStr = ""
  ZZ_Ckey = ""
  ZZ_Flength = 0
  SELECT C
  IF LEN(ZZ_File3) <> 0
    USE &ZZ_File3
    * build structure extended file to get field info
    COPY TO TCdata.$$$ STRUCTURE EXTENDED
    SELECT D
    USE TCData.$$$
    INDEX ON Field_Name TO TCdatan.$$$
    SET INDEX TO TCdatan.$$$
    ZZ_GoodFlds = .T.
    IF LEN(ZZ_Indx3) <> 0
      * create index expressions
      ZZ_Cntr = 1
      DO WHILE ZZ_Cntr <= 3
        DO CASE
        CASE ZZ_Cntr = 1
          ZZ_ErrWrd = "First"
        CASE ZZ_Cntr = 2
          ZZ_ErrWrd = "Second"
        CASE ZZ_Cntr = 3
          ZZ_ErrWrd = "Third"
        ENDCASE
        ZZ_Vname = "ZZ_IndxF3" + CHR(ZZ_Cntr+64)
        IF LEN(&ZZ_Vname) = 0
          EXIT
        ENDIF
        * determine type of index field 1
        SEEK UPPER(&ZZ_Vname)
        IF EOF()
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field is not in data file C, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDIF
        * build index string
        DO CASE
        CASE Field_Type = "C"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "UPPER(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+UPPER(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "D"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "DTOC(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+DTOC(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "N"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "STR(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+STR(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "M"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file C is a memo field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        CASE Field_Type = "L"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file C is a logical field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDCASE
        ZZ_Cntr = ZZ_Cntr + 1
      ENDDO
      IF .NOT. ZZ_GoodFlds
        LOOP
      ENDIF
      USE
      SELECT C
      IF ZZ_Bindx3
        ZZ_Mspaces = 4 - ((ZZ_Flength/4 - INT(ZZ_Flength/4)) * 4)
        IF ZZ_Mspaces <> 0 .AND. ZZ_Mspaces <> 4
          ZZ_IndxStr = ZZ_IndxStr + " + SPACE(" + STR(ZZ_Mspaces,1,0) + ")"
        ENDIF
        @ 23,00 CLEAR
        @ 24,00 SAY "Building index for database file " + ZZ_File3
        INDEX ON &ZZ_IndxStr TO &ZZ_Indx3
      ENDIF
    ENDIF	
    IF LEN(ZZ_Indx3) <> 0
      SET INDEX TO &ZZ_Indx3
    ENDIF
    * create search expressions
    SELECT D
    USE TaData.$$$
    SET INDEX TO Tadatan.$$$
    ZZ_Cntr = 1
    ZZ_GoodFlds = .T.
    DO WHILE ZZ_Cntr <= 3
      DO CASE
      CASE ZZ_Cntr = 1
        ZZ_ErrWrd = "First related field in file C"
      CASE ZZ_Cntr = 2
        ZZ_ErrWrd = "Second related field in file C"
      CASE ZZ_Cntr = 3
        ZZ_ErrWrd = "Third related field in file C"
      ENDCASE
      ZZ_Vname = "ZZ_RelaF3" + CHR(ZZ_Cntr+64)
      IF LEN(&ZZ_Vname) = 0
        EXIT
      ENDIF
      * determine type of Related field 1
      SEEK UPPER(&ZZ_Vname)
      IF EOF()
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " was not found in file A, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDIF
      * build related string
      DO CASE
      CASE Field_Type = "C"
        IF ZZ_Cntr = 1
          ZZ_Ckey = ZZ_Ckey + "UPPER(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Ckey = ZZ_Ckey + "UPPER(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "D"
        IF ZZ_Cntr = 1
          ZZ_Ckey = ZZ_Ckey + "DTOC(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Ckey = ZZ_Ckey + "+DTOC(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "N"
        IF ZZ_Cntr = 1
          ZZ_Ckey = ZZ_Ckey + "STR(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Ckey = ZZ_Ckey + "+STR(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "M"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a memo field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      CASE Field_Type = "L"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a logical field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDCASE
      ZZ_Cntr = ZZ_Cntr + 1
    ENDDO
    IF .NOT. ZZ_GoodFlds
      LOOP
    ENDIF
    USE
  ENDIF
  * pull index expressions and build index for file D
  ZZ_IndxStr = ""
  ZZ_Dkey = ""
  ZZ_Flength = 0
  SELECT D
  IF LEN(ZZ_File4) <> 0
    USE &ZZ_File4
    * build structure extended file to get field info
    COPY TO TDdata.$$$ STRUCTURE EXTENDED
    SELECT E
    USE TDData.$$$
    INDEX ON Field_Name TO TDdatan.$$$
    SET INDEX TO TDdatan.$$$
    ZZ_GoodFlds = .T.
    IF LEN(ZZ_Indx4) <> 0
      * create index expressions
      ZZ_Cntr = 1
      DO WHILE ZZ_Cntr <= 3
        DO CASE
        CASE ZZ_Cntr = 1
          ZZ_ErrWrd = "First"
        CASE ZZ_Cntr = 2
          ZZ_ErrWrd = "Second"
        CASE ZZ_Cntr = 3
          ZZ_ErrWrd = "Third"
        ENDCASE
        ZZ_Vname = "ZZ_IndxF4" + CHR(ZZ_Cntr+64)
        IF LEN(&ZZ_Vname) = 0
          EXIT
        ENDIF
        * determine type of index field 1
        SEEK UPPER(&ZZ_Vname)
        IF EOF()
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field is not in data file D, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDIF
        * build index string
        DO CASE
        CASE Field_Type = "C"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "UPPER(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+UPPER(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "D"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "DTOC(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+DTOC(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "N"
          IF ZZ_Cntr = 1
            ZZ_IndxStr = ZZ_IndxStr + "STR(" + &ZZ_Vname + ")"
          ELSE
            ZZ_IndxStr = ZZ_IndxStr + "+STR(" + &ZZ_Vname + ")"
          ENDIF
          ZZ_Flength = ZZ_Flength + Field_len
        CASE Field_Type = "M"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file D is a memo field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        CASE Field_Type = "L"
          @ 23,00 CLEAR
          @ 24,00 SAY ZZ_ErrWrd + " indexing field in data file D is a logical field, press any key..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          CLOSE DATABASES
          ZZ_GoodFlds = .F.
          EXIT
        ENDCASE
        ZZ_Cntr = ZZ_Cntr + 1
      ENDDO
      IF .NOT. ZZ_GoodFlds
        LOOP
      ENDIF
      USE
      SELECT D
      IF ZZ_Bindx4
        ZZ_Mspaces = 4 - ((ZZ_Flength/4 - INT(ZZ_Flength/4)) * 4)
        IF ZZ_Mspaces <> 0 .AND. ZZ_Mspaces <> 4
          ZZ_IndxStr = ZZ_IndxStr + " + SPACE(" + STR(ZZ_Mspaces,1,0) + ")"
        ENDIF
        @ 23,00 CLEAR
        @ 24,00 SAY "Building index for database file " + ZZ_File4
        INDEX ON &ZZ_IndxStr TO &ZZ_Indx4
      ENDIF
    ENDIF	
    IF LEN(ZZ_Indx4) <> 0
      SET INDEX TO &ZZ_Indx4
    ENDIF
    * create search expressions
    SELECT E
    USE TaData.$$$
    SET INDEX TO Tadatan.$$$
    ZZ_Cntr = 1
    ZZ_GoodFlds = .T.
    DO WHILE ZZ_Cntr <= 3
      DO CASE
      CASE ZZ_Cntr = 1
        ZZ_ErrWrd = "First related field in file D"
      CASE ZZ_Cntr = 2
        ZZ_ErrWrd = "Second related field in file D"
      CASE ZZ_Cntr = 3
        ZZ_ErrWrd = "Third related field in file D"
      ENDCASE
      ZZ_Vname = "ZZ_RelaF4" + CHR(ZZ_Cntr+64)
      IF LEN(&ZZ_Vname) = 0
        EXIT
      ENDIF
      * determine type of Related field 1
      SEEK UPPER(&ZZ_Vname)
      IF EOF()
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " was not found in file A, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDIF
      * build related string
      DO CASE
      CASE Field_Type = "C"
        IF ZZ_Cntr = 1
          ZZ_Dkey = ZZ_Dkey + "UPPER(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Dkey = ZZ_Dkey + "UPPER(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "D"
        IF ZZ_Cntr = 1
          ZZ_Dkey = ZZ_Dkey + "DTOC(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Dkey = ZZ_Dkey + "+DTOC(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "N"
        IF ZZ_Cntr = 1
          ZZ_Dkey = ZZ_Dkey + "STR(A->" + &ZZ_Vname + ")"
        ELSE
          ZZ_Dkey = ZZ_Dkey + "+STR(A->" + &ZZ_Vname + ")"
        ENDIF
      CASE Field_Type = "M"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a memo field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      CASE Field_Type = "L"
        @ 23,00 CLEAR
        @ 24,00 SAY ZZ_ErrWrd + " is a logical field, press any key..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        CLOSE DATABASES
        ZZ_GoodFlds = .F.
        EXIT
      ENDCASE
      ZZ_Cntr = ZZ_Cntr + 1
    ENDDO
    IF .NOT. ZZ_GoodFlds
      LOOP
    ENDIF
    USE
  ENDIF

  ZZ_Exit = .F.
  DO WHILE .T.
    * reset the subtotalling variables
    ZZ_SubTot1 = 0.0
    ZZ_SubTot2 = 0.0
    ZZ_SubTot3 = 0.0
    ZZ_SubTot4 = 0.0
    ZZ_SubTot5 = 0.0
    ZZ_RepTot1 = 0.0
    ZZ_RepTot2 = 0.0
    ZZ_RepTot3 = 0.0
    ZZ_RepTot4 = 0.0
    ZZ_RepTot5 = 0.0
    * go to the EOF() in area A and skip to pull blank field values
    * (pretty neat, huh?)
    SELECT A
    GO BOTTOM
    SKIP
    * assign key parameters
    ZZ_Key_Nbr = 0
    IF LEN(ZZ_SKey1) <> 0
      ZZ_StartK1 = &ZZ_SKey1
      ZZ_EndK1 = &ZZ_SKey1
      ZZ_StartO1 = &ZZ_SKey1
      ZZ_EndO1 = &ZZ_SKey1
      ZZ_Key_Nbr = ZZ_Key_Nbr + 1
    ENDIF
    IF LEN(ZZ_SKey2) <> 0
      ZZ_StartK2 = &ZZ_SKey2
      ZZ_EndK2 = &ZZ_SKey2
      ZZ_StartO2 = &ZZ_SKey2
      ZZ_EndO2 = &ZZ_SKey2
      ZZ_Key_Nbr = ZZ_Key_Nbr + 1
    ENDIF
    IF LEN(ZZ_SKey3) <> 0
      ZZ_StartK3 = &ZZ_SKey3
      ZZ_EndK3 = &ZZ_SKey3
      ZZ_StartO3 = &ZZ_SKey3
      ZZ_EndO3 = &ZZ_SKey3
      ZZ_Key_Nbr = ZZ_Key_Nbr + 1
    ENDIF
    GO TOP
    * now, decide where to put the from-to prompts
    IF ZZ_Key_Nbr <> 0
      * determine if any prompt + search key exceeds the screen width
      ZZ_mixed = .F.
      IF LEN(ZZ_SKey1) <> 0
        IF TYPE("ZZ_StartK1") = "C"
          IF LEN("Starting " + ZZ_STit1 + ZZ_StartK1) + 1 > 77
            ZZ_Mixed = .T.
          ENDIF
        ELSE
          IF LEN("Starting " + ZZ_STit1) + 10 > 77
            ZZ_Mixed = .T.
          ENDIF
        ENDIF
      ENDIF
      IF LEN(ZZ_SKey2) <> 0
        IF TYPE("ZZ_StartK2") = "C"
          IF LEN("Starting " + ZZ_STit2 + ZZ_StartK2) + 1 > 77
            ZZ_Mixed = .T.
          ENDIF
        ELSE
          IF LEN("Starting " + ZZ_STit2) + 10 > 77
            ZZ_Mixed = .T.
          ENDIF
        ENDIF
      ENDIF
      IF LEN(ZZ_SKey3) <> 0
        IF TYPE("ZZ_StartK3") = "C"
          IF LEN("Starting " + ZZ_STit3 + ZZ_StartK3) + 1 > 77
            ZZ_Mixed = .T.
          ENDIF
        ELSE
          IF LEN("Starting " + ZZ_STit3) + 10 > 77
            ZZ_Mixed = .T.
          ENDIF
        ENDIF
      ENDIF
      * determine start row and colums numbers for each prompt and search field
      IF ZZ_Mixed
        DO CASE
        CASE ZZ_Key_Nbr = 1
          ZZ_StartRow = 11
        CASE ZZ_Key_Nbr = 2
          ZZ_StartRow = 8
        OTHERWISE
          ZZ_StartRow = 5
        ENDCASE
        IF LEN(ZZ_SKey1) <> 0
          ZZ_1KeyP = 40 - (LEN("Starting " + ZZ_STit1) / 2)
          IF TYPE("ZZ_StartK1") = "C"
            ZZ_1KeyF = 40 - (LEN(ZZ_StartK1) / 2) 
          ELSE
            ZZ_1KeyF = 35
          ENDIF
        ENDIF
        IF LEN(ZZ_SKey2) <> 0
          ZZ_2KeyP = 40 - (LEN("Starting " + ZZ_STit2) / 2)
          IF TYPE("ZZ_StartK2") = "C"
            ZZ_2KeyF = 40 - (LEN(ZZ_StartK2) / 2) 
          ELSE
            ZZ_2KeyF = 35
          ENDIF
        ENDIF
        IF LEN(ZZ_SKey3) <> 0
          ZZ_3KeyP = 40 - (LEN("Starting " + ZZ_STit3) / 2)
          IF TYPE("ZZ_StartK3") = "C"
            ZZ_3KeyF = 40 - (LEN(ZZ_StartK3) / 2) 
          ELSE
            ZZ_3KeyF = 35
          ENDIF
        ENDIF
      ELSE
        DO CASE
        CASE ZZ_Key_Nbr = 1
          ZZ_StartRow = 12
        CASE ZZ_Key_Nbr = 2
          ZZ_StartRow = 10
        OTHERWISE
          ZZ_StartRow = 8
        ENDCASE
        IF LEN(ZZ_SKey1) <> 0
          IF TYPE("ZZ_StartK1") = "C"
            ZZ_1KeyP = 40 - (LEN("Starting " + ZZ_STit1 + ZZ_StartK1) / 2)
          ELSE
            ZZ_1KeyP = 40 - (LEN("Starting " + ZZ_STit1 + "          ") / 2)
          ENDIF
        ENDIF
        IF LEN(ZZ_SKey2) <> 0
          IF TYPE("ZZ_StartK2") = "C"
            ZZ_2KeyP = 40 - (LEN("Starting " + ZZ_STit2 + ZZ_StartK2) / 2)
          ELSE
            ZZ_2KeyP = 40 - (LEN("Starting " + ZZ_STit2 + "          ") / 2)
          ENDIF
        ENDIF
        IF LEN(ZZ_SKey3) <> 0
          IF TYPE("ZZ_StartK3") = "C"
            ZZ_3KeyP = 40 - (LEN("Starting " + ZZ_STit3 + ZZ_StartK3) / 2)
          ELSE
            ZZ_3KeyP = 40 - (LEN("Starting " + ZZ_STit3 + "          ") / 2)
          ENDIF
        ENDIF
      ENDIF

      IF LEN(ZZ_MakeProg) <> 0
        * create desired report program
        DO Rdriver3
        ZZ_Exit = .T.
        EXIT
      ENDIF

      * bring up the from-to data items for edit
      CLEAR
      @ 01,00 SAY "ͻ"
      @ 02,00 SAY " SBS DATABASE REPORT DRIVER                                  GENERATE REPORTS "
      @ 03,00 SAY "ͼ"
      DO WHILE .T.
        * reset search variables
        IF LEN(ZZ_SKey1) <> 0
          ZZ_StartK1 = ZZ_StartO1
          ZZ_EndK1 = ZZ_EndO1
        ENDIF
        IF LEN(ZZ_SKey2) <> 0
          ZZ_StartK2 = ZZ_StartO2
          ZZ_EndK2 = ZZ_EndO2
        ENDIF
        IF LEN(ZZ_SKey3) <> 0
          ZZ_StartK3 = ZZ_StartO3
          ZZ_EndK3 = ZZ_EndO3
        ENDIF
        * bring them up for editing
        ZZ_TmpRow = ZZ_StartRow
        IF ZZ_Mixed
          IF LEN(ZZ_SKey1) <> 0
            @ ZZ_TmpRow,ZZ_1KeyP SAY "Starting " + "&ZZ_STit1"
            @ ZZ_TmpRow+1,ZZ_1KeyF GET ZZ_StartK1
            @ ZZ_TmpRow+3,ZZ_1KeyP SAY "  Ending " + "&ZZ_STit1"
            @ ZZ_TmpRow+4,ZZ_1KeyF GET ZZ_EndK1
            ZZ_TmpRow = ZZ_TmpRow + 6
          ENDIF
          IF LEN(ZZ_SKey2) <> 0
            @ ZZ_TmpRow,ZZ_2KeyP SAY "Starting " + "&ZZ_STit2"
            @ ZZ_TmpRow+1,ZZ_2KeyF GET ZZ_StartK2
            @ ZZ_TmpRow+3,ZZ_2KeyP SAY "  Ending " + "&ZZ_STit2"
            @ ZZ_TmpRow+4,ZZ_2KeyF GET ZZ_EndK2
            ZZ_TmpRow = ZZ_TmpRow + 6
          ENDIF
          IF LEN(ZZ_SKey3) <> 0
            @ ZZ_TmpRow,ZZ_3KeyP SAY "Starting " + "&ZZ_STit3"
            @ ZZ_TmpRow+1,ZZ_3KeyF GET ZZ_StartK3
            @ ZZ_TmpRow+3,ZZ_3KeyP SAY "  Ending " + "&ZZ_STit3"
            @ ZZ_TmpRow+4,ZZ_3KeyF GET ZZ_EndK3
            ZZ_TmpRow = ZZ_TmpRow + 6
          ENDIF
        ELSE
          IF LEN(ZZ_SKey1) <> 0
            @ ZZ_TmpRow,ZZ_1KeyP SAY "Starting " + "&ZZ_STit1" GET ZZ_StartK1
            @ ZZ_TmpRow+2,ZZ_1KeyP SAY "  Ending " + "&ZZ_STit1" GET ZZ_EndK1
            ZZ_TmpRow = ZZ_TmpRow + 4
          ENDIF
          IF LEN(ZZ_SKey2) <> 0
            @ ZZ_TmpRow,ZZ_2KeyP SAY "Starting " + "&ZZ_STit2" GET ZZ_StartK2
            @ ZZ_TmpRow+2,ZZ_2KeyP SAY "  Ending " + "&ZZ_STit2" GET ZZ_EndK2
            ZZ_TmpRow = ZZ_TmpRow + 4
          ENDIF
          IF LEN(ZZ_SKey3) <> 0
            @ ZZ_TmpRow,ZZ_3KeyP SAY "Starting " + "&ZZ_STit3" GET ZZ_StartK3
            @ ZZ_TmpRow+2,ZZ_3KeyP SAY "  Ending " + "&ZZ_STit3" GET ZZ_EndK3
            ZZ_TmpRow = ZZ_TmpRow + 4
          ENDIF
        ENDIF
        @ 23,00 CLEAR
        @ 23,00 SAY "Please enter the starting and ending search paramenters above."
        @ 24,00 SAY "To print all records, leave all parameters blank.  Press Esc to exit."
        READ
        IF LASTKEY() = 27
          ZZ_Exit = .T.
          EXIT
        ENDIF
        ZZ_1SameKey = .F.
        ZZ_2SameKey = .F.
        ZZ_3SameKey = .F.
        * check for blank starting parameters
        IF LEN(ZZ_SKey1) <> 0
          IF ZZ_StartK1 = ZZ_StartO1
            ZZ_1SameKey = .T.
            ZZ_2SameKey = .T.
            ZZ_3SameKey = .T.
            EXIT
          ENDIF
        ELSE
          ZZ_1SameKey = .T.
          ZZ_2SameKey = .T.
          ZZ_3SameKey = .T.
          EXIT
        ENDIF
        IF LEN(ZZ_SKey2) <> 0
          IF ZZ_StartK2 = ZZ_StartO2
            ZZ_2SameKey = .T.
            ZZ_3SameKey = .T.
          ENDIF
        ELSE
          ZZ_2SameKey = .T.
          ZZ_3SameKey = .T.
        ENDIF
        IF LEN(ZZ_SKey3) <> 0
          IF ZZ_StartK3 = ZZ_StartO3
            ZZ_3SameKey = .T.
          ENDIF
        ELSE
          ZZ_3SameKey = .T.
        ENDIF
	* set and search for entered starting parameters
        ZZ_ExitEdit = .T.
        ZZ_SrchS1 = ""
        * build a search string for key one
        DO CASE
        CASE TYPE("ZZ_StartK1") = "N"
          ZZ_SrchS1 = STR(ZZ_StartK1)
        CASE TYPE("ZZ_StartK1") = "D"
          ZZ_SrchS1 = DTOC(ZZ_StartK1)
        OTHERWISE
          ZZ_SrchS1 = UPPER(TRIM(ZZ_StartK1))
        ENDCASE
        SEEK ZZ_SrchS1
        IF EOF()
          @ 23,00 CLEAR
          @ 23,00 SAY "Starting " + ZZ_STit1 + " was not found."
          @ 24,00 SAY "Press any key to continue..."
          SET CONSOLE OFF
          WAIT
          SET CONSOLE ON
          GO TOP
          LOOP
        ENDIF
        * pull found variable for the next search field
        ZZ_StartK1 = &ZZ_SKey1
        DO CASE
        CASE TYPE("ZZ_StartK1") = "N"
          ZZ_SrchS1 = STR(ZZ_StartK1)
        CASE TYPE("ZZ_StartK1") = "D"
          ZZ_SrchS1 = DTOC(ZZ_StartK1)
        OTHERWISE
          ZZ_SrchS1 = UPPER(ZZ_StartK1)
        ENDCASE
        IF .NOT. ZZ_2SameKey
          DO CASE
          CASE TYPE("ZZ_StartK2") = "N"
            ZZ_SrchS1 = ZZ_SrchS1 + STR(ZZ_StartK2)
          CASE TYPE("ZZ_StartK2") = "D"
            ZZ_SrchS1 = ZZ_SrchS1 + DTOC(ZZ_StartK2)
          OTHERWISE
            ZZ_SrchS1 = ZZ_SrchS1 + UPPER(TRIM(ZZ_StartK2))
          ENDCASE
          SEEK ZZ_SrchS1
          IF EOF()
            @ 23,00 CLEAR
            @ 23,00 SAY "Starting " + ZZ_STit2 + " was not found."
            @ 24,00 SAY "Press any key to continue..."
            SET CONSOLE OFF
            WAIT
            SET CONSOLE ON
            GO TOP
            LOOP
          ENDIF
          * pull found variable
          ZZ_StartK2 = &ZZ_SKey2
          DO CASE
          CASE TYPE("ZZ_StartK2") = "N"
            ZZ_SrchS1 = ZZ_SrchS1 + STR(ZZ_StartK2)
          CASE TYPE("ZZ_StartK2") = "D"
            ZZ_SrchS1 = ZZ_SrchS1 + DTOC(ZZ_StartK2)
          OTHERWISE
            ZZ_SrchS1 = ZZ_SrchS1 + UPPER(ZZ_StartK2)
          ENDCASE
        ENDIF
        IF .NOT. ZZ_3SameKey
          DO CASE
          CASE TYPE("ZZ_StartK3") = "N"
            ZZ_SrchS1 = ZZ_SrchS1 + STR(ZZ_StartK3)
          CASE TYPE("ZZ_StartK3") = "D"
            ZZ_SrchS1 = ZZ_SrchS1 + DTOC(ZZ_StartK3)
          OTHERWISE
            ZZ_SrchS1 = ZZ_SrchS1 + UPPER(TRIM(ZZ_StartK3))
          ENDCASE
          SEEK ZZ_SrchS1
          IF EOF()
            @ 23,00 CLEAR
            @ 23,00 SAY "Starting " + ZZ_STit3 + " was not found."
            @ 24,00 SAY "Press any key to continue..."
            SET CONSOLE OFF
            WAIT
            SET CONSOLE ON
            GO TOP
            LOOP
          ENDIF
          * pull found variable
          ZZ_StartK3 = &ZZ_SKey3
          DO CASE
          CASE TYPE("ZZ_StartK3") = "N"
            ZZ_SrchS1 = ZZ_SrchS1 + STR(ZZ_StartK3)
          CASE TYPE("ZZ_StartK3") = "D"
            ZZ_SrchS1 = ZZ_SrchS1 + DTOC(ZZ_StartK3)
          OTHERWISE
            ZZ_SrchS1 = ZZ_SrchS1 + UPPER(ZZ_StartK3)
          ENDCASE
        ENDIF
        EXIT
      ENDDO
    ENDIF
    IF ZZ_Exit
      EXIT
    ENDIF
    * get set to print the report
    SELECT A
    ZZ_Lnct = 0
    * assign the variables usable buy the report
    ZZ_PageNbr = 1
    ZZ_Count = 0
    DO CASE
    CASE ZZ_Dest = "LPT1" .OR. ZZ_Dest = "LPT2" .OR. ZZ_Dest = "LPT3"
      @ 23,00 CLEAR
      @ 24,00 SAY "Sending report to " + ZZ_Dest + ", press the Esc key to abort..."
      SET PRINTER TO &ZZ_Dest
      SET CONSOLE OFF
      SET PRINT ON
    CASE ZZ_Dest = "SCREEN"
      ZZ_Pagelen = 22
      CLEAR
    OTHERWISE
      @ 23,00 CLEAR
      @ 23,00 SAY "Sending report to disk file " + ZZ_Dest + "."
      @ 24,00 SAY "Press the Esc key to abort..."
      SET CONSOLE OFF
      SET ALTERNATE TO &ZZ_Dest
      SET ALTERNATE ON
    ENDCASE
    ZZ_Hcntr = 0
    ZZ_Bcntr = 0
    ZZ_Scntr = 0
    ZZ_Fcntr = 0
    ZZ_Abort = .F.
    DO WHILE .NOT. EOF()
      * check for any exceeded ending search parameters
      IF LEN(ZZ_SKey1) <> 0
        IF ZZ_EndK1 <> ZZ_EndO1
          DO CASE
          CASE TYPE("ZZ_EndK1") = "N"
            IF &ZZ_SKey1 > ZZ_EndK1 .AND. ZZ_EndK1 <> 0
              EXIT
            ENDIF
          CASE TYPE("ZZ_EndK1") = "D"
            IF &ZZ_SKey1 > ZZ_EndK1
              EXIT
            ENDIF
          OTHERWISE
            IF UPPER(&ZZ_SKey1) > UPPER(ZZ_EndK1)
              EXIT
            ENDIF
          ENDCASE
        ENDIF
      ENDIF
      IF LEN(ZZ_SKey2) <> 0
        IF ZZ_EndK2 <> ZZ_EndO2
          DO CASE
          CASE TYPE("ZZ_EndK2") = "N"
            IF &ZZ_SKey2 > ZZ_EndK2 .AND. ZZ_EndK2 <> 0
              EXIT
            ENDIF
          CASE TYPE("ZZ_EndK2") = "D"
            IF &ZZ_SKey2 > ZZ_EndK2
              EXIT
            ENDIF
          OTHERWISE
            IF UPPER(&ZZ_SKey2) > UPPER(ZZ_EndK2)
              EXIT
            ENDIF
          ENDCASE
        ENDIF
      ENDIF
      IF LEN(ZZ_SKey3) <> 0
        IF ZZ_EndK3 <> ZZ_EndO3
          DO CASE
          CASE TYPE("ZZ_EndK3") = "N"
            IF &ZZ_SKey3 > ZZ_EndK3 .AND. ZZ_EndK3 <> 0
              EXIT
            ENDIF
          CASE TYPE("ZZ_EndK3") = "D"
            IF &ZZ_SKey3 > ZZ_EndK3
              EXIT
            ENDIF
          OTHERWISE
            IF UPPER(&ZZ_SKey3) > UPPER(ZZ_EndK3)
              EXIT
            ENDIF
          ENDCASE
        ENDIF
      ENDIF
      * Check for an esc keypress
      I = INKEY()
      IF I = 27
        ZZ_Abort = .T.
        EXIT
      ENDIF
      * check for any condition parameters
      IF LEN(ZZ_Cond) <> 0
        IF &ZZ_Cond
        ELSE
          SKIP
          LOOP
        ENDIF
      ENDIF
      * increment the record counter
      ZZ_Count = ZZ_Count + 1
      * perform positioning in the other three databases
      IF LEN(ZZ_File2) <> 0 .AND. LEN(ZZ_Indx2) <> 0 .AND. LEN(ZZ_BKey) <> 0
        SELECT B
        SEEK &ZZ_BKey
      ENDIF
      IF LEN(ZZ_File3) <> 0 .AND. LEN(ZZ_Indx3) <> 0 .AND. LEN(ZZ_CKey) <> 0
        SELECT C
        SEEK &ZZ_CKey
      ENDIF
      IF LEN(ZZ_File4) <> 0 .AND. LEN(ZZ_Indx4) <> 0 .AND. LEN(ZZ_DKey) <> 0
        SELECT D
        SEEK &ZZ_DKey
      ENDIF
      SELECT A
      * accumulate subtotals if entered
      IF LEN(ZZ_Stot1B) <> 0
        ZZ_SubField = &ZZ_Stot1B
      ENDIF
      IF LEN(ZZ_Stot1F) <> 0
        ZZ_SubTot1 = ZZ_SubTot1 + &ZZ_Stot1F
      ENDIF
      IF LEN(ZZ_Stot2F) <> 0
        ZZ_SubTot2 = ZZ_SubTot2 + &ZZ_Stot2F
      ENDIF
      IF LEN(ZZ_Stot3F) <> 0
        ZZ_SubTot3 = ZZ_SubTot3 + &ZZ_Stot3F
      ENDIF
      IF LEN(ZZ_Stot4F) <> 0
        ZZ_SubTot4 = ZZ_SubTot4 + &ZZ_Stot4F
      ENDIF
      IF LEN(ZZ_Stot5F) <> 0
        ZZ_SubTot5 = ZZ_SubTot5 + &ZZ_Stot5F
      ENDIF
      * accumulate report totals
      IF LEN(ZZ_Rtot1F) <> 0
        ZZ_RepTot1 = ZZ_RepTot1 + &ZZ_Rtot1F
      ENDIF
      IF LEN(ZZ_Rtot2F) <> 0
        ZZ_RepTot2 = ZZ_RepTot2 + &ZZ_Rtot2F
      ENDIF
      IF LEN(ZZ_Rtot3F) <> 0
        ZZ_RepTot3 = ZZ_RepTot3 + &ZZ_Rtot3F
      ENDIF
      IF LEN(ZZ_Rtot4F) <> 0
        ZZ_RepTot4 = ZZ_RepTot4 + &ZZ_Rtot4F
      ENDIF
      IF LEN(ZZ_Rtot5F) <> 0
        ZZ_RepTot5 = ZZ_RepTot5 + &ZZ_Rtot5F
      ENDIF

      * controller logic
      IF ZZ_Type = "RECORD"
        * print header
        CLEAR
        IF ZZ_Hmax <> 0 
          ZZ_Hcntr = 0
          DO WHILE ZZ_Hcntr < ZZ_Hmax
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Vname = "ZZ_Head" + LTRIM(STR(ZZ_Hcntr,3,0))
            DO Rdriver2
            ZZ_Hcntr = ZZ_Hcntr + 1
            ZZ_Lnct = ZZ_Lnct + 1
          ENDDO
          IF ZZ_Abort
            EXIT
          ENDIF
          ZZ_Hcntr = 0
        ENDIF
        * print the body
        IF ZZ_Bmax <> 0
          ZZ_Bcntr = 0
          DO WHILE ZZ_Bcntr < ZZ_Bmax
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Vname = "ZZ_Body" + LTRIM(STR(ZZ_Bcntr,3,0))
            DO Rdriver2
            ZZ_Bcntr = ZZ_Bcntr + 1
            ZZ_Lnct = ZZ_Lnct + 1
          ENDDO
          IF ZZ_Abort
            EXIT
          ENDIF
          ZZ_Bcntr = 0
        ENDIF
        SKIP
        * check for subtotal print
        IF LEN(ZZ_Stot1F) <> 0 .AND. LEN(ZZ_Stot1B) <> 0
          IF &ZZ_Stot1B <> ZZ_SubField
            ZZ_Scntr = 0
            DO WHILE ZZ_Scntr < ZZ_Smax
              I = INKEY()
              IF I = 27
                ZZ_Abort = .T.
                EXIT
              ENDIF
              ZZ_Vname = "ZZ_Subt" + LTRIM(STR(ZZ_Scntr,3,0))
              * backup to the previous record
              SKIP - 1
              DO Rdriver2
              SKIP
              ZZ_Scntr = ZZ_Scntr + 1
              ZZ_Lnct = ZZ_Lnct + 1
            ENDDO
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Scntr = 0
            * pull new subtotal field and reset accumulators
            ZZ_SubField = &ZZ_Stot1B
            ZZ_SubTot1 = 0.0
            ZZ_SubTot2 = 0.0
            ZZ_SubTot3 = 0.0
            ZZ_SubTot4 = 0.0
            ZZ_SubTot5 = 0.0
          ENDIF
        ENDIF
        * print the footer
        IF ZZ_Fmax <> 0
          ZZ_Fcntr = 0
          DO WHILE ZZ_Fcntr < ZZ_Fmax
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Vname = "ZZ_Foot" + LTRIM(STR(ZZ_Fcntr,3,0))
            DO Rdriver2
            ZZ_Fcntr = ZZ_Fcntr + 1
            ZZ_Lnct = ZZ_Lnct + 1
          ENDDO
          IF ZZ_Abort
            EXIT
          ENDIF
          ZZ_Fcntr = 0
        ENDIF
        * call an eject
        ZZ_PageNbr = ZZ_PageNbr + 1
        ZZ_Lnct = 0
        IF ZZ_Dest = "S"
          WAIT
          @ ROW(),00
        ELSE
          IF ZZ_Eject
            EJECT
          ENDIF
        ENDIF
      ELSE
        * it is a summary report
        IF ZZ_Lnct > ZZ_Pagelen
          * print the page footer of the report if entered
          IF ZZ_Fmax <> 0
            ZZ_Fcntr = 0
            DO WHILE ZZ_Fcntr < ZZ_Fmax
              I = INKEY()
              IF I = 27
                ZZ_Abort = .T.
                EXIT
              ENDIF
              ZZ_Vname = "ZZ_Foot" + LTRIM(STR(ZZ_Fcntr,3,0))
              DO Rdriver2
              ZZ_Fcntr = ZZ_Fcntr + 1
              ZZ_Lnct = ZZ_Lnct + 1
            ENDDO
            IF ZZ_Abort
              EXIT
            ENDIF
          ENDIF
          ZZ_PageNbr = ZZ_PageNbr + 1
          ZZ_Lnct = 0
          ZZ_Hcntr = 0
          IF ZZ_Dest = "S"
            WAIT
            @ ROW(),00
            @ ROW()-1,00
            CLEAR
          ELSE
            IF ZZ_Eject
              EJECT
            ENDIF
          ENDIF
        ENDIF
        IF ZZ_Hcntr = 0 .AND. ZZ_Hmax <> 0 
          DO WHILE ZZ_Hcntr < ZZ_Hmax
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Vname = "ZZ_Head" + LTRIM(STR(ZZ_Hcntr,3,0))
            DO Rdriver2
            ZZ_Hcntr = ZZ_Hcntr + 1
            ZZ_Lnct = ZZ_Lnct + 1
          ENDDO
          IF ZZ_Abort
            EXIT
          ENDIF
        ENDIF
        * print the body lines
        IF ZZ_Bmax <> 0
          ZZ_Bcntr = 0
          DO WHILE ZZ_Bcntr < ZZ_Bmax
            I = INKEY()
            IF I = 27
              ZZ_Abort = .T.
              EXIT
            ENDIF
            ZZ_Vname = "ZZ_Body" + LTRIM(STR(ZZ_Bcntr,3,0))
            DO Rdriver2
            ZZ_Bcntr = ZZ_Bcntr + 1
            ZZ_Lnct = ZZ_Lnct + 1
          ENDDO
          IF ZZ_Abort
            EXIT
          ENDIF
          ZZ_Bcntr = 0
        ENDIF
        SKIP
        * check for subtotal print
        IF LEN(ZZ_Stot1F) <> 0 .AND. LEN(ZZ_Stot1B) <> 0
          IF &ZZ_Stot1B <> ZZ_SubField
            ZZ_Scntr = 0
            DO WHILE ZZ_Scntr < ZZ_Smax
              I = INKEY()
              IF I = 27
                ZZ_Abort = .T.
                EXIT
              ENDIF
              ZZ_Vname = "ZZ_Subt" + LTRIM(STR(ZZ_Scntr,3,0))
              SKIP - 1
              DO Rdriver2
              SKIP
              IF ZZ_Lnct > ZZ_Pagelen
                ZZ_PageNbr = ZZ_PageNbr + 1
                ZZ_Lnct = 0
                IF ZZ_Dest = "S"
                  WAIT
                  @ ROW(),00
                  @ ROW()-1,00
                  CLEAR
                ELSE
                  ZZ_Hcntr = 0
                  IF ZZ_Eject
                    EJECT
                  ENDIF
                ENDIF
              ENDIF
              ZZ_Scntr = ZZ_Scntr + 1
              ZZ_Lnct = ZZ_Lnct + 1
            ENDDO
            IF ZZ_Abort
              EXIT
            ENDIF
            ZZ_Scntr = 0
            * pull new subtotal field and reset accumulators
            ZZ_SubField = &ZZ_Stot1B
            ZZ_SubTot1 = 0.0
            ZZ_SubTot2 = 0.0
            ZZ_SubTot3 = 0.0
            ZZ_SubTot4 = 0.0
            ZZ_SubTot5 = 0.0
            * check for a new page on a subtotal print
            IF ZZ_SNewPage .AND. .NOT. EOF()
              ZZ_Lnct = 99999
            ENDIF
          ENDIF
        ENDIF
      ENDIF
    ENDDO
    IF .NOT. ZZ_Abort
      * check for report total print
      ZZ_Rcntr = 0
      DO WHILE ZZ_Rcntr < ZZ_Rmax
        ZZ_Vname = "ZZ_Rept" + LTRIM(STR(ZZ_Rcntr,3,0))
        SKIP - 1
        DO Rdriver2
        SKIP
        ZZ_Rcntr = ZZ_Rcntr + 1
        ZZ_Lnct = ZZ_Lnct + 1
      ENDDO
      ZZ_Rcntr = 0
      IF ZZ_Dest = "S"
        WAIT
        @ ROW(),00
        @ ROW()-1,00
      ELSE
        IF ZZ_Eject
          EJECT
        ENDIF
      ENDIF
    ENDIF
    IF LEN(ZZ_SKey1) = 0
      EXIT
    ENDIF
    he P CONSOLE ON
    hEP PRINP OFF
    CLOSE ALTERNATE
  ENDDO
  CLOSE DATABASES
  he P CONSOLE ON
  hEP PRINP OFF
  CLOSE ALTERNATE
ENDDO
RETURN
