/* Program :MEMOLINE.C 
   Date ---:December 4, 1986
   Author -:Kevin E. Saffer (from a program written by Brian Russell and
            David Dodson, originally published in Nantucket News, Vol 1,1.

            Special thanks to Fred at Nantucket Tech Support!

   Notes --:This program provides an additional memo handling function
            for the Clipper compiler, Autumn '86 version.
        
            The function MEMOLINE provides a line extract function
            for manipulating memo fields.  This is useful when you wish to 
            print or display a selected number of lines from a memo field.

            Specify the memo field, the starting line number, and the number
            of lines to be returned.

            Will return a null if specified lines are not found.

            For Wordstar compatible editors, any soft carriage returns
            will be translated to hard carriage returns.

     Syntax: ?? MEMOLINE(MemoField,StartLine,NumberOfLines)

            To use with previous versions of Clipper, replace all references
            to _str_all with _str_alloc, and refrences to _str_rel with 
            _str_release, then recompile.

            Compile with Lattice large model only.  The compiling command
            was: lc -mls -v -n memoline.  The resulting object file may then
            be included in your programs as a file, or added to your memo
            library using Plib86. */
 

/* various defines and external declarations from extend.h,
   a program file distributed on your Clipper disks */

#include "extend.h"

#define HARD_CR '\r'
#define SOFT_CR ('\r' | 0x80)
#define LINE_FEED '\n'

MEMOLINE()
{
  /* initialize local memvars and functions */
  char *_str_all();             /* pointer to clipper function for memory allocation */
  char *pos1;                   /* position in the source memo */
  char *pos2;                   /* position in the target memo */
  char *str2;                   /* pointer to the target memo */
  unsigned size2;               /* size of source memo */
  unsigned startline;           /* passed starting line number */
  unsigned numoflines;          /* passed number of lines */
  unsigned currentline;         /* keeps track of the current line number */

  /* check passed parameters */
  if (PCOUNT >= 3 && ISCHAR(1) && ISNUM(2) && ISNUM(3))
  {
    pos1 = _parc(1);            /* get position in source memo */
    size2 = strlen(pos1) + 1;   /* calculate size of source memo + 1 */
    str2 = _str_all(size2);     /* allocate memory for target memo */
    pos2 = str2;                /* position in target memo */
    currentline = 1;            /* initialize line counter */
    startline = _parni(2);      /* get passed start line */
    numoflines = _parni(3);     /* get passed number of lines */

    /* skip to specified starting line in the memo */
    while ((currentline < startline) && (*pos1))
    {
      if (*pos1 == LINE_FEED)   /* check for a line feed */
         currentline++;         /* bump line counter if found */
      *pos1++;                  /* bump source pointer */
    }  

    /* build target memo field from the current line on */
    while (((currentline - startline) < numoflines) && (*pos1))
    {
      *pos2 = *pos1;            /* add character to target */
      if (*pos2 == LINE_FEED)   /* check for a line feed */
         currentline++;         /* bump line counter if found */
      if (*pos2 == SOFT_CR)     /* check for soft cr */
         *pos2 = HARD_CR;       /* replace with hard cr */
      *pos1++;                  /* bump source pointer */
      *pos2++;                  /* bump target pointer */
    }

    *pos2 = '\0';               /* terminate target memo by adding a null */
    _retc(str2);                /* return it to Clipper */
    _str_rel(str2,size2);       /* release target memo memory */
  }
  else
    _retc("");                  /* error, return null */
}

/* EOF:MEMOLINE.C */
