* PROGRAM --:RDRIVER.PRG
* DATE -----:12/02/87   
* AUTHOR ---:Kevin E. Saffer, of Torrington, CT
* 
* This program is hearby released into the public domain for non-commercial
* use only by Saffer Business Systems.
*
* This program initializes the operating environment and provides a menu 
* for the operator.  Functions to delete report scripts and display database
* structures are in this file.  Functions to read and execute a report script
* are in the files RDRIVER1, RDRIVER2, and RDRIVER3.
*
* Most memory variables are prefixed with ZZ_ to prevent any conflicts with
* database field names.

* declare the MemoLine function external (in the file MEMOLINE.OBJ)
EXTERNAL Memoline
* establish working environment
SET BELL OFF
SET COLOR TO
SET CONFIRM ON
SET CONSOLE ON
SET DELETED ON
SET DELIMITER TO '[]'
SET DELIMITER OFF
SET DEVICE TO SCREEN
SET ESCAPE ON
SET EXCLUSIVE ON
SET HEADING OFF
SET INTENSITY ON
SET MENU OFF
SET PRINT OFF
SET SAFETY OFF
* display the mighty SBS screen!
DO Logo
* initialize the report spec memvar
ZZ_Spec = SPACE(8)
* main program loop
DO WHILE .T.
  * reset the printer and close databases on every pass
  SET PRINTER TO LPT1
  CLOSE DATABASES
  SET CONFIRM ON
  CLEAR
  @ 01,00 SAY "ͻ"
  @ 02,00 SAY " SBS DATABASE REPORT DRIVER                                         MAIN MENU "
  @ 03,00 SAY " PUBLIC DOMAIN BY SAFFER BUSINESS SYSTEMS                         VERSION 1.0 "
  @ 04,00 SAY "ͼ"
  @ 24,00 SAY "Please indicate your selection or press the Esc key to exit."
  SET MESSAGE TO
  * loop in here until we get a valid user choice
  DO WHILE .T.
    @ 11,20 PROMPT "1.  Generate Report From Existing Script."
    @ 13,20 PROMPT "2.  Delete a Report Script.              "
    @ 15,20 PROMPT "3.  Display a Database File Structure.   "
    @ 17,20 PROMPT "4.  DOS Access.                          "
    MENU TO ZZ_Mchoice
    IF ZZ_Mchoice = 0
      IF FILE("*.$$$")
        @ 23,00 CLEAR
        @ 24,00 SAY "Erasing temporary files..."
        @ 23,00 SAY ""
        SET CONSOLE OFF
        RUN ERASE *.$$$
        SET CONSOLE ON
      ENDIF
      CLEAR
      RETURN
    ENDIF
    IF ZZ_Mchoice >= 1 .AND. ZZ_Mchoice <= 4
      EXIT
    ENDIF
  ENDDO
  * branch based on operator choice
  DO CASE
  CASE ZZ_Mchoice = 1
    * run a report script
    DO Rdriver1
  CASE ZZ_Mchoice = 2
    * delete a report script
    DO WHILE .T.
      CLEAR
      @ 01,00 SAY "ͻ"
      @ 02,00 SAY " SBS DATABASE REPORT DRIVER                            DELETE A REPORT SCRIPT "
      @ 03,00 SAY "ͼ"
      ZZ_Spec = SPACE(8)
      @ 12,23 SAY "Enter Report Script" GET ZZ_Spec PICTURE '@!@K'
      @ 24,00 SAY "Please enter the filename, press Enter for a list, or press Esc to exit."
      READ
      IF LASTKEY() = 27 
        EXIT
      ENDIF
      IF ZZ_Spec = SPACE(8) 
        ZZ_Junk = RPTLIST()
        LOOP
      ENDIF
      ZZ_Name = LTRIM(TRIM(ZZ_Spec)) + ".RPT"
      IF .NOT. FILE("&ZZ_Name")
        @ 23,00 CLEAR
        @ 24,00 SAY "Script file does not exist, press any key to continue..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        LOOP
      ENDIF
      * we have a valid file, kill it
      @ 23,00 CLEAR
      @ 24,00 SAY "Deleting this report script..."
      @ 23,00 SAY ""
      SET CONSOLE OFF
      RUN ERASE &ZZ_Name 
      ZZ_Name = LTRIM(TRIM(ZZ_Spec)) + ".RPN"
      RUN ERASE &ZZ_Name 
      SET CONSOLE ON
    ENDDO
  CASE ZZ_Mchoice = 3
    * disp database structure
    DO WHILE .T.
      CLEAR
      @ 01,00 SAY "ͻ"
      @ 02,00 SAY " SBS DATABASE REPORT DRIVER                   DISPLAY DATABASE FILE STRUCTURE "
      @ 03,00 SAY "ͼ"
      ZZ_Tname = SPACE(8)
      @ 12,20 SAY "Enter Database File Name" GET ZZ_Tname PICTURE '@!@K'
      @ 24,00 SAY "Please enter the filename, press Enter for a list, or press Esc to exit."
      READ
      IF LASTKEY() = 27
        EXIT
      ENDIF
      IF ZZ_Tname = SPACE(8)
        * list any database file in the current directory
        @ 23,00 CLEAR
        @ 24,00 SAY "Searching for database files..."
        * use an array for simplicity
        ZZ_MaxFile = ADIR("*.DBF")
        IF ZZ_Maxfile <> 0
          DECLARE ZZ_DbfFiles[ADIR("*.DBF")]
          ADIR("*.DBF",ZZ_DbfFiles)
          @ 04,00 CLEAR
          ZZ_FileCntr = 1
          ZZ_Row = 5
          ZZ_Col = 1
          DO WHILE ZZ_FileCntr <= ZZ_MaxFile
            @ ZZ_Row,ZZ_col SAY SPACE(12 - LEN(ZZ_DbfFiles[ZZ_FileCntr])) + ZZ_DbfFiles[ZZ_FileCntr] 
            ZZ_Row = ZZ_Row + 1
            IF ZZ_Row = 23
              ZZ_Col = ZZ_Col + 13
              ZZ_Row = 5
            ENDIF
            IF ZZ_Col > 75
              EXIT
            ENDIF
            ZZ_FileCntr = ZZ_FileCntr + 1
          ENDDO
          @ 23,00 SAY ""
          WAIT
        ENDIF
        RELEASE ZZ_DbfFiles 
        LOOP
      ENDIF
      ZZ_Tname = LTRIM(TRIM(ZZ_Tname)) + ".DBF"
      IF .NOT. FILE("&ZZ_Tname")
        @ 23,00 CLEAR
        @ 24,00 SAY "Database file does not exist, press any key to continue..."
        SET CONSOLE OFF
        WAIT
        SET CONSOLE ON
        LOOP
      ENDIF
      * we have a valid file, display it's structure
      USE &ZZ_Tname
      * build structure extended file to get field info
      COPY TO Tadata.$$$ STRUCTURE EXTENDED
      USE TaData.$$$
      @ 04,00 CLEAR
      @ 05,00 SAY " Field Name Type Len Dec    Field Name Type Len Dec    Field Name Type Len Dec"
      @ 06,00 SAY " ---------- ---- --- ---    ---------- ---- --- ---    ---------- ---- --- ---"
      DO WHILE .T.
        @ 07,00 CLEAR
        Drow = 07
        Dcol = 1
        Doffset = 27
        DO WHILE Dcol < 60 .AND. (.NOT. EOF())
          @ Drow,Dcol SAY Field_Name
          @ Drow,Dcol + 11 SAY Field_Type
          @ Drow,Dcol + 16 SAY Field_Len
          @ Drow,Dcol + 20 SAY Field_Dec
          Drow = Drow + 1
          IF Drow > 22
            Drow = 7
            Dcol = Dcol + Doffset
          ENDIF
          SKIP
        ENDDO
        ZZ_wait = " "
        @ 23,00 CLEAR
        @ 24,00 SAY "Press the Enter key to scroll fields or press the Esc key to exit" GET ZZ_Wait
        READ
        IF LASTKEY() = 27
          EXIT
        ENDIF
        IF EOF()
          GO TOP
        ENDIF
      ENDDO
    ENDDO
  CASE ZZ_Mchoice = 4
    * run command.com
    CLEAR
    @ 01,00 SAY "ͻ"
    @ 02,00 SAY " SBS DATABASE REPORT DRIVER                                        DOS ACCESS "
    @ 03,00 SAY "ͼ"
    @ 05,00 SAY "Enter EXIT at the DOS prompt to return to the Report Driver."
    RUN Command
  ENDCASE
ENDDO

FUNCTION Chkfname
  * used to make sure that the operator enters a valid DOS filename
  PARAMETERS ZZ_Testfile
  ZZ_Goodchar = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789:\."
  ZZ_Chrptr = 1
  ZZ_Chrmax = LEN(ZZ_Testfile)
  ZZ_Filegood = .T.
  DO WHILE ZZ_Chrptr <= ZZ_Chrmax
    ZZ_chrtest = UPPER(SUBSTR(ZZ_Testfile,ZZ_Chrptr,1))
    IF AT(ZZ_Chrtest,ZZ_Goodchar) = 0
      ZZ_Filegood = .F.
      EXIT
    ENDIF
    ZZ_Chrptr = ZZ_Chrptr + 1
  ENDDO
RETURN(ZZ_Filegood)

FUNCTION RPTLIST
  * used to search for and list report scripts, called be RDRIVER1 as well
  @ 23,00 CLEAR
  @ 24,00 SAY "Searching for report scripts..."
  ZZ_MaxFile = ADIR("*.RPT")
  IF ZZ_Maxfile <> 0
    * declare array for disk file names
    DECLARE ZZ_RepFiles[ADIR("*.RPT")]
    ADIR("*.RPT",ZZ_RepFiles)
    * declare array for report descriptions and load them
    DECLARE ZZ_RepNames[ZZ_MaxFile]
    ZZ_FileCntr = 1
    DO WHILE ZZ_FileCntr <= ZZ_MaxFile
      ZZ_ReadName = LTRIM(SUBSTR(SPACE(12 - LEN(ZZ_RepFiles[ZZ_FileCntr])) + ZZ_RepFiles[ZZ_FileCntr],1,8) + ".RPN")
      ZZ_RepNames[ZZ_FileCntr] = MEMOREAD(ZZ_ReadName)
      ZZ_FileCntr = ZZ_FileCntr + 1
    ENDDO
    @ 04,00 CLEAR
    @ 05,00 SAY "  FILE NAME     DESCRIPTION"
    @ 06,00 SAY "  ------------  ------------------------------------------------------------"
    ZZ_FileCntr = 1
    ZZ_Row = 7
    DO WHILE .T.
      @ ZZ_Row,2 SAY SPACE(12 - LEN(ZZ_RepFiles[ZZ_FileCntr])) + ZZ_RepFiles[ZZ_FileCntr] 
      @ ZZ_Row,16 SAY SUBSTR(ZZ_RepNames[ZZ_FileCntr],1,60)
      ZZ_Row = ZZ_Row + 1
      IF ZZ_Row = 23 .OR. ZZ_FileCntr = ZZ_MaxFile
        ZZ_Wait = " "
        @ 24,00 SAY "Press the Enter key to Scroll the list or press Esc to exit" GET ZZ_wait PICTURE '!'
        READ
        IF LASTKEY() = 27
          EXIT
        ENDIF
        ZZ_Row = 7
        IF ZZ_FileCntr = ZZ_MaxFile
          ZZ_FileCntr = 0
        ENDIF
        @ 07,00 CLEAR
      ENDIF
      ZZ_FileCntr = ZZ_FileCntr + 1
    ENDDO
  ENDIF
  RELEASE ZZ_RepFiles 
  RELEASE ZZ_RepNames 
RETURN .T.
