* This program demonstrates the getprts() function, which reads the names
* of all printers in an R&R configuration file into an array with the same
* name as the configuration file.

FUNCTION LISTCNF ( cnfname )
   LOCAL cnflist, count

   qout ( 'Here we go (note the long load time - Clipper 5.0 thing)')
   qout ( '' )
   IF ( cnfname == NIL )
      cnfname := 'RR.CNF'
   endif

   cnflist := getprts(cnfname)
   count := 0
   AEVAL ( cnflist, { |prn| count += if (prn==NIL, 0, 1) } )

   ? "There are " + LTRIM(STR(count)) + " printers defined in " + cnfname

   AEVAL ( cnflist, { |prn,num| if (prn!=NIL, qout ( 'Printer ' + LTRIM(STR(num)) + ":    [" + prn + "]"), NIL ) } )
   ?
   ?
RETURN 0

