////////////////////////////////////////////////////////////////////////////
//
// Provided by Concentric Data Systems, Inc. as an example. This Clipper
// code has not been certified - use at your own risk. The Version 3 R&R
// configuration file structure is subject to change without notice.
//
// This function opens the configuration file specified, and fills a public
// array of the same name with the eight printer names, leaving names blank
// where not defined. For example, getprts("RR.CNF") fills an array named RR
// with the names of the eight printers defined in the configuration file
// named RR.CNF.
//
// Modified: 02-12-91 11:06am by Patrick T. Hurley
//    better Clipper 5.0 support returns an array - no publics
//    uses locals etc...

// 
FUNCTION getprts ( cnfname )
   LOCAL retval := ASIZE ( {}, 8 )
   LOCAL data, dataptr, handle, printer, offset[8], rectype

   // Add default argument...
   IF ( cnfname == NIL )
      cnfname := 'RR.CNF'
   ENDIF

   IF !( '.' $ cnfname )
      cnfname += '.CNF'          //  append .CNF if necessary
   ENDIF

   handle := FOPEN ( cnfname, 0 )             //  open config file, read only

   DO WHILE .T.                        //  get file offsets of printers
      data := SPACE(768)                //  initialize an input buffer
      rectype := readrec( handle, @data )    //  read the next record
      IF ( rectype == 15 )                    //  if it's a printer offset record
         dataptr := 1                   //  initialize pointer to data
         FOR printer = 1 TO 8          //  process eight printer offsets
            //  convert long integer to number
            // alot easier this way ( and faster... )
            offset[printer] := BIN2L ( substr ( data, dataptr, 4 ) )
            dataptr += 4         //  advance pointer to next offset
         NEXT
         EXIT
      ENDIF
   ENDDO

   FOR printer = 1 TO 8                //  process eight printers
      IF ( offset[printer] # 0 )             //  if the printer is defined
         FSEEK(handle, offset[printer], 0)   //   seek the definition
         DO WHILE .T.                  //   loop until printer name record
            data := SPACE(768)          //   initialize an input buffer
            rectype := readrec(handle,@data)  //   read the next record
            IF ( rectype == 260 )          //   if it's a printer name record
               retval [ printer ] := ;
                  SUBSTR(data,2,ASC(data))  //    place printer name into array
               EXIT
            ENDIF
         ENDDO
      ELSE                          //  otherwise printer isn't defined
         retval [ printer ] := NIL  //  so place NIL or NULL?? I like NIL
      ENDIF
   NEXT

RETURN retval                       //  return the printer array

// 
/////////////////////////////////
//
// Function: readrec ( handle, buffer )
//
// Notes:    read next config file record
//           return the record type
//
FUNCTION readrec ( handle, buffer )
   LOCAL length, type

   type := SPACE(2)                        //  initialize an input buffer
   FREAD(handle, @type, 2)                //  read the record type code
   type = BIN2W ( type )
//       (ASC(SUBSTR(type, 1, 1)) * 256^0) +;
//       (ASC(SUBSTR(type, 2, 1)) * 256^1)      //  convert integer to number

   length := SPACE(2)                   //  initialize an input buffer
   FREAD(handle, @length, 2)              //  read the record length
   length = BIN2W ( length )
//       (ASC(SUBSTR(length, 1, 1)) * 256^0) +;
//       (ASC(SUBSTR(length, 2, 1)) * 256^1)    //  convert integer to number

   FREAD(handle, @buffer, length)            //  read this record's data
RETURN type                         //  return the record type code
