***************************************************************
* Royce D. Bacon Clipper 5.0 Function Library                 *
* (C)COPYRIGHT 1990 - Royce D. Bacon - RDB systems            *
*       CompuServe user-id = 70042,1001                       *
*       You are free to use this in your own programs.        *
*       You may make modifications to it if you like.         *
*       Any comments are welcome.                             *
* RDBFUNC.PRG -  Version 1.02                                 *
* AUTHOR: Royce D. Bacon, 10/90                               *
* PURPOSE: This program contains common user functions        *
*                                                             *
* MODIFICATIONS:                                              *
*                                                             *
***************************************************************

#include "INKEY.CH"
#include "BOX.CH"
#include "ERROR.CH"
#include "DOSERROR.CH"
#include "SET.CH"

*******************************************************************
*                                                                 *
*                          USER FUNCTIONS                         *
*                                                                 *
*******************************************************************
*
******************** FUNCTION CENTER ******************************
*!*********************************************************************
*!
*!       Function: CENTER()
*!
*!*********************************************************************
FUNCTION Center
PARAMETERS string,row_num
**********
*
* PURPOSE: Center a string on a 80 character line
* PARAMETERS:
*     string - A character string that is to be centered
*     row_num - The screen row where the string is to be printed
* RETURN VALUE:
*     The column where the string starts
*
***********
LOCAL col_num
col_num = 40 - INT(LEN(TRIM(string)) / 2)
@ row_num,col_num SAY TRIM(string)
RETURN col_num

******************** FUNCTION BELL   ******************************
*!*********************************************************************
*!
*!       Function: BELL()
*!
*!*********************************************************************
FUNCTION Bell
PARAMETERS junk
**********
*
* PURPOSE: Make a beeping sound
* PARAMETERS: none
* RETURN VALUE: none
*
***********
Tone(261.7,9)
RETURN nil

********************* FUNCTION VALYN    **************************
*!*********************************************************************
*!
*!       Function: VALYN()
*!
*!*********************************************************************
FUNCTION Valyn
PARAMETERS myn
**********
*
* PURPOSE: Validates a response as Y or N
* PARAMETERS:
*     MYN - The character string to be validated
* RETURN VALUE:
*     .T. if the value is Y or N
*     .F. if the value is other than Y or N
*         An error dialog box will be displayed
*
***********
IF UPPER(myn) = 'Y' .OR. UPPER(myn) = 'N'
   RETURN(.T.)
ELSE
   Msgdisp(c_msgcritl, ;
      'Value is invalid.', ;
      'Valid values are Y and N.', ;
      'Press any key to continue.' )
   RETURN(.F.)
ENDIF

********************* FUNCTION ACFUNC ********************************
*!*********************************************************************
*!
*!       Function: ACFUNC()
*!
*!*********************************************************************
FUNCTION Acfunc
PARAMETERS STATUS, element, position
**********
*
* FUNCTIONS: User function for ACHOICE - handles exception keys, etc.
* PARAMETERS:
*     STATUS   - The status of ACHOICE processing
*       0 = idle
*       1 = Cursor past top of list
*       2 = Cursor past end of list
*       3 = Keystroke exception
*       4 = No item selectable
*     ELEMENT  - The current element number in the array
*     POSITION - Relative position within the window
* RETURN VALUE:
*     0 = abort selection and return zero
*     1 = make selection returning index of current item
*     2 = continue selection process
*     3 = go to next item whose first character matches the last key
*         pressed
*
***********

LOCAL KEY
KEY = LASTKEY()

DO CASE
CASE STATUS = 0       && IDLE
   RETURN(2)           && CONTINUE PROCESSING
CASE STATUS = 1       && CURSOR PAST TOP OF LIST
   RETURN(2)           && CONTINUE PROCESSING
CASE STATUS = 2       && CURSOR PAST BOTTOM OF LIST
   RETURN(2)           && CONTINUE PROCESSING
CASE STATUS = 3       && KEYSTROKE EXCEPTION
   DO CASE
   CASE KEY = K_ESC
      RETURN(0)   && ABORT SELECTION AND RETURN ZERO
   CASE KEY = 13
      RETURN(1)   && SELECT CURRENT ITEM
   OTHERWISE
      RETURN(3)   && GO TO ITEM STARTING WITH THIS LETTER
   ENDCASE
CASE STATUS = 4       && NO ITEM SELECTABLE
   RETURN(0)           && ABORT SELECTION AND RETURN ZERO
ENDCASE

********************* Function MsgDisp ***************************
*!*********************************************************************
*!
*!       Function: MSGDISP()
*!
*!*********************************************************************
FUNCTION Msgdisp
PARAMETERS color_cd, msg1, msg2, msg3, msg4
**********
*
* PURPOSE: Displays a message box of up to 4 lines in color color_cd
* PARAMETERS:
*     color_cd - The color settings for the message box
*     msg1-4 - A character string that is to be centered
* RETURN VALUE:
*     .F. if the Esc key is pressed, .T. otherwise
*
***********

LOCAL sav_screen, row_pos, col_left, col_right, num_msgs, max_len, I
LOCAL top_row, bot_row, KEY, sv_color, sv_device
LOCAL msg[4]
sv_device := SET(_SET_DEVICE, 'SCREEN')    // Set device to screen
msg[1] := msg1
msg[2] := msg2
msg[3] := msg3
msg[4] := msg4
num_msgs := Pcount() - 1
sv_color := SETCOLOR(color_cd)
top_row := 10 - INT(num_msgs / 2)
bot_row := 14 + INT(num_msgs / 2)
max_len := LEN(TRIM(msg[1]))
I = 2
DO WHILE I <= num_msgs
   max_len = MAX(max_len, LEN(TRIM(msg[i])))
   I++
ENDDO
col_left = 38 - INT(max_len / 2)
col_right = 42 + INT(max_len / 2)
sav_screen := Shdwbox(top_row, col_left, bot_row, col_right, color_cd)
row_num = top_row + 2
I = 1
DO WHILE I <= num_msgs
   col_pos = 40 - INT(LEN(TRIM(msg[i])) / 2)
   @ row_num,col_pos SAY TRIM(msg[i])
   I++
   row_num++
ENDDO
Bell()
KEY := 0
FT_Mshowcrs()
DO WHILE KEY == 0
   KEY = INKEY(.1)
   IF FT_Mbutprs(0) > 0
      KEY := 1
   ENDIF
ENDDO
FT_Mhidecrs()
SETCOLOR(sv_color)
Restscreen(top_row, col_left, bot_row+1, col_right+1, sav_screen)
SET(_SET_DEVICE, sv_device)    // Set device back
IF KEY = K_ESC
   RETURN(.F.)
ELSE
   RETURN(.T.)
ENDIF

************************ FUNCTION paperlnd *********************
*!*********************************************************************
*!
*!       Function: PAPERLND(SETUP_11)()
*!
*!          Calls: DIALOGBOX()    (function  in ?)
*!
*!*********************************************************************
FUNCTION Paperlnd(setup_11)
**********
*
* PURPOSE: Displays a message to load 11 x 8 1/2 (Landscape) paper
* PARAMETERS:
*    Printer setup string for landscape paper
* RETURN VALUE:
*     .F. if the Esc key is pressed, .T. otherwise
*
***********

LOCAL go_on, msgs[1], colors[2], buttons[2], sv_device
msgs[1] := 'Place 11 X 8 1/2 (Landscape) paper in the printer.'
colors[1] := colors[2] := c_msgnote
buttons[1] := 'Continue'
buttons[2] := 'Cancel'
go_on := dialogbox(msgs, colors, buttons)
IF go_on == 2
   RETURN(.F.)
ENDIF

DO WHILE !Isprinter() .AND. go_on == 1
   msgs[1] := 'Printer is not ready - Correct the situation.'
   colors[1] := colors[2] := c_msgwarn
   buttons[1] := 'Retry'
   go_on := dialogbox(msgs, colors, buttons)
   IF go_on == 2
      RETURN(.F.)
   ENDIF
ENDDO

sv_device := SET(_SET_DEVICE, 'PRINTER')   // SAVE current DEVICE and SET TO PRINTER
@ 1,1 SAY setup_11
SET(_SET_DEVICE, sv_device)

RETURN(.T.)

************************ FUNCTION paperptr *********************
*!*********************************************************************
*!
*!       Function: PAPERPTR(SETUP_8_5)()
*!
*!          Calls: DIALOGBOX()    (function  in ?)
*!
*!*********************************************************************
FUNCTION Paperptr(setup_8_5)
**********
*
* PURPOSE: Displays a message to load 8 1/2 x 11 (Portrait) paper
* PARAMETERS:
*    Printer setup string for portrait paper
* RETURN VALUE:
*     .F. if the Esc key is pressed, .T. otherwise
*
***********

LOCAL go_on, msgs[1], colors[2], buttons[2], sv_device
msgs[1] := 'Place 8 1/2 x 11 (Portrait) paper in the printer.'
colors[1] := colors[2] := c_msgnote
buttons[1] := 'Continue'
buttons[2] := 'Cancel'
go_on := dialogbox(msgs, colors, buttons)
IF go_on == 2
   RETURN(.F.)
ENDIF

DO WHILE !Isprinter() .AND. go_on == 1
   msgs[1] := 'Printer is not ready - Correct the situation.'
   colors[1] := colors[2] := c_msgwarn
   buttons[1] := 'Retry'
   go_on := dialogbox(msgs, colors, buttons)
   IF go_on == 2
      RETURN(.F.)
   ENDIF
ENDDO

sv_device := SET(_SET_DEVICE, 'PRINTER')   // SAVE current DEVICE and SET TO PRINTER
@ 1,1 SAY setup_8_5
SET(_SET_DEVICE, sv_device)

RETURN(.T.)

*********************** PROCEDURE INITENVR **************************
*!*********************************************************************
*!
*!      Procedure: INITENVR
*!
*!*********************************************************************
PROCEDURE INITENVR
**********
*
* PURPOSE: Initializes environment to standard mode and initializes
*           some common variables
* PARAMETERS:
*     none
* RETURN VALUE:
*     none
*
***********

Errorblock( {|e| Rdberror(E)} )    // Invoke my error handler
SET DEVICE TO SCREEN
SET PRINT OFF
SET STATUS OFF
SET Bell OFF
SET CONFIRM OFF
SET DELETED ON
SET DELIMITERS OFF
SET EXACT ON
SET INTENSITY ON
SET TALK OFF
SET SAFETY OFF

PUBLIC help_level, callpgm, var, Bell, help_name, help_type
PUBLIC right_mark, esc_key
PUBLIC left_arrow, right_arrow, up_arrow, down_arrow, dbl_box
PUBLIC first_time, esc
PUBLIC clipper      && SET BY CLIPPER OR DBASEIII
PUBLIC rc_pgup, rc_forscr, rc_quit

STORE .T. TO first_time        && First time switch
STORE .F. TO esc               && Escape pressed?
STORE 0 TO help_level          && help level
STORE ' ' TO callpgm, var, help_name, help_type    && For help system
STORE CHR(7) TO Bell           && To sound the bell
esc_key = 27                   && Escape key
left_arrow = CHR(27)           && Left arrow key
right_arrow = CHR(26)          && Right arrow key
up_arrow = CHR(24)             && Up arrow key
down_arrow = CHR(25)           && Down arrow key
right_mark = CHR(251)          && Check mark for menu selection
dbl_box = CHR(201) + CHR(205) + CHR(187) + CHR(186) + CHR(188) + CHR(205) + ;
   CHR(200) + CHR(186) + ' '   && Filled in box with double lines
rc_pgup = 18                   && Page-up key
rc_forscr = 3                  && Page-down (forward screen) key
rc_quit = 27                   && Escape (quit) key

FT_Mreset()                    // Reset mouse routines

RETURN

***************************************************************
*!*********************************************************************
*!
*!       Function: CONVSTR(()
*!
*!*********************************************************************
FUNCTION Convstr( string )
**********                                                    *
*                                                             *
* PURPOSE: This function converts a string of decimal         *
*          values specified as nnn/nnn/... to a string of     *
*          characters CHR(nnn) + CHR(nnn) ...                 *
* PARAMETERS:                                                 *
*     Character variable containing a string of decimal       *
*     values specified as nnn/nnn/...                         *
* RETURN VALUE:                                               *
*     Character value of form CHR(nnn) + CHR(nnn)...          *
* MODIFICATIONS:                                              *
*                                                             *
*                                                             *
*                                                             *
***************************************************************

LOCAL slash := 0, char := '', string_wk := ''
LOCAL new_string := ''
string_wk = string
IF Right(string_wk,1) # '/'
   string_wk += '/'
ENDIF
slash = AT('/', string_wk)
DO WHILE slash > 1
   char = LEFT(string_wk, slash-1)
   new_string = new_string + CHR(VAL(char))
   string_wk = Right(string_wk, LEN(string_wk)-slash)
   slash = AT('/', string_wk)
ENDDO

RETURN(new_string)

****************** FUNCTION ShdwBox ******************************
*!*********************************************************************
*!
*!       Function: SHDWBOX(()
*!
*!          Calls: MAXROW()       (function  in ?)
*!               : MAXCOL()       (function  in ?)
*!
*!*********************************************************************
FUNCTION Shdwbox( top_row, col_left, bot_row, col_right, box_color)
**********
*
* PURPOSE: Draws a shadow box in color box_color
* PARAMETERS:
*    top_row - upper row of box
*    col_left - left-most column of box
*    bot_row - lower row of box (shadow extends one line below)
*    col_right - right-most column of box (shadow extends on column
*                to the right)
*    box_color - The color settings for the box
* RETURN VALUE:
*    The saved screen area displaced by the box
*
***********

LOCAL s_top_row, s_col_left, s_bot_row, s_col_right
LOCAL sv_color, sv_screen, dblbox
s_top_row := top_row + 1
s_col_left := col_left + 1
s_bot_row := bot_row + 1
s_col_right := col_right + 1
IF s_bot_row > maxrow()
   s_bot_row := maxrow()
ENDIF
IF s_col_right > maxcol()
   s_col_right := maxcol()
ENDIF
sv_screen = Savescreen(top_row, col_left, s_bot_row, s_col_right)
sv_color := SETCOLOR(box_color)   && Save old color and reset to box color

Restscreen( s_bot_row, col_left+1, s_bot_row, s_col_right,;
   TRANSFORM( Savescreen(s_bot_row, col_left+1, s_bot_row, s_col_right),;
   REPLICATE("X", s_col_right - col_left ) ) )

Restscreen( top_row+1, s_col_right, s_bot_row, s_col_right,;
   TRANSFORM( Savescreen(top_row+1, s_col_right , s_bot_row, s_col_right),;
   REPLICATE("X", s_bot_row - top_row ) ) )

dblbox := CHR(201) + CHR(205) + CHR(187) + CHR(186) + CHR(188) + ;
   CHR(205) + CHR(200) + CHR(186) + ' '
SETCOLOR(box_color)
@ top_row, col_left, bot_row, col_right BOX dblbox
SETCOLOR(sv_color)
RETURN(sv_screen)

********************** FUNCTION NormColor *****************************
*!*********************************************************************
*!
*!       Function: NORMCOLOR(USECOLOR)()
*!
*!          Calls: GAUGENEW()     (function  in ?)
*!
*!*********************************************************************
FUNCTION Normcolor(usecolor)
**********
*
* PURPOSE: Defines and sets color variables to normal IBM SAA colors
* PARAMETERS:
*    usecolor - logical variable indicating if we should use
*               color mode - .T. = use color, .F. = use black & white
* RETURN VALUE:
*    The color variables are declared PUBLIC
*
***********

PUBLIC c_bar, c_panel, c_pnlget, c_fkeys, c_msgnote, c_msgwarn, c_msgcritl
PUBLIC c_hlpbar, c_hlppnl, c_hlpget, c_hlpfkeys, c_hlpnote, c_hlpwarn, c_hlpcritl
PUBLIC c_popbar, c_poppnl, c_popget, c_popfkeys, c_popnote, c_popwarn, c_popcritl

IF usecolor
   *  COLOR DISPLAYS
   *  NORMAL PANELS
   c_bar = 'N/BG,BG/N,,,BG/N'           && ACTION BAR
   c_panel = 'B/W,W/GR,,,W/N'           && DISPLAY PANEL
   c_pnlget = 'N/W,W/GR,,,W/N'          && PANEL DURING GETS
   c_fkeys = 'N/W,W/N'                  && FUNCTION KEYS
   c_msgnote = 'N/W,W/N'                && NOTIFICATION MSGS
   c_msgwarn = 'N/GR+,GR+/N'            && WARNING MSGS
   c_msgcritl = 'W/R,R/W'               && CRITICAL MSGS
   *  HELP PANELS
   c_hlpbar = 'N/BG,BG/N,,,N/BG'        && ACTION BAR
   c_hlppnl = 'BG/B,B/GR+,,,B/BG'       && DISPLAY PANEL
   c_hlpget = 'W/B,B/GR+,,,B/W'         && PANEL DURING GETS
   c_hlpfkeys = 'W/B,B/W'               && FUNCTION KEYS
   c_hlpnote = 'N/W,W/N'                && NOTIFICATION MSGS
   c_hlpwarn = 'N/GR+,GR+/N'            && WARNING MSGS
   c_hlpcritl = 'W/R,R/W'               && CRITICAL MSGS
   *  POP UP WINDOWS
   c_popbar = 'N/W,W/N,,,N/W'           && ACTION BAR
   c_poppnl = 'B/BG,BG/CR+,,,BG/B'      && DISPLAY PANEL
   c_popget = 'N/BG,BG/CR+,,,BG/N'      && PANEL DURING GETS
   c_popfkeys = 'N/BG,BG/N'             && FUNCTION KEYS
   c_popnote = 'N/W,W/N'                && NOTIFICATION MSGS
   c_popwarn = 'N/GR+,GR+/N'            && WARNING MSGS
   c_popcritl = 'W/R,R/W'               && CRITICAL MSGS
ELSE
   *  MONOCHROME DISPLAYS
   *  NORMAL PANELS
   c_bar = 'N/W,W/N,,,N/W'              && ACTION BAR
   c_panel = 'W/N,N/W+,,,N/W'           && DISPLAY PANEL
   c_pnlget = 'W/N,N/W+,,,N/W'          && PANEL DURING GETS
   c_fkeys = 'W/N,N/W'                  && FUNCTION KEYS
   c_msgnote = 'W/N,N/W'                && NOTIFICATION MSGS
   c_msgwarn = 'W+/N,N/W+'              && WARNING MSGS
   c_msgcritl = 'N/W,W/N'               && CRITICAL MSGS
   *  HELP PANELS
   c_hlpbar = 'N/W,W/N,,,N/W'           && ACTION BAR
   c_hlppnl = 'W/N,N/W+,,,N/W'          && DISPLAY PANEL
   c_hlpget = 'W/N,N/W+,,,N/W'           && PANEL DURING GETS
   c_hlpfkeys = 'W/N,N/W'               && FUNCTION KEYS
   c_hlpnote = 'W/N,N/W'                && NOTIFICATION MSGS
   c_hlpwarn = 'W+/N,N/W+'              && WARNING MSGS
   c_hlpcritl = 'N/W,W/N'               && CRITICAL MSGS
   *  POP UP WINDOWS
   c_popbar = 'N/W,W/N,,,N/W'           && ACTION BAR
   c_poppnl = 'N/W,W+/N,,,N/W'          && DISPLAY PANEL
   c_popget = 'N/W,W+/N,,,N/W'          && PANEL DURING GETS
   c_popfkeys = 'N/W,W/N'               && FUNCTION KEYS
   c_popnote = 'N/W,W/N'                && NOTIFICATION MSGS
   c_popwarn = 'N/W+,W+/N'              && WARNING MSGS
   c_popcritl = 'W/N,N/W'               && CRITICAL MSGS
ENDIF

RETURN(nil)

/***
*  Gauge.prg
*
*  Sample functions to create, display, and update a percentage completed
*  progress gauge.  This function can be used for creating user interface
*  options such as a status bar to indicate the current status of a process.
*
*  Copyright (c) 1990, Nantucket Corp.  All rights reserved.
*  David R. Allison
*
*  Note: Compile with /W/N options
*
*/

// BOX array definitions
#define B_TOP           1
#define B_LEFT          2
#define B_BOTTOM        3
#define B_RIGHT         4
#define B_BACKCOLOR     5
#define B_BARCOLOR      6
#define B_DISPLAYNUM    7
#define B_BARCHAR       8
#define B_BOXLINES      "Ŀ"

/***
*  GaugeNew( <nRowTop>, <nColumnTop>, <nRowBottom>, <nColumnBottom>,
*     [<cBackgroundColor>],
*     [<cGaugeColor>],
*     [<cGaugeCharacter>] ) --> aGauge
*
*  Create a new gauge array
*
*/
*!*********************************************************************
*!
*!       Function: GAUGENEW(()
*!
*!          Calls: GAUGEDISPLAY() (function  in ?)
*!
*!*********************************************************************
FUNCTION gaugenew( ntop, nleft, nbottom, nright, ;
   cbackcolor, cbarcolor, cbarcharacter )
LOCAL ahandle := { ntop, nleft, nbottom, nright, ;
   "W/N", "W+/N", .T., CHR( 219 ) }
// resolve PARAMETERS
IF cbackcolor <> nil
   ahandle[ B_BACKCOLOR ] := cbackcolor
ENDIF
IF cbarcolor <> nil
   ahandle[ B_BARCOLOR ] := cbarcolor
ENDIF
IF cbarcharacter <> nil
   ahandle[ B_BARCHAR ] := cbarcharacter
ENDIF

// ok, the defaults are SET, now let's make sure it will fit on the
// SCREEN correctly
IF ahandle[ B_RIGHT ] < ahandle[ B_LEFT ] + 4
   ahandle[ B_RIGHT ] := ahandle[ B_LEFT ] + 4
ENDIF

IF ahandle[ B_BOTTOM ] < ahandle[ B_TOP ] + 2
   ahandle[ B_BOTTOM ] := ahandle[ B_TOP ] + 2
ENDIF

// determine IF we can fit the bracketed number ON TOP of the graph
IF ahandle[ B_RIGHT ] < ahandle[ B_LEFT ] + 9
   ahandle[ B_DISPLAYNUM ] := .F.
ENDIF

RETURN( ahandle )

/***
*  GaugeDisplay( aGauge ) --> aGauge
*  Display a gauge array to the screen
*
*/
*!*********************************************************************
*!
*!       Function: GAUGEDISPLAY(()
*!
*!          Calls: GAUGEUPDATE()  (function  in ?)
*!
*!*********************************************************************
FUNCTION gaugedisplay( ahandle )
LOCAL ncenter := ROUND((ahandle[ B_RIGHT ] - ahandle[ B_LEFT ]) / 2, 0 ) + 1
LOCAL coldcolor := SETCOLOR( ahandle[ B_BACKCOLOR ] )

@ ahandle[ B_TOP ], ahandle[ B_LEFT ] CLEAR TO ;
   ahandle[ B_BOTTOM ], ahandle[ B_RIGHT ]

@ ahandle[ B_TOP ], ahandle[ B_LEFT ], ;
   ahandle[ B_BOTTOM ], ahandle[ B_RIGHT ] BOX B_BOXLINES

IF ahandle[ B_DISPLAYNUM ]
   @ ahandle[ B_TOP ], ncenter SAY "[      ]"
ENDIF

SETCOLOR( coldcolor )

RETURN( ahandle )

/***
*  GaugeUpdate( aGauge, nPercent ) --> aGauge
*  Updates a gauge with a new progress value and redisplays the gauge
*  to the screen to the screen
*
*/
*!*********************************************************************
*!
*!       Function: GAUGEUPDATE(()
*!
*!          Calls: DIALOGBOX()    (function  in ?)
*!
*!*********************************************************************
FUNCTION gaugeupdate( ahandle, npercent )
LOCAL ncenter := ROUND((ahandle[ B_RIGHT ] - ahandle[ B_LEFT ]) / 2, 0 ) + 1
LOCAL coldcolor := SETCOLOR( ahandle[ B_BARCOLOR ] )
LOCAL nbarratio := (ahandle[ B_RIGHT ]) - (ahandle[ B_LEFT ] + 1)
LOCAL nrow := 0, ncols := 0

IF ahandle[ B_DISPLAYNUM ]
   @ ahandle[ B_TOP ], ncenter + 2 SAY STR( npercent * 100, 3 ) + "%"
ENDIF

IF npercent > 1
   npercent := 1
ENDIF

IF npercent < 0
   npercent := 0
ENDIF

ncols := ROUND( npercent * nbarratio, 0 )

@ ahandle[ B_TOP ] + 1, ahandle[ B_LEFT ] + 1 CLEAR TO ;
   ahandle[ B_BOTTOM ] - 1, ahandle[ B_RIGHT ] - 1

FOR nrow := 1 TO (ahandle[ B_BOTTOM ] - ahandle[ B_TOP ] - 1)
   @ nrow + ahandle[ B_TOP ], ahandle[ B_LEFT ] + 1 SAY ;
      REPLICATE( ahandle[ B_BARCHAR ], ncols )
NEXT

SETCOLOR( coldcolor )

RETURN( ahandle )

************************ FUNCTION DialogBox **************************

*!*********************************************************************
*!
*!       Function: DIALOGBOX(MSGARRAY,()
*!
*!          Calls: MAXROW()       (function  in ?)
*!               : MAXCOL()       (function  in ?)
*!               : ENHANCECOLOR() (function  in ?)
*!
*!*********************************************************************
FUNCTION dialogbox(msgarray, colorarray, buttonarray)
**********************************************************************
**
** Function: Display a dialog box, with action buttons, and get response
** Parameters:
**    MsgArray: An array containing the messages to be displayed in the
**              dialog boxes (must be single dimension array).
**    ColorArray: An array containing the colors to use as follows:
**           [1]: Color of the Dialog box
**           [2]: Color of non-selected buttons, selected buttons are
**                displayed in the enhanced color
**           Defaults for both are the current color
**    ButtonArray: An array containing text for the buttons to be displayed
** Returns: The number of the button selected, e.g. 1, or negative
**          number indicating the error that occured during processing.
**
**********************************************************************

#define  dblbox  CHR(201)+CHR(205)+CHR(187)+CHR(186)+CHR(188)+ ;
   CHR(205)+CHR(200)+CHR(186)+ ' '
#define  sglbox  ( CHR(218) + CHR(196) + CHR(191) + CHR(179) + ;
   CHR(217) + CHR(196) + CHR(192) + CHR(179)+ ' ' )


LOCAL lenmsgarray, boxsize, toprow, bottomrow, maxmsglen, lenbtnarray
LOCAL leftcol, rightcol, sv_color, sv_screen, I, totbtnlen, maxlen
LOCAL boxcolor, buttoncolor, buttonselcolor
LOCAL nextloc, btnrow, mbtnrow, mbtncol, nbtnsel, posmove
LOCAL btnloc[LEN(ButtonArray)]
LOCAL sv_device

// determine SIZE and location of dialog box.
lenmsgarray := LEN(msgarray)
lenbtnarray := LEN(buttonarray)
boxsize := lenmsgarray + 2 + 4 + 2
toprow := INT(maxrow() / 2) - INT(boxsize / 2)
IF toprow < 1
   RETURN(-1)              // BOX won't fit on screen
ENDIF
bottomrow := toprow + boxsize + 1  // includes ROW FOR shadow
IF bottomrow > maxrow()
   RETURN(-1)              // BOX won't fit on screen
ENDIF

// determine longest MESSAGE Line TO be displayed
maxmsglen := LEN( msgarray[1] )    // assume first Line is longest
I := 2
DO WHILE I <= lenmsgarray
   maxmsglen := MAX(LEN(msgarray[i]), maxmsglen)
   I++
ENDDO

// determine TOTAL length of buttons
totbtnlen := 0
I := 1
DO WHILE I <= lenbtnarray
   totbtnlen += LEN(buttonarray[i]) + 8
   I++
ENDDO
maxlen := MAX(maxmsglen, totbtnlen)

// determine Right and LEFT boundaries of BOX
leftcol := INT(maxcol() / 2) - INT(maxlen / 2) - 2
IF leftcol < 1
   RETURN(-1)         // BOX won't fit on screen
ENDIF
rightcol := leftcol + maxlen + 5  // includes COL FOR shadow
IF rightcol > maxcol()
   RETURN(-1)         // BOX won't fit on screen
ENDIF

// determine colors TO USE
IF TYPE(colorarray[1]) <> 'U'                 // COLOR of BOX
   boxcolor := colorarray[1]
ELSE
   boxcolor := SETCOLOR()
ENDIF
IF TYPE(colorarray[2]) <> 'U'                 // COLOR of normal buttons
   buttoncolor := colorarray[2]
ELSE
   boxcolor := SETCOLOR()
ENDIF
buttonselcolor := enhancecolor(buttoncolor)  // COLOR of selected buttons

// SAVE current ENVIRONMENT
sv_color := SETCOLOR(boxcolor)      // SAVE current COLOR & RESET TO BOX COLOR
sv_screen := Savescreen(toprow, leftcol, bottomrow, rightcol)  // SCREEN
sv_device := SET(_SET_DEVICE, 'SCREEN')    // Set device to screen

// draw the dialog BOX
Shdwbox(toprow, leftcol, bottomrow-1, rightcol-1, boxcolor)

// Display the messages
I := 1
DO WHILE I <= lenmsgarray
   Center(msgarray[i], toprow + 1 + I)
   I++
ENDDO

// determine locations FOR buttons
nextloc := leftbtn := INT(maxcol() / 2) - INT(totbtnlen / 2) + 2
I := 1
DO WHILE I <= lenbtnarray
   btnloc[i] := nextloc
   nextloc += LEN(buttonarray[i]) + 8
   I++
ENDDO

// Display the buttons
SETCOLOR(buttoncolor)
btnrow := toprow + 1 + lenmsgarray + 2
I := 1
DO WHILE I <= lenbtnarray
   @ btnrow, btnloc[i], btnrow+2, btnloc[i]+LEN(buttonarray[i])+3 BOX sglbox
   @ btnrow + 1, btnloc[i] + 2 SAY buttonarray[i]
   I++
ENDDO

// highlight A button and wait for a key or mouse button press
thisbtn := lastbtn := 1     // highlight first button TO start WITH
btnnotsel = .T.             // button selected?
DO WHILE btnnotsel          // DO until A button is selected
   // turn OFF previous button selection
   SETCOLOR(buttoncolor)
   @ btnrow, btnloc[LastBtn], btnrow+2, btnloc[LastBtn]+LEN(buttonarray[LastBtn])+3 BOX sglbox
   @ btnrow + 1, btnloc[LastBtn] + 2 SAY buttonarray[LastBtn]
   // turn ON this button selection
   SETCOLOR(buttonselcolor)
   @ btnrow, btnloc[ThisBtn], btnrow+2, btnloc[ThisBtn]+LEN(buttonarray[ThisBtn])+3 BOX dblbox
   @ btnrow + 1, btnloc[ThisBtn] + 2 SAY buttonarray[ThisBtn]
   SETCOLOR(boxcolor)
   KEY := 0
   FT_Mshowcrs()                 // Display mouse cursor
   DO WHILE KEY == 0
      KEY := INKEY(.1)           // WAIT FOR A KEY press
      IF key <> 0
         LOOP
      ENDIF
      IF FT_Mbutprs(0) > 0       // Have a mouse button pressed?
         DO WHILE FT_Mbutrel(0) == 0
         ENDDO
         // Determine which display button was selected
         mbtnrow := FT_MGetx()
         IF mbtnrow < btnrow .OR. mbtnrow > btnrow + 2  // Check if mouse in right rows
            LOOP
         ENDIF
         mbtncol := FT_MGety()    // Get mouse col
         nbtnsel := 0
         I := 1
         DO WHILE I <= lenbtnarray .AND. nbtnsel == 0
            IF mbtncol >= btnloc[I] .AND. mbtncol <= btnloc[I] + LEN(buttonarray[I])+3
               mbtnsel := I
            ENDIF
            I++
         ENDDO
         posmove := mbtnsel - thisbtn
         DO CASE
         CASE posmove == 0
            KEYBOARD CHR(K_ENTER)                      // select it
         CASE posmove > 0
            KEYBOARD REPLICATE(CHR(K_RIGHT), posmove) + ;  // Move to correct button
                     CHR(K_ENTER)                      // And then select it
         CASE posmove < 0
            KEYBOARD REPLICATE(CHR(K_LEFT), ABS(posmove)) + ;  // Move to correct button
                     CHR(K_ENTER)               // And then select it
         ENDCASE
      ENDIF
   ENDDO
   FT_Mhidecrs()                 // Hide mouse cursor
   DO CASE
   CASE KEY == K_ENTER .OR. KEY == K_ESC
      btnnotsel := .F.                 // indicate button selected
      btnselected := thisbtn           // RECORD which button
   CASE KEY == K_RIGHT .OR. KEY == K_TAB
      lastbtn := thisbtn
      thisbtn ++                       // move Up one button
      IF thisbtn > lenbtnarray
         thisbtn := 1                  // handle WRAP around
      ENDIF
   CASE KEY == K_LEFT .OR. KEY == K_SH_TAB
      lastbtn := thisbtn
      thisbtn --                       // move Back one button
      IF thisbtn < 1
         thisbtn := lenbtnarray        // handle WRAP around
      ENDIF
   ENDCASE
ENDDO

// RESTORE the ENVIRONMENT
SETCOLOR(sv_color)      // RESTORE original COLOR
Restscreen(toprow, leftcol, bottomrow, rightcol, sv_screen)  // RESTORE SCREEN
SET(_SET_DEVICE, sv_device)    // Set device back

RETURN btnselected

******************************************************************
*!*********************************************************************
*!
*!       Function: ENHANCECOLOR(COLOR)()
*!
*!          Calls: INDEXREL()     (function  in ?)
*!
*!*********************************************************************
FUNCTION enhancecolor(COLOR)
LOCAL regcolor, enhcolor, firstcomma, secondcomma
firstcomma := AT(',', COLOR)
secondcomma := AT(',', SUBSTR(COLOR, firstcomma + 1))
IF secondcomma == 0                 // If no 2nd comma
   secondcomma := LEN(COLOR) + 1    //    point past end of string
ENDIF
regcolor := LEFT(COLOR, firstcomma-1)       // standard COLOR
enhcolor := SUBSTR(COLOR, firstcomma + 1, secondcomma-1)     // Enhanced color

RETURN enhcolor + ',' + regcolor + SUBSTR(COLOR, firstcomma + secondcomma)



************************ FUNCTION INDEXREL *************************
*!*********************************************************************
*!
*!       Function: INDEXREL(REL_VAR,()
*!
*!*********************************************************************
FUNCTION indexrel(rel_var, db, return_var)
**********
*
* FUNCTIONS: Simulates using a SET RELATION and alias for indexing, e.g.
*               SET RELATION TO OECLNTNBR INTO CUSTDB
*               INDEX ON CUSTDB->CSTSLSMN
*            This is required because using an alias in an index
*            clause does not work at this time.
* PARAMETERS:
*    rel_var - the value of the relational variable, e.g. oeclntnbr
*    db - the database that is the object of the relation, e.g. CUSTDB
*    return_var - the name of the variable whose value is to be
*                 returned, e.g. CSTSLSMN
* RETURN VALUE:
*    The value of the variable indicated by return_var
*
***********

LOCAL last_area
last_area := SELECT()       && save area currently selected
SELECT (db)                 && select related database
SEEK rel_var                && seek the value passed
ret_value := &return_var    && get the value of the variable specified
SELECT (last_area)          && reselect original database
RETURN ret_value            && return specified variable

*: EOF: RDBFUNC.PRG
