***************************************************************
* Royce D. Bacon Clipper 5.0 Error System                     *
* (C)COPYRIGHT 1991 - Royce D. Bacon - RDB systems            *
*       CompuServe user-id = 70042,1001                       *
*       You are free to use this in your own programs.        *
*       You may make modifications to it if you like.         *
*       Any comments are welcome.                             *
* RDBERROR.PRG -  Version 1.02                                *
* AUTHOR: Royce D. Bacon, 06/91                               *
* PURPOSE: This program contains an error system for Clipper  *
*          5.01.                                              *
*                                                             *
*                                                             *
***************************************************************
*
****
*  Clipper 5.01 error handler
*  This error routine is based upon the error handler provided with
*  Clipper 5.0 with the following functionality added.
*     1. Printer errors are handled by displaying a dialog box that
*        allows a retry or cancel.
*     2. Zero divide condition is handled by displaying a message
*        and returning a value of zero
*     3. A file notfound error condition for a file with an extension of
*        NTX results in an error message suggesting a reindex of the
*        databases.
*     4. A file notfound error condition results in a message to make
*        sure you are in the right directory.
*     5. DOS error conditions result in an error message defining the
*        error condition and suggesting actions to resolve the problem
*        when possible.
*     6. An error message indicating the user procedure, line number
*        and error condition is displayed on the top line of the screen.
*     7. A file "ERRORMSG.ERR" is created that contains complete
*        error condition information.
*     8. The current record of each database in use is dumped to a
*        file named database.ERR.
*     9. The error message file (ERRORMSG.ERR) is printed.
*    10. The current screen is printed using the Tom Rettig Library
*        PRTSC function.
*
*****

#include "INKEY.CH"
#include "BOX.CH"
#include "ERROR.CH"
#include "DOSERROR.CH"
#include "SET.CH"

***
*       Errorrdb.prg
*       Clipper 5.01 error handler - As customized by Royce D. Bacon
*
***


/* put messages TO stderr */
#COMMAND ? <LIST,...>   =>  ?? CHR(13) + CHR(10) ; ?? <LIST>
#COMMAND ?? <LIST,...>  =>  outerr(<LIST>)
#COMMAND RETRY          =>  RETURN(.T.)        && Retry the operation
#COMMAND RESUME         =>  RETURN(.F.)        && Default recovery


/***
*       ErrorSys()
*
*       Note:  automatically executes at startup
*/

*!*********************************************************************
*!
*!      Procedure: ERRORSYS()
*!
*!          Calls: DIALOGBOX()    (function  in ?)
*!               : FILENAME()     (function  in ?)
*!               : SUBSYSTEM()    (function  in ?)
*!               : SUBCODE()      (function  in ?)
*!               : DESCRIPTION()  (function  in ?)
*!               : OPERATION()    (function  in ?)
*!
*!   Binary Files: PRTSC.BIN
*!
*!    Other Files: &FNAME
*!               : ERRORMSG.ERR
*!
*!*********************************************************************
PROC errorsys()
Errorblock( {|e| Rdberror(E)} )
RETURN


/***
*       RdbError()

****
FUNCTION Rdberror(E)
LOCAL I, msgs[2], colors[2], buttons[2], doitagain, reqretry
LOCAL name, Line, msg, fhandle, numwrite, lastarea, area, currec, fname

// for network open error, set NETERR() and subsystem default
IF ( e:genCode == EG_OPEN .and. e:osCode == 32 .and. e:canDefault )
   NetErr(.t.)
   RETURN (.f.)                                                                    // NOTE
ENDIF

// for lock error during APPEND BLANK, set NETERR() and subsystem default
IF ( e:genCode == EG_APPENDLOCK .and. e:canDefault )
   NetErr(.t.)
   RETURN (.f.)                                                                    // NOTE
ENDIF

**      Handle printer errors by displaying msg & retrying
IF ( E:gencode == EG_PRINT .AND. E:canretry )
   SET DEVICE TO SCREEN
   msgs[1] := 'Printer not ready!'
   msgs[2] := 'Correct the printer problem.'
   colors[1] := colors[2] := c_msgwarn
   buttons[1] := 'Retry'
   buttons[2] := 'Cancel'
   doitagain := dialogbox(msgs, colors, buttons)
   /* RETRY PRINT operation again */
   IF doitagain = 1
      SET DEVICE TO PRINTER
      RETRY
   ELSE
      RESUME
   ENDIF
ENDIF

**      Handle zero divides by display a message & substituting a zero
IF ( E:gencode == EG_ZERODIV .AND. E:cansubstitute )
   Msgdisp(c_msgwarn, 'Zero divide in '+ TRIM(Procname(1)) + ;
      "(" + Alltrim(STR(Procline(1))) + ")", ;
      'Substituting a zero for result - Results may be wrong!', ;
      'Press any key to continue.' )
   RETURN(0)
ENDIF

IF E:gencode == EG_OPEN .AND. E:oscode = DOS_NOTFOUND
   IF Right(TRIM(E:filename()),3) == 'NTX'
      Msgdisp(c_msgcritl, 'Index file ' + TRIM(E:filename()) + ' not found!', ;
         'Reindex the databases and try again.', ;
         'Press any key to continue.')
   ELSE
      Msgdisp(c_msgcritl, 'File ' + TRIM(E:filename()) + ' not found!', ;
         'Make sure you are in the correct directory.', ;
         'Press any key to continue.')
   ENDIF
ENDIF

IF E:oscode <> 0 .AND. E:canretry .AND. E:tries < 4
   doitagain := .T.
   msgs[1] := msgs[2] := ''
   DO CASE
   CASE E:oscode == DOS_NOTFOUND
      msgs[1] := 'File ' + TRIM(E:filename) + ' not found'
   CASE E:oscode == DOS_PATHNFND
      msgs[1] := 'Path ' + TRIM(E:filename) + ' not found or drive not ready'
   CASE E:oscode == DOS_2MANYFILES
      msgs[1] := 'Too many files open'
      msgs[2] := 'Increase FILES= in CONFIG.SYS or SET CLIPPER=F larger'
      doitagain := .F.
   CASE E:oscode == DOS_ACESDEND
      msgs[1] := 'Access to file ' + TRIM(E:filename) + ' denied.'
   CASE E:oscode == DOS_INSUFMEMORY
      msgs[1] := 'Insufficient memory available'
      msgs[2] := 'Unload any resident programs, etc.'
   CASE E:oscode == DOS_INVDRIVE
      msgs[1] := 'Invalid drive specified'
      doitagain := .F.
   CASE E:oscode == DOS_WRITPROTECT
      msgs[1] := 'Diskette is write protected - remove write protection'
   CASE E:oscode == DOS_DRIVENOTRDY
      msgs[1] := 'Drive not ready'
   CASE E:oscode == DOS_DATAERROR
      msgs[1] := 'Data error reading file ' + TRIM(E:filename)
   CASE E:oscode == DOS_SECNOTFND
      msgs[1] := 'Sector not found error reading file ' + TRIM(E:filename)
   CASE E:oscode == DOS_OUTOFPAPER
      msgs[1] := 'Printer out of paper'
   CASE E:oscode == DOS_WRITEFAULT
      msgs[1] := 'Write fault reading file ' + TRIM(E:filename)
   CASE E:oscode == DOS_READFAULT
      msgs[1] := 'Read fault reading file ' + TRIM(E:filename)
   CASE E:oscode == DOS_GENFAILURE
      msgs[1] := 'General failure reading file ' + TRIM(E:filename)
   CASE E:oscode == DOS_SHRVIOLATION
      msgs[1] := 'Not allowed to share file ' + TRIM(E:filename)
   CASE E:oscode == DOS_LOCKVIOLATION
      msgs[1] := 'File ' + TRIM(E:filename) + ' is locked'
   CASE E:oscode == DOS_INVDISKCHG
      msgs[1] := 'Invalid disk change'
   CASE E:oscode == DOS_NETWKNOSPRT
      msgs[1] := 'Network request not supported'
      doitagain := .F.
   CASE E:oscode == DOS_REMOTNOLISTEN
      msgs[1] := 'Remote computer not listening'
   CASE E:oscode == DOS_DUPNAMENTWRK
      msgs[1] := 'Duplicate name on the network'
   CASE E:oscode == DOS_NETNMNOTFND .OR. E:oscode = DOS_NETNAMNOFND
      msgs[1] := 'Network name not found'
   CASE E:oscode == DOS_NETBUSY
      msgs[1] := 'Network is busy'
   CASE E:oscode == DOS_NETDEVNOTEXIST
      msgs[1] := 'Network device no longer exists'
   CASE E:oscode == DOS_NETHDWERROR
      msgs[1] := 'Network adapter hardware error'
   CASE E:oscode == DOS_PRNQFULL
      msgs[1] := 'Network print queue full'
   CASE E:oscode == DOS_PRNNOSPACE
      msgs[1] := 'Not enough space for print file'
   CASE E:oscode == DOS_ACSDENIED
      msgs[1] := 'Access denied'
   CASE E:oscode == DOS_PAUSED
      msgs[1] := 'Network temporarily paused'
   CASE E:oscode == DOS_NETREDIRPAUSE
      msgs[1] := 'Network print or disk redirection temporarily paused'
   CASE E:oscode == DOS_FILEXISTS
      msgs[1] := 'File ' + TRIM(E:filename) + ' already exists'
   CASE E:oscode == DOS_NOTMD
      msgs[1] := 'Cannot make directory entry for file ' + TRIM(E:filename)
      doitagain := .F.
   OTHERWISE
      msgs[1] := 'Other DOS error'
   ENDCASE
   IF msgs[2] == ''
      Asize(msgs, 1)
   ENDIF
   buttons[1] := 'Cancel'
   IF doitagain
      buttons[2] := 'Retry'
   ELSE
      Asize(buttons, 1)
   ENDIF
   colors[1] := colors[2] := c_msgcritl
   reqretry := dialogbox(msgs, colors, buttons)
   IF doitagain .AND. reqretry = 2
      RETRY
   ENDIF
ENDIF

I := 2
** Find first user procedure with line numbers
DO WHILE ( !EMPTY(Procname(I)) ) .AND. Procline(I) = 0
   I++
ENDDO
IF ( !EMPTY(Procname(I)) ) .AND. Procline(I) <> 0
   name = Procname(I)
   Line = Procline(I)
ELSE
   ** Assume proc(1) is user procedure
   name = Procname(2)
   Line = Procline(2)
ENDIF

** Display message on line 0
msg = TRIM(E:description)
msg = msg + ' error in procedure ' + name + ' at line ' + STR(Line,6)
SET DEVICE TO SCREEN
@ 0,0 SAY msg

** Write a file "ERRORMSG.ERR" that contains error messages
fhandle = Fcreate("ERRORMSG.ERR", 0)
IF Ferror() <> 0              && error in writing file so use screen
   @  1,0 SAY 'Can not open ERRORMSG.ERR - DOS error = ' + STR(Ferror,3)
   ** **      /* put a message to STDOUT */
   ? "Error"

   IF ( !EMPTY(E:subsystem()) )
      ?? " " + E:subsystem() + "/" + LTRIM(STR(E:subcode()))
   ENDIF

   IF ( !EMPTY(E:description()) )
      ?? "  " + E:description()
   ENDIF

   IF ( !EMPTY(E:operation()) )
      ?? ": " + E:operation()
   ENDIF

   IF ( !EMPTY(E:filename()) )
      ?? ": " + E:filename()
   ENDIF

   IF ( E:gencode == EG_OPEN .OR. E:gencode == EG_CREATE )
      ?? "  (DOS error " + LTRIM(STR(E:oscode)) + ")"
   ENDIF

   *  /* Traceback */
   I := 1
   DO WHILE ( !EMPTY(Procname(I)) )
      ? "Called from ", TRIM(Procname(I)) + ;
         "(" + Alltrim(STR(Procline(I))) + ")  "

      I++
   ENDDO

   * Print the current screen
   * This uses the Tom Rettig Library function PRTSC
   * The Tom Rettig library has been released to the public domain
   * and is available on Compuserve in the Nantucket Forum, as well
   * as other locations.
   *
   * If you do not have the Tom Rettig library you may define the variable
   * NOTRLIB at compile time to skip this statement, e.g.
   *   CLIPPER RDBFUNC /DNOTRLIB
   *
   #ifndef NOTRLIB
      CALL prtsc          && Print the current screen using TR library
   #endif
   Errorlevel(1)
   QUIT

ENDIF

msg = 'Please provide this printout to the developer to assist in' + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Resolving the problem.' + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Program Version is '
Errorblock( {|e| Rdbverer(E)} )   // Special error block to handle undefined ver_number or ver_date
msg += ver_number + ' - '
msg += ver_date
msg += CHR(13) + CHR(10)
Errorblock( {|e| Rdberror(E)} )   // Back to normal error handler
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Error in procedure ' + name + ' at line ' + STR(Line,6) + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = "Subsystem is: " + E:subsystem + " / Code is: " + ;
   LTRIM(STR(E:subcode)) + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Error is: ' + E:description + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Generic error code is: ' + STR(E:gencode,6) + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
msg = 'Model of operation is: ' + E:operation + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))

IF ( !EMPTY(E:filename()) )
   msg = 'File with error = ' + E:filename() + CHR(13) + CHR(10)
   numwrite = Fwrite(fhandle, msg, LEN(msg))
ENDIF
IF ( E:gencode == EG_OPEN .OR. E:gencode == EG_CREATE )
   msg = '(DOS error ' + LTRIM(STR(E:oscode)) + ')' + CHR(13) + CHR(10)
   numwrite = Fwrite(fhandle, msg, LEN(msg))
ENDIF
msg = CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))

*  /* Traceback */
I := 1
DO WHILE ( !EMPTY(Procname(I)) )
   msg = "Called from " + TRIM(Procname(I)) + ;
      "(" + Alltrim(STR(Procline(I))) + ")  " + CHR(13) + CHR(10)
   numwrite = Fwrite(fhandle, msg, LEN(msg))

   I++
ENDDO

*  Dump database information
msg = CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))
lastarea = SELECT()
msg = 'Current selected area is ' + STR(lastarea,3) + ' - Database is ' + ALIAS(lastarea)
msg = msg + CHR(13) + CHR(10)
numwrite = Fwrite(fhandle, msg, LEN(msg))

area = 1
DO WHILE area < 13
   IF LEN(ALIAS(area)) <> 0
      SELECT (area)
      msg = CHR(13) + CHR(10)
      numwrite = Fwrite(fhandle, msg, LEN(msg))
      msg = 'Area ' + STR(area,2) + ' contains database ' + ALIAS(area) + CHR(13) + CHR(10)
      numwrite = Fwrite(fhandle, msg, LEN(msg))
      currec = RECNO()
      msg = 'Current record number is ' + STR(currec,5) + CHR(13) + CHR(10)
      numwrite = Fwrite(fhandle, msg, LEN(msg))
      fname = ALIAS(area) + '.ERR'
      msg = "You may display this record by entering TYPE " + fname + CHR(13) + CHR(10)
      numwrite = Fwrite(fhandle, msg, LEN(msg))
      COPY TO &fname FOR RECNO() = currec SDF
   ELSE
      msg = 'Area ' + STR(area,2) + ' not in use ' + CHR(13) + CHR(10)
      numwrite = Fwrite(fhandle, msg, LEN(msg))
   ENDIF
   area = area + 1
ENDDO
Fclose(fhandle)
SELECT (lastarea)

** Print the error message file for them
EJECT
SET CONSOLE OFF
SET DEVICE TO PRINTER
TYPE errormsg.err TO PRINTER

@ PROW()+2,1 SAY REPLICATE('=',20) + ' CURRENT SCREEN ' + REPLICATE('=',20)
* Print the current screen
* This uses the Tom Rettig Library function PRTSC
* The Tom Rettig library has been released to the public domain
* and is available on Compuserve in the Nantucket Forum, as well
* as other locations.
*
* If you do not have the Tom Rettig library you may define the variable
* NOTRLIB at compile time to skip this statement, e.g.
*   CLIPPER RDBFUNC /DNOTRLIB
*
#ifndef NOTRLIB
   CALL prtsc          && Print the current screen using TR library
#endif
SET DEVICE TO SCREEN
SET CONSOLE ON
EJECT

Errorlevel(1)
QUIT

******************** FUNCTION Rdbverer ****************************
STATIC FUNC Rdbverer(E)
*
* Handles situation where ver_number or ver_date are undefined
* It defines those variables as public
*
PUBLIC ver_number := 'Unknown', ver_date := 'Unknown'
RETURN(.T.)    //Retry operation

