/***
*       inkey.ch
*       Standard INKEY() key-code definitions
*       Copyright (c) 1990 Nantucket Corp.  All rights reserved.
*/

// Cursor movement keys
#define K_UP                    5               // Uparrow, Ctrl-E
#define K_DOWN                  24              // Dnarrow, Ctrl-X
#define K_LEFT                  19              // Leftarrow, Ctrl-S
#define K_RIGHT                 4               // Rightarrow, Ctrl-D
#define K_HOME                  1               // Home, Ctrl-A
#define K_END                   6               // End, Ctrl-F
#define K_PGUP                  18              // PgUp, Ctrl-R
#define K_PGDN                  3               // PgDn, Ctrl-C
#define K_CTRL_LEFT             26              // Ctrl-Leftarrow, Ctrl-Z
#define K_CTRL_RIGHT    2               // Ctrl-Rightarrow, Ctrl-B
#define K_CTRL_HOME             29              // Ctrl-Home, Ctrl-]
#define K_CTRL_END              23              // Ctrl-End, Ctrl-W
#define K_CTRL_PGUP             31              // Ctrl-PgUp, Ctrl-Hyphen
#define K_CTRL_PGDN             30              // Ctrl-PgDn, Ctrl-^
#define K_CTRL_RET              10              // Ctrl-Return

#define K_ESC                   27              // Esc, Ctrl-[
#define K_RETURN                13              // Return, Ctrl-M
#define K_ENTER                 13              // Enter, Ctrl-M


// Editing keys
#define K_INS                   22              // Ins, Ctrl-V
#define K_DEL                   7               // Del, Ctrl-G
#define K_BS                    8               // Backspace, Ctrl-H
#define K_CTRL_BS               127             // Ctrl-Backspace
#define K_TAB                   9               // Tab, Ctrl-I
#define K_SH_TAB                271             // Shift-Tab


// Control keys
#define K_CTRL_A                1               // Ctrl-A, Home
#define K_CTRL_B                2               // Ctrl-B, Ctrl-Rightarrow
#define K_CTRL_C                3               // Ctrl-C, PgDn, Ctrl-ScrollLock
#define K_CTRL_D                4               // Ctrl-D, Rightarrow
#define K_CTRL_E                5               // Ctrl-E, Uparrow
#define K_CTRL_F                6               // Ctrl-F, End
#define K_CTRL_G                7               // Ctrl-G, Del
#define K_CTRL_H                8               // Ctrl-H, Backspace
#define K_CTRL_I                9               // Ctrl-I, Tab
#define K_CTRL_J                10              // Ctrl-J
#define K_CTRL_K                11              // Ctrl-K
#define K_CTRL_L                12              // Ctrl-L
#define K_CTRL_M                13              // Ctrl-M, Return
#define K_CTRL_N                14              // Ctrl-N
#define K_CTRL_O                15              // Ctrl-O
#define K_CTRL_P                16              // Ctrl-P
#define K_CTRL_Q                17              // Ctrl-Q
#define K_CTRL_R                18              // Ctrl-R, PgUp
#define K_CTRL_S                19              // Ctrl-S, Leftarrow
#define K_CTRL_T                20              // Ctrl-T
#define K_CTRL_U                21              // Ctrl-U
#define K_CTRL_V                22              // Ctrl-V, Ins
#define K_CTRL_W                23              // Ctrl-W, Ctrl-End
#define K_CTRL_X                24              // Ctrl-X, Dnarrow
#define K_CTRL_Y                25              // Ctrl-Y
#define K_CTRL_Z                26              // Ctrl-Z, Ctrl-Leftarrow


// Alt keys
#define K_ALT_A                 286             // Alt-A
#define K_ALT_B                 304             // Alt-B
#define K_ALT_C                 302             // Alt-C
#define K_ALT_D                 288             // Alt-D
#define K_ALT_E                 274             // Alt-E
#define K_ALT_F                 289             // Alt-F
#define K_ALT_G                 290             // Alt-G
#define K_ALT_H                 291             // Alt-H
#define K_ALT_I                 279             // Alt-I
#define K_ALT_J                 292             // Alt-J
#define K_ALT_K                 293             // Alt-K
#define K_ALT_L                 294             // Alt-L
#define K_ALT_M                 306             // Alt-M
#define K_ALT_N                 305             // Alt-N
#define K_ALT_O                 280             // Alt-O
#define K_ALT_P                 281             // Alt-P
#define K_ALT_Q                 272             // Alt-Q
#define K_ALT_R                 275             // Alt-R
#define K_ALT_S                 287             // Alt-S
#define K_ALT_T                 276             // Alt-T
#define K_ALT_U                 278             // Alt-U
#define K_ALT_V                 303             // Alt-V
#define K_ALT_W                 273             // Alt-W
#define K_ALT_X                 301             // Alt-X
#define K_ALT_Y                 277             // Alt-Y
#define K_ALT_Z                 300             // Alt-Z

// Function keys
#define K_F1                    28              // F1, Ctrl-\
#define K_F2                    -1              // F2
#define K_F3                    -2              // F3
#define K_F4                    -3              // F4
#define K_F5                    -4              // F5
#define K_F6                    -5              // F6
#define K_F7                    -6              // F7
#define K_F8                    -7              // F8
#define K_F9                    -8              // F9
#define K_F10                   -9              // F10

// Control-function keys
#define K_CTRL_F1       -20             // Ctrl-F1
#define K_CTRL_F2       -21             // Ctrl-F2
#define K_CTRL_F3       -22             // Ctrl-F4
#define K_CTRL_F4       -23             // Ctrl-F3
#define K_CTRL_F5       -24             // Ctrl-F5
#define K_CTRL_F6       -25             // Ctrl-F6
#define K_CTRL_F7       -26             // Ctrl-F7
#define K_CTRL_F8       -27             // Ctrl-F8
#define K_CTRL_F9       -28             // Ctrl-F9
#define K_CTRL_F10      -29             // Ctrl-F10

// Alt-function keys
#define K_ALT_F1                -30             // Alt-F1
#define K_ALT_F2                -31             // Alt-F2
#define K_ALT_F3                -32             // Alt-F3
#define K_ALT_F4                -33             // Alt-F4
#define K_ALT_F5                -34             // Alt-F5
#define K_ALT_F6                -35             // Alt-F6
#define K_ALT_F7                -36             // Alt-F7
#define K_ALT_F8                -37             // Alt-F8
#define K_ALT_F9                -38             // Alt-F9
#define K_ALT_F10               -39             // Alt-F10

// Shift-function keys
#define K_SH_F1                 -10             // Shift-F1
#define K_SH_F2                 -11             // Shift-F2
#define K_SH_F3                 -12             // Shift-F3
#define K_SH_F4                 -13             // Shift-F4
#define K_SH_F5                 -14             // Shift-F5
#define K_SH_F6                 -15             // Shift-F6
#define K_SH_F7                 -16             // Shift-F7
#define K_SH_F8                 -17             // Shift-F8
#define K_SH_F9                 -18             // Shift-F9
#define K_SH_F10                -19             // Shift-F10

//     lower-case definitions
// cursor movement keys
#define k_up                    5               // Uparrow, Ctrl-E
#define k_down                  24              // Dnarrow, Ctrl-X
#define k_left                  19              // Leftarrow, Ctrl-S
#define k_right                 4               // Rightarrow, Ctrl-D
#define k_home                  1               // Home, Ctrl-A
#define k_end                   6               // End, Ctrl-F
#define k_pgup                  18              // PgUp, Ctrl-R
#define k_pgdn                  3               // PgDn, Ctrl-C
#define k_ctrl_left             26              // Ctrl-Leftarrow, Ctrl-Z
#define k_ctrl_right    2               // Ctrl-Rightarrow, Ctrl-B
#define k_ctrl_home             29              // Ctrl-Home, Ctrl-]
#define k_ctrl_end              23              // Ctrl-End, Ctrl-W
#define k_ctrl_pgup             31              // Ctrl-PgUp, Ctrl-Hyphen
#define k_ctrl_pgdn             30              // Ctrl-PgDn, Ctrl-^
#define k_ctrl_ret              10              // Ctrl-Return

#define k_esc                   27              // Esc, Ctrl-[
#define k_return                13              // Return, Ctrl-M
#define k_enter                 13              // Enter, Ctrl-M


// editing keys
#define k_ins                   22              // Ins, Ctrl-V
#define k_del                   7               // Del, Ctrl-G
#define k_bs                    8               // Backspace, Ctrl-H
#define k_ctrl_bs               127             // Ctrl-Backspace
#define k_tab                   9               // Tab, Ctrl-I
#define k_sh_tab                271             // Shift-Tab


// control keys
#define k_ctrl_a                1               // Ctrl-A, Home
#define k_ctrl_b                2               // Ctrl-B, Ctrl-Rightarrow
#define k_ctrl_c                3               // Ctrl-C, PgDn, Ctrl-ScrollLock
#define k_ctrl_d                4               // Ctrl-D, Rightarrow
#define k_ctrl_e                5               // Ctrl-E, Uparrow
#define k_ctrl_f                6               // Ctrl-F, End
#define k_ctrl_g                7               // Ctrl-G, Del
#define k_ctrl_h                8               // Ctrl-H, Backspace
#define k_ctrl_i                9               // Ctrl-I, Tab
#define k_ctrl_j                10              // Ctrl-J
#define k_ctrl_k                11              // Ctrl-K
#define k_ctrl_l                12              // Ctrl-L
#define k_ctrl_m                13              // Ctrl-M, Return
#define k_ctrl_n                14              // Ctrl-N
#define k_ctrl_o                15              // Ctrl-O
#define k_ctrl_p                16              // Ctrl-P
#define k_ctrl_q                17              // Ctrl-Q
#define k_ctrl_r                18              // Ctrl-R, PgUp
#define k_ctrl_s                19              // Ctrl-S, Leftarrow
#define k_ctrl_t                20              // Ctrl-T
#define k_ctrl_u                21              // Ctrl-U
#define k_ctrl_v                22              // Ctrl-V, Ins
#define k_ctrl_w                23              // Ctrl-W, Ctrl-End
#define k_ctrl_x                24              // Ctrl-X, Dnarrow
#define k_ctrl_y                25              // Ctrl-Y
#define k_ctrl_z                26              // Ctrl-Z, Ctrl-Leftarrow


// alt keys
#define k_alt_a                 286             // Alt-A
#define k_alt_b                 304             // Alt-B
#define k_alt_c                 302             // Alt-C
#define k_alt_d                 288             // Alt-D
#define k_alt_e                 274             // Alt-E
#define k_alt_f                 289             // Alt-F
#define k_alt_g                 290             // Alt-G
#define k_alt_h                 291             // Alt-H
#define k_alt_i                 279             // Alt-I
#define k_alt_j                 292             // Alt-J
#define k_alt_k                 293             // Alt-K
#define k_alt_l                 294             // Alt-L
#define k_alt_m                 306             // Alt-M
#define k_alt_n                 305             // Alt-N
#define k_alt_o                 280             // Alt-O
#define k_alt_p                 281             // Alt-P
#define k_alt_q                 272             // Alt-Q
#define k_alt_r                 275             // Alt-R
#define k_alt_s                 287             // Alt-S
#define k_alt_t                 276             // Alt-T
#define k_alt_u                 278             // Alt-U
#define k_alt_v                 303             // Alt-V
#define k_alt_w                 273             // Alt-W
#define k_alt_x                 301             // Alt-X
#define k_alt_y                 277             // Alt-Y
#define k_alt_z                 300             // Alt-Z

// function keys
#define k_f1                    28              // F1, Ctrl-\
#define k_f2                    -1              // F2
#define k_f3                    -2              // F3
#define k_f4                    -3              // F4
#define k_f5                    -4              // F5
#define k_f6                    -5              // F6
#define k_f7                    -6              // F7
#define k_f8                    -7              // F8
#define k_f9                    -8              // F9
#define k_f10                   -9              // F10

// control-function keys
#define k_ctrl_f1       -20             // Ctrl-F1
#define k_ctrl_f2       -21             // Ctrl-F2
#define k_ctrl_f3       -22             // Ctrl-F4
#define k_ctrl_f4       -23             // Ctrl-F3
#define k_ctrl_f5       -24             // Ctrl-F5
#define k_ctrl_f6       -25             // Ctrl-F6
#define k_ctrl_f7       -26             // Ctrl-F7
#define k_ctrl_f8       -27             // Ctrl-F8
#define k_ctrl_f9       -28             // Ctrl-F9
#define k_ctrl_f10      -29             // Ctrl-F10

// alt-function keys
#define k_alt_f1                -30             // Alt-F1
#define k_alt_f2                -31             // Alt-F2
#define k_alt_f3                -32             // Alt-F3
#define k_alt_f4                -33             // Alt-F4
#define k_alt_f5                -34             // Alt-F5
#define k_alt_f6                -35             // Alt-F6
#define k_alt_f7                -36             // Alt-F7
#define k_alt_f8                -37             // Alt-F8
#define k_alt_f9                -38             // Alt-F9
#define k_alt_f10               -39             // Alt-F10

// shift-function keys
#define k_sh_f1                 -10             // Shift-F1
#define k_sh_f2                 -11             // Shift-F2
#define k_sh_f3                 -12             // Shift-F3
#define k_sh_f4                 -13             // Shift-F4
#define k_sh_f5                 -14             // Shift-F5
#define k_sh_f6                 -15             // Shift-F6
#define k_sh_f7                 -16             // Shift-F7
#define k_sh_f8                 -17             // Shift-F8
#define k_sh_f9                 -18             // Shift-F9
#define k_sh_f10                -19             // Shift-F10

