EXTEND.F

#  EXTEND.F (ratfor)
#
#  Defines and externs for interfacing with Clipper from C.
#
#  Large model FORTRAN library (double word pointers to code
#  and data).
#
#  Copyright (c) 1988 Nantucket Corporation
#

define clipper         void pascal

#   parinfo types
define undef           0
define character       1
define numeric         2
define logical         4
define date            8
define alias           16
define mptr            32              
define memo            65
define word            128
define array           512

#       Parameter count/type.
        interface tofunction prinfo
     +          [c,alias:'__parinfo']
     +          (n)
        integer*2 n,prinfo
        end

        interface to function prinfa
     +          [c, alias: '__parinfa']
     +          (i, j)
        integer*2 i, j, prinfa
        end


#       Parameter values.
        interface to function parc
     +          [c, varying, alias:'__parc']
     +          (n)
        integer*2 n 
        locfar(n) parc
        end


        interface to function parcsiz
     +          [c, varying, alias:'__parcsiz']
     +          (n)
                integer*2 n, parcsiz
        end

        interface to function parclen
     +          [c, varying, alias:'__parclen']
     +          (n)
        integer*2 n, parclen
        end

        interface to function parni
     +          [c, varying, alias:'__parni']
     +          (n)
        integer*2 n, parni
        end

        interface to function parnl
     +          [c, varying, alias:'__parnl']
     +          (n)
        integer*4 n
        integer*2 parnl
        end

        interface to function parnd
     +          [c, varying, alias:'__parnd']
     +          (n)
        integer*2 n
        real*8 parnd
        end

        interface to function parl
     +          [c, varying, alias:'__parl']
     +          (n)
        integer*2 n, parl
        end

        interface to function pards
     +          [c, varying, alias:'_pards']
     +          (n)
        integer*2 n
        locfar(n) pards
        end


# One and only one of the ret?? funtions must be used.
#
#       Clipper function return values.

        interface to subroutine retc
     +          [c, alias:'__retc']
     +          (locfar(i))
        character*n i
        end

        interface to subroutine rclen
     +          [c, alias:'__retclen']
     +          (locfar(n))
        integer*2 n
        end

        interface to subroutine retni
     +          [c, alias:'__retni']
     +          (n)
        integer*2 n
        end

        interface to subroutine retnl
     +          [c, alias:'__retnl']
     +          (n)
        integer*4 n
        end

        interface to subroutine retnd
     +          [c, alias:'__retnd']
     +          (n)
        real*8 n
        end

        interface to subroutine retl
     +          [c, alias:'__retl']
     +          (n)
        integer*2 n
        end

        interface to subroutine retds
     +          [c, alias:'__retds']
     +          (locfar(str))
        character*n str
        end

#       procedure (do) return

        interface to subroutine ret
     +          [c, alias:'__ret']
        end



#       Allocate memory.
#       Parameter: requested size in bytes.
#       Returns far pointer to memory or null.

        interface to function xmgrab
     +          [c, alias:'__exmgrab']
     +          (n)
        integer*2 n
        character*1 m
        locfar(m) xmgrab
        end

#   Free allocated memory.
#   Parameters: pointer from exmgrab(), same size passed
#   to exmgrab().

        interface to subroutine xmback
     +          [c, alias:'__exmback']
     +          (locfar(i), j)
        character*1 i
        integer*2 j
        end


#   Parameter check macros.
define pcount          (pinfo(0))
define ischar(n)       (pinfo(n) .and. character)
define isnum(n)        (pinfo(n) .and. numeric)
define islog(n)        (pinfo(n) .and. logical)
define isdate(n)       (pinfo(n) .and. date)
define ismemo(n)       (pinfo(n) .and. memo)
define isbyref(n)      (pinfo(n) .and. mptr)
define isarray(n)      (pinfo(n) .and. array)
define alength(n)      (pinfa(n, 0))

#   Header structure.
common /dbfblk/sig,ymd,lrec,data_off,rec_size,pad
character*1  sig
character*3  ymd
integer*4    lrec
integer*2    data_off
integer*2    rec_size
character*20 pad(20)
