*************************************************************************
****                                                                 ****
*                      RANDOM number generator                          *
****                                                                 ****
*************************************************************************
*
*
* COPYRIGHT 1988 by GALES FERRY SOFTWARE COMPANY
*                   PO BOX 592
*                   GALES FERRY, CT 06335


* RESERVED: rseed - GLOBAL
*           rnd   - GLOBAL

* Call:
*    rseed set to zero or some seed value
* Return:
*    rnd set to new random value


    * if random seed is less than zero or if it is equal to zero
    *    then reseed - this function won't work otherwise
    IF rseed<=0
        rseed=VAL(RIGHT(TIME(),2))
    ENDIF
    *
    * Begin recalculating new seed. First multiply by PI;
    * Second, multiply by some number between 900 and 960.
    * By multiplying by 900 or so, the number will roll over nicer.
    rseed=(3.14159*RSEED)*(900+VAL(RIGHT(TIME(),2)))

    * Next, take the log of the seed. Since we're going to use only
    *   the fractional part of the result, this helps stir up the
    *   random pot.
    * Finally, multiply by 39. This moves the distribution from the 0 - 3
    *   range,  to the 0 - 9 range, but not as predictable as with a small
    *   integer.
    rseed=LOG(rseed)*39
    rseed=rseed-INT(rseed)

    rnd=rseed

RETURN
