* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program..: RANDOM12.PRG & rnd() function                                    *
* Author...: Ken Rockson                                                      *
* Date.....: 05-28-1990                                                       *
* Copyright: This program is hereby donated to the public domain.             *
*                                                                             *
* Notes....: This function generates a different psuedo-random number between *
*            1 and the number passed it for each iteration.  It seeds with    *
*            the internal clock.  It is based on Allen Jackson's RANDOM.PRG,  *
*            but uses recursive non-linear feedback of the resulting numbers  *
*            to create unique, non-repeating numbers with a fairly smooth     *
*            distribution (within 0.8%). I've also included a benchmark       *
*            routine so that you can play with it and maybe improve it. Also  *
*            included is the original RANDOM.PRG. I don't think Allen Jackson *
*            will mind. If you know him, please send this to him.             *
*                                                                             *
*            If you use have any questions or comments, or make improvements, *
*            call or write me at:                                             *
*                                                                             *
*            The Animation Station                                            *
*            (416) 443-8670 (voice)                                           *
*            150 Graydon Hall Drive, Suite 2602                               *
*            Don Mills, Ontario, Canada M3A 3B3                               *
*                                                                             *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

* Here's the info from the top of Allen Jackson's program:

* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program..: RANDOM.PRG v 1.1                                                 *
* Author...: Allen Jackson                                                    *
* Date.....: 05-28-1990                                                       *
* Copyright: This program is hereby donated to the public domain.             *
*                                                                             *
* Notes....: This program generates a different psuedo-random number between  *
*            0 and 1 for each iteration.  It generates a different number     *
*            each second because the seed used is based on the internal       *
*            clock.  Originally, I had implemented it as a function, but      *
*            some dBASE dialects could not handle it.  Implementation as a    *
*            function is left to the user.                                    *
*                                                                             *
*            I know there are ways to generate the numbers quicker, but I've  *
*            not yet found a way other than this that works in EVERY dialect. *
*            For example, FoxPro now includes a RAND() function that is far   *
*            superior to this kludge.                                         *
*                                                                             *
*            If you use this program and have any questions or comments,      *
*            drop me a note at:                                               *
*                                                                             *
*                             MCS Consulting                                  *
*                             8125 Starwood Court                             *
*                             Baton Rouge, LA  70820                          *
*                                                                             *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

declare i[10]
afill(i,0)
lastnum=0
lastask=0
DO WHILE .T.
consec=0
lc=0
for x=1 to 6000
   ln=lastnum
   y=rnd(10)                    && Randomly draw a number from 1 to 10.
   i[y]=i[y]+1                  && Count number of 1's, 2's, etc. drawn.
   if y=ln
     lc=lc+1
     if lc>consec               && Count consecutive numbers.
       consec=lc
     endif
   endif
 next x
 ?
 it=0
 for x=1 to 10                  && Display running count of 1's, 2's, etc.
   ?? str(i[x],7)
   it=it+i[x]
 next x
 ?
 for x=1 to 10                  && Display percentage content of 1's, etc.
   ?? str(i[x]/it*100,7,2)
 next x
 ?? str(consec,4)               && Display number of consecutive numbers
ENDDO                           && drawn on this pass.                   
RETURN



function rnd

* Draw a number from one to (oneto).

parameter oneto

   * If this is a repeat request for a certain range, seed with the last
   * number drawn. Otherwise, seed with hundreths of a second.

   if lastask=oneto
     lastnum=(mOD(lastnum*lastnum*7137421+21132487, 10000000)/ 10000000*oneto)+1
   else
     lastnum=(mOD(seconds()*7137421+21132487,10000000)/10000000*oneto)+1
   endif
   lastask=oneto
   return lastnum


