* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
* Program..: RANDOM.PRG v 1.1                                                 *
* Author...: Allen Jackson                                                    *
* Date.....: 05-28-1990                                                       *
* Copyright: This program is hereby donated to the public domain.             *
*                                                                             *
* Notes....: This program generates a different psuedo-random number between  *
*            0 and 1 for each iteration.  It generates a different number     *
*            each second because the seed used is based on the internal       *
*            clock.  Originally, I had implemented it as a function, but      *
*            some dBASE dialects could not handle it.  Implementation as a    *
*            function is left to the user.                                    *
*                                                                             *
*            I know there are ways to generate the numbers quicker, but I've  *
*            not yet found a way other than this that works in EVERY dialect. *
*            For example, FoxPro now includes a RAND() function that is far   *
*            superior to this kludge.                                         *
*                                                                             *
*            If you use this program and have any questions or comments,      *
*            drop me a note at:                                               *
*                                                                             *
*                             MCS Consulting                                  *
*                             8125 Starwood Court                             *
*                             Baton Rouge, LA  70820                          *
*                                                                             *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

CLEAR
SET TALK OFF
SET ESCAPE ON
SET BELL OFF
SET DECIMAL TO 0

DO WHILE .T.

   * Wait for clock to change to insure good seeds
   currtime = TIME()
   DO WHILE TIME() = currtime  
   ENDDO

   t = TIME()
   seed = VAL(SUBSTR(t,1,2)+SUBSTR(t,4,2)+SUBSTR(t,7,2))
   rnd = MOD(seed*7137421+21132487,10000000)/10000000

   * 'rnd' is a number between 0 and 1
   * Set 'randomnum' equal to '(rnd() * x)' where 'x' is the number you
   * want to use as the maximum number to be generated.  For example:
   
   randomnum = rnd * 3  
   @ 12,32 SAY randomnum

ENDDO

RETURN
