do startup

private _hand, _pick1, _pick2, _pick3, _help,  _mode, _active,     ;
        _btr, _blc, _bbr, _brc, _b1, _b2, _b3, _b4, _b5, _b6, _b7, ;
        _mess, _first

* set help string
*------------------
_help = []

* open help files
*-----------------
_hand = fopen("raffat.hyp",0)

if ferror() != 0

    * no help available
    *--------------------
    mainlog[3] = .f.

    m_csroff()
    scroll(07,20,09,60,0,funcolor[3])
    box(07,20,09,60,m_frame(),funcolor[3],m_data(16),m_data(17))
    _temp = "Help is Unavailable"
    print(08,d_center(_temp,20,60),_temp,funcolor[3])


endif



* demo database
*---------------------
if !file("demo.dbf")
    d_message("DEMO.DBF File is missing...Program aborted",-2,-2,; 
                funcolor[1])
    if mainlog[3]
        fclose("raffat.hyp")
    endif

    csron()
    m_csroff()
    cls()
    quit

endif

use demo 
if !file("demo.ntx")
    index on upper(runner) to demo
endif
set index to demo

* browse screen coordinates
*---------------------------
_btr = 03
_blc = 05
_bbr = maxrow()-4
_brc = 60

* browse startup coordinates
*----------------------------
_b1 = 0     && no split screen window to start
_b2 = 1
_b3 = demo->(recno())
_b4 = 1
_b5 = 0
_b6 = 0
_b7 = 0

* clear screen
*---------------
m_csroff()
scroll(01,00,maxrow(),maxcol(),0,funcolor[1],  ;
                iif(g_color,chr(32),chr(177)))
scroll(00,00,00,maxcol(),0,funcolor[6])
print(00,maxcol()-10,"F1-HELP",funcolor[6])

do paint_main
_first = .t.

m_csron()

* starting active pad
*---------------------
_active = 1

* main loop
*--------------
*-----------------
do while .t.

    * help string
    *--------------
    _help = [d_pulldown]

    _pick1 = d_pulldown(_active,mainmenu,mainlog,funcolor[6],;
                       funcolor[2],funcolor[5])

    _active = iif(_pick1>0,int(_pick1),1)

    if _first
        scroll(01,00,24,79,0,funcolor[1])
        _first = .f.
    endif

    do case
     
        * check for browse
        *----------------
        case _pick1 = 1.01



            * configure browse
            *-------------------
            m_data(29,1)
            m_data(1,_b1)
            m_data(2,_b2)
            m_data(3,_b3)
            m_data(4,_b4)
            m_data(5,_b5)
            m_data(6,_b6)
            m_data(7,_b7)

            m_title("     Olympic Marathon Performances     ")

            * browse with frame
            *--------------------
            _mode = [BF]

            * help string
            *--------------
            _help = [d_browse]

            * a little help at bottom
            *-------------------------
            _mess = "             [ALT-S] Split Screen   [ALT-M] Move   [ALT-E] Expand" 
            m_csroff()
            print(maxrow(),00,untrim(_mess,80),funcolor[6]) 


            * browse
            *--------------------
            _pick2 = d_browse(@_btr,@_blc,@_bbr,@_brc,titles,fields, ;
                              funcolor[1],funcolor[3],               ;
                              _mode,keys,_mtr,_mlc,_mbr,_mrc)

            * repaint screen
            *-----------------
            m_csroff()
            scroll(01,00,maxrow(),maxcol(),0,funcolor[1],  ;
                        iif(g_color,chr(32),chr(177)))
            m_csron()

            m_title([])

            * save last status of browse
            *----------------------------
            _b1 = m_data(1)
            _b2 = m_data(2)
            _b3 = m_data(3)
            _b4 = m_data(4)
            _b5 = m_data(5)
            _b6 = m_data(6)
            _b7 = m_data(7)

            loop

        * check for snakepit
        *-----------------------
        case _pick1 = 1.02

            * start-up disabled
            *-------------------
            m_data(29,0)

            * help string
            *--------------
            _help = [d_snakepit]
            do marathon_a
            loop

        * check for d_mouse
        *--------------------
        case _pick1 = 2.01

            * help string
            *--------------
            _help = [d_mouse]

            d_mouse(04,15,funcolor[1],funcolor[4])

        * check for d_filer
        *----------------
        case _pick1 = 2.02

            * a little help at bottom
            *-------------------------
            _mess = "  [TAB] Menus   [ALT-R] Drives   [ALT-S] Sort"+ ;
                    "[ALT-X] Exit   [SPACE] Tag Files"
            m_csroff()
            print(maxrow(),00,untrim(_mess,80),funcolor[6]) 

            * help string
            *--------------
            _help = [d_filer]

            * browse
            *--------------------
            _pick2 = d_filer(03,10,funcolor[1],funcolor[4],"*.*")

            * repaint screen
            *-----------------
            m_csroff()
            scroll(01,00,maxrow(),maxcol(),0,funcolor[1],  ;
                        iif(g_color,chr(32),chr(177)))
            m_csron()

            loop

        * check for d_calender
        *------------------------
        case _pick1 = 2.03
            
            * help string
            *--------------
            _help = [d_calender]


            _date = d_calender(04,10,date(),funcolor[1],funcolor[3])

        * check for main help
        *----------------
        case _pick1 = 3.01

            * goto main screen
            *--------------------
            set key 28 to

            d_viewhype(_hand,funcolor[7],funcolor[8],[])

            * reset help
            *--------------
            set key 28 to r_help

            loop

        * check for help about raffat.lib
        *----------------------------------
        case _pick1 = 3.02

            * goto main screen
            *--------------------
            set key 28 to

            d_viewhype(_hand,funcolor[7],funcolor[8],[About Raffat.Lib])

            * reset help
            *--------------
            set key 28 to r_help
            loop

        * check for help on functions
        *----------------------------------
        case _pick1 = 3.03

            * goto main screen
            *--------------------
            set key 28 to

            d_viewhype(_hand,funcolor[7],funcolor[8],[Function Index])

            * reset help
            *--------------
            set key 28 to r_help
            loop

        case _pick1 = 4.00

            if mainlog[3]
                fclose("raffat.hyp")
            endif
            csron()
            m_csroff()
            cls()
            quit

    endcase

enddo











* Startup procedure for smacs
*------------------------------------
proc startup

    public  g_color

    ? "Initializing Program"

    * set global help status
    *-------------------------
    g_help = ""                                && default to no help

    * set global keys
    *-----------------
    set key 28 to r_help

    * turn cursor off
    *------------------
    csroff()

    * set mouse double click speed
    *--------------------------------
    m_data(14,5)

    * open all the database files
    *------------------------------
    ? "Opening Databases"


    * set all the clipper stuff
    *---------------------------
    set confirm on
    set deleted on
    set scoreboard off
    set wrap on
    set unique off
    set decimals to 2
    set exact off
    setcancel(.f.)

    * pulldown menu array and logicals
    *------------------------------
    public mainmenu[4],  mainlog[4]

    mainmenu[1] = "FUNCTIONS:~Browse DBF - D_BROWSE::"+ ;
                  "~MultiColumn Achoice/Picklist - D_SNAKEPIT"
    mainmenu[2] = "DIALOGS:Set ~Mouse Double Click - D_MOUSE::"+ ;
                  "File ~Browser - D_FILER::Popup ~Calender - D_CALENDER" 
    mainmenu[3] = "HELP:~Main Help Screen:~About RAFFAT LIB:~List of Functions"
    mainmenu[4] = "QUIT"

    * fill menu logicals with defaults
    *-----------------------------------
    afill(mainlog,.t.)

    * browse arrays
    *-------------------
    public fields[4], titles[4], keys[1], _mtr[1], _mlc[1], _mbr[1], _mrc[1]

    fields[1] = "RUNNER"
    fields[2] = "YEAR"
    fields[3] = "COUNTRY"
    fields[4] = "TIME"

    titles[1] = " Runner"
    titles[2] = " Year"
    titles[3] = " Country"
    titles[4] = " Time"

    keys[1] = 999

    _mtr[1] = 00
    _mlc[1] = 00
    _mbr[1] = 00
    _mrc[1] = maxcol()

    * author array
    *-------------------
    public author[6]
    author[1] = "             RAFFAT.LIB"
    author[2] = ""
    author[3] = " Add-On User Function Library for FUNCky "
    author[4] = "             (and Clipper)"
    author[5] = ""    
    author[6] = "           by Dennis Tierney"    

    * load colors
    *-------------
    load_color()

    * default box type
    *---------------------
    m_frame("Ŀ ")

    * set FUNCky mega function flags
    *--------------------------------
    m_data(22,1)            && auto screen restore

    * virtual screen coordiantes
    *-----------------------------
    m_data(8,1)
    m_data(9,0)
    m_data(10,maxrow()-1)
    m_data(11,maxcol())


return


* set the program colors
*-------------------------
*---------------------------
function load_color
    private _temp, _ctr, _x

    public  funcolor[11]
    blinkbit(.f.)

    if (!iscolor()) .or. ("/M" $ upper(command()))
	    funcolor[1] = 7
        funcolor[2] = 15
        funcolor[3] = 112
	    funcolor[4] = 15
    	funcolor[5] = 7
        funcolor[6] = 7
	    funcolor[7] = 7
        funcolor[8] = 15
	    funcolor[9] = 7
        funcolor[10]= 15
		funcolor[11]= 7

        m_data(17,0)

        * B & W
        *--------
        g_color = .f.

    else

        * mn_pull color
        *------------------
        funcolor[1] = 71            && main color
        funcolor[2] = 250			&& pull down active letter
	    funcolor[3] = 48			&& pop query color & background screen
        funcolor[4] = 78            && main menu active letter
        funcolor[5] = 244  			&& menu in-active
        funcolor[6] = 241			&& pull down menu main
        funcolor[7] = 48            && help color
	    funcolor[8] = 62            && help highlight color
		funcolor[9] = 176			&& 
        funcolor[10]= 78            && 
        funcolor[11]= 20            && 

        * shadow color
        *-----------------
        m_data(17,8)

        * we have color
        *---------------
        g_color = .t.

    endif

    * set up shadow type
    *---------------------
    m_data(16,1)

return ([])


procedure r_help

    parameter dum1, dum2, dum3

    private _amess[3]

    set key 28 to

    if mainlog[3]

        * goto help
        *--------------------
        d_viewhype(_hand,funcolor[7],funcolor[8],_help)

    else

        _amess[1] =  "   Help is not available"
        _amess[2] =  "For Help copy RAFFAT.HYP into"
        _amess[3] =  "current Directory"

        d_message(_amess,-2,-2,funcolor[1],"Press any key...")

    endif

    set key 28 to r_help

return


* paint main screen
*--------------------
procedure paint_main
scroll(07,08,14,70,0,funcolor[1])
print(08,10,"                                      ",iif(g_color,78,funcolor[1]))
print(09,10,"                             ",iif(g_color,67,funcolor[1]))
print(10,10,"                                            ",iif(g_color,66,funcolor[1]))
print(11,10,"                               ",iif(g_color,65,funcolor[1]))
print(12,10,"                                             ",iif(g_color,72,funcolor[1]))
print(13,10,"                                    ",iif(g_color,64,funcolor[1]))

_mess = " DEMO PROGRAM "
print(15,d_center(_mess),_mess,iif(g_color,79,funcolor[1]))

return




procedure marathon_a

    private _marathon[60], _miletime, _thontime, _x, _mess, _scr

    _miletime = "04:40"
    _thontime = []

    * this will take a second
    *---------------------------
    m_csroff()
    _scr = savescreen(07,18,10,60)
    scroll(07,20,09,60,0,funcolor[3])
    box(07,20,09,60,m_frame(),funcolor[3],m_data(16),m_data(17))
    _temp = "Building Pace Table...Please Wait"
    print(08,d_center(_temp,20,60),_temp,funcolor[3])


    * build pace table array
    *-------------------------
    for _x = 1 to 60

        * marathon time
        *----------------
        _thontime = sectostr(strtosec(_miletime)*26.2)

        * fill array
        *---------------
        _marathon[_x] = [ ]+pad(_miletime,5)+[  ]+pad(_thontime,8)+[ ]

        * increment pace time
        *---------------------
        _miletime = sectostr(strtosec(_miletime)+5)

    next

    restscreen(07,18,10,60,_scr)

    _mess = "Minutes/Mile Pace Table for the Marathon"
    scroll(02,15,04,65,0,funcolor[1])
    box(02,15,04,65,m_frame(),funcolor[1],m_data(16),m_data(17))
    print(03,d_center(_mess,15,65),_mess,funcolor[4])
    m_csron()

    _pick3 = d_snakepit(06,08,maxrow()-2,maxcol()-8,_marathon,.t.,3, ;
                        funcolor[1],funcolor[3],[AF])

    m_csroff()
    scroll(01,00,maxrow(),maxcol(),0,funcolor[1],  ;
                    iif(g_color,chr(32),chr(177)))
    m_csron()

return



function sectostr
    parameter _seconds

    private _seconds, _rettime, _temph, _tempm, _temps

    _rettime = []

    * convert to time string
    *---------------------------------
    _temph = int(_seconds / 3600)
    _tempm = int(((_seconds / 3600) - _temph) * 60)
    _temps = int(round(((((_seconds / 3600) - _temph) * 60) - _tempm) * 60,0))

    _rettime = iif(_temph > 0,ltrim(str(_temph))+[:],[])+ ;
               right(leadchar(str(_tempm),"0"),2)+[:] +   ;
               right(leadchar(str(_temps),"0"),2)


return (_rettime)

function strtosec
    parameter _timestring

    private _seconds, _x, _ctr, _multiply

    _seconds  = 0
    _multiply = 1


    * convert time to numeric seconds
    *-------------------------------------
    _ctr = chrcount([:],_timestring) + 1

    for _x = _ctr to 1 step -1

        _seconds = _seconds +round((val(strextract(_timestring,[:],_x)) ;
                              * _multiply),0)

        _multiply = _multiply * 60

    next

return(_seconds)


