******************************************************************************
* RADIOBUT.prg
*  Copyright (c) 1991 by Ian Thurston - but (ab)use this as you will
*  Demonstration of a CLIPPER UDF to display RADIO BUTTONS
*
*  To compile the demo
*        CLIPPER radiobut
*
*  To link the demo
*        TLINK RADIOBUT,,,CLIPPER.LIB EXTEND.LIB
*    or  PLINK86 FI RADIOBUT LIB CLIPPER, EXTEND
*
**** DEMO OF RADIO() function ************************************************

SETCOLOR( IIF( ISCOLOR(), "W/B,B/W","W/N,N/W"))
CLEAR
DO WHILE .T.    && pretty shoddy, I know
@ 24,30 say "A Demo of RADIO()"
@ 1, 0 SAY REPLICATE( CHR(205),80)
@ 0, 5 PROMPT "Demonstration"
@ 0,25 PROMPT "Source Code"
@ 0,45 PROMPT "Documentation"
@ 0,65 PROMPT "Exit to DOS"
MENU TO h_choice
SAVE SCREEN TO s_radiobut
DO CASE
CASE h_choice = 1   && Do The Demo
    CLEAR
    SET CURSOR OFF
    * 1. default call
    ? "Do you want to see the demonstration"
    IF radio() = 1
        * 2. Sample call
        CLEAR
        DECLARE options[5]
        OPTIONS[1]="Add"
        OPTIONS[2]="Cancel"
        OPTIONS[3]="Index"
        OPTIONS[4]="Utils"
        OPTIONS[5]="QUIT"
        firstchoice = 0
        ro = 10
        DO WHILE firstchoice < 5
            firstchoice=RADIO(options, firstchoice, ro)
            IF firstchoice > 0
                @ ro + 11, 10 SAY "Your choice: " + options[firstchoice]
                INKEY(3)
                @ ro + 11, 0
            ENDIF
        ENDDO
    ENDIF
    SET CURSOR ON

CASE h_choice = 2
    DO scanfile WITH "RADIOBUT.PRG"

CASE h_choice = 3
    DO scanfile WITH "WHATSUP.DOC"

CASE h_choice = 0 .OR. h_choice = 4     && Exit
    @ 20,10 SAY "Thanks for trying 'RADIO' (a.k.a. Button ... button ...)"
    INKEY(3)
    QUIT
ENDCASE
RESTORE SCREEN FROM s_radiobut
ENDDO

****
PROC scanfile   && Support routine ... RADIO() is at the bottom
****
PARAMETERS what2scan
IF FILE(what2scan)
    PRIVATE s_scanfile, tempcolor
    SAVE SCREEN TO s_scanfile
    @  2 ,15 SAY "Browse ASCII File: Use cursor keys to move, ESC to Exit"
    @  3,0 SAY REPLICATE( CHR(220), 80)
    @ 23,0 SAY REPLICATE( CHR(223), 80)
    tempcolor=SETCOLOR( SUBSTR(SETCOLOR(), AT(",",SETCOLOR())+1))
    MEMOEDIT( MEMOREAD( what2scan), 4, 0, 22, 79, .F.)
    RESTORE SCREEN FROM s_scanfile
    SETCOLOR( tempcolor)
    RELEASE s_scanfile, tempcolor
ENDIF
RETURN

* Here's the meat:

********
FUNCTION radio      && "radio button metaphor function
********
*  Calling sequence: mvar = RADIO( [<array1>,[expN1,[expN2]]])
*  <array1>  is an array of character strings to display as menu choices.
*            From 2 - 7 choices are allowed. Defaults "Yes" and "No"
*
*  <expN1>   is the number of the button which should initially be "down".
*            If 0 (the default), no buttons are down
*
*  <expN2>   is the top row of the box framing the buttons. The default is 8.
*
*  RETURNS:  The number of the button if <Enter>ed, or 0 if <ESC>aped
*
*  Assumes: Nothing
*  Examples:
*   RADIO()                 centres window with YES and NO buttons
*   RADIO(myarray)          up to 7 buttons named by myarray
*   RADIO(myarray, 1, 5)    displayed with button 1 down, at row 5
*
*
*  Keys:
*   ENTER   returns with number of button that was down
*   ESC     returns with 0

PARAMETERS options, firstchoice,ro
PRIVATE a, b, co, l, lk, radio_scrn
IF PCOUNT()<3       && set default row to 8 if necessary
    ro = 8
endif
IF ro > 14          && can't go below bottom of screen !!
    ro = 14
ENDIF
IF PCOUNT()<2       && set default initial choice to 1 if necessary
    firstchoice = 0
ENDIF
IF PCOUNT()<1       && set default options array to Yes/No if necessary
    PRIVATE options[2]
    options[1]="Yes"
    options[2]="No"
ENDIF
SAVE SCREEN TO radio_scrn
l = LEN(options)
IF (L > 7) .OR. (L < 2) && check for too many or too few buttons
    RETURN 0
ENDIF
co = 38 - 5*l
PRIVATE button[6]   && array of strings to draw radio button
button[1]=""   && start here and draw 1-4 if button is down
button[2]=""   && start here and draw 2-5 if button is up
button[3]=""
button[4]=""
button[5]="     "
button[6]="     "
bchoice=firstchoice
@ ro,co,ro+10,co+10*l + 3 BOX("ͻȺ")  && frame the button box
@ ro+10, co+1 say "Keys: 1-" + TRANSFORM(l,"9 ");
        +chr(27)+" "+chr(26)+" "+chr(17)+chr(196)+chr(217)+" Esc"
KEYBOARD " "    && Flush it
INKEY()
DO WHILE LASTKEY()!=13
    FOR a = 1 TO l
        boffset=IIF(bchoice=a,0,1)      && boffset=0 -> down, =1 -> up
        FOR b = 1 TO 5
            @ ro+b+1, co + a*10 - 6 SAY button[b+boffset]
        NEXT b
        @ ro+4-boffset, co + a*10 - 5 SAY TRANSFORM(a," 9 ")
        @ ro+8, co + a*10 - 5 SAY options[a]
    NEXT a
    INKEY(0)
    lk = LASTKEY()
    DO CASE
        case lk > 48 .AND. lk < 49 + l    && digit from 1 to # of buttons
            bchoice = lk - 48
        CASE lk= 4      && right arrow, next button to right goes down
            bchoice = IIF(bchoice < l, bchoice +1,bchoice)
        CASE lk=13      && enter key means choice was made
            EXIT
        CASE lk=27
            bchoice = 0
            EXIT
        CASE lk= 19     && left arrow, next button to left goes down
            bchoice = IIF(bchoice > 1, bchoice -1,bchoice)
    ENDCASE
ENDDO
RESTORE SCREEN FROM radio_scrn
RELEASE a, b, co, button, l, lk, radio_scrn
RETURN bchoice

* END FUNCTION radiobut()

