* Procedure: QTO.PRG
* Author...: Barry Grant
* Date.....: 05-29-85, modified 06-06-85 by Ray Love
* Notes....: Based on a routine by Tom Rettig from the  "Advanced
*            Programmer's Guide", copyright (c) 1985 Luis Castro,
*            Jay Hansen, and Tom Rettig. Published by Ashton-Tate.
*
* This program allows programs to call one another by starting
* execution with a batch file then modifying that batch file to
* call the next program.  This is done by passing the name of the
* next program to the procedure QUIT_TO.  For example,
*
*    DO Quit_to WITH next
*
* where the contents of next is the program to execute. The called
* routines can return by using the same procedure.  To exit the batch
* file, pass "GOTO END" to QUIT_TO.
*
* * * * * * * * * *  I M P O R T A N T  * * * * * * * * * * * * * *
* The length of the memory variable passed to QUIT_TO must always *
* be 8 characters.  The file pointer used by DOS must find the    *
* instruction GOTO START at the same location in the the batch    *
* file every time.                                                *
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* Any memory variables that need to be passed may be SAVEd to a
* .MEM file.
*
* This example uses the names START.BAT for the batch file and
* MAIN.EXE for the intitial program to execute.  The file START.BAT
* contains the following:
*
*     ECHO OFF
*     MAIN
*     GOTO START
*     :START
*     GOTO END
*     GOTO START
*     :END
*     ECHO ON

PROCEDURE QUIT_TO
PARAMETERS program
   SET ALTERNATE TO START.BAT
   SET ALTERNATE ON
   SET CONSOLE OFF
   ? "ECHO OFF"
   ? "MAIN"
   ? "GOTO START"
   ? ":START"
   ? program
   ? "GOTO START"
   ? ":END"
   ? "ECHO ON"
   SET ALTERNATE TO
   SET CONSOLE ON
   QUIT
* EOP QUIT_TO

* The following three programs demonstrate the use of QUIT_TO.
* Compile separately, create START.BAT, and enter "START" to the
* DOS prompt.

* MAIN.PRG
* Notes...: Main menu of a procedure to call other programs.

SET PROCEDURE TO QTO
DO WHILE .T.
   CLEAR
   @ 10,30 SAY "M A I N   M E N U"
   @ 11,30 SAY "_________________"
   @ 12,30 SAY "1.  Program 1"
   @ 13,30 SAY "2.  Program 2"
   @ 14,30 SAY "3.  Quit"
   choice = " "
   DO WHILE .NOT. CHOICE $"123"
      @ 18,30 SAY "Choice? " GET CHOICE PICTURE "9"
      READ
   ENDDO
   DO CASE
      CASE choice = "1"
         * Add spaces to make next 8 characters long...
         next = "TEST_1  "
         DO QUIT_TO WITH next
      CASE choice = "2"
         next = "TEST_2  "
         DO QUIT_TO WITH next
      CASE choice = "3"
         next = "GOTO END"
         DO QUIT_TO WITH next
   ENDCASE
ENDDO
* EOF MAIN.PRG

*TEST_1.PRG
SET PROCEDURE TO QTO
CLEAR
WAIT "This is TEST_1.PRG.  Press any key to return to MAIN."
next = "MAIN    "
DO QUIT_TO WITH next
* EOF TEST_1.PRG

*TEST_2.PRG
SET PROCEDURE TO QTO
CLEAR
WAIT "This is TEST_2.PRG.  Press any key to return to MAIN."
next = "MAIN    "
DO QUIT_TO WITH next
* EOF TEST_2.PRG
