PBACK()     && use these two lines if the file is compiled as it is
RETU        && and not placed in a function library.

* ============================================================================
* ============================================================================
* Syntax:   PBACK([<expC1>],[<expC2>])   Version 2.1 (July 1992)
*
* Argument: <expC1> path and file specifications    (*.* if not specified)
*           <expC2> a string with files to exclude  (optional)
*
* Return:   .T. backup succesful
*           .F. backup not succesful
*
* Usage:    Used to Backup files from hard disk to floppy disk
* Note:     Include the full path in wildcard string
*
* Example:  PBACK("c:\progs\hot*.db*","read.me config.sys")
*
*           Can be used with Clipper S87 or 5.0
*
*           This file includes the following functions:
*
*           HSORRY()   - Places a message in a centered box.
*           HPROMPT()  - Displays a prompt at the bottom of the screen.
*           HYES()     - Asks for YES or NO.
*           PADR()     - Pad a string to the right. (take out for Clipper 5.0)
*           PADL()     - Pad a string to the left.  (take out for Clipper 5.0)
*
* Copyright: (c) 1992 by Per Kjellqvist
*                        Le Caddie 4
*                        CH - 1936 VERBIER
*                        Switzerland            CompuServe 71540,2311
* ============================================================================
FUNC PBACK
PARA lwcard, lexcl
PRIV lmem,lbyte_tot,lbyte_cop,lfile_no,lin,lxx,lread,ldrive,lbackno,;
     ltime,llist,ldisk_no,linc,lbuffer,lout,lpos,lwrite,lname,lfiles,;
     lc1,lc2,lpath,lkey,lerror,ldel,ltarget,llog,lscreen,lscr,;
     PX_disk, PX_number, PX_byte, PX_list, PX_files,;
     l_01,l_02,l_03,l_04,l_05,l_07,l_12,l_13,l_15,l_16,l_17,l_18,l_19,l_20,;
     lpick[2]

  * - INITIALIZE TEXT STRINGS ------------------------------------------------
  lmem = "per_back.mem"       && Name of .MEM file stored on each disk

  lc1  = "B/BG"                                     && background colour
  lc2  = "GR+/BG"                                   && highlight colour
  lc3  = "B/RB"                                     && popup boxes
  l_01 = " BACKUP FILES TO REMOVABLE MEDIA "
  l_02 = "Estimated Time"
  l_03 = "Bytes"
  l_04 = "Files"
  l_05 = "Completed......Files"
  l_07 = "Diskettes Needed:"
  l_12 = "Confirmation:                [Letter] ["+CHR(27)+"] ["+CHR(26)+"] []-Select [ESC]-Quit"
  l_13 = "Drive:                       [Letter] ["+CHR(24)+"] ["+CHR(25)+"] []-Select [ESC]-Quit"
  l_15 = "Backup:                     DISK ACCESS                   [ESC]-Quit"
  l_16 = "Do you really want to abandon this operation ?"
  l_17 = "SUCCESSFUL BACKUP"
  l_18 = "Sorry, This disk has already been used"
  l_19 = "Sorry, No disk in drive or Write-protected / Unformatted disk"
  l_20 = "BACKUP IS NOT COMPLETE"
  lpick[1] = " Disk Drive A "
  lpick[2] = " Disk Drive B "
  * --------------------------------------------------------------------------
  lscreen = SAVESCREEN(3,4,22,75)

  SET CURSOR OFF
  SETCOLOR(lc1)
  @ 03,04 CLEAR TO 22,75
  @ 03,04 TO 22,75 DOUB
  @ 04,05 TO 04,74 DOUB
  @ 20,05 TO 20,74 DOUB
  @ 04,41 TO 20,41
  @ 11,42 TO 11,74
  @ 04,04 SAY ""
  @ 20,04 SAY ""
  @ 04,75 SAY ""
  @ 20,75 SAY ""
  @ 04,41 SAY ""
  @ 11,41 SAY ""
  @ 11,75 SAY ""
  @ 20,41 SAY ""
  SETCOLOR(lc2)
  @ 3,(80-LEN(l_01))/2 SAY l_01
  SETCOLOR(lc1)

  * ---- LOAD ARRAY WITH FILENAMES AND COUNT BYTES -----------------------------
  lwcard    = IF(TYPE("lwcard")<>"C","*.*",UPPE(lexcl)) && files to back up
  lexcl     = IF(TYPE("lexcl")<>"C","",UPPE(lexcl))     && files to exclude
  lbyte_tot = 0                                         && bytes to be backed up
  llist     = ""                                        && files to be backed up
  lfiles    = ADIR(lwcard)
  lpath     = LEFT(lwcard,RAT("\",lwcard))
  PRIV ARname[lfiles], ARsize[lfiles]
  ADIR(lwcard,ARname,ARsize)
  FOR lxx = 1 TO lfiles
      lname = ARname[lxx]
      IF ! lname $ lexcl
         SCROLL(5,5,19,40,1)
         @ 19,6 SAY PADR(lname,12)+TRAN(ARsize[lxx]," 99,999,999")
         lbyte_tot = lbyte_tot + ARsize[lxx]
         llist     = llist + PADR(lname,12)     && each item has a length of 12
      ENDI
  NEXT
  * ----------------------------------------------------------------------------


  * NOTE:-----------------------------------------------------------------------
  * I found the transfer speed to be approx 5500 bytes/sec with buffer size
  * 4096. It might depend on your hardware so you might want to test it.
  * ----------------------------------------------------------------------------
  ltime     = lbyte_tot/5500+10                                            && 5500 bytes/second
  lbackno   = SECONDS()                                                    && a serial number for the backup set
  lbyte_cop = 0                                                            && bytes copied so far
  linc      = 4096                                                         && buffer size in bytes
  ldisk_no  = 0                                                            && initialize disk counter
  llog      = .T.                                                          && start by logging new diskette

  @ 05,43 SAY PADR(l_02,19,".")                         && Estimated Time
  @ 06,43 SAY PADL(l_03,19)                             && Bytes
  @ 07,43 SAY PADL(l_04,19)                             && Files
  @ 09,43 SAY PADR(l_05,19)                             && Done  Files
  @ 10,43 SAY PADL("%",19)                              && %
  @ 12,43 SAY l_07                                      && Diskettes Needed:
  @ 14,49 SAY PADR('5 " 360 KB',20,".")
  @ 15,54 SAY PADR('1.2 MB',15,".")
  @ 17,49 SAY PADR('3 " 720 KB',20,".")
  @ 18,54 SAY PADR('1.4 MB',15,".")

  SETCOLOR(lc2)
  @ 05,66 SAY PADL(INT(ltime/3600%24),2,"0")+":"+;      && Hours ( % -> MOD() )
              PADL(INT(ltime/60%60),2,"0")+":"+;        && Minutes
              PADL(INT(ltime%60),2,"0")                 && Seconds
  @ 06,62 SAY TRAN(lbyte_tot,"9999,999,999")            && Bytes
  @ 07,62 SAY STR(LEN(llist)/12,12)                     && Files
  @ 14,69 SAY STR(INT(lbyte_tot/360000)+1,5)
  @ 15,69 SAY STR(INT(lbyte_tot/1200000)+1,5)
  @ 17,69 SAY STR(INT(lbyte_tot/720000)+1,5)
  @ 18,69 SAY STR(INT(lbyte_tot/1400000)+1,5)
  SETCOLOR(lc1)

 FOR lfile_no = 1 TO lfiles
     lname = ARname[lfile_no]
     IF ! lname $ lexcl
         lpos    = 0
         lin     = FOPEN(lpath+lname)                                      && Open the source file
         lerror  = FERROR()
         ltarget = .T.
         DO WHIL lerror = 0
            * -- LOG NEW DISKETTE --------------------------------------------
            IF llog
               llog     = .F.
               ltarget  = .T.
               ldisk_no = ldisk_no + 1                                     && increment disk number
               DO WHIL .T.
                  * ---- USER INPUT OF DRIVE TO BACKUP TO ------------------------------------
                  HPROMPT(l_13)
                  lscr = SAVESCREEN(16,32,19,47)
                  @ 16,32 TO 19,47
                  ldrive  = CHR(64+ACHOICE(17,33,18,46,lpick))
                  RESTSCREEN(16,32,19,47,lscr)
                  * --------------------------------------------------------------------------
                  IF ldrive = "@"
                     EXIT
                  ELSE
                     * -------------------------------------------------------------------------
                     HPROMPT(l_15)   &&Backup:          DISK ACCESS         [ESC]-Quit
                     PX_disk   = ldisk_no
                     PX_number = 0
                     IF FILE(ldrive+":"+lmem)
                        REST FROM &ldrive.:&lmem ADDI
                     ENDI
                     IF PX_disk < ldisk_no .AND. PX_number = lbackno
                        HSORRY(l_18)            && Sorry, This disk has already been used
                     ELSE
                        IF ! FCLOSE(FCREATE(ldrive+":x"))
                           HSORRY(l_19)    && Sorry, No disk in drive or Write-protected / Unformatted disk
                        ELSE
                           * --- ERASE EXISTING FILES ---------------------------
                           lxx = ADIR(ldrive+":*.*")
                           IF lxx > 0
                              PRIV ltmp[lxx]
                              ADIR(ldrive+":*.*",ltmp)
                              FOR lxx = 1 TO LEN(ltmp)
                                  ldel = ldrive+":"+ltmp[lxx]
                                  ERASE &ldel
                              NEXT
                           ENDI
                           * ----------------------------------------------------
                           PX_disk   = ldisk_no
                           PX_number = lbackno
                           PX_byte   = lbyte_tot
                           Px_list   = llist       && list of files
                           PX_files  = lfiles
                           SAVE TO &ldrive.:&lmem ALL LIKE PX_*
                           IF ldisk_no = 1
                              @ 5,5 CLEA TO 19,40
                           ENDI
                           EXIT
                        ENDI
                     ENDI
                  ENDI
               ENDD
               IF ldrive = "@"
                  EXIT
               ENDI
            ENDI
            * ----------------------------------------------------------------
            IF lpos = 0
               SCROLL(5,5,19,40,1)
               @ 19,6 SAY PADR(lname,12)+TRAN(ARsize[lfile_no]," 99,999,999")
            ENDI
            * -- OPEN TARGET FILE --------------------------------------------
            IF ltarget
               ltarget = .F.
               lout    = FCREATE(ldrive+":"+lname)
               IF FERROR() <> 0
                  EXIT
               ENDI
            ENDI
            * ----------------------------------------------------------------
            lbuffer   = SPAC(linc)
            lread     = FREAD(lin,@lbuffer,linc)
            lerror    = FERROR()
            IF lerror = 0
               IF lread = 0
                  FCLOSE(lout)
                  EXIT
               ELSE
                  lwrite    = FWRITE(lout,lbuffer,lread)
                  lerror    = FERROR()
                  IF lerror = 0
                     lpos      = lpos      + lwrite
                     lbyte_cop = lbyte_cop + lwrite
                     SETCOLOR(lc2)
                     @ 19,30 SAY TRAN(lpos,"99,999,999")
                     @ 09,62 SAY TRAN(lbyte_cop,"9999,999,999")
                     @ 10,62 SAY STR(ROUND(lbyte_cop/lbyte_tot*100,0),12)
                     SETCOLOR(lc1)
                     IF lwrite < lread                                     && THE WHOLE FILE DID NOT FIT
                        FSEEK(lin,lpos)                                    && position pointer where text ended
                        FCLOSE(lout)                                       && close the outfile
                        llog = .T.                                         && log new disk
                     ENDI
                  ENDI
               ENDI
            ENDI
            lkey = NEXTKEY()                                               && read keyboard buffer, and clear it
            KEYBOARD CHR(0)                                                && clear keyboard buffer
            INKEY()                                                        && - " -
            IF lkey = 27                                                   && [ESC] was pressed while in the loop
               TONE(900,5)
               TONE(900,5)
               lerror = IF(HYES(16,l_16),1,lerror)
            ENDI
            IF lerror <> 0
               IF FCLOSE(lout)
                  ERASE &ldrive.:&lname
               ENDI
            ENDI
         ENDD
         FCLOSE(lin)
         IF ARsize[lfile_no] <> lpos .OR. lerror <> 0
            EXIT
         ENDI
     ENDI
 NEXT
 DO CASE
    CASE lbyte_tot=lbyte_cop
         HSORRY(l_17)          && successful
    CASE lbyte_cop<>0
         HSORRY(l_20)          && not completed
 ENDC

RESTSCREEN(3,4,22,75,lscreen)
RETU (lbyte_tot = lbyte_cop)


* ============================================================================
* ============================================================================
* Syntax:   HSORRY(<expC>)
* Argument: <expC> is string to be shown on screen.
* Return:   .F. if ESC was pressed, otherwise .T.
* Usage:    Used to display a message when the user has made a misstake.
* Note:     The message is placed in a box, and is displayed on line 21
* Example:  HSORRY("Sorry, The name is not valid")
* ============================================================================
  FUNC HSORRY
  PARA ltext
  PRIV lscreen,lkey

  lscreen = SAVESCREEN(16,0,22,79)
  TONE(900,1)
  TONE(900,1)
  TONE(900,1)
  TONE(900,2)
  SETCOLOR(lc3)
  @ 16,(76-LEN(ltext))/2 TO 18,(82+LEN(ltext))/2 DOUB
  @ 17,(78-LEN(ltext))/2 SAY " "+ltext+" "
  SETCOLOR(lc1)
  lkey = INKEY(0)
  RESTSCREEN(16,0,22,79,lscreen)
  RETU lkey<>27


* ============================================================================
* ============================================================================
* Syntax:   HPROMPT(<expC>)
* Argument: <expC> is the text to be displayed on line 24 in inverse text.
* Return:   .T.
* Usage:    To display a prompt line corresponding to current action.
* Note:
* Example:  HPROMPT(l_15)
* ============================================================================
  FUNC HPROMPT
  PARA ltext

  SETCOLOR(lc2)
  @ 21,6 SAY PADR(ltext,68)
  SETCOLOR(lc1)
  RETU .T.


* ============================================================================
* ============================================================================
* Syntax:   HYES(<expN>,<expC>)
* Argument: <expN1> row for text
*           <expC>  question string
* Return:   .T. for answer=YES  .F. for answer=.F. or [ESC]
* Usage:    Used to prompt a YES or NO question to the user.
* Note:     selecting NO and pressing [ESC] gives the same result
* Example:  lanswer = HYES(20,"Do you want to quit?")
* ============================================================================
  FUNC HYES
  PARA lrow, lstring
  PRIV lkey, lscreen, lno

  lscreen = SAVESCREEN(lrow-1,0,lrow+1,79)
  lno     = LEN(lstring)
  SETCOLOR(lc3)
  @ lrow-1,(67-lno)/2 TO lrow+1,(91+lno)/2 DOUB
  @ lrow,(71-lno)/2-1 SAY " " + lstring + SPAC(10)
  @ lrow,(74+lno)/2 PROMPT "YES"
  @ lrow,(83+lno)/2 PROMPT "NO "
  SETCOLOR(lc1)
  HPROMPT(l_12)
  MENU TO lkey
  RESTSCREEN(lrow-1,0,lrow+1,79,lscreen)
  RETU lkey = 1


* ============================================================================
* ============================================================================
* Syntax:   PADR(exp,expN,<expC>)
* Argument: exp    = character, numeric or date value to pad
*           expN   = lenght of character string to return
*           <expC> = character to pad, if not specified spaces are used
* Return:   String
* Usage:    pad a character string on the right with a fill character
* Example:  ? "["+PADR("per",10)+"]"
*           gives   [per       ]
*           ? PADR("per",10,".")
*           gives    per.......
* ============================================================================
  FUNC PADR
  PARA lexp, lno, lpad
  RETU LEFT(ALLTRIM(TRANS(lexp,""))+REPL(IF(PCOUNT()=3,lpad," "),lno),lno)


* ============================================================================
* ============================================================================
* Syntax:   PADL(exp,expN,<expC>)
* Argument: exp    = character, numeric or date value to pad
*           expN   = lenght of character string to return
*           <expC> = character to pad, if not specified spaces are used
* Return:   String
* Usage:    pad a character string on the left with a fill character
* Example:  ? "["+PADL("per",10)+"]"
*           gives   [       per]
*           ? PADL("per",10,"0")
*           gives    0000000per
* ============================================================================
  FUNC PADL
  PARA lexp, lno, lpad
  RETU RIGHT(REPL(IF(PCOUNT()=3,lpad," "),lno)+ALLTRIM(TRANS(lexp,"")),lno)
