/*  Program:    CHECKVOL.C
    Author:     Clifford Wiebe
    Date:       Tue  02-19-1991
    Purpose:    Dos allows you to put volume labels on disks,
                but does not give you any way of using that
                information.

                The volume label check is not case sensitive,
                which should reduce the batch file code somewhat.
 
                This program is given freely to the public domain.
                If it is of some use to you, great.  I have found
                this program of great use in creating installation
                batch files and checking for volume labels before
                making / restoring backups. No warranty implied or
                given.
 
        Clifford Wiebe
        CIS: 73670,1377
        Compiled using Turbo C 2.0
 
*/
 
/* INCLUDES */
#include <stdio.h>
#include <dos.h>
 
 
/* CONSTANTS */
#define BEEP  7
#define TRUE  1
#define FALSE 0
 
#define NOERROR 0
 
#define NOVOL   1
 
static struct
{
 unsigned char ExtCode;
 char Resl [5];
 unsigned char Code;
 unsigned char OldDrive;
 char OldName[11];
 char Res2[5];
 char NewName [11];
 char Res3[9];
}
 
DirFcb = {'\xff',"",'\x10'},
VolFcb = {'\xff',"",'\x08','\0',"???????????"};
 
static struct
  {
char Res1 [8];
char OldVolid [11];
char Res2 [5];
char NewVolid[11];
char Res3[9];
}
  Dta;
 
 
  int FilError;
  int Length;
 
/* LOCAL FUNCTION PROTOTYPES */
 
char *FilGetVolid (int Drive);
void rtrim(char *Volid, int Length);

/* Start of main program            */
main (int argc, char *argv[])
{
   char *Volid;
   char *VolLabel;
   int Drive;
 
if (argc == 1 && argv[1] == "?")
{
    printf("CHECKVOL, 1991\n\n");
    printf("Usage: CHECKVOL [d:]volume\n");
    printf("Returns: ERRORLEVEL 0 if Volume is the same.\n");
    printf("Returns  ERRORLEVEL 1 if Volume is not the same.\n\n");
    printf("ie: Checkvol b:startup\n");
    printf("    if errorlevel 1 echo Disk in Drive B: is not Startup!\n");
    return(0);
}
Drive = toupper(argv[1][0]) - 64;
 
VolLabel = argv[1];
++VolLabel;
++VolLabel;
Volid = FilGetVolid(Drive);
rtrim(Volid,11);
if(!stricmp(Volid,VolLabel))
  exit(0);
else
  exit(1);
}
 
/***********************************************************

char *FilGetVolid (int Drive)
{
  int ErrorCode;
  _DX = (unsigned int)&Dta;         /* pass address of DTA  */
  _AH = 0x1a;
  geninterrupt( 0x21);
 
  VolFcb.OldDrive = Drive;
  _DX = (unsigned int)&VolFcb;
  _AH = 0x11;
  geninterrupt(0x21);
 
  ErrorCode = _AL;
  if (ErrorCode == 0)
  {
    FilError = NOERROR;
    return (Dta.OldVolid);
  }
  else
  {
    FilError = NOVOL;
    return (NULL);
  }
} /* End of FilGetVolid */
 
/***********************************************************

void rtrim(char *String, int Length)
    {
    char *ChPt;
 
    if (Length < 1)
        return;
    ChPt = String + Length - 1; /* points to last character of string */
 
    /* Scan backwards in string until first nonblank, */
    /* non-null character */
    while (ChPt > String && (*ChPt == '\0' || *ChPt == ''))
        --ChPt;
 
    if (*ChPt == '\0' || *ChPt == ' ')      /* string entirely blank/null   */
        *ChPt = '\0';                       /* null at first position       */
    else if (ChPt < String + Length - 1)    /* String  contains nonblank     */
        *(++ChPt) = '\0';                   /* non-null character(s)        */
}
