/*
 * File......: PWRMAKE.PRG
 * Author....: Clifford Wiebe [CIS ID: 73670,1377]
 * Date......: 16 Jan 1992 12:00:00
 * Revision..: Revision: 1.3
 *
 * This is an original work by Clifford Wiebe and is placed in the
 * public domain.
 *
 * Note: Auxiliary files CHECKVOL.EXE, PKZIP.EXE, PKUNZIP.EXE are referenced
 *		 in the backup and restore batch files.
 *
 *
*/


#include "fileio.ch"
#include "directry.ch"
#include "string.ch"
#include "commands.ch"
#include "inkey.ch"

#define COMPILER_NAME				'CLIPPER'
#define OBJ_ENVIRONMENT 			'.;C:\CLIPPER5\OBJ'
#define CH_ENVIRONMENT				'C:\CLIPPER5\INCLUDE'
#define LIB_ENVIRONMENT 			'C:\CLLIPPER5\LIB'
#define CMD_ENVIRONMENT 			'/v /w /m'
#define LINKER_NAME 				'BLINKER'
#define PLL_ENVIRONMENT 			'C:\CLIPPER5\PLL'
#define BACKUP_DIRECTORY			'C:\ZIP'
#define DATA_DIRECTORY				'.\'


function main(cOpt1, cOpt2, cOpt3, cOpt4, cOpt5, cOpt6, cOpt7, cOpt8, cOpt9)
	Local x, n, n2, c, aOptions := {}, aProg := {}, aClip := {}
	local lOverwrite := .f., cAuthor := 'Your Name Here', lHelp := .f.
	local cProject := '', nHandle, cBackup, cCompiler
	local cEnvCmd, cEnvCh, cEnvLib, cEnvObj, cEnvPll, cData, cMainPrg

	Local nClip, nPrg, nLink, cOut, nOut, cDataZip

	? "Power Make for Clipper 5.1"
	? "Copyright 1992 (C) Clifford Wiebe 1992. Public Domain Version"
	?

	// Parse the command line options
	aOptions := {cOpt1,cOpt2,cOpt3,cOpt4,cOpt5,cOpt6,cOpt7,cOpt8,cOpt9}

	// Setup defaults before the command line override
	cCompiler	:= COMPILER_NAME
	cEnvObj 	:= OBJ_ENVIRONMENT
	cEnvCh		:= CH_ENVIRONMENT
	cEnvLib 	:= LIB_ENVIRONMENT
	cEnvPll 	:= PLL_ENVIRONMENT
	cEnvCmd 	:= CMD_ENVIRONMENT
	cBackup 	:= BACKUP_DIRECTORY
	cData		:= DATA_DIRECTORY

	for n := 1 to len(aOptions)
		aOptions[n] := iif(aOptions[n] == nil,'',aOptions[n] )
	next
	for n := 1 to len(aOptions)
		do case
			case '/o' $ lower(aOptions[n])
				lOverwrite := .t.
			case '/a' $ lower(aOptions[n])
				cAuthor := substr(aOptions[n],3)
				// Author is special command line option, it
				// can contain spaces. Check for it.
				n2 := n
				while n2 < len(aOptions) .and. !('/' $ aOptions[n2+1] )
					n2++
					cAuthor += ' ' + aOptions[n2]
				enddo
			case '/?' $ aOptions[n]
				lHelp := .t.
			case '/n' $ lower(aOptions[n])
				cProject := upper(substr(aOptions[n],3))
			case '/b' $ lower(aOptions[n])
				cBackup := substr(aOptions[n],3)
				// strip any trailing backslash
				if right(cBackup,1) != '\'
					cBackup += '\'
				endif
			case '/d' $ lower(aOptions[n])
				cData := substr(aOptions[n],3)
				// strip any trailing backslash
				if right(cData,'\') != '\'
					cData += '\'
				endif
            case '/c' $ lower(aOptions[n])
				cCompiler := upper(substr(aOptions[n],3))
			case '/m' $ lower(aOptions[n])
				cMainPrg := upper(substr(aOptions[n],3))
		endcase
	next

	if lHelp
		HelpScreen()
		quit
	endif
	// If the main (.prg) is not specified, default to the project
	// name for the main module. This module is only one that is
	// not overlayed in the link file. It also will be the of the
	// executable.
	if !(file("*.prg"))
		? "No PRG files found...exiting"+chr(7)
		quit
	endif

	if empty(cProject)
		? 'Project name not found, enter PWRMAKE /? for help'
		quit
	elseif len(cProject) > 8
		? 'Project name greater than 8 characters'
		quit
	endif


	? 'Creating Project files for '+ cProject

	* declare and load the array
	****************************
	aProg  := Directory("*.prg")
	aClip := Directory("*.clp")

	if len(aProg) == 0
		? 'no .PRG files found'
		quit
	endif

	asort(aProg,,,{|x,y| x[1] < y[1]})

	? 'creating ' + cProject + '.RMK'
	if file(cProject + '.rmk') .and. !lOverwrite
		if !YesNo(cProject+'.rmk project found, Ok to Overwrite? ')
			quit
		endif
	endif
	if (nHandle := fcreate(cProject+'.RMK',FC_NORMAL)) == -1
		? 'make file cannot be created, exiting'
		quit
	endif

	// Write the header file information
	fwriteline(nHandle,"// Make File....: "+cProject)
	fwriteline(nHandle,"// Date Created.: "+dtoc(date()))
	fwriteline(nHandle,"// Author.......: "+cAuthor)
	fwriteline(nHandle,"// Comments.....: Created by Pwrmake")
	fwriteline(nHandle,"//                                  ")
	fwriteline(nHandle,"")
	fwriteline(nHandle,"// Make File macros")
	fwriteline(nHandle,padr("COMPILER        = " + cCompiler,40) + '// Compiler Name')
	fwriteline(nHandle,padr("CLIPPERCMD      = " + cEnvCmd,40) + "// Default Compiler Directives")
	fwriteline(nHandle,padr("LINKERNAME      = "+LINKER_NAME,40)+"// Linker name")
	fwriteline(nHandle,padr("CLIPDEBUG       = " + cEnvCmd + " /b ",40) + "// Debug Compiler Directives")
	fwriteline(nHandle,"")
	fwriteline(nHandle,"// makepath macros")
	fwriteline(nHandle,"makepath[.obj] = " + cEnvObj)
	fwriteline(nHandle,"makepath[.ch]  = " + cEnvCh)
	fwriteline(nHandle,"makepath[.lib] = " + cEnvLib)
	fwriteline(nHandle,"makepath[.pll] = " + cEnvPll)
	fwriteline(nHandle,"")
	fwriteline(nHandle,"// Inference rules ")
	fwriteline(nHandle,".PRG.OBJ:")
	fwriteline(nHandle,"    $(COMPILER) $* (CLIPPERCMD)")
	fwriteline(nHandle,"")

	// Process the .PRG files
	nPrg  := len(aProg)
	for n := 1 to nPrg
		c := padr(StripExt(aProg[n,F_NAME])+".OBJ",15)
		fwriteline(nHandle,c + ":"+space(6)+StripExt(aProg[n,F_NAME])+".PRG")
	next
	fwriteline(nHandle,"")

	fwriteline(nHandle,padr(cMainPrg+".EXE",15)+":")
	fwriteline(nHandle,space(3)+"$(LINKERNAME) @"+StripExt(cProject)+".LNK")
	fclose(nHandle)

	//*******************************************************************

	? 'creating '+cProject+'.LNK'
	nLink := fcreate(cProject+'.LNK',FC_NORMAL)
	fwriteline(nHandle,"#  Link File....: "+cProject)
	fwriteline(nHandle,"#  Date Created.: "+dtoc(date()))
	fwriteline(nHandle,"#  Author.......: "+cAuthor)
	fwriteline(nHandle,"")
	fwriteline(nHandle,"BLINKER OVERLAY FIXED")
	fwriteline(nHandle,"BLINKER OVERLAY UMB ON")
	fwriteline(nHandle,"BLINKER OVERLAY PAGEFRAME ON")
	fwriteline(nHandle,"BLINKER ENVIRONMENT NAME "+upper(cProject))
	fwriteline(nHandle,"BLINKER INCREMENTAL ON")
	fwriteline(nHandle,"OUTPUT "+cMainPrg+'.EXE')
	fwriteline(nHandle,"FILE   "+cMainPrg)
	fwriteline(nHandle,"#Force commonly used routines resident")
	fwriteline(nHandle,"#module -*-*-* place common routine here")
	fwriteline(nHandle,"BEGINAREA   ")
	for n := 1 to nPrg
		if !(upper(cProject)+'.PRG' == aProg[n,F_NAME])
			fwriteline(nHandle,CHR(9)+"FILE "+StripExt(aProg[n,F_NAME]))
		endif
	next
	fwriteline(nHandle,"ENDAREA")
	fwriteline(nHandle,"# Overlayed Library files, could be replaced with")
	fwriteline(nHandle,"# one of various (.std) files available")
	fwriteline(nHandle,"BEGINAREA   ")
	fwriteline(nHandle,CHR(9)+"ALLOCATE NANFOR")
	fwriteline(nHandle,CHR(9)+"ALLOCATE EXTEND")
	fwriteline(nHandle,"ENDAREA")
	fwriteline(nHandle,"SEARCH CLIPPER")
	fwriteline(nHandle,"SEARCH DBFNTX")
	fwriteline(nHandle,"SEARCH TERMINAL")
	fclose(nHandle)

	? 'creating COMPILE.BAT'
	nHandle := fcreate("COMPILE.BAT",FC_NORMAL)
	fwriteLine(nHandle,"@Echo Off")
	fwriteline(nHandle,"Echo Making Project "+cProject)
	fwriteline(nHandle,"")
	fwriteline(nHandle,"rmake /w "+cProject)
	fwriteline(nHandle,"")

	? 'creating BACKUP.BAT'
	nHandle := fcreate('Backup.Bat',FC_NORMAL)
	fwriteline(nHandle,"@Echo Off")
	fwriteline(nHandle,"REM Backup Batch File created by PwrMake on "+dtoc(date()))
	fwriteline(nHandle,"if (%1)==() goto nodrive")
	fwriteline(nHandle,"")
	fwriteline(nHandle,"REM    Next section uses CheckVol to verify the disk is correct")
	fwriteline(nHandle,"REM    You can use the DOS Label or Nortons VL command to put")
	fwriteline(nHandle,"REM    a volume label on a disk")
	fwriteline(nHandle,"REM    Checkvol is a utility written in C")
	fwriteline(nHandle,":checkdisk")
	fwriteline(nHandle,"checkvol %1"+upper(cProject))
	fwriteline(nHandle,"if errorlevel 1 goto wrong")
	fwriteline(nHandle,"goto continue")
	fwriteline(nHandle,":wrong")
	fwriteline(nHandle,"Echo "+upper(cProject)+" disk not found in Drive %1")
	fwriteline(nHandle,"pause")
	fwriteline(nHandle,"goto checkdisk")
	fwriteline(nHandle,"")
	fwriteline(nHandle,":continue")
	fwriteline(nHandle,"Echo Backing up "+upper(cProject)+" system to Drive %1 using "+upper(cProject)+".LST")
	fwriteline(nHandle,"if not exist "+cBackup+"NUL echo Creating "+cBackup+" directory")
	fwriteline(nHandle,"if not exist " + cBackup + "*.* if not exist " + cBackup + "NUL md "+  substr(cBackup,1,len(cBackup)-1))
	fwriteline(nHandle,"pkzip -u " + cBackup + cProject +" @"+cProject+".lst")
	fwriteline(nHandle,"echo Copying ZipFile to Diskette in Drive %1")
	fwriteline(nHandle,"copy "+cBackup+cProject+".zip %1 > NUL")
	fwriteline(nHandle,"")
	fwriteline(nHandle,"REM Check if data should be backed up")
	fwriteline(nHandle,"if (%2)==() goto end")
	fwriteline(nHandle,"if (%2)==(/DATA) goto data")
	fwriteline(nHandle,"if (%2)==(/data) goto data")
	fwriteline(nHandle,"goto end")
	fwriteline(nHandle,"")
	fwriteline(nHandle,":DATA")
	fwriteline(nHandle,"Echo Backing up DBF/NTX files")
	// Create the name for the data zipfile
	cDataZip := rtrim(left(cProject,7)) + "D"
	fwriteline(nHandle,"pkzip -u "+cBackup+cDataZip+" "+cData+"*.dbf "+cData+"*.ntx ")
	fwriteline(nHandle,"Echo Ready to move "+cDataZip+".zip to Drive %1, any key")
   fwriteline(nHandle,"pause > nul")
   fwriteline(nHandle,"copy "+cBackup+cDataZip+".zip %1 > NUL")
   fwriteline(nHandle,"goto end")
   fwriteline(nHandle,"")
   fwriteline(nHandle,":noDrive")
   fwriteline(nHandle,"echo Drive not specified")
   fwriteline(nHandle,"echo Backup [a:/b:] [/DATA]")
   fwriteline(nHandle,":end")
   fclose(nHandle)

   ? 'creating RESTORE.BAT'
   nHandle := fcreate('Restore.bat',FC_NORMAL)
   fwriteline(nHandle,"@Echo Off")
   fwriteline(nHandle,"REM Restore Batch File created by PwrMake on "+dtoc(date()))
   fwriteline(nHandle,"if (%1)==() goto nodrive")
   fwriteline(nHandle,"")
   fwriteline(nHandle,"REM    Next section uses CheckVol to verify the disk is correct")
   fwriteline(nHandle,"REM    You can use the DOS Label or Nortons VL command to put")
   fwriteline(nHandle,"REM    a volume label on a disk")
   fwriteline(nHandle,":checkdisk")
   fwriteline(nHandle,"checkvol %1"+upper(cProject))
   fwriteline(nHandle,"if errorlevel 1 goto wrong")
   fwriteline(nHandle,"goto continue")
   fwriteline(nHandle,":wrong")
   fwriteline(nHandle,"Echo "+upper(cProject)+" disk not found in Drive %1")
   fwriteline(nHandle,"pause")
   fwriteline(nHandle,"goto checkdisk")
   fwriteline(nHandle,"")
   fwriteline(nHandle,":continue")

	fwriteline(nHandle,"if not exist "+cBackup+"NUL echo Creating "+cBackup+" directory")
	fwriteline(nHandle,"if not exist " + cBackup + "*.* if not exist " + cBackup + "NUL md "+  substr(cBackup,1,len(cBackup)-1))
   fwriteline(nHandle,"if not exist %1"+cProject+".zip goto nofile")
   fwriteline(nHandle,"Echo Restoring "+upper(cProject)+" system from Drive %1")
   fwriteline(nHandle,"copy %1" + cProject + ".zip "+cBackup+cProject)
   fwriteline(nHandle,"Echo Only files newer than existing files will be restored")
   fwriteline(nHandle,"pkunzip -n "+cBackup+cProject)
   fwriteline(nHandle,"")
   fwriteline(nHandle,"REM Check if data should be backed up")
   fwriteline(nHandle,"if (%2)==() goto end")
   fwriteline(nHandle,"if (%2)==(/DATA) goto data")
   fwriteline(nHandle,"if (%2)==(/data) goto data")
   fwriteline(nHandle,"goto end")
   fwriteline(nHandle,"")
   fwriteline(nHandle,":DATA")
   fwriteline(nHandle,"Echo Restoring DBF/NTX files")
   // Create the name for the data zipfile
   cDataZip := rtrim(left(cProject,7)) + "D"
   fwriteline(nHandle,":CheckData")
   fwriteline(nHandle,"if not exist %1"+cDataZip+".zip goto NoData")
   fwriteline(nHandle,"copy %1"+cDataZip+".zip "+cBackup+cDataZip+".zip > nul")
   fwriteline(nHandle,"pkunzip -n "+cBackup+cDataZip +" "+cData+"*.dbf "+cData+"*.ntx")
   fwriteline(nHandle,"goto end")
   fwriteline(nHandle,"")
   fwriteline(nHandle,":NoData")
   fwriteline(nHandle,"echo Data File %1"+cDataZip+".zip not found")
   fwriteline(nHandle,"echo Insert Data Disk and press a key")
   fwriteline(nHandle,"pause > nul")
   fwriteline(nHandle,"goto CheckData")
   fwriteline(nHandle,"")

   fwriteline(nHandle,":nofile")
   fwriteline(nHandle,"echo "+cProject+".zip not found on Drive %1")
   fwriteline(nHandle,"goto end")
   fwriteline(nHandle,"")
   fwriteline(nHandle,":noDrive")
   fwriteline(nHandle,"echo Drive not specified")
   fwriteline(nHandle,":end")
   fclose(nHandle)

   ? 'creating '+cProject+'.LST'
   nHandle := fcreate(cProject+'.lst')
   fwriteline(nHandle,"*.BAT")
   fwriteline(nHandle,"*.FRM")
   fwriteline(nHandle,"*.LBL")
   fwriteline(nHandle,"*.DOC")
   fwriteline(nHandle,"*.CNF")
   fwriteline(nHandle,"*.TXT")
   fwriteline(nHandle,"*.DOC")
   fwriteline(nHandle,"*.CH")
   fwriteline(nHandle,cProject+".lnk")
   fwriteline(nHandle,cProject+".rmk")
   fwriteline(nHandle,cProject+".lst")
   fwriteline(nHandle,cProject+".prg")


   ? 'done'
   ?
   ? 'To use the Backup/Restore Batch Files, you must have'
   ? 'a single diskette with a volume label of '+upper(cProject)
return ( NIL )
*----------------------------------------------------------------------------*
function HelpScreen()

	? "Syntax PwrMake /nproject [switches] "
	?
	? "where:   /n<project> = project name"
	? "         /n<MainPrg> = main non-overlayed program for project"
	? "                       defaults to <project>"
	? "         /a<name>    = author's name"
	? "         /b<dir>     = backup directory, defaults to c:\zip"
	? "         /c<compiler>= compiler name, defaults to CLIPPER.EXE"
	? "         /o          = overwrite existing files without prompting"
	? "         /d<dir>     = dbf file directory, defaults to current directory"
	? "         /?          = displays this help screen"
	?
	? "Files Created:"
	? "         compile.bat    runs RMAKE with <project>.rmk"
	? "         backup.bat     Backs up complete system to zipfile and floppy"
	? "                        /DATA will backup dbf files"
	? "         restore.bat    Restores system saved with Backup.bat"
	? "         <project>.RMK  Make file"
	? "         <project>.LNK  Link file"
	? "         <project>.LST  File list for pkzip"
	?
	? "Environment variables will be used for paths"
return ( nil )

function YesNo ( cText )
	//
	//	returns .T. if Y or y is pressed
	//
	local n := 0, c := ''

	? cText
	while .t.
		n := inkey(0)
		c := chr(n)
		if c $ 'YyNn'
			exit
		endif
	enddo
	?
return ( c $ 'Yy' )

function fwriteline(fileHandle,cString)
	local nStringLen

	cString += chr(13) + chr(10)
	nStringLen := len(cString)

return( nStringLen == fwrite(fileHandle,cString,nStringLen) )

function StripExt( cFile )
	// returns a path/filename without an extension
   local cPath := '', c, nPos

   if (nPos := rat('\', cFile)) > 0
      cPath := substr(cFile,1,nPos)
      cFile := StripPath(cFile)
   endif
   if (nPos := rat('.',cFile)) > 0
      cFile := substr(cFile,1,nPos-1)
   endif
return (  cPath + cFile )

