#define RINGSTOANSWER 1
#include "clippwrl.ch"
proc test(playfile)
local t
local lines,line
local first,last
local event,eventdata
local LioArray[LIO_SIZE]
if !empty(t:=PL_getver())
  ?"Powerline TSR version is "+t
  if PL_Shutdown()
    ?'any previous activity halted'
    lines=PL_Start(,@first,@last)
    ?"Number of lines installed: ",lines
    ?"features:",first,last
    if lines=0
      quit
    endif
    for line=1 to lines
      if PL_Enable(line,OFFHOOKCOMP+ONHOOKCOMP+SILENCEON+SILENCEOFF+RINGSREC,;
                   RINGSTOANSWER)
        ?"line", line,"enabled"
      else
        ?"problem on line", line
      endif
    next
    if !PL_Relays( 1, OFFHOOK, ONLOCAL )
      ?"problem with setting relays"
      quit
    endif
    if !busy_wait(1,OFFHC)
      ?"problem putting line 1 offhook"
    endif
    ?"relays on line 1 set to OFFHOOK, ONLOCAL "
    if !PL_Microphone(1, .T.)
      ?"could not turn on microphone"
    endif
    ?"recording to file",playfile
    LioArray[LIO_FNAME]:=playfile
    LioArray[LIO_MAX_TIME]=30
    if !PL_RecFile(1,LioArray)
      ?"could not start recording"
    endif
    ?"recording, any key to stop...."
    do while .T.
      if inkey()>0
        ?"key pressed"
        PL_StopLine(1)
        exit
      endif
    enddo
    if !busy_wait(1,LSTOP)
      ?"problem waiting for recording to end"
    endif
    if !PL_Microphone( 1, .F. )
      ?"could not turn off Microphone"
    endif
  else
    ?"could not shutdown previous activity"
    quit
  endif
  if PL_Shutdown()
    ?"System shut down"
  else
    ?"problem shutting down system"
  endif
else
  ?"Powerline TSR is not installed"
endif
return
***************************************************
function busy_wait(linewanted,eventwanted)
local event,eventdata,line
local i
?"waiting for event "
if valtype(eventwanted)=="A"
  for i=1 to len(eventwanted)
    ??eventwanted[i]
  next
else
  ??eventwanted
endif
do while .T.
  event=PL_Event(@line,@eventdata)
  if event<>0
    ?"event",event," on line", line
  endif
  if (valtype(eventwanted)=="N" .and. event==eventwanted) .or. ;
     (valtype(eventwanted)=="A" .and. ascan(eventwanted,event)>0)
    exit
  endif
  if inkey()==27
    ?"aborted"
    quit
  endif
enddo
return (event>=0)
