#define RINGSTOANSWER 1
#include "clippwrl.ch"
#include "fileio.ch"

proc test
local event,eventdata
local LioArray[LIO_SIZE]
local Ind_Handle
local Buffer,I
local digit
local filename:=space(12)
Local maxrcds:=10
local Comp_Rate:=3
local Headersize:=32
local Rec_Num:=0
local Offset,Rec_Size
local Getlist:={}
if !Startup()
  quit
endif
clear screen
@ 1,1 say "Name of indexed file      : "  get filename
@ 3,1 say "Maximum number of records : " get maxrcds picture "99"
@ 5,1 say "Compression rate          : " get Comp_Rate
read
if lastkey()==27
  quit
endif
Filename:=trim(filename)
Ind_Handle:=fcreate(Filename)
if Ind_Handle<0
  ?"unable to create file"
  quit
endif
fwrite(Ind_Handle, chr(Headersize))
fwrite(Ind_Handle, chr(Comp_Rate))
fwrite(Ind_Handle, l2bin(maxrcds))
fwrite(Ind_Handle, l2bin(Rec_num))
fclose(Ind_Handle)
if !PL_Microphone(1, .T.)
  ?"could not turn on microphone"
  quit
endif
LioArray[LIO_FNAME] = Filename
LioArray[LIO_COMP_RATE] = Comp_rate
LioArray[LIO_MAX_SIL] = 2
LioArray[LIO_CTRL_FLAGS] = 32         //precede with beep
offset := (maxrcds + 1) * Headersize
do while .T.
  LioArray[LIO_INDEX_ADDR] = offset
  ?"Press any key to begin recording..."
  inkey(0)
  ?"Recording record",rec_num
  ?"Press any key to stop recording"
  if !PL_RecIndex(1,LioArray)
    ?"Unable to start record"
    quit
  endif
  /* wait for the recording to terminate */
  busy_wait(1,{MAXSIL,LSTOP})
  /* write record information to the index array */
  Ind_Handle := fopen(filename, FO_READWRITE)
  ?Offset,fseek(Ind_Handle,0,FS_END)
  Rec_Size:=fseek(Ind_Handle,0,FS_END)-offset
  ?rec_size
  fseek(Ind_Handle, 32*(rec_num+1), FS_SET)
  fwrite(Ind_Handle, l2bin(offset))
  fwrite(Ind_Handle, l2bin(Rec_Size))
  fwrite(Ind_Handle, ltrim(str(rec_num))+Chr(0))
  fclose(Ind_Handle)
  offset += Rec_size
  rec_num++
  if (rec_num >= maxrcds)
    ?"No more room for records"
    exit
  endif
  clear typeahead
  ?"Record another record? [y/n] "
  if upper(chr(inkey(0)))<>"Y"
    exit
  endif
enddo
PL_Microphone(1, .F.)
/* write current number of records in file */
Ind_Handle := fopen(filename, FO_READWRITE)
fseek(Ind_Handle, 6, FS_SET)
fwrite(Ind_Handle, l2bin(rec_num))
fclose(Ind_Handle)
if PL_Shutdown()
  ?"System shut down"
else
  ?"problem shutting down system"
endif
return
***************************************************
function Startup
Local Vernum
local lines,line
local first,last
if empty(Vernum:=PL_getver())
  ?"Powerline TSR is not installed"
  return .F.
endif
?"Powerline TSR version is "+Vernum
if !PL_Shutdown()
  ?"could not shutdown previous activity"
  return .F.
endif
?'any previous activity halted'
lines=PL_Start(,@first,@last)
?"Number of lines installed: ",lines
?"features:",first,last
if lines=0
  return .F.
endif
for line=1 to lines
  if PL_Enable(line,OFFHOOKCOMP+ONHOOKCOMP+SILENCEON+SILENCEOFF+RINGSREC,;
               RINGSTOANSWER)
    ?"line", line,"enabled"
  else
    ?"problem on line", line
  endif
next
PL_Speaker( 1, .F. )
return .T.
***************************************************
function busy_wait(linewanted,eventwanted)
local event,eventdata,line
local i
?"waiting for event "
if valtype(eventwanted)=="A"
  for i=1 to len(eventwanted)
    ??eventwanted[i]
  next
else
  ??eventwanted
endif
clear typeahead
do while .T.
  event=PL_Event(@line,@eventdata)
  if event<>0
    ?"event",event," on line", line
  endif
  if (valtype(eventwanted)=="N" .and. event==eventwanted) .or. ;
     (valtype(eventwanted)=="A" .and. ascan(eventwanted,event)>0)
    exit
  endif
  if inkey()<>0
    PL_StopLine(linewanted)
  endif
enddo
return (event>=0)
