#define RINGSTOANSWER 1
#include "clippwrl.ch"
#include "fileio.ch"

proc test(playfile,Playstring)
local event,eventdata
local LioArray[LIO_SIZE]
local Ind_Handle
local Des_Handle
local Buffer,I
local Offset,Reclen
local foffset := 0                /* offset into the record */
local digit
local Des_File:="TEST.RD"

if !file(Playfile)
  ?"file not found"
  quit
endif
if !Startup()
  quit
endif
if !PL_Relays( 1, OFFHOOK, ONLOCAL )
  ?"problem with setting relays"
  quit
endif
if !busy_wait(1,OFFHC)
  ?"problem putting line 1 offhook"
endif
?"relays on line 1 set to OFFHOOK, ONLOCAL "
if !PL_Speaker( 1, .T. )
  ?"could not turn on speaker"
endif
if !PL_SetLevel(1, .T.)
  ?"could not turn up the volume"
endif
?"playing indexed file",playfile
Ind_Handle:=fopen(playfile)
Des_Handle:=fcreate(Des_File)
/* move file pointer to the header entry for the compression rate */
fseek( Ind_handle, 1, FS_SET )
buffer:=space(1)
fread(Ind_Handle,@buffer,1)           // read compression rate
LioArray[LIO_COMP_RATE]:=bin2i(buffer)
?" compression rate is",LioArray[LIO_COMP_RATE]
LioArray[LIO_CTRL_FLAGS] = 4         //mode 1
LioArray[LIO_FNAME]:=Des_File
for i:=1 to len(Playstring)
  digit = substr(Playstring,I,1)                     /* get next digit from string */
  /* move file pointer to the header entry for the corresp. record */
  fseek( Ind_handle, 32*(asc(digit) - asc('0') + 1),FS_SET )
  Offset:=space(4)
  /* read the record's offset and length from the file header */
  fread( Ind_Handle, @Offset, 4)
  Reclen:=space(4)
  fread( Ind_Handle, @Reclen, 4)
  ?"Offset",bin2l(Offset), "Record length",bin2l(Reclen)
  /* move record descriptor file pointer to next 128 byte boundary */
  fseek( Des_handle, foffset, FS_SET )
  foffset += 128
  fwrite( Des_handle, offset, 4)
  fwrite( Des_handle, reclen, 4)
  fwrite( Des_handle, Playfile)
  fwrite(Des_Handle,chr(0),1)
next
fclose(Ind_handle)
fclose(Des_handle)
//    LioArray[LIO_MAX_TIME]:=3
if !PL_PlayIndex(1,LioArray)
  ?"could not play file"
endif
if !busy_wait(1,{PBEOF,MAXSECS})
  ?"problem waiting for recording to end"
endif
if !PL_Speaker( 1, .F. )
  ?"could not turn off speaker"
endif
if PL_Shutdown()
  ?"System shut down"
else
  ?"problem shutting down system"
endif
return
***************************************************
function Startup
Local Vernum
local lines,line
local first,last
if empty(Vernum:=PL_getver())
  ?"Powerline TSR is not installed"
  return .F.
endif
?"Powerline TSR version is "+Vernum
if !PL_Shutdown()
  ?"could not shutdown previous activity"
  return .F.
endif
?'any previous activity halted'
lines=PL_Start(,@first,@last)
?"Number of lines installed: ",lines
?"features:",first,last
if lines=0
  return .F.
endif
for line=1 to lines
  if PL_Enable(line,OFFHOOKCOMP+ONHOOKCOMP+SILENCEON+SILENCEOFF+RINGSREC,;
               RINGSTOANSWER)
    ?"line", line,"enabled"
  else
    ?"problem on line", line
  endif
next
return .T.
***************************************************
function busy_wait(linewanted,eventwanted)
local event,eventdata,line
local i
?"waiting for event "
if valtype(eventwanted)=="A"
  for i=1 to len(eventwanted)
    ??eventwanted[i]
  next
else
  ??eventwanted
endif
do while .T.
  event=PL_Event(@line,@eventdata)
  if event<>0
    ?"event",event," on line", line
  endif
  if (valtype(eventwanted)=="N" .and. event==eventwanted) .or. ;
     (valtype(eventwanted)=="A" .and. ascan(eventwanted,event)>0)
    exit
  endif
  if inkey()==27
    ?"aborted"
    quit
  endif
enddo
return (event>=0)
