/*********************************************************************
 * PWRLINE.CH  Powerline Clipper interface definitions               *
 *********************************************************************/


/*********************************************************************
 *                         Powerline Constants                       *
 *********************************************************************/

/********* Interrupt Enables ************/

#define  DCBON       16384            /* debounced clunk bit on     */
#define  DCBOFF      8192            /* debounced clunk bit off    */
#define  LCINTERRUP  4096            /* loop current interruption  */
#define  LOOPPULSE   2048            /* loop current pulse        */
#define  LOCALCOFF   1024            /* local phone off hook trans */
#define  LOCALCON    512            /* local phone on hook trans  */
#define  DIGITREC    256            /* digit received interrupt   */
#define  LCONTRANS   128            /* loop current On trans      */
#define  ONHOOKCOMP  32            /* onhook complete interrupt  */
#define  OFFHOOKCOMP 16            /* offhook complete interrupt */
#define  SILENCEON   8            /* silence on interrupt       */
#define  SILENCEOFF  4            /* silence off interrupt      */
#define  RINGSREC    2            /* rings received interrupt   */
#define  LCOFFTRANS  1            /* loop current off trans     */

/*********** Conditions *****************/

#define  DTMPLAY     1            /* playback mode              */
#define  DTMRECORD   2            /* record mode                */
#define  OFFHOOK    .F.            /* hook relay: off            */
#define  ONHOOK     .T.            /* hook relay: on             */
#define  ONLINE     .F.            /* line/local relay: line     */
#define  ONLOCAL    .T.            /* line/local relay: local    */
#define  DRDTMF      1            /* digit recog: dtmf          */
#define  DRCP        4            /* digit recog: type A        */
#define  DRPARP      6            /* digit recog: type A w/partial*/
#define  DRCPEDGE    12            /* digit recog: type B edge   */
#define  DRCPTIME    14            /* digit recog: type B time   */
#define  DRCALLA     16            /* digit recog: call analysis */
#define  FLUSHDBYES  1            /* flush input digit buffer   */
#define  FLUSHDBNO   0            /* no digit buffer flush      */
#define  OLDLOADCPP  2            /* old load pulse digit parms */
#define  LOADCPPARMS 4            /* load pulse digit parameters*/

/************* Events codes ***********/

#define  NOEVENT  0                 /* event queue empty         */
#define  MAXDGTS  1                 /* maximum digits            */
#define  TERMDIG1 2                 /* terminating digit 1       */
#define  LSTOP    3                 /* line stop                 */
#define  PWRDOSER 4                 /* DOS error                 */
#define  MAXBYTES 5                 /* maximum bytes             */
#define  MAXSECS  7                 /* timeout: max seconds      */
#define  OFFHC    8                 /* offhook complete          */
#define  DIALCMPL 9                 /* dialing complete          */
#define  MAXSIL   10                 /* timeout: silence          */
#define  PBEOF    11                 /* playback: eof             */
#define  LSTERM   12                 /* loop signal termination   */
#define  ONHC     14                 /* onhook complete           */
#define  DIGREC   15                 /* digit received            */
#define  LOOPEV   16                 /* loop event                */
#define  CALLPROG 16                 /* call progress tone detect */
#define  RINGR    21                 /* rings received            */
#define  SILCHG   22                 /* silence state changed     */
#define  TERMDIG2 29                 /* termination digit 2       */
#define  IDDTERM  30                 /* idd termination           */
#define  MAXNSIL  31                 /* maximum non-silence       */

/************* Loop Event Data codes ***********/

#define  LELPCON  1                 /* loop current ON           */
#define  LELPCOFF 2                 /* loop current OFF          */
#define  LELPCI   3                 /* loop current interruption */
#define  LELPP    4                 /* loop current pulse        */
#define  LELLCON  17                 /* local current ON          */
#define  LELLCOFF 18                 /* local current OFF         */


/* call progress detection data codes */

#define  DIALTONE 1                 /* dialtone detected         */
#define  RINGTONE 2                 /* ringtone detected         */
#define  BUSYTONE 4                 /* busytone detected         */
#define  REORDER  8                 /* reorder tone detected     */
#define  VOX      16                 /* voice detected            */
#define  USERCPT  32                 /* user defined tone detected*/
#define  LOADCPP  128                 /* load call progress parms  */

/* Line IO Area definitions */
#define LIO_FNAME      1
#define LIO_COMP_RATE  2
#define LIO_BYTE_COUNT 3
#define LIO_MAX_TIME   4
#define LIO_MAX_DIGITS 5
#define LIO_TERM_DIGIT 6
#define LIO_MAX_SIL    7
#define LIO_LOOP_SIG   8
#define LIO_INDEX_ADDR 9
#define LIO_CTRL_FLAGS 10
#define LIO_INIT_DIGIT 11
#define LIO_TERM_MASK  12
#define LIO_ID_DELAY   13
#define LIO_MAX_NSIL   14
#define LIO_SIZE       LIO_MAX_NSIL
