/*Ŀ
 ݳ                                                                      
 ݳ Program Name: PTEST.PRG         Copyright: Gallagher Computing Corp. 
 ݳ Date Created: 03/05/93           Language: Clipper 5.0               
 ݳ Time Created: 17:14:41             Author: Kevin S Gallagher         
 ݳ                                                                      
 ݳ Comments:                                                            
 ݳ Since Clipper 5.2 has delivered some RDD drivers as stock equipment  
 ݳ I wanted to try out the RDD for 'Paradox' tables, and  this program  
 ݳ does just that. It may not be as polished as it could be! Also note  
 ݳ that there  are instructions in the 'makefile' for inclusion of the  
 ݳ library called  'GRUMP.LIB', and as is it will compile/link without  
 ݳ 'GRUMP.LIB'.  Also note that I extracted two (2) functions from the  
 ݳ 'NANFOR.LIB' library, version 2.1 - ft_shadow() and ft_proper() for  
 ݳ they are written in "C" and "assembly" which reduces the final code  
 ݳ size, and also increases the speed of program execution.             
 ݳ                                                                      
 ݳ Operations:                                                          
 ݳ                                                                      
 ݳ [ENTER]      - To edit the current highlighted record in the table   
 ݳ [F2]         - Add a new record to the table                         
 ݳ [F1]         - Simple Help screen                                    
 ݳ [DEL]        - Does what it says (will first ask for confirmation)   
 ݳ                                                                      
 ݳ About records:                                                       
 ݳ A important not on CA-Clippers RDD for paradox, is that when using   
 ݳ this driver the CA-Clipper function 'RECNO()' returns a character    
 ݳ string of the primary field that we think of as the index, thus it   
 ݳ can not be used as in .DBF format which return a pointer to the      
 ݳ record as a numeric value. This is why I have one field that carries 
 ݳ a numeric value that can be utilized as a record number...           
 ݳ                                                                      
 ݳ This program is only a starting point for a first look the RDD driver
 ݳ and can be expanded or tweaked without much fuss...                  
 
            */

#include "common.ch"
#include "inkey.ch"
#include "box.ch"

#define JUST_EDITING .F.
#define NEW_DATA     .T.
// Better boxes than how Clipper defaults are done - ala Greg Lief
#define BFRAMES { "ͻȺ ", "Ŀ ", " ", SPACE(9),          ;
                  "ķԳ ", "͸Ӻ ", "ĿӺ ", "",       ;
                  "", "", "", " "        }

#ifdef MR_GRUMP
#undef YES
#undef NO
#include "grump.ch"
#include "grumpr.ch"
#endif

#ifndef MR_GRUMP
#translate KsgRead()                          =>    ;
    ( SETCURSOR( 3 ), READMODAL( getlist ),         ;
      getlist := {}, SETCURSOR( 0 ),                ;
      !( LASTKEY() = 27 )                           )
#endif

#define cFileName  "ADDRESS"
#define COORD1      8,5,20,76
#define COORD2      8,5,18,74 

#xtranslate LSTRINT( <n> ) => LTRIM( STR( INT( <n> ) ) )
#xtranslate X1( <n> )      => SUBSTR( STR( <n> ), 1, AT(".",STR( <n> ) ) -1 )

function main()
    local x,y
    // Array to append data to the new table..
    local myData_ := {                                                   ;
    { "Gallagher", "Kevin", "Sean", "Programmer", "Gallagher Computing", ;
      "660 Woodward Drive", "Huntingdon Valley", "PA", "19006",          ;
      "215-947-3504", "215-947-3504", "215-947-3504",                    ;
      "Clipper programmer - Jack of all trades - Master of None"       },;
    { "Balsom", "Chris", " ","President", "Hyperkinetix, Inc.",          ;
      "666 Baker #405", "Costa Mesa", "CA", "92626", "714-668-9234",     ;
      "714-935-0831", "714-935-0823", "Products - Warplink and Builder"},;
    { "Lief", "Greg",  " ","President", "Grumpfish, Inc",                ;
      "2450 Lancaster Drive NE, #206", "Salem", "OR", "97305",           ;
      "503-588-1815", "503-588-1980","503-588-7572",                     ;
      "Author of GRUMPFISH library for Clipper language, great library"},;
    { "Fogle","Robert", " ","President","HRF Associates",                ;
      "15 Bank Street", "Stamford", "CT", "06901", "203-961-1199",       ;
      "203-961-1197","203-961-1129",                                     ;
      "The best API network library for Clipper language"              },;
    { "Willis","Joy",  "Gallagher ", "President", "Gallagher Computing" ,;
      "660 Woodward Drive", "Huntingdon Valley", "PA", "19006",          ;
      "215-947-3504", "215-947-3504", "215-947-3504", "Hello World.. " } }

    // check for table as well as primary index file(s)
    IF FILE( cFileName+".DB" ) .AND. FILE( cFileName+".PX" )
        USE ( cFileName ) VIA "DBPX" NEW
    ELSE
        DBCREATE( "ADDRESS.DB", {  { "Last_Name*" , "C" ,  20, 0 }   ,   ; 
                                   { "First_Name" , "C" ,  20, 0 }   ,   ;
                                   { "Middle_Nam" , "C" ,  20, 0 }   ,   ;
                                   { "Title     " , "C" ,  35, 0 }   ,   ;
                                   { "Company   " , "C" ,  35, 0 }   ,   ;
                                   { "Street    " , "C" ,  30, 0 }   ,   ;
                                   { "City      " , "C" ,  25, 0 }   ,   ;
                                   { "State     " , "C" ,   2, 0 }   ,   ;
                                   { "Zip       " , "C" ,  10, 0 }   ,   ;
                                   { "Work_Tel  " , "C" ,  12, 0 }   ,   ;
                                   { "Fax_Tel   " , "C" ,  12, 0 }   ,   ;
                                   { "Extra_Tel " , "C" ,  12, 0 }   ,   ;
                                   { "Notes     " , "C" , 200, 0 }   ,   ;
                                   { "RecNums   " , "N" ,   9, 2 }   }   )

        USE ( cFileName )  NEW VIA "DBPX"
        // append some test data to the new table..
        for x := 1 to 5
            append blank
            for y := 1 to 13
                fieldput( y, myData_[x][y])
            next
            replace FIELD->RecNums WITH x
        next
        dbgotop()
    ENDIF
    // check for network open file errors
    IF NETERR()
        ALERT("NETWORK ERROR", {" QUIT "} )
        QUIT
    ENDIF

    PBrowse()

return nil

/*
* Function comments:
* - Note there are two methods of doing the colors in the browse and can 
*   be changed by either defining or undefining 'DO_COLOR1'                  
*
* - The columns are hard coded,  but is easy to modify for a generic type
*   of browse ie. (this is a simple way of doing a generic browse),
*   FOR i :=1 TO FCOUNT()
*       cCol := TBCOLUMNNEW( FIELD( i ), FIELDBLOCK( FIELD( i ) ) )
*       oBrowse:ADDCOLUMN( cCol )
*   NEXT
*
*/

#define DO_COLOR1

FUNCTION PBrowse
    local i, nKey := 0, cBrowCol, aRec, oBrowse := TBROWSEDB( 2,1,20,78 )

    dispbox(1,0,21,79,"","GR+/B")

    // Code block to reposition data
    oBrowse:skipBlock:= { |x| Skipper( x, oBrowse ) }
    oBrowse:COLORSPEC:= "w+/b, b/w, gr+/b, b/w, w+/r"
    oBrowse:COLSEP   := "  "
    oBrowse:HEADSEP  := ""
    // add all the fields into the TBrowse, with proper headings
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Last"     , { || FIELD->LAST_NAME  } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "First"    , { || FIELD->FIRST_NAME } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Middle"   , { || FIELD->MIDDLE_NAM } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Title"    , { || FIELD->TITLE      } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Company"  , { || FIELD->COMPANY    } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Street"   , { || FIELD->STREET     } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "City"     , { || FIELD->CITY       } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "State"    , { || FIELD->STATE      } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Zip"      , { || FIELD->ZIP        } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Work Tel" , { || FIELD->WORK_TEL   } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Fax Tel"  , { || FIELD->FAX_TEL    } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "Extra Tel", { || FIELD->EXTRA_TEL  } ) )
    oBrowse:ADDCOLUMN( TBCOLUMNNEW( "My Notes" , { || FIELD->NOTES      } ) )

    #ifdef DO_COLOR1
    FOR i :=1 TO oBrowse:colCount
        oBrowse:getColumn( i ):defcolor  :={ 3 , 5 }
        oBrowse:getColumn( i ):colorBlock:={ || { 1 , 4 } }
    NEXT
    #else
    aRec := { 1, 1, oBrowse:rowCount, oBrowse:colCount }
    #endif
    
    WHILE .T.

        oBrowse:ForceStable()
        #ifndef DO_COLOR1
        oBrowse:colorRect( aRec, {3,4} )
        #endif

        // see if we hit the first or last record, and sound off..
        if ( oBrowse:hitBottom )
            tone(150,1)
        elseif ( oBrowse:hitTop )
            tone(250,1)
        endif

        oBrowse:refreshCurrent():forceStable()

        // Wait for a keypress and show which record we are sitting on!
        ShowCount()
        nKey := inkey( 0 )
        ShowCount()
        if ( nKey == K_ESC )
            IF alert("Do you really;want to QUIT?;"+replicate("",15),      ;
                {"Yes","No"},"W+/N") <> 2
                EXIT
            ENDIF
        else
            // evaluate keypress
            applyKey( oBrowse, nKey )
        endif

    ENDDO
return nil

STATIC FUNCTION Skipper( nSkip, oBrowse )
    LOCAL i := 0

    do case
        case ( nSkip == 0 .or. lastrec() == 0 )
            dbSkip( 0 )
            
        case ( nSkip > 0 .and. !eof() )
            while ( i < nSkip )                  // Skip Foward
                dbskip( 1 )

                if eof() 
                    dbskip( -1 )
                    EXIT
                endif
                i++
            enddo
        case ( nSkip < 0 )
            while ( i > nSkip )                  // Skip backward
                dbskip( -1 )
                if bof()
                    exit
                endif
                i--
            enddo
    endcase
RETURN i

STATIC PROCEDURE ApplyKey( oBrowse, nKey )
    do case
        case nKey == K_DOWN
            oBrowse:down()
        case nKey == K_PGDN
            oBrowse:pageDown()
        case nKey == K_CTRL_PGDN
            oBrowse:goBottom()
        case nKey == K_UP
            oBrowse:up()
        case nKey == K_PGUP
            oBrowse:pageUp()
        case nKey == K_CTRL_PGUP
            oBrowse:goTop()
        case nKey == K_RIGHT
            oBrowse:right()
        case nKey == K_LEFT
            oBrowse:left()
        case nKey == K_HOME
            oBrowse:home()
        case nKey == K_END
            oBrowse:end()
        case nKey == K_CTRL_LEFT
            oBrowse:panLeft()
        case nKey == K_CTRL_RIGHT
            oBrowse:panRight()
        case nKey == K_CTRL_HOME
            oBrowse:panHome()
        case nKey == K_CTRL_END
            oBrowse:panEnd()
        case nKey == K_DEL
            // validate removal of the record
            TONE(4000, 5)
            TONE(3000,12)
            TONE(2000,10)
            TONE(1000, 5)
            IF ALERT("REMOVE THIS RECORD",{ " No ", " Yes " } ) == 2
                dbdelete()
                oBrowse:refreshAll()
            ENDIF
        case nKey == K_F3
            alert("RECNO --> "+ RTRIM( RECNO() ) )
        case nKey == K_RETURN
            #ifdef MR_GRUMP
               gTBedit( JUST_EDITING )
            #else
               cTBedit( JUST_EDITING )
            #endif
        case nKey == K_F2
            IF ALERT("ADD A NEW PERSON TO THE FILE",{"Yes","No"}) == 1
                APPEND BLANK
                #ifdef MR_GRUMP
                   gTBedit( NEW_DATA )
                   oBrowse:refreshall()
                #else
                   cTBedit( NEW_DATA )
                   oBrowse:refreshall()
                #endif
            ENDIF
        otherwise
            HELP()
    endcase
RETURN

/*
* Function for adding or editing data in the Paradox table.
* See comments in 'makefile' for usage. Also not the param
* being sent to the function is a logical, telling if we
* are in edit or append mode.
*/
#ifdef MR_GRUMP
FUNCTION gTBedit( lAppend )
    local buffer:="", getlist :={}, oldcur := setcursor( 3 )
    local oldcolor := setcolor("w+/rb")

    buffer := EXBOX(COORD2,2,40,'',.T.,"EDIT DATA")
    @ 9, 7  say "First Name"
    @ 9, 41 say "Middle"
    @10, 7  say "Last Name"
    @11, 7  say "Street"
    @12, 7  say "City"
    @13, 7  say "State"
    @14, 7  say "Zip Code"
    @15, 7  say "Phone"
    @16, 7  say "Fax"
    @17, 7  say "Notes"
    setcolor( oldcolor )
    @09,19 gget ADDRESS->First_Name PROPER                 color "w+/rb,w+/n"
    @09,48 gget ADDRESS->Middle_Nam PROPER                 color "w+/rb,w+/n"
    @10,19 gget ADDRESS->Last_Name  PROPER                 color "w+/rb,w+/n"
    @11,19 gget ADDRESS->Street                            color "w+/rb,w+/n"
    @12,19 gget ADDRESS->City       PROPER                 color "w+/rb,w+/n"
    @13,19 gget ADDRESS->State      PROPER Valid IsState() color "w+/rb,w+/n"
    @14,19 gget ADDRESS->Zip                               color "w+/rb,w+/n"
    @15,19 gget ADDRESS->Work_Tel PICTURE "999-999-9999"   color "w+/rb,w+/n"
    @16,19 gget ADDRESS->Fax_Tel  PICTURE "999-999-9999"   color "w+/rb,w+/n"
    @17,19 gget ADDRESS->Notes    PICTURE "@S50"           color "w+/rb,w+/n"
    READ TIMEOUT 30

    // This is for pointing to a record as a numeric
    IF lAppend
        ADDRESS->RecNums:= (LASTREC()+1) -1
    ENDIF

    ByeByeBox(buffer)
    setcursor( oldcur )

return nil
#else
FUNCTION cTBedit( lAppend )
    local oldscrn :=savescreen(COORD1), oldcolor :=setcolor("w+/rb")
    local getlist:={}

    dispbox(COORD2,BFRAMES[12])
    FT_SHADOW( COORD2 )
    @ 9, 7  say "First Name"
    @ 9, 41 say "Middle"
    @10, 7  say "Last Name"
    @11, 7  say "Street"
    @12, 7  say "City"
    @13, 7  say "State"
    @14, 7  say "Zip Code"
    @15, 7  say "Phone"
    @16, 7  say "Fax"
    @17, 7  say "Notes"
    setcolor( oldcolor )
    @09,19 get ADDRESS->First_Name                        color "w+/rb,w+/n"
    @09,48 get ADDRESS->Middle_Nam                        color "w+/rb,w+/n"
    @10,19 get ADDRESS->Last_Name                         color "w+/rb,w+/n"
    @11,19 get ADDRESS->Street                            color "w+/rb,w+/n"
    @12,19 get ADDRESS->City                              color "w+/rb,w+/n"
    @13,19 get ADDRESS->State                             color "w+/rb,w+/n"
    @14,19 get ADDRESS->Zip                               color "w+/rb,w+/n"
    @15,19 get ADDRESS->Work_Tel PICTURE "999-999-9999"   color "w+/rb,w+/n"
    @16,19 get ADDRESS->Fax_Tel  PICTURE "999-999-9999"   color "w+/rb,w+/n"
    @17,19 get ADDRESS->Notes    PICTURE "@S50"           color "w+/rb,w+/n"
    KsgRead()
    ADDRESS->Last_name  := FT_PROPER( ADDRESS->Last_name  )
    ADDRESS->First_name := FT_PROPER( ADDRESS->First_name )

    // This is for pointing to a record as a numeric
    IF lAppend
        ADDRESS->RecNums:= (LASTREC()+1) -1
    ENDIF
    restscreen(COORD1,oldscrn)
return nil
#endif

/*
* This function shows the current record number, while traversing
* thru the TBrowse.
*/
FUNCTION Showcount()
    @MAXROW(), 45   say "Record Number "           color 'w+/rb'
    @MAXROW(),COL() say LSTRINT(FIELD->RecNums)    color 'gr+/rb'
    @MAXROW(),COL() say " of "                     color 'w+/rb'
    @MAXROW(),COL() say LSTRINT( LASTREC())        color 'gr+/rb'
return nil


FUNCTION HELP
    local oldscrn := savescreen( COORD1 ), oldcolor :=setcolor("w+/rb")

    dispbox( COORD2,BFRAMES[12] )
    FT_SHADOW( COORD2 )
    @ 8,26 say CHR( 231 )
    @ 8,27 say "PRESS ANY KEY TO EXIT HELP"                  color "w+/n"
    @ 8,53 say CHR( 201 )
    @ 9, 7 say "This is an example of 'Clipper 5.2' viewing a Paradox table with a"
    @10, 7 say "replacement 'RDD' database driver.  Note the index is created abit"
    @11, 7 say "different than with regular .DBF type of files, see the '*' in the"
    @11,64 say "*"                                           color "w+/n"
    @12, 7 say "array that creates the database.  Note that the edit and appending"
    @13, 7 say "of data into the Paradox table is done either with plain 'Clipper'" 
    @14, 7 say "or with the help of 'GRUMPFISH' third party library.              "
    @15, 7 say "To Edit data press [ENTER] and to add new data press [F2]"
    @16, 7 say "To exit the demo press the [ESC] key"
    @17, 7 say "Have fun Kevin"                              color "gr+/rb"
    inkey(0)
    KEYBOARD CHR(1)
    inkey(0)
    setcolor( oldcolor )
    restscreen( COORD1,oldscrn )
return nil

// First code of the program, set default RDD to paradox
INIT PROCEDURE STARTME
    set(_SET_SCOREBOARD,.F.)
    SETCURSOR( 0 )
    REQUEST DBPX
    RDDSETDEFAULT( "DBPX" )
    SETCOLOR("W/N")
    DISPBOX(0,0,MAXROW(),MAXCOL(),BFRAMES[10],"W+/W")
    @MAXROW(),0 say PADR(" F1 = HELP",80) color "W+/RB"
    _boxdefs()
RETURN

// ending code prior to termination of the program.
EXIT PROCEDURE SoLong
    // if nothing open Clipper spits out an error message
    IF USED()
        UNLOCK
    ENDIF
    SETCOLOR('W/N')
    CLS
    SETMODE(25)
    DBCLOSEALL()
    SETCURSOR( 1 )
    setcolor("W+/RB")
    // Show credits and copyright notices
    DISPBOX(0,0,6,MAXCOL(),BFRAMES[2])
    @1,1 say PADC("Paradox RDD Demo for Clipper 5.2",78)
    @2,1 say PADC("Created by",78)
    @3,1 say PADC("Kevin S. Gallagher",78)
    @4,1 say PADC("Clipper (c) Computer Associates",78)
    @5,1 say PADC("Grump.lib (c) Grumpfish, Inc.",78)
    SETCOLOR("W/N")
    @10,0
RETURN


