//**************************************************************
// PUSHPOP.CH by Hannes Ziegler CIS 100142,302
// Uploaded:  Sep 26th 93
//
// PUSH and POP commands. You save/set a maximum of 4096
// memvars, set-funcs, screens, database-vars to one array 
// and restore the original state with one line of code
//
// PUSH setcursor(3), setcolor(cColor) TO aStack
//
// This is all you need to set/save setcursor() and colour
//
// POP aStack ALL
//
// This is the 'undo' command. It restores setkey(), dispbox(),
// select(), recno(), readinsert(), indexord()... you name it.
//**************************************************************

*#define   FIRST_IN_FIRST_OUT // asterisk in front: last in first out


#command  PUSH <x> [,<y>] TO <array>  ;
      =>  aadd(<array>,Save(<x>)) [; aadd(<array>, Save(<y>)) ]

#command  PUSH <x> TO <array>  ;
      =>  aadd(<array>,Save(<x>))


#ifdef FIRST_IN_FIRST_OUT

	#command  POP [FROM] <array> ALL;
	      =>  aeval(<array>,{|a| a\[2]:eval(a\[1])}) ; <array>:={}

	#command  POP [FROM] <array>;
				=>  ( <array>\[1,2]:eval(<array>\[1,1]) ,            ;
              adel(<array>,1), asize(<array>,len(<array>)-1) )


#else // last in first out

	#command  POP [FROM] <array> ALL;
        =>  aeval(<array>,;
  	              {|a,i|i:=len(<array>)-i+1,;
    	            <array>\[i,2]:eval(<array>\[i,1]) }) ; <array>:={}

	#command  POP [FROM] <array>;
				=>  ( <array>\[len(<array>),2]:eval(<array>\[len(<array>),1]),;
               asize(<array>,len(<array>)-1) )
#endif

//*************************
// Save memvars
// PUSH  var:=16 TO aStack
//*************************
#xtranslate  Save( <v> := <value> ) ;
         => { {|x|x:=<v>,<v>:=<value>,x}:eval(), {|x|<v>:=x} }


//******************************************************
// SET-Functions 
// eg: SetKey(), SetCursor(), SetInsert(), SetColor()
// PUSH  Setcursor( if(readinsert(),3,1) ) TO aStack
// PUSH  SetKey(K_ENTER,{||Edit()})        TO aStack
// PUSH  SetKey(K_INS,{||setcursor( if(readinsert(!readinsert()),1,3) )} ) TO aStack
//******************************************************
#xtranslate  Save( <func>(<p1>,<p2>) ) ;
         => { <func>(<p1>,<p2>), {|x|<func>( <p1>, x)} }

#xtranslate  Save( <func>([<p1>]) ) ;
         => { <func>([<p1>]), {|x|<func>(x) } }

//*********************
// Save CURSOR-Position
//*********************
#xtranslate  Save( SavePos() ) ;
         => { {row(),col()},{|a| SetPos(a\[1],a\[2])} }

#xtranslate  Save( CursorPos() ) => Save( SavePos() )

//*******************************************
// SAVESCREEN()
// PUSH  savescreen(10,10,20,60)  TO  aStack
//*******************************************
#xtranslate  Save( SaveScreen(<nT>,<nL>,<nB>,<nR>) ) ;
         => { SaveScreen(<nT>,<nL>,<nB>,<nR>),;
              {|x|RestScreen(<nT>,<nL>,<nB>,<nR>,x)} }


//*************************************************
// DISPBOX() plus SAVESCREEN()
// PUSH  dispbox(10,10,20,60,2,"W/B")  TO  aStack
//*************************************************
#xtranslate  Save( DispBox(<nT>,<nL>,<nB>,<nR>[,<opt,...>]) ) ;
         => {;
		          {|x|;
    		        x:=SaveScreen(<nT>,<nL>,<nB>,<nR>),;
        		    DispBox(<nT>,<nL>,<nB>,<nR>[,<opt>]),;
            	  x;
              }:eval(),;
              {|x|RestScreen(<nT>,<nL>,<nB>,<nR>,x)};
            }


//*************************************************
// Save RECNO() 
// PUSH  recno()  TO  aStack
//*************************************************
#xtranslate  Save( recno() ) ;
         => { {select(),recno()}, {|a|(a\[1])->(dbgoto(a\[2]))} }


//*************************************************
// Set/save SELECT()
// PUSH  select("Customer")  TO  aStack
//*************************************************
#xtranslate  Save( select([<cAlias>]) ) ;
         => { {|x|x:=select()[,dbselectarea(<cAlias>)],x}:eval(),;
             {|n| dbselectarea(n)};
						}


//*************************************************
// Set/Save INDEXORD() 
// PUSH  indexord(2)  TO  aStack
//*************************************************
#xtranslate  Save( indexord([<i>]) ) ;
         => { { select(),;
                {|x|x:=indexord()[,dbsetorder(<i>)],x}:eval();
              },;
             {|a| (a\[1])->(dbsetorder(a\[2]))};
						}


//*************************************************
// Some weired stuff:
// PUSH  say(5,10,"Hello","W+/R")  TO  aStack
//*************************************************
#xtranslate  Save( say(<nT>,<nL>,<cString>[,<cColor>]) ) ;
         => {;
							{|x|x:=SaveScreen(<nT>,<nL>,<nT>,maxcol()),;
	                setpos(<nT>,<nL>),devout(<cString>[,<cColor>]),x;
              }:eval(),;
              {|x|RestScreen(<nT>,<nL>,<nT>,maxcol(),x)};
            }


*********************************************************************
*  This is a demonstration of PUSH and POP commands
*  Just uncomment the lines and compile a PPO
*  
*  
* #include "inkey.ch"
* 
* Proc test()
* local aStack:={}, dummy := "Test"
* 
* select 2
* use address
* 
* PUSH                                ;
*    SavePos()                        ,;  // Save row(), col()
*    setcursor(3)                     ,;  // Save/set cursor shape
*    setcolor("BG/B,W+/B")            ,;  // Save/set colour
*    recno()                          ,;  // Save recno()
*    select( "Adress")                ,;  // Save/set workarea
*    indexord(2)                      ,;  // Save/set indexord()
*    setkey( K_ENTER ,{|| Edit()  } ) ,;  // Save/set codeblock for K_ENTER
*    setkey( K_ESC   ,{|| Quit()  } ) ,;  // Save/set codeblock for K_ESC
*    dispbox( 1, 1, 23, 78, 2, "N/W") ,;  // SaveScreen(), DispBox()
*    dummy := "New"                   ,;  // Save/assign variable
*    say( 0,0,"Hello","W+/R" )        ;   // Say and savescreen()
* TO aStack                               // Define array as savestack
* 
* dbgoto(12)                              // move recno()
* 
* select 1
* address->(browse())
* 
* POP FROM aStack // Pop/restore one element -> restore first line
* POP FROM aStack // Same                    -> dummy=="Test"
* POP      aStack // Same                    -> screen is as on entry
* 
* POP FROM aStack ALL // Pop/restore all     -> original state
* 
* inkey(0)
* 
* return
*  
* Func Edit()
* setkey(K_ENTER,nil);Keyboard chr(13) // edit browse()
* Func Quit()
* setkey(K_ESC,nil);Keyboard chr(27)   // terminate browse()
