/*-------------------------------------------------------------------------*

    Program...: PUSHDEMO.PRG    PUSHBUTTON DEMO PROGRAM
    Date......: June 12, 1993
    Author....: Wendy Starbuck

*--------------------------------------------------------------------------*/


// Include Standard Headers
#include "pushbutn.ch"                 // Pushbutton headers
#include "inkey.ch"                    // Keypress constants

// Define Program Actions
#define  INITIALIZATION       1
#define  OPEN_WINDOW          2
#define  ENTER_UPDATE_DATA    3
#define  SELECT_FILES         4
#define  EXECUTE_BACKUP       5
#define  END_OF_JOB           6
#define  HOUSEKEEPING         7

function Main()

    // Declare public variables
    memvar GetList

    // Declare control variables
    local  lContinue    := .T.         // Continuation status indicator
    local  lAbort       := .F.         // Abort condition flag
    local  nAction      := 1           // Program action pointer
    local  nChoice
    local  cBkUpFrom
    local  cBkUpTo
    local  nBkUpType
    local  nBkUpMethod
    local  cGetColor

    // Program control loop
    while lContinue .and. ! lAbort

        do case
        case nAction == INITIALIZATION
            SaveEnviron()
            set scoreboard off
            CLS
            cGetColor := substr( ( cGetColor := ColorSet(COL_WIND_STD)),;
                                 1, (at(",",cGetColor)-1 ) )
            SetBlink(.F.)
            cBkUpFrom   := "C:\WORK                 "
            cBkUpTo     := "C:\WORK                 "
            nBkUpType   := 1
            nBkUpMethod := 1
            nChoice     := 1
            nAction     := OPEN_WINDOW

        case nAction == OPEN_WINDOW
            Win_Create( 4, 10, 20, 69, ColorSet(COL_WIND_STD), WIN_DUMB_WINDOW )
            Win_Title( "Demo Program - Execute Backup" )
            ColorChg( COL_WIND_STD )
            // WTO, WSAY, WGET just repositions the coordinates within the
            // window, otherwise they are benign
            @ 3,  3 WTO  6, 56
            @ 7,  3 WTO 11, 29
            @ 7, 30 WTO 11, 56
            ColorChg( COL_WIND_TEXT )
            @ 3, 27 WSAY "From/To"
            @ 4,  6 WSAY "Backup from.........:"
            @ 5,  6 WSAY "Backup to...........:"
            @ 7, 10 WSAY "File Selection"
            @ 7, 36 WSAY "Handling Method"
            nAction := ENTER_UPDATE_DATA

        case nAction == ENTER_UPDATE_DATA
            Win_Mssg( " This program has no functioning backup routines ! " )
            @ 4, 30 WGET cBkUpFrom ;
                         picture "@! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
            @ 5, 30 WGET cBkUpTo   ;
                         picture "@! XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

            // Radiobuttons from RADIOBTN.PRG by Dan Comeau
            @ 8, 06 WGET nBkUpType                                        ;
                         color cGetColor                                  ;
                         with radiobuttons { "Application files",         ;
                                             "Database files",            ;
                                             "All files"          } nobox
            @ 8, 32 WGET nBkUpMethod                                      ;
                         color cGetColor                                  ;
                         with radiobuttons { "Overwrite files",           ;
                                             "Save files"         } nobox

            // Pushbuttons from PUSHBUTN.PRG by Wendy Starbuck
            @13, 07 WGET nChoice                                          ;
                         color ColorSet( COL_WIND_STD )                   ; 
                         start at nChoice                                 ;
                         with pushbuttons { "   Select   ",               ;
                                            "   Backup   ",               ;
                                            "    Quit    "                }

            set cursor on
            read
            set cursor off

            // Kill buttons
            RadioBtnKill()
            PushBtnKill()

            // Handle keypresses
            do case
            // Permit enter or spacebar to execute the buttons
            case LastKey() == K_ENTER .or. ;
                 LastKey() == K_SPACE
                    // Handle button choices
                    do case
                    case nChoice == 1 ; nAction := SELECT_FILES
                    case nChoice == 2 ; nAction := EXECUTE_BACKUP
                    case nChoice == 3 ; nAction := END_OF_JOB
                    endcase
            case LastKey() == K_ESC
                nAction := END_OF_JOB
            endcase

        case nAction == SELECT_FILES
            ActionBox( { "Select Files is not installed!" },, ;
                       SOUND_BEEPER, OK_BUTTON )
            nAction := ENTER_UPDATE_DATA

        case nAction == EXECUTE_BACKUP
            ActionBox( { "Execute Backup is not installed!",  ;
                         "Press OK to continue or",           ;
                         "ESCAPE to end it all!" },,          ; 
                       SOUND_BEEPER, OK_BUTTON )
            if Lastkey() == K_ESC
                nAction := END_OF_JOB
            else
                nAction := ENTER_UPDATE_DATA
            endif

        case nAction == END_OF_JOB
            // Always do your housekeeping
            Win_Kill()
            RestEnviron()
            lContinue := .F.
   
        endcase

    end

return NIL


/* EOF: PUSHDEMO.PRG ------------------------------------------------------*/
