/*  This program is placed in the public domain by
    Marty Altschul
    507 Westmoreland Court
    Charlottesville, VA 22901
    Phone: (804) 973-2986

    March 7, 1991
    */


/*  The following routine demonstates how the function CUA_MENU works
    It is not needed if CUA_MENU is called by another program. */

LOCAL array := { {'I',  {'A','1','2', {'3','a','b'},'4'}, 'B', 'C'}, ;
                 'II',;
                 {'III',{'A','1','2', {'3','a','b'},'4'}, 'B', 'C'}, ;
                 'Quit' }, ;
      test :={}, i
CLEAR
SETPOS(10,0)
DO WHILE .T.
   test := cua_menu(array)
   IF LEN(test) == 0
      ? 'EMPTY'
   ELSE
      ? ''
      FOR i = 1 TO LEN(test)
          ?? test[i]
      NEXT
      IF test[1] == 4
         EXIT
      ENDIF
   ENDIF
ENDDO
RETURN

***************************
FUNCTION CUA_MENU (topline)
***************************
/*  This function creates a pulldown menu structure using data stored in the
    multidimensional array topline. */
LOCAL holdcursor := { ROW(), COL() }, ;
      holdscreen := SAVESCREEN( 0, 0, 0, 79 ), ;
      holdcolor := SETCOLOR( 'N/W,W+/N' ), ;
      dropstart[ LEN(topline) ], ;
      retval := {}, i, pickit

SCROLL(0,0,0,79,0)

DO WHILE .T.
   /* Create a bar menu across the top of the screen */
   SETPOS( 0,0 )
   FOR i = 1 TO LEN(topline)
       dropstart[i] := COL() + 2

       /* If the element selected is an array, it indicates that there is
          a submenu beneath this level.  The first element of that subarray
          is the prompt which triggers that submenu.  If the element is not
          an array, then there are no sublevels below for that choice */

       @ 0, dropstart[i] PROMPT IIF( VALTYPE( topline[i] ) = 'A', ;
                                     topline[i][1], ;
                                     topline[i])
   NEXT
   MENU TO pickit

   /*  retval is the array returned from this function. */

   IF pickit == 0
      /* If no values are selected return an empty array of 0 length */
      ASIZE(retval, 0)

   ELSE
      ASIZE( retval, 1 )
      retval[1] := pickit
      IF VALTYPE( topline[pickit] ) == 'A'
         makechoice( 1, dropstart[pickit], topline[pickit], retval )
         IF LEN(retval) = 1
            LOOP
         ENDIF
      ENDIF
   ENDIF

   EXIT

ENDDO

SETCOLOR( holdcolor )
RESTSCREEN( 0, 0, 0, 79, holdscreen )
SETPOS( holdcursor[1], holdcursor[2] )
RETURN retval


******************************************
FUNCTION makechoice( t, l, array, retval )
******************************************
/* A function which is called either by CUA_MENU or recursively by itself
   to select choices and modify the array RETVAL to reflect choices made */
LOCAL maxwidth := 0 , ;
      base := {}, ;
      level := LEN(retval) + 1, ;
      i, b, r, pickit, holdscreen

FOR i = 2 TO LEN(array)
    AADD( base, IIF( VALTYPE( array[i] ) == 'A', array[i][1], array[i] ) )
    maxwidth = MAX( maxwidth, LEN( base[i - 1] ) )
NEXT
b := t + LEN(base) + 1
r := l + maxwidth + 1
holdscreen := SAVESCREEN( t, l, b, r )
SCROLL(  t, l, b, r, 0)
@ t, l TO b, r
DO WHILE .T.

   FOR i = 1 TO LEN(base)
       @ t + i, l + 1 PROMPT PAD(base[i], maxwidth)
   NEXT
   MENU TO pickit

   IF pickit == 0
      ASIZE( retval, level - 1 )

   ELSE
      ASIZE( retval, level )
      retval[ level ] := pickit

      IF VALTYPE( array[ pickit + 1 ] ) == 'A'
         makechoice( t + pickit - 1, r + 1, array[ pickit + 1 ], retval )
         IF LEN(retval) = level
            LOOP
         ENDIF
      ENDIF

   ENDIF

   EXIT

ENDDO
RESTSCREEN( t, l, b, r, holdscreen )

RETURN NIL


