/*
   PUB2STAT.PRG  [ Courtesy: Steve Kolterman 76320,37 ]
   A strategy to convert PUBLICs to STATICs.
   S'87 way:                      5.0 way:
   PUBLIC mvar                ->  Sstatics(MVAR,somevalue)
   mvar = somevalue
   To add a system STATIC...
   - write a new #define in your SSTATICS.CH, e.g., #define FREEBEE 5.
   - increment the value of 'NUM_STATICS' in SSTATICS.CH by 1.
   - add an element to 'statarray' in Sstatics() and include its value
     in the declaration, e.g., '{ FREEBEE,"no charge" }'.
   - Recompile and link, of course.
   - Compile: clipper pub2stat /n/w/a; clipper sk_sstat /n/w/a;
   - Link:  rtlink fi pub2stat,sk_sstat /pll:base50  [or] /pll:fullbase
   - on a 386/25, the ENTIRE routine executes in 0.000-0.050 secs.
   - thanks to Don Caton and Bill Christison.  Let me know if you decide
     to use it.
*/
#include "sstatics.ch"
FUNCTION TestPub2()
LOCAL startime,endtime,oldcolor := Setcolor( IF(ISCOLOR(),"GR+/B","W+/N") )

CLS
startime := seconds()
Qout( Sstatics(NUMBER) )                         // should return 38
Qout( Sstatics(NUMBER,157))                     // should return 157
Qout( Sstatics(NUMBER))                        // should return 157
Qout( Sstatics(TRUTH) )                       // should return .T.
Qout( Sstatics(TRUTH,.F.) )                  // should return .F.
Qout( Sstatics(TRUTH) )                     // should return .F.
Qout( Sstatics(SDATE) )                    // should return today's date
Qout( Sstatics(SDATE,CTOD("01/01/91")))   // should return New Years Day
Qout( Sstatics(SDATE) )                  // should return New Years Day
Qout( Sstatics(THATNAME) )              // should return 'Michelle'
Qout( Sstatics(THATNAME,"Steve") )     // should return 'Steve'
Qout( Sstatics(THATNAME) )            // should return 'Steve'
endtime := seconds() -startime
Qout( "" )
Qout( "PUB2STAT executed in "+TRANSFORM( endtime,"9.999" )+" secs." )
Qout( "" )
SETCOLOR(oldcolor)
QUIT
RETURN NIL

***************************************************************************
