* PROGRAM BAR.PRG

*  USAGE:>    BAR nnnnn-nnnn printer     (9 DIGIT zipcode with '-' )
*                    -or-
*  USAGE:>    BAR nnnnnnnnn printer      (9 DIGIT zipcode w/o '-' )
*                    -or-
*  USAGE:>    BAR nnnnn printer          (5 DIGIT zipcode)
*
*  NOTES: n=Zipcode digits.  printer= 'TOSHIBA', 'EPSON', 'EPSONLQ',
*                                     or 'CITOH' in capital letters
*
*  John Fronheiser     72520,1522
*  5/13/91
*
*  Based on an upload by Kevin J Stricklin, 71117-1437   PSTNET.ZIP
*          AND upload by Hugh Hemington, 72447-3475   LASENV.ZIP
*
*  I took Kevin's code and changed it to make it easier to support
*  BOTH Clipper Summer '87 and Clipper 5.0. Added support for CITOH
*  8510/1550 printers and support for 5 DIGIT zipcodes is also now
*  included.


PARAMETERS izipcode,prtr
*  Prtr = "TOSHIBA", "EPSON", "EPSONLQ", "CITOH" only
   SET PRINT ON
   SET CONSOLE OFF

   ? 'Example PostNet bar code'
   ? 'This is the zip        : '+izipcode
   ? 'This is Psuedo Bar Code: ' + PsuedoBar(TRIM(STRTRAN(izipcode,'-')))
   ? 'This is the real thing : ' + PostNet(izipcode,prtr)

   EJECT

   SET CONSOLE ON
   SET PRINT OFF
   CLEAR ALL
   QUIT

FUNCTION PostNet
   PARAMETERS cZipCode, cPrinter
*  check for valid looking zipcode (ie: $ '123456789' .and. LEN(zc) = 5 or 9)
   cZipBar = ''
   pZipBar = ''
   cZipCode = TRIM(STRTRAN(cZipCode,'-'))
   IF LEN(cZipCode) = 5 .OR. LEN(cZipCode) = 9
      pZipBar = PsuedoBar(cZipCode)
      cZipBar = PrinterBar(pZipBar,cPrinter)
   ENDIF
   RETURN (cZipBar)
*  EOFUNCTION: PostNet

FUNCTION PsuedoBar
   PARAMETERS cZipCode
*  Function argument is a 9 character string,
*  returns a psuedo barcode (ie: 1 00011 00101 00110 etc... 1 )
*  0 represents a short bar; 1 represents a tall bar

*  calculate check digit for barcode
   STOR 0 TO total
   STOR TRIM(cZipCode) TO cZipCode
   FOR x=1 TO LEN(cZipCode)
      STOR total+VAL(SUBSTR(cZipCode,x,1)) TO total
   NEXT x
   STOR 10-(total-(INT(total/10)*10)) TO chkdigit
   IF chkdigit < 10
      STOR cZipCode+STR(chkdigit,1) TO cZipCode
   ELSE
      STOR cZipCode+"0" TO cZipCode
   ENDIF && chkdigit < 10

   rtn_code = '1' && Starting Tall Bar

   FOR counter = 1 to LEN(cZipCode)
      cDigit = SUBSTR(cZipCode,counter,1)
      DO CASE
         CASE cDigit = '1'
            rtn_code = rtn_code + '00011'
         CASE cDigit = '2'
            rtn_code = rtn_code + '00101'
         CASE cDigit = '3'
            rtn_code = rtn_code + '00110'
         CASE cDigit = '4'
            rtn_code = rtn_code + '01001'
         CASE cDigit = '5'
            rtn_code = rtn_code + '01010'
         CASE cDigit = '6'
            rtn_code = rtn_code + '01100'
         CASE cDigit = '7'
            rtn_code = rtn_code + '10001'
         CASE cDigit = '8'
            rtn_code = rtn_code + '10010'
         CASE cDigit = '9'
            rtn_code = rtn_code + '10100'
         OTHERWISE  && '0'
            rtn_code = rtn_code + '11000'
      ENDCASE
   NEXT
   rtn_code = rtn_code + '1' && Ending Tall Bar
   RETURN (rtn_code)
*  EOFUNCTION: PsuedoBar


FUNCTION PrinterBar
   PARAMETERS pZipBar, cPrinter
*  This function accepts a Psuedo Bar Code and a printer emulation.
*  Returns a printer specific bar code.

   DO CASE

      CASE cPrinter = 'TOSHIBA'
      *  180 dpi, 4 bytes per column, bars 3 col wide, space 5 col wide
      *  tall bar 24 pins high, short bar 12 pins high
         cZipBar = chr(27)+';'  && start 180dpi graphics
         IF LEN(pZipBar)=52
         *  10 digit zipcode (52 bars)
            cZipBar = cZipBar + '0416' && send 416 cols (52*(3+5))
         ELSE
         *  6 digit zipcode (32 bars)
            cZipBar = cZipBar + '0256' && send 256 cols (32*(3+5))
         ENDIF && LEN(pZipBar)=52
         FOR counter = 1 TO LEN(pZipBar)
            IF SUBSTR(pZipBar,counter,1) = '1'
               cZipBar = cZipBar + REPL(chr(63),12) && 3 full height bars
            ELSE
               cZipBar = cZipBar + REPL(chr(0)+chr(0)+chr(63)+chr(63),3) && 3 half height bars
            ENDIF
            cZipBar = cZipBar + REPL(chr(0),20) && 5 empty bars
         NEXT

      CASE cPrinter = 'EPSONLQ'
      *  180 dpi, 3 bytes per column, bars 3 col wide, space 5 col wide
      *  tall bar 24 pins high, short bar 12 pins high
         cZipBar = chr(27)+'*'+chr(39) && start 180dpi graphics
         IF LEN(pZipBar)=52
         *  10 digit zipcode (52 bars)
            cZipBar = cZipBar + chr(160)+chr(1) && send 416 cols (52*(3+5)) = 160+(1*256)
         ELSE
         *  6 digit zipcode (32 bars)
            cZipBar = cZipBar + chr(0)+chr(1) && send 256 cols (32*(3+5)) = 0+(1*256)
         ENDIF && LEN(pZipBar)=52
         FOR counter = 1 TO LEN(pZipBar)
            IF SUBSTR(pZipBar,counter,1) = '1'
               cZipBar = cZipBar + REPL(chr(255),9)
            ELSE
               cZipBar = cZipBar + REPL(chr(0)+chr(15)+chr(255),3)
            ENDIF
            cZipBar = cZipBar + REPL(chr(0),15)
         NEXT

      CASE cPrinter = 'EPSON'
      *  120 dpi, 1 byte per column, bars 2 col wide, space 4 col wide
      *  tall bar 8 pins high, short bar 4 pins high
         cZipBar = chr(27)+'L' && start 120 dpi graphics
         IF LEN(pZipBar)=52
         *  10 digit zipcode (52 bars)
            cZipBar = cZipBar + chr(56)+chr(1) && send 312 cols (52*(2+4)) = 56+(1*256)
         ELSE
         *  6 digit zipcode (32 bars)
            cZipBar = cZipBar + chr(192)+chr(0) && send 192 cols (32*(2+4)) = 192+(0*256)
         ENDIF && LEN(pZipBar)=52
         FOR counter = 1 TO LEN(pZipBar)
            IF SUBSTR(pZipBar,counter,1) = '1'
               cZipBar = cZipBar + REPL(chr(255),2)
            ELSE
               cZipBar = cZipBar + REPL(chr(15),2)
            ENDIF
            cZipBar = cZipBar + REPL(chr(0),4)
         NEXT

      CASE cPrinter = 'PCL4'
      *  300 dpi, vector graphics, bars 6 dots wide, spaces 8 dots wide
      *  tall bars 40 dots high, short bars 16 dots high
         cZipBar = chr(27) + '*p-40Y' && move from baseline to top of char box
         FOR counter = 1 TO LEN(pZipBar)
            IF SUBSTR(pZipBar,counter,1) = '1'
               cZipBar = cZipBar + chr(27) + '*c6a40b0P'
            ELSE
               * 6 wide, 16 high, solid black
               cZipBar = cZipBar + chr(27) + '*p+24Y' && move down to start short bar
               cZipBar = cZipBar + chr(27) + '*c6a16b0P'
               cZipBar = cZipBar + chr(27) + '*p-24Y' && move up to start all chars
            ENDIF
            cZipBar = cZipBar + chr(27) + '*p+14X' && move 14 dots right
         NEXT
         cZipBar = cZipBar + chr(27) + '*p+40Y' && move cursor back to baseline

      CASE cPrinter = 'CITOH'
      *  160 dpi (proportional spacing), 1 byte per column, bars 2 col wide, space 6 col wide
         cZipBar = chr(27) + chr(80) && set for proportional spacing
         cZipBar = cZipBar + chr(27) + chr(83) && start graphics
         IF LEN(pZipBar)=52
         *  10 digit zipcode (52 bars)
            cZipBar = cZipBar + '0416' && send 416 cols (52*8)
         ELSE
         *  6 digit zipcode (32 bars)
            cZipBar = cZipBar + '0256' && send 256 cols (32*8)
         ENDIF && LEN(pZipBar)=52
         FOR counter = 1 TO LEN(pZipBar)
            IF SUBSTR(pZipBar,counter,1) = '1'
               cZipBar = cZipBar + REPL(chr(255),2)
            ELSE
               cZipBar = cZipBar + REPL(chr(240),2)
            ENDIF
            cZipBar = cZipBar + REPL(chr(0),6)
         NEXT
         cZipBar = cZipBar + chr(27)+chr(69) && reset to 12 Cpi

   ENDCASE
   RETURN (cZipBar)
*  EOFUNCTION: PrinterBar

*  EOF: BAR.PRG
