;
;****************************************************************
;                                                               *
;          CLIPPER ROUTINE - PRINTER STATUS ( PARALLEL )        *
;                      By Kelly Mc Tiernan                      *
;                                                               *
;****************************************************************
;
;
;       This routine is to be called to determine the current status
;       of the printer on IBM compatables. This routine is a simple
;       go / no - go status report. Its usefullness stems from the 
;       fact that program termination to the operating system can
;       be avoided. i.e. - instead of DOS error, provide internal 
;       program error message. Ignoring error will return to the 
;       application instead of DOS. Call with a single byte string
;       as a parameter. Returned in this string will be:
;
;               0 = ON LINE, READY
;               1 = PRINTER OFF LINE OR NOT READY
;
;       Note: This routine assumes parallel port 1.
;
;       e.g. - STATUS = " "
;              CALL PRSTAT WITH STATUS
;
PUBLIC  prstat
;
CHECK   EQU     2                       ; status check command
PNUM    EQU     0                       ; parallel port 1 
PRNT    EQU     17h                     ; bios printer interupt
REDY    EQU     90h                     ; printer ready
;
        _PROG SEGMENT BYTE
        ASSUME  CS:_PROG
;
prstat  PROC    FAR
        push    bp                      ; standard setup, param's
        mov     bp,sp                   ;
        push    es                      ;
        les     di,dword ptr [bp + 6]   ; address of return status byte
        mov     ah,CHECK                ; status check
        mov     dx,PNUM                 ; port 1
        int     PRNT                    ;
        mov     al,'0'                  ; returned if O.K.
        cmp     ah,REDY                 ; ready ?
        jz      done                    ; yes
        inc     al                      ; ascii 1
done:
        stosb                           ; place return byte
        pop     es                      ; restore state
        pop     bp                      ;
        ret
prstat  ENDP
_PROG   ENDS
        END
