/*****
*
* Author     Jean Paquin      [76130,3455]
* Thanks     Paul Skip Moon [73377,710] for his suggestions
* Date       July 1st, 1991
* Revision   July 5th, 1991
*
* Note       Enhancements to function already submitted to Nanforum
*            by Craig Baker. The function is:
*
*            1. shorter
*            2. more efficient
*               a) only two passes to convert the string
*               b) no subfunction calls
*            3. checks type and length of parameter submitted
*            4. returns string with embedded CHR(0)
*
* Syntax     PROPER(cString)
*
* Purpose    Converts letters in cString to uppercase provided
*            the following conditions:
*
*            . when letter is the first of cString
*            . when letter is preceeded by: [ ]  Space
*                                            -   Dash
*                                            .   Period
*                                            '   Single Quote
*                                            "   Double Quote
*                                           Mac
*                                           Mc
*
*            example                 result
*            ----------------------  ---------------
*            jean paquin             Jean Paquin
*            paul "skip" moon        Paul "Skip" Moon
*            leslie-ann o'neil       Leslie-Ann O'Neil
*            d.k. macdonald          D.K. MacDonald
*            mCdOnAlD'S restaurants  McDonald's Restaurants
*
*            as you probably noticed, PROPER() is converting 's to lowercase
*
* Compiling  CL /c /AL /Zl /Od /FPa /Gs proper.c
*
*            /c     compile only, do not automatically invoke the linker
*            /AL    use the large model
*            /Zl    do not place the names of the default librairies
*                   in the object file
*            /Od    defeats optimization so that function will work
*                   properly when linking with Blinker and WarpLink
*            /FPa   do not generate floating point calls
*            /Gs    do not generate stack probes
*
***/

#include "nandef.h"
#include "extend.h"
#define SPACE         ' '
#define DOUBLE_QUOTE  '\"'
#define SINGLE_QUOTE  '\''
#define DASH          '-'
#define PERIOD        '.'
#define ToUpper(c)    ((c) >= 'a' && (c) <= 'z' ? (c) - 32 : (c))
#define ToLower(c)    ((c) >= 'A' && (c) <= 'Z' ? (c) + 32 : (c))
#define IsAlpha(c)    ((c) >= 'a' && (c) <= 'z' || (c) >= 'A' && (c) <= 'Z')

CLIPPER PROPER()
{
     int  cap    = TRUE;   // first letter of cString is uppercase
   quant  i;               // type (quant) used to process long strings
   quant  length = 0;      // If missing or invalid parameter
    char *string = "";     // If missing or invalid parameter

   if (ISCHAR(1) && (quant)_parclen(1) > 0) {

      string = _parc(1);
      length = _parclen(1);

      /*****
      *
      * First pass -- straight conversion
      *
      */

      for (i = 0; i < length; i++) {

          string[i] = (cap ? ToUpper(string[i]) : ToLower(string[i]));

          /***
          *
          *  if current character is: space
          *                           dash
          *                           period
          *                           single quote
          *                        or double quote
          *  next letter is converted to uppercase
          *
          ***/

          cap = (string[i] == SPACE        ||
                 string[i] == DASH         ||
                 string[i] == PERIOD       ||
                 string[i] == SINGLE_QUOTE ||
                 string[i] == DOUBLE_QUOTE);
      }

      /*****
      *
      * Second pass -- process exceptions
      *
      */

      for (i = 0; i < length; i++) {

          // Convert to uppercase first letter appearing after "Mc"

          if (string[i] == 'M' && string[i + 1] == 'c') {
             string[i + 2] = ToUpper(string[i + 2]);
             i += 3;
          }

          // Convert to uppercase first letter appearing after "Mac"

          if (string[i] == 'M'     &&
              string[i + 1] == 'a' &&
              string[i + 2] == 'c') {
             string[i + 3] = ToUpper(string[i + 3]);
             i += 4;
           }

          // Convert "'s" to lowercase

          if (string[i] == SINGLE_QUOTE && string[i + 1] == 'S') {
             string[i + 1] = 's';
             i += 2;
          }
      }

   }

   _retclen(string,length);

}
